"use strict";

require('adapter-min.js');

__globalAdapter.init();

requirePlugin('cocos');

if (GameGlobal.isIOSHighPerformanceMode) {
  console.log('启用iOS高性能适配');
  cc.macro.ENABLE_WEBGL_ANTIALIAS = true;
  cc.MeshBuffer.prototype.checkAndSwitchBuffer = function (vertexCount) {
      if (this.vertexOffset + vertexCount > 65535) {
          this.uploadData();
          this._batcher._flush();
      }
  };     
  cc.MeshBuffer.prototype.forwardIndiceStartToOffset = function () {
      this.uploadData();
      this.switchBuffer();
  }  
}
__globalAdapter.adaptEngine();

require('./ccRequire');

require('./src/settings'); // Introduce Cocos Service here


require('./main'); // TODO: move to common
// Adjust devicePixelRatio


cc.view._maxPixelRatio = 4;

if (cc.sys.platform !== cc.sys.WECHAT_GAME_SUB) {
  // Release Image objects after uploaded gl texture
  cc.macro.CLEANUP_IMAGE_CACHE = true;
}

window.boot();