
import { _decorator, Component, Node, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = WatchTank
 * DateTime = Thu Dec 23 2021 00:52:39 GMT+0800 (中国标准时间)
 * Author = Winterning
 * FileBasename = WatchTank.ts
 * FileBasenameNoExtension = WatchTank
 * URL = db://assets/WatchTank.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */
 
@ccclass('WatchTank')
export class WatchTank extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property({ type: Node })
    tank: Node;

    start () {
        // [3]
        // this.node.position.set(this.tank.position.x, this.tank.position.y, 1000)
    }

    update (deltaTime: number) {
        // [4]
        // this.node.position.set(this.tank.position.x, this.tank.position.y, 1000)

        this.node.position = new Vec3(this.tank.position.x, this.tank.position.y, 1000);
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
