const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Camera)
    camera2: cc.Camera = null;

    @property(cc.Sprite)
    cameraSprite: cc.Sprite = null;



    onLoad() {

        console.log("---->>>");
        
        const texture = new cc.RenderTexture();
        texture.initWithSize(this.cameraSprite.node.width, this.cameraSprite.node.height);
        const spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);
        this.cameraSprite.spriteFrame = spriteFrame;
        this.camera2.targetTexture = texture;

        this.camera2.render();

        this.camera2.node.x = 0;
        this.camera2.node.y = 0;


    }


}
