import { _decorator, Button, Component, instantiate, Material, Node, Sprite, Vec4 } from 'cc';
const { ccclass, property } = _decorator;


@ccclass('TestGradient')
export class TestGradient extends Component {

    @property(Sprite)
    sprite: Sprite = null;

    @property(Button)
    btnVis: Button = null;

    private material: Material = null;

    start() {
        
        this.material = this.sprite.getMaterialInstance(0);
        // this.material = this.sprite.getSharedMaterial(0);

        if (this.material) {
            this.material.setProperty("endColor", new Vec4(1, 0, 0, 1));
        }
        this.sprite.node.active = false;
        this.sprite.node.active = true;

        this.btnVis.node.on('click', () => {
            this.sprite.node.active = !this.sprite.node.active;
        });
    }

}


