// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    private _clipList = ['1020101003', '1020101006', '1020101008', '1020101010'];
    private _playIdx = 0;
    private _playing?;
    private _playingname?;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    // update (dt) {}

    onScreenClicked() {
        if (this._playing) {
            this._playing.stop();
        }

        const clipName = this._clipList[this._playIdx];
        this._playingname = clipName;
        this.playAudio(clipName);

        this._playIdx++;
        if (this._playIdx >= this._clipList.length) {
            this._playIdx = 0;
        }
    }

    playAudio(name:string) {
        cc.resources.load(name, cc.AudioClip, (err, clip) => {
            if (err) {
                console.error(err);
                return;
            }
            if (this._playingname != name) {
                return;
            }

            this._playing = qg.createInnerAudioContext();
            this._playing.src = clip._nativeAsset.src;
            this._playing.loop = false;
            this._playing.volume = 1;
            this._playing.play();
        });
    }
}
