
import { _decorator, Component, Node, ModelComponent, primitives, utils, find } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent_001
 * DateTime = Mon Jun 20 2022 17:50:17 GMT+0800 (中国标准时间)
 * Author = Koei
 * FileBasename = NewComponent-001.ts
 * FileBasenameNoExtension = NewComponent-001
 * URL = db://assets/NewComponent-001.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */

@ccclass('NewComponent_001')
export class NewComponent_001 extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    private model: ModelComponent;

    onLoad() {
        this.model = find('Node').getComponent(ModelComponent);
        if (this.model == null) this.model = find('Node').addComponent(ModelComponent);
        this.scheduleOnce(() => {
            this.rebuildModel();

        }, 4)
        this.scheduleOnce(() => {
            find('Node').active = false;
        }, 5)
        this.scheduleOnce(() => {
            this.rebuildModel2();

        }, 8)
        this.scheduleOnce(() => {
            find('Node').active = true;
            this.model._updateModels()
        }, 10)
    }

    private rebuildModel() {
        let capsule: primitives.IGeometry = primitives.torus(0.5, 0.1, {
            radialSegments: 8,
            tubularSegments: 24,
            arc: 1.0 * 2 * Math.PI,
        });

        let mesh = utils.createMesh(capsule);
        if (this.model.mesh) this.model.mesh.destroy();
        this.model.mesh = mesh;
    }

    private rebuildModel2() {
        let capsule: primitives.IGeometry = primitives.torus(0.8, 0.5, {
            radialSegments: 8,
            tubularSegments: 24,
            arc: 1.0 * 2 * Math.PI,
        });

        let mesh = utils.createMesh(capsule);
        if (this.model.mesh) this.model.mesh.destroy();
        this.model.mesh = mesh;
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
