import { _decorator, color, Component, Label, tween, Tween, v3 } from "cc";

const { ccclass, property } = _decorator;
//链表节点——候选角色
@ccclass('CandidateRole')
export default class CandidateRole extends Component {
    public mDistance: number = 0; //到椭圆最低点的距离
    public mPositionIndex!: number;     //节点在链表中的序号
    public mNextPositionX!: number;
    public mNextPositionY!: number;
    public mColorR!: number;
    public mColorG!: number;
    public mColorB!: number;
    public mbIsSelected!: boolean;   // 是否被选中
    public mpNextRole!: CandidateRole;//节点右面角色的指针
    public mpForeRole!: CandidateRole;//左/前一个 
    public changeSelectCall?: Function; //改变选中状态回调
    public clickCall?: Function; //点击回调


    init() {

        this.mPositionIndex = 0;
        this.mbIsSelected = false;
        this.mDistance = 0;
        this.mColorB = 255;
        this.mColorG = 255;
        this.mColorR = 255;
    }

    onLoad() {
        this.init();
    }

    setPositionIndex(index: number) {
        this.mPositionIndex = index;
    }

    getPositionIndex() {
        return this.mPositionIndex;

    }

    setScale(scale: number) {
        this.node.setScale(v3(scale,scale,scale));
    }

    setZOrder(zIndex: number) {
        this.node.setSiblingIndex(zIndex);
    }


    setPositionX(x: number) {
        this.node.x = x;
    }
    getPositionX() {
        return this.node.x;
    }

    setPositionY(y: number) {
        this.node.y = y;

    }
    getPositionY() {
        return this.node.y;
    }

    getScale() {
        return this.node.scale;
    }

    runAction(actions: Tween<any>) {
        tween(this.node).sequence(actions).start();
    }

    setColor(r: number, g: number, b: number) {
        if (r && g && b)
            this.node.color = color(r, g, b);
    }

    setOpacity(opacity: number) {
        if (opacity)
            this.node.opacity = opacity;
    }

    setChangeSelectCall(call: Function) {
        this.changeSelectCall = call;
    }

    changeSelected(isSelected: boolean){
        this.mbIsSelected = isSelected;
        this.changeSelectCall && this.changeSelectCall(isSelected);
    }

    setClickCall(call: Function) {
        this.clickCall = call;
    }

    clickRole() {
        this.clickCall && this.clickCall();
    }
}
