// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class test extends cc.Component {

    @property(cc.Node)
    test_node: cc.Node = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        cc.assetManager.loadRemote('https://img0.baidu.com/it/u=2040236003,1735531774&fm=253&fmt=auto&app=120&f=JPEG?w=800&h=1200.png', (err, res: cc.Texture2D) => {
            if (err) {
                console.error("加载错误,Function:loadRemote", res)
                return
            }
            let sprite = this.test_node?.getComponent(cc.Sprite)
            console.log("加载成功", this.test_node.name, res, new cc.SpriteFrame(res))
            // sprite!.spriteFrame = new cc.SpriteFrame(res)
            var spriteFrame = new cc.SpriteFrame(res);
            sprite!.spriteFrame = spriteFrame
        })
    }
}
