"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const http = __importStar(require("http"));
const url = __importStar(require("url"));
let NEED_LOG = false;
class MyClass {
    constructor() {
        this.server = undefined;
        // register your ipc messages here
        this.messages = {
            'open'() {
            },
        };
    }
    load() {
        if (this.server)
            return;
        this.server = http.createServer((request, response) => {
            NEED_LOG && Editor.log("来了请求");
            // url请求参数{"name":"aty","age":26}
            var args = url.parse(request.url, true).query;
            if (args.uuid) {
                let path = Editor.assetdb.uuidToFspath(args.uuid);
                response.writeHead(200, {
                    "Content-Type": "text/html;charset=utf-8",
                    "Access-Control-Allow-Origin": "*",
                    "Connection": "close",
                    "Cache-Control": "no-cache,must-revalidate",
                    "Pragma": "no-cache",
                    "Expires": "0",
                });
                response.write(path);
                response.end();
            }
            else {
                response.writeHead(200, {
                    "Content-Type": "text/html;charset=utf-8",
                    "Access-Control-Allow-Origin": "*",
                    "Connection": "close",
                    "Cache-Control": "no-cache,must-revalidate",
                    "Pragma": "no-cache",
                    "Expires": "0",
                });
                response.write("中文：remote asset db server ready, 测试链接 http://localhost:9999/?uuid=0275e94c-56a7-410f-bd1a-fc7483f7d14a!");
                response.end();
            }
        });
        this.server.on("error", (error) => {
            NEED_LOG && Editor.log("remote asset db 出错了" + error);
        });
        this.server.on("listening", () => {
            NEED_LOG && Editor.log("remote asset db 开始 listening 成功");
        });
        setTimeout(() => {
            if (!this.server)
                return;
            this.server.listen(9999, "127.0.0.1");
            NEED_LOG && Editor.log("127.0.0.1 remote asset db server ON LINE! 测试链接 http://localhost:9999/?uuid=0275e94c-56a7-410f-bd1a-fc7483f7d14a");
        }, 1000);
    }
    unload() {
        if (this.server) {
            this.server.close();
            this.server = undefined;
            NEED_LOG && Editor.log("remote asset db server OFF LINE");
        }
    }
}
;
module.exports = new MyClass();
