import * as http from "http";
import * as url from "url";

let NEED_LOG = false;

class MyClass {

    server: http.Server = undefined;

    load() {

        if(this.server)
            return;

        this.server = http.createServer((request, response) => {

            NEED_LOG && Editor.log("来了请求")

            // url请求参数{"name":"aty","age":26}
            var args = url.parse(request.url, true).query;

            if (args.uuid) {
                let path = Editor.assetdb.uuidToFspath(args.uuid as string);

                response.writeHead(200, {
                    "Content-Type": "text/html;charset=utf-8",
                    "Access-Control-Allow-Origin":"*",
                    "Connection": "close",
                    "Cache-Control":"no-cache,must-revalidate",
                    "Pragma":"no-cache",
                    "Expires":"0",
                });

                response.write(path);
                response.end();
            } else {
                response.writeHead(200, {
                    "Content-Type": "text/html;charset=utf-8",
                    "Access-Control-Allow-Origin":"*",
                    "Connection": "close",
                    "Cache-Control":"no-cache,must-revalidate",
                    "Pragma":"no-cache",
                    "Expires":"0",
                });
                response.write("中文：remote asset db server ready, 测试链接 http://localhost:9999/?uuid=0275e94c-56a7-410f-bd1a-fc7483f7d14a!");
                response.end();
            }
        });


        this.server.on("error", (error:Error)=>{
            NEED_LOG && Editor.log("remote asset db 出错了" + error);
        });

        this.server.on("listening", ()=>{
            NEED_LOG && Editor.log("remote asset db 开始 listening 成功");
        });

        setTimeout(() => {

            if(!this.server)
                return;

            this.server.listen(9999, "127.0.0.1");

            NEED_LOG && Editor.log("127.0.0.1 remote asset db server ON LINE! 测试链接 http://localhost:9999/?uuid=0275e94c-56a7-410f-bd1a-fc7483f7d14a");

        }, 1000);

    }

    unload() {


        if (this.server) {
            this.server.close();
            this.server = undefined;
            NEED_LOG && Editor.log("remote asset db server OFF LINE");
        }
    }

    // register your ipc messages here
    messages = {
        'open'() {

        },
    }

};

module.exports = new MyClass();