#-*- coding:UTF-8 -*-
import os
import re
from biplist import readPlist
from PIL import Image


def split_plist_atlas(path):
    if os.path.isfile(os.path.splitext(path)[0]+".png") == False:
        return 
    image = Image.open(os.path.splitext(path)[0]+".png")
    try:
        plist = readPlist(os.path.splitext(path)[0]+".plist")
    except:
        return
    prefix = os.path.dirname(path)+os.sep + "Sprites_" + \
    get_file_name(path) + os.sep
    if ('frames' in plist) == False:
        print( 'frames' in plist) 
        return
     
    frames = plist["frames"]
    
    regex = re.compile("({|})")
    for k in frames:
        filename = prefix + k.replace("jpg", "png")
        rectKey = "frame" if "frame" in frames[k] else "textureRect"
        rect = regex.sub("", frames[k][rectKey]).split(",")
        rect = [int(v) for v in rect]
        rotateKey = "rotated" if "rotated" in frames[k] else "textureRotated"
        rotate = frames[k][rotateKey]
        x = rect[0]
        y = rect[1]
        w = rect[0] + rect[2] if not rotate else rect[0] + rect[3]
        h = rect[1] + rect[3] if not rotate else rect[1] + rect[2]
        box = (x, y, w, h)
        img = image.crop(box)
        if not os.path.exists(prefix):
            os.makedirs(prefix)
        if rotate:
            img = img.rotate(90, expand=1)
        try :
            img.save(filename)
        except:
            print(filename)
        print(filename)


def get_file_name(path):
    filename = os.path.split(path)[-1]
    index = filename.rfind(".")
    return filename[0:index]


def readDir(dirPath):
    # if dirPath[-1] == '/':
    #     print('文件夹路径末尾不能加/')
    #     return
    allFiles = []
    if os.path.isdir(dirPath):
        fileList = os.listdir(dirPath)
        for file in fileList:
            file = os.path.join(dirPath, file)
            if os.path.isdir(file):
                subFiles = readDir(file)
                # allFiles = subFiles + allFiles
            else:
                if os.path.splitext(file)[1] == ".plist":
                    split_plist_atlas(file)
        return allFiles
    else:
        return 'Error,not a dir'
readDir("./")





