import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {

    _click: boolean = false;
    @property()
    get click() {
        return this._click;
    }

    set click(value: boolean) {
        if (value === this._click) return;
        this._click = value;
        this.createBoard();
    }
    @property
    _create: number = 0;
    @property
    get create() {
        return this._create;
    }
    set create(value: number) {
        if (value === this._create) return;
        this._create = value;
        this.createBoard();
    }

    async createBoard() {
        // let quat = new Quat();
        // Quat.fromEuler(quat, 0, 0, 22.5);
        // v3(0,0,22.5).transformQuat();
        //@ts-ignore
        await Editor.Message.request('scene', 'set-property', {
            uuid: this.node.children[0].uuid,
            path: '_euler',
            dump: {
                type: "cc.Vec3",
                value: {
                    "x": 0,
                    "y": 0,
                    "z": 22.5,
                }
            },
        });
        /**
        for (let i = 0; i < this.num; i++) {
            const node = await Editor.Message.request('scene', 'create-node', {
                name: 'New Node',
                type: "cc.Prefab",
                parent: this.node.uuid,
                assetUuid: this.prefab.uuid,
                unlinkPrefab: true,
            });
            let n = await Editor.Message.request('scene', "query-node", node);
            for (let j = 0; j < n.children.length; j++) {
                let child = n.children[j];
                await Editor.Message.request('scene', 'set-property', {
                    uuid: child.value.uuid,
                    path: '_prefab',
                    dump: {
                        value: null,
                    },
                });
            }
            await Editor.Message.request('scene', 'set-property', {
                uuid: node,
                path: '_euler',
                dump: {
                    type: "cc.Vec3",
                    value: {
                        "x": 0,
                        "y": 0,
                        "z": this.angle * i,
                    }
                },
            });
        }

        await Editor.Message.request('scene', 'soft-reload');
        // await Editor.Message.request("scene", "save-scene");

        let children = [];
        let len = this.node.children[0].children.length;
        for (let i = 0; i < len; i++) {
            this.node.children.forEach((child) => {
                children.push(child.children[i].uuid);
            })
        }
        await Editor.Message.request('scene', 'set-parent', {
            parent: this.node.uuid,
            uuids: children,
            keepWorldTransform: true,
        });
        
        */
        // await Editor.Message.request('scene', 'soft-reload');
        //@ts-ignore
        await Editor.Message.request("scene", "save-scene");
    }

}

