System.register(["cc", "cc/env"], function (_export, _context) {
  "use strict";

  var _cclegacy, Enum, Overflow, NodeEventType, UITransform, Label, _decorator, EDITOR, _dec, _dec2, _dec3, _dec4, _class, _class2, _descriptor, _descriptor2, _descriptor3, _crd, ccclass, property, LabelType, ALabel;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  _export("LabelType", void 0);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      Enum = _cc.Enum;
      Overflow = _cc.Overflow;
      NodeEventType = _cc.NodeEventType;
      UITransform = _cc.UITransform;
      Label = _cc.Label;
      _decorator = _cc._decorator;
    }, function (_ccEnv) {
      EDITOR = _ccEnv.EDITOR;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "3f5efVHPmlB/Y6oiAIDzY14", "ALabel", undefined);

      ({
        ccclass,
        property
      } = _decorator);
      /**
       * @en Enum for Overflow.
       *
       * @zh 文本类型。
       */

      (function (LabelType) {
        LabelType[LabelType["NONE"] = 0] = "NONE";
        LabelType[LabelType["ADAPTIVE_WIDTH"] = 1] = "ADAPTIVE_WIDTH";
        LabelType[LabelType["FIX_BYTE"] = 2] = "FIX_BYTE";
        LabelType[LabelType["FIX_LENGTH"] = 3] = "FIX_LENGTH";
      })(LabelType || _export("LabelType", LabelType = {}));

      /**
       *  Label扩展 超出限制后剩余显示省略符号
       *  1 ADAPTIVE_WIDTH  自适应宽 根据文本宽显示
       *  2 FIX_BYTE 固定字节长度（中文2个字节 英文1个字节）
       *  3 FIX_LENGTH 固定字符长度
       */
      _export("ALabel", ALabel = (_dec = ccclass('ALabel'), _dec2 = property({
        type: Enum(LabelType),
        tooltip: "\u6587\u672C\u7C7B\u578B\n        1 ADAPTIVE_WIDTH  \u81EA\u9002\u5E94\u5BBD \u6839\u636E\u6587\u672C\u5BBD\u663E\u793A\n        2 ADAPTIVE_HEIGHT \u81EA\u9002\u5E94\u9AD8 \u6839\u636E\u6587\u672C\u9AD8\u663E\u793A\n        3 FIX_BYTE \u56FA\u5B9A\u5B57\u8282\u957F\u5EA6\uFF08\u4E2D\u65872\u4E2A\u5B57\u8282 \u82F1\u65871\u4E2A\u5B57\u8282\uFF09\n        4 FIX_LENGTH \u56FA\u5B9A\u5B57\u7B26\u957F\u5EA6"
      }), _dec3 = property({
        tooltip: "\u6587\u672C\u7C7B\u578B \u9650\u5236\u503C \n        FIX_BYTE \u56FA\u5B9A\u5B57\u8282\u957F\u5EA6\uFF08\u4E2D\u65872\u4E2A\u5B57\u8282 \u82F1\u65871\u4E2A\u5B57\u8282\uFF09\n        FIX_LENGTH \u56FA\u5B9A\u5B57\u7B26\u957F\u5EA6",

        visible() {
          {
            return this.labelType >= LabelType.FIX_BYTE;
          }
        }

      }), _dec4 = property({
        tooltip: "\u8D85\u51FA\u9650\u5236\u540E\u7701\u7565\u53F7",

        visible() {
          {
            return this.labelType > LabelType.NONE;
          }
        }

      }), _dec(_class = (_class2 = class ALabel extends Label {
        constructor() {
          super(...arguments);

          _initializerDefineProperty(this, "labelType", _descriptor, this);

          _initializerDefineProperty(this, "labelLimit", _descriptor2, this);

          _initializerDefineProperty(this, "labelEllipsis", _descriptor3, this);

          this.realString = "";
        }

        get string() {
          return super.string;
        }

        set string(value) {
          if (value == undefined) {
            value = '';
          }

          if (this._string === value || this.realString === value) {
            return;
          }

          this.refreshLabel(value);
        }

        refreshLabel(value) {
          this.realString = value;
          super.string = this.transformString(value);
        }
        /**
        * 编辑器方法
        * 当离开文本热点的时候，设置适配宽  改为自适应高度，要不无法设置文本宽度
        */


        onLostFocusInEditor() {
          if (EDITOR && this.labelType == LabelType.ADAPTIVE_WIDTH) {
            this.overflow = Overflow.RESIZE_HEIGHT;
          }
        }

        onLoad() {
          super.onLoad && super.onLoad();
          this.node.on(NodeEventType.SIZE_CHANGED, this.onSizeChanged, this);
        }

        onDestroy() {
          this.node.off(NodeEventType.SIZE_CHANGED, this.onSizeChanged, this);
          super.onDestroy();
        }

        onSizeChanged() {
          if (this.labelType != LabelType.ADAPTIVE_WIDTH || !this.realString) {
            return;
          }

          this.refreshLabel(this.realString);
        }
        /**转换字符串 */


        transformString(value) {
          var maxSize = this.node.getComponent(UITransform).contentSize;
          var valueLength = this.safeMeasureText(value);
          var tempValue = "";
          var tempLength = 0;

          switch (this.labelType) {
            case LabelType.NONE:
              return value;

            case LabelType.ADAPTIVE_WIDTH:
              tempLength = value.length;

              if (valueLength > maxSize.x) {
                while (--tempLength > 0) {
                  tempValue = value.substring(0, tempLength) + this.labelEllipsis;

                  if (this.safeMeasureText(tempValue) <= maxSize.x) {
                    return tempValue;
                  }
                }
              }

              return value;

            case LabelType.FIX_BYTE:
              for (var i = 0; i < value.length; i++) {
                tempLength += value.charCodeAt(i) > 255 ? 2 : 1;

                if (tempLength > this.labelLimit) {
                  return tempValue + this.labelEllipsis;
                }

                tempValue += value.charAt(i);
              }

              return tempValue;

            case LabelType.FIX_LENGTH:
              if (value.length <= this.labelLimit) {
                return value;
              }

              return value.substring(0, this.labelLimit) + this.labelEllipsis;
          }

          return value;
        }
        /**获取文本宽度 */


        safeMeasureText(string) {
          this.assemblerData.context.font = this.getFontDesc();
          var metric = this.assemblerData.context.measureText(string);
          var width = metric && metric.width || 0;
          return width;
        }

        getFontDesc() {
          var fontDesc = this.fontSize.toString() + "px ";
          fontDesc += this._fontFamilys();

          if (this.isBold) {
            fontDesc = "bold " + fontDesc;
          }

          if (this.isItalic) {
            fontDesc = "italic " + fontDesc;
          }

          return fontDesc;
        }

        _fontFamilys() {
          if (!this.useSystemFont) {
            if (this.font) {
              var _this$font;

              return ((_this$font = this.font) == null ? void 0 : _this$font._nativeAsset) || 'Arial';
            } else {
              return 'Arial';
            }
          }

          return this.fontFamily || 'Arial';
        }

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "labelType", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return LabelType.NONE;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "labelLimit", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 5;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "labelEllipsis", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return "...";
        }
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=b99553353f6d7182e719f3a64935b1211c02ba0d.js.map