const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
  start(): void {
    this.screenShot().then((res) => {
      if (res) {
        let node = new cc.Node();
        node.width = cc.winSize.width;
        node.height = cc.winSize.height;
        node.parent = cc.director.getScene();
        let sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = res;
        let width = cc.winSize.width;
        let height = cc.winSize.height;
        node.x = width / 2;
        node.y = height / 2;

        node.name = "screenShotNode";

        // 关闭截图前的展示
        this.node.getChildByName("bg").active = false;
      }
    });
  }

  screenShot(): Promise<cc.SpriteFrame> {
    return new Promise(async (resolve) => {
      let node = new cc.Node();
      node.parent = cc.director.getScene();
      this.camera = node.addComponent(cc.Camera);
      let visibleSize = cc.view.getVisibleSize();
      node.x = visibleSize.width / 2;
      node.y = visibleSize.height / 2;
      
      this.screenShotInit();
      this.createCanvas();

      let sf = await this.getSpriteFrame();
      if (this.camera) {
        this.camera.node.destroy();
      }
      resolve(sf);
    });
  }

  /**当前的渲染图 */
  private texture: cc.RenderTexture;
  /**截屏的摄像机 */
  private camera: cc.Camera;
  /**当前场景元素 */
  private canvas: HTMLCanvasElement;

  screenShotInit() {
    let texture = new cc.RenderTexture();
    texture.initWithSize(
      cc.visibleRect.width,
      cc.visibleRect.height,
      cc["gfx"]["RB_FMT_S8"]
    );
    this.camera.targetTexture = texture;
    this.texture = texture;
  }

  /**创建Canvas和Context，填充图像数据 */
  private createCanvas() {
    let width = this.texture.width;
    let height = this.texture.height;

    if (!this.canvas) {
      this.canvas = document.createElement("canvas");
      this.canvas.width = width;
      this.canvas.height = height;
    } else {
      this.clearCanvas();
    }
    // 写入渲染数据
    let ctx = this.canvas.getContext("2d");
    //手动渲染摄像机，获得当前场景截图数据
    this.camera.render();
    let data = this.texture.readPixels();

    let rowBytes = width * 4;

    for (let row = 0; row < height; row++) {
      let srow = height - 1 - row;
      let imageData = ctx.createImageData(width, 1);
      let start = srow * width * 4;
      for (let i = 0; i < rowBytes; i++) {
        imageData.data[i] = data[start + i];
      }
      ctx.putImageData(imageData, 0, row);
    }
    return this.canvas;
  }

  /**创建图片元素，放回这个图片生成的 SpriteFrame */
  private getSpriteFrame(): Promise<cc.SpriteFrame> {
    return new Promise((resolve, reject) => {
      let dataURL = this.canvas.toDataURL("image/png");
      let img = document.createElement("img");
      img.src = dataURL;

      let texture = new cc.Texture2D();
      texture.initWithElement(img);
      let spriteFrame = new cc.SpriteFrame();
      spriteFrame.setTexture(texture);
      resolve(spriteFrame);
    });
  }

  clearCanvas() {
    let ctx = this.canvas.getContext("2d");
    ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);
  }
}
