const fs = require('fs');

/**TTF的uuid */
var ttf_uuid = '';
/**预制路径 */
var prefab_path = '';
/**操作参数 0:卸载TTF 1:设置TTF */
var operateTTF = -1;
/// 执行如:node AutoSetOrDeleteTTF.js -path /Users/wangbojie/workSpace/demo/assets/resources/prefab -uuid 2b53065a-ddb2-48a7-aec5-875697659d25 -operate 1
// Parse arguments
var i = 2;
while (i < process.argv.length) {
    var arg = process.argv[i];
    switch (arg) {
        case '-path':
            prefab_path = process.argv[i + 1];
            i += 2;
            break;
        case '-uuid':
            ttf_uuid = process.argv[i + 1];
            i += 2;
        case '-operate':
            operateTTF = isNaN(Number(process.argv[i + 1])) ? -1 : Number(process.argv[i + 1]);
            i += 2;
        default:
            i++;
            break;
    }
}
if (prefab_path == '') {
    console.warn('预制路径需要绝对路径');
} else if (ttf_uuid == '') {
    console.warn('字体ttf的uuid不能为空');

} else if (operateTTF != 1 && operateTTF != 0) {
    console.warn(`-operate参数有误0:卸载TTF 1:设置TTF`);
}
else {
    console.log('------开始打印构建参数------');
    console.log('预制路径:', prefab_path);
    console.log('TTF的uuid:', ttf_uuid);
    console.log(`${operateTTF === 1 ? '设置' : '卸载'}预制中的TTF`);
    console.log('------结束打印构建参数------');
    let bool = main();
    if (bool) {
        console.log('生成完成请启动或点一下cocos creator');
        console.log('生成完成请启动或点一下cocos creator');
        console.log('生成完成请启动或点一下cocos creator');
    }
}
function main() {
    let allFiles = getAllFiles(prefab_path);
    if (!allFiles) return;
    if (allFiles.length === 0) {
        console.warn(`文件夹${prefab_path}下没有找到预制`);
        return;
    }
    for (let i = 0; i < allFiles.length; i++) {
        let filePath = allFiles[i];
        // 同步读取文件内容
        let content = fs.readFileSync(filePath).toString();
        let contentObj = JSON.parse(content);
        for (let index = 0; index < contentObj.length; index++) {
            const element = contentObj[index];
            if (element['__type__'] === 'cc.Label') {
                if (operateTTF === 1) { //设置字体
                    if (element['_N$file'] === null && element['_isSystemFontUsed'] === true) {
                        element['_N$file'] = {
                            __uuid__: ttf_uuid
                        }
                        element['_isSystemFontUsed'] = false;
                    }
                } else if (operateTTF === 0) { //删除字体
                    if (element['_N$file'] && element['_N$file']['__uuid__'] === ttf_uuid && !element['_isSystemFontUsed']) {
                        element['_N$file'] = null;
                        element['_isSystemFontUsed'] = true;
                    }
                }
            } else if (element['__type__'] === 'cc.RichText') {
                if (operateTTF === 1) {//设置字体
                    if (element['_N$font'] === null && element['_isSystemFontUsed'] === true) {
                        element['_N$font'] = {
                            __uuid__: ttf_uuid
                        }
                        element['_isSystemFontUsed'] = false;
                    }
                } else if (operateTTF === 0) {//删除字体
                    if (element['_N$font'] && element['_N$font']['__uuid__'] === ttf_uuid && !element['_isSystemFontUsed']) {
                        element['_N$font'] = null;
                        element['_isSystemFontUsed'] = true;
                    }
                }
            }
        }
        fs.writeFileSync(filePath, JSON.stringify(contentObj));
    }
    return true;
}


/**
 * 递归遍历，获取指定文件夹下面的所有文件路径
 */
function getAllFiles(filePath) {
    let allFilePaths = [];
    if (fs.existsSync(filePath)) {
        const files = fs.readdirSync(filePath);
        for (let i = 0; i < files.length; i++) {
            let file = files[i]; // 文件名称（不包含文件路径）
            let currentFilePath = filePath + '/' + file;
            let stats = fs.lstatSync(currentFilePath);
            if (stats.isDirectory()) {
                allFilePaths = allFilePaths.concat(getAllFiles(currentFilePath));
            } else {
                if (currentFilePath.indexOf('.prefab') != -1 && currentFilePath.indexOf('.meta') === -1) {
                    allFilePaths.push(currentFilePath);
                }
            }
        }
    } else {
        console.warn(`指定的目录${filePath}不存在！`);
        return null;
    }

    return allFilePaths;
}