// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    n: cc.Node = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        let p = this.n.parent;
        setInterval(() => {
            this.n.parent = p;
            this.n.setWorldDirty();
            let nY = this.n.convertToWorldSpaceAR(cc.v2(0,0)).y;
            let pY = this.n.parent.convertToWorldSpaceAR(this.n.position).y;
            console.log(nY, pY, nY - pY);
            this.n.parent = null;
        },100);
    }

    // update (dt) {}
}
