"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unload = exports.load = exports.methods = void 0;
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
exports.methods = {
    async rename() {
        let root = await Editor.Message.request("scene", "query-node-tree");
        //name为"New Node"的节点都是预制 预制需要取children[0].children[0] 场景直接取本身
        let target = root.name == "New Node" ? (root.children[0].name == "should_hide_in_hierarchy" ? root.children[0].children[0] : root.children[0]) : root;
        console.log(`当前是${root.name == "New Node" ? "预制体" : "场景"}`, target);
        console.log("开始重命名...");
        startRename(target);
        if (target) {
            await Editor.Message.request("scene", "save-scene");
            await Editor.Message.request("scene", "soft-reload");
            await Editor.Message.request("scene", "save-scene");
        }
    }
};
async function startRename(target) {
    if (!target) {
        return;
    }
    let idx1 = 1;
    for (let i = 0; i < target.children.length; ++i) {
        let child = target.children[i];
        //有些预制体第一个是自身
        //跳过嵌套的预制体
        if (child.prefab.isUnwrappable)
            continue;
        //console.log(child.uuid);
        //console.log(`将${child.name}节点命名为c${idx1}`);
        let isSucc = await Editor.Message.request("scene", "set-property", { uuid: child.uuid, path: "name", dump: { value: `c${idx1++}` } });
        if (!isSucc) {
            console.log("失败的节点：", child);
            break;
        }
        if (child.children.length > 0) {
            startRename(child);
        }
    }
    // for(let i=0;i<target.children.length;++i){
    //     let child = target.children[i];
    //     console.log("child",child);
    //     console.log("prefab",child["prefab"]);
    //     console.log("Unwrappable",child.prefab["isUnwrappable"]);
    // }
}
/**
 * @en Hooks triggered after extension loading is complete
 * @zh 扩展加载完成后触发的钩子
 */
const load = function () { };
exports.load = load;
/**
 * @en Hooks triggered after extension uninstallation is complete
 * @zh 扩展卸载完成后触发的钩子
 */
const unload = function () { };
exports.unload = unload;
