var window = $global; var cc = window.cc = window.cc || {}; var b2 = window.b2 = window.b2 || {}; var sp = window.sp = window.sp || {}; var dragonBones = window.dragonBones = window.dragonBones || {}; var __globalAdapter = window.__globalAdapter = window.__globalAdapter || {}; var __cocos_require__ = window.__cocos_require__; var Image = window.Image; var HTMLCanvasElement = window.HTMLCanvasElement; var HTMLImageElement = window.HTMLImageElement; var ImageBitmap = window.ImageBitmap; var document = window.document; var DOMParser = window.DOMParser; var performance = window.performance; var XMLHttpRequest = window.XMLHttpRequest; var WebSocket = window.WebSocket; var __extends = window.__extends; var __assign = window.__assign; var __rest = window.__rest; var __decorate = window.__decorate; var __param = window.__param; var __metadata = window.__metadata; var __awaiter = window.__awaiter; var __generator = window.__generator; var __exportStar = window.__exportStar; var __createBinding = window.__createBinding; var __values = window.__values; var __read = window.__read; var __spread = window.__spread; var __spreadArrays = window.__spreadArrays; var __await = window.__await; var __asyncGenerator = window.__asyncGenerator; var __asyncDelegator = window.__asyncDelegator; var __asyncValues = window.__asyncValues; var __makeTemplateObject = window.__makeTemplateObject; var __importStar = window.__importStar; var __importDefault = window.__importDefault; var __classPrivateFieldGet = window.__classPrivateFieldGet; var __classPrivateFieldSet = window.__classPrivateFieldSet;
"use strict";

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() { }; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var touchstartCB;
var touchcancelCB;
var touchendCB;
var touchmoveCB;

var $global_old = Object.assign({}, $global);
var oldKeys = {};

function handleTouchEvent(event) {
  var changedTouches = event.changedTouches;

  if (changedTouches) {
    var _iterator = _createForOfIteratorHelper(changedTouches),
      _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var touch = _step.value;
        touch.clientX = touch.x;
        touch.clientY = touch.y;
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }
}

var onShowCB;
var onHideCB;

Page({
  data: {
    canvasId: "",
    uniId: null,
  },
  onLoad() {
    this.uniId = this.uniId(); // Canvas 的唯一id
    let canvasId = "canvas" + this.uniId;
    this.setData({
      canvasId: canvasId,
      show: true,
    });

    // Canvas创建完成后调用cocos的启动回调函数
    $global.__cocosCallback = function () {
      delete require.cache[require.resolve("../../ccRequire")];
      require('../../ccRequire');

      delete require.cache[require.resolve("../../adapter.js")];
      require('../../adapter.js');

      __globalAdapter.init();

      delete require.cache[require.resolve("../../cocos2d-js.js")];
      require('../../cocos2d-js.js');

      delete require.cache[require.resolve("../../physics.js")];
      require('../../physics.js');

      __globalAdapter.adaptEngine();

      delete require.cache[require.resolve("../../src/settings")];
      require('../../src/settings'); // Introduce Cocos Service here

      delete require.cache[require.resolve("../../main")];
      require('../../main'); // TODO: move to common
      // Adjust devicePixelRatio

      cc.view._maxPixelRatio = 4; // Release Image objects after uploaded gl texture

      cc.macro.CLEANUP_IMAGE_CACHE = true;
      window.boot();
    };

    __globalAdapter.onShow = function (cb) {
      onShowCB = cb;
    };

    __globalAdapter.onHide = function (cb) {
      onHideCB = cb;
    };
  },
  onUnload() {
    delete require.cache[require.resolve("../../main")];
    delete require.cache[require.resolve("../../src/settings")];
    delete require.cache[require.resolve("../../physics.js")];
    delete require.cache[require.resolve("../../cocos2d-js.js")];
    delete require.cache[require.resolve("../../adapter.js")];
    delete require.cache[require.resolve("../../ccRequire")];

    // todo:混合开发可能存在风险，如果小程序动态载入脚本，会导致别人的脚本被删除掉
    let deleteKeys = [];
    let newKeys = Object.keys(require.cache);
    for (const key of newKeys) {
      if (!oldKeys[key]) {
        // 不在旧的cache列表,则说明是游戏内容
        deleteKeys.push(key);
      }
    }
    for (let i = 0; i < deleteKeys.length; i++) {
      let key = deleteKeys[i];
      delete require.cache[key];
    }

    if (require.main) {
      deleteKeys = [];
      newKeys = Object.keys(require.main);
      for (const key of newKeys) {
        if (!oldKeys[key]) {
          deleteKeys.push(key);
        }
      }
      for (let i = 0; i < deleteKeys.length; i++) {
        let key = deleteKeys[i];
        delete require.cache[key];
        delete require.main[key];
      }
    }

    deleteKeys = null;

    touchstartCB = null;
    touchcancelCB = null;
    touchendCB = null;
    touchmoveCB = null;

    onShowCB = null;
    onHideCB = null;

    if (window) {
      let keys = Object.keys(window);
      for (let key of keys) {
        window[key] = null;
      }
      window = null;
    }

    $global_old.b2 = {};
    $global_old.cc = {};
    $global_old.dragonBones = {};
    $global_old.sp = {};
    $global_old.__globalAdapter = {};
    $global.screencanvas = null;
    $global.__cocosCallback = null;

    $global = Object.assign({}, $global_old);

    __globalAdapter = {};
    $global_old = null;
  },
  onReady: function onReady() {
    __globalAdapter.onTouchStart = function (cb) {
      touchstartCB = cb;
    };

    __globalAdapter.onTouchCancel = function (cb) {
      touchcancelCB = cb;
    };

    __globalAdapter.onTouchEnd = function (cb) {
      touchendCB = cb;
    };

    __globalAdapter.onTouchMove = function (cb) {
      touchmoveCB = cb;
    };
  },
  onError: function onError(err) {
    console.error('error in page: ', err);
  },
  onTouchStart: function onTouchStart(event) {
    handleTouchEvent(event);
    touchstartCB && touchstartCB(event);
  },
  onTouchCancel: function onTouchCancel(event) {
    handleTouchEvent(event);
    touchcancelCB && touchcancelCB(event);
  },
  onTouchEnd: function onTouchEnd(event) {
    handleTouchEvent(event);
    touchendCB && touchendCB(event);
  },
  onTouchMove: function onTouchMove(event) {
    handleTouchEvent(event);
    touchmoveCB && touchmoveCB(event);
  },
  canvasOnReady: function canvasOnReady() {
    my.createCanvas({
      id: this.data.canvasId,
      success: function success(canvas) {
        if (!canvas) {
          console.error('failed to create canvas.');
          return;
        }

        // 保存进入游戏引擎之前的cache信息
        oldKeys = Object.keys(require.cache);
        if (require.main) {
          oldKeys = Object.assign(oldKeys, Object.keys(require.main));
        }

        // Canvas创建完成后调用cocos的启动回调函数
        __globalAdapter = __globalAdapter || {};

        $global.screencanvas = canvas;
        $global.__cocosCallback();

      },
      fail: function fail(err) {
        console.error('failed to init on screen canvas', err);
      }
    });
  },
  onShow: function onShow(options) {
    onShowCB && onShowCB();
  },
  onHide: function onHide(options) {
    onHideCB && onHideCB();
  },

  /**
   * 生成 canvas id，由于 tb 同一个canvas id 会导致画布创建失败
   */
  uniId: function () {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(
      /[xy]/g,
      function (c) {
        var r = (Math.random() * 16) | 0,
          v = c == "x" ? r : (r & 0x3) | 0x8;
        return v.toString(16);
      }
    );
  },
});