interface ArrayConstructor {
    translateElements<F extends (index: number, array: ArrayLike<any>) => any>(array: ArrayLike<any>, size: number, predicate: F, thisArg?: any): ReturnType<F>[];
}

if (Array.translateElements == null) {
    Array.translateElements = function <T, F extends (index: number, obj: T[]) => any>(array: T[], size: number, predicate: F, thisArg?: any): ReturnType<F>[] {
        const result: ReturnType<F>[] = [];
        for (let i = 0; i < array.length; i += size)
            result.push(predicate.call(thisArg, i, array));
        return result;
    }
}