import { instantiate, JsonAsset, Prefab } from "cc";
import { director, Director, game, resources } from "cc";
import { EDITOR_NOT_IN_PREVIEW } from "cc/env";

class SetupConfig {
    private gameViewPrefab: Prefab;

    public initialize(callback: () => void): void {
        console.log("SetupConfig initialize");

        let logicActiveTime: number;
        director.on(Director.EVENT_BEFORE_SCENE_LAUNCH, (scene) => {
            console.log("EVENT_BEFORE_SCENE_LAUNCH", scene, scene.name);
            logicActiveTime = performance.now();

            // const gameViewNode = instantiate(this.gameViewPrefab);
            // scene.addChild(gameViewNode);
        });

        director.on(Director.EVENT_AFTER_SCENE_LAUNCH, (scene) => {
            console.log("EVENT_AFTER_SCENE_LAUNCH", scene, scene.name);
            console.log(`active scene nodes use time: ${(performance.now() - logicActiveTime).toFixed(0)} ms`);
        });

        resources.load("gameView", (err, prefab: Prefab) => {
            if (err) return console.error(err);

            this.gameViewPrefab = prefab;
            callback();
        });
    }
}

function setupPlayable() {
    game.onPostProjectInitDelegate.add(() => new Promise<void>(resolve => new SetupConfig().initialize(resolve)));
}

if (!EDITOR_NOT_IN_PREVIEW) {
    setupPlayable();
}