import { _decorator, Component, sp } from "cc";
import { sSpinePartGrindConfig } from "./spine_part_grind_config";
import SpineSkinPartPlayer from "./spine_skin_part_player";


const { ccclass, property, menu } = _decorator;

@ccclass
@menu("Game/Battle/BattleTestUI")
export default class BattleTestUI extends Component {

    @property({ displayName: '人物动画', type: sp.Skeleton })
    roleSkeleton: sp.Skeleton = null;
    @property({ displayName: '人物动画', type: sp.Skeleton })
    role2Skeleton: sp.Skeleton = null;

    protected onEnable(): void {

        if (this.roleSkeleton) {
            let spineSkinPartPlayer = this.roleSkeleton.addComponent(SpineSkinPartPlayer);
            spineSkinPartPlayer.setSkinConfig(sSpinePartGrindConfig);
            spineSkinPartPlayer.setSkinPart('body', 'juese1');
            // spineSkinPartPlayer.setSkinPart('item', 'tiechu1');
            this.roleSkeleton.setAnimation(0, 'death', true);
        }
        if (this.role2Skeleton) {
            let spineSkinPartPlayer = this.role2Skeleton.addComponent(SpineSkinPartPlayer);
            spineSkinPartPlayer.customSkinName = 'custom2';
            spineSkinPartPlayer.setSkinConfig(sSpinePartGrindConfig);
            spineSkinPartPlayer.setSkinPart('body', 'juese2');
            // spineSkinPartPlayer.setSkinPart('item', 'tiechu1');
            this.role2Skeleton.setAnimation(0, 'death', true);
        }
    }

    onBtnClick(){
        
        if (this.roleSkeleton) {
            let spineSkinPartPlayer = this.roleSkeleton.getComponent(SpineSkinPartPlayer);
            spineSkinPartPlayer.setSkinPart('item', 'yumi');
            this.roleSkeleton.setAnimation(0, 'death', true);
        }
    }
}