import { _decorator, animation, Button, cclegacy, Component, Label, Node, profiler, resources, sp } from 'cc';
const { ccclass, property } = _decorator;


@ccclass('dc')
export class dc extends Component {

    @property({ type: Label, tooltip: '显示批次信息' })
    dcLabel: Label = null;
    
    start() {
        profiler.hideStats();
        profiler.showStats();
    }

    lateUpdate(deltaTime: number) {
        let state = null;
        if(cclegacy.profiler.stats){
            state = cclegacy.profiler.stats;
        }else{
            state = cclegacy.profiler._stats;
        }
        let dc = state.draws.counter._value;
        let fps =  Math.floor(state.fps.counter._averageValue);
        if (this.dcLabel) {
            this.dcLabel.string = `dc: ${dc}`;
        }
    }
}


