import { _decorator, animation, Button, cclegacy, Component, Label, Node, profiler, resources, Skeleton, sp } from 'cc';
const { ccclass, property } = _decorator;

interface changeClothArgs {
    skeleton: sp.Skeleton,
    slotName: string,
    attaName: string;
    targetSkeletonName?: string,
    targetSkeletonData?: sp.SkeletonData,
    targetSkinName?: string,
    targetSlotName?: string,
    targetAttaName?: string,
}


@ccclass('TestChangeCloth')
export class TestChangeCloth extends Component {

    randTimes: number = 0;
    protected onLoad(): void {
    }

    start() {
        let spineArray = this.getComponentsInChildren(sp.Skeleton);
        this.randTimes++;
        for (let i = 0; i < spineArray.length; i++) {
            let spine = spineArray[i];
            if (spine.enabledInHierarchy) {
                let runtimeData = spine.skeletonData.getRuntimeData();
                let defaultSkin: sp.spine.Skin = runtimeData.findSkin("default");
                runtimeData.findSkin("juese1") && defaultSkin.addSkin(runtimeData.findSkin("juese1"));
                runtimeData.findSkin("skin2") && defaultSkin.addSkin(runtimeData.findSkin("skin2"));
                spine.setSkin("default");
            }
        }
    }

    lateUpdate(deltaTime: number) {
    }

    onIssue() {
        let spineArray = this.getComponentsInChildren(sp.Skeleton);
        this.randTimes++;
        const items = ["yumi", "tiechu", "xiaojingu", "rensheng", "qingtong"];
        for (let i = 0; i < spineArray.length; i++) {
            let spine = spineArray[i];
            if (spine.enabledInHierarchy) {
                let id = Math.floor(Math.random() * 100) % 17 + 1;
                if(Math.random()>0.5){
                    this.changeCloth(spine, "tiechu", "tiechu", spine.skeletonData, items[id % items.length], "tiechu", "tiechu");
                    this.changeCloth(spine, "tou", "tou1", spine.skeletonData, "skin" + id, "tou", "tou1");
                }
                else{
                    this.changeCloth(spine, "tou", "tou1", "spine/gou", "", "tou", "gou_tou");
                }
                spine.setSkin("default");
            }
        }
    }

    /**
     * changeCloth方法的参数预处理
     */
    private _makeChangeClothArgs(): changeClothArgs {
        if (arguments.length < 4) {
            return null;
        }
        // arg 1 2 3
        let ret: changeClothArgs = { skeleton: arguments[0], slotName: arguments[1], attaName: arguments[2] };
        // arg 4
        if (typeof arguments[3] == "string") {
            ret.targetSkeletonName = arguments[3];
        }
        else {
            ret.targetSkeletonData = arguments[3];
        }
        // arg 5 6 7
        if (arguments.length === 4) {
            ret.targetSkinName = undefined;
            ret.targetSlotName = ret.slotName;
            ret.targetAttaName = ret.attaName;
        }
        else if (arguments.length === 5) {
            ret.targetSkinName = arguments[4];
            ret.targetSlotName = ret.slotName;
            ret.targetAttaName = ret.attaName;
        }
        else if (arguments.length === 6) {
            ret.targetSkinName = undefined;
            ret.targetSlotName = arguments[4];
            ret.targetAttaName = arguments[5];
        }
        else if (arguments.length === 7) {
            ret.targetSkinName = arguments[4];
            ret.targetSlotName = arguments[5];
            ret.targetAttaName = arguments[6];
        }
        return ret;
    }
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonName: string);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonName: string, targetSkinName: string);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonName: string, targetSlotName: string, targetAttaName: string);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonName: string, targetSkinName: string, targetSlotName: string, targetAttaName: string);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonData: sp.SkeletonData);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonData: sp.SkeletonData, targetSkinName: string);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonData: sp.SkeletonData, targetSlotName: string, targetAttaName: string);
    public changeCloth(skeleton: sp.Skeleton, slotName: string, attaName: string, targetSkeletonData: sp.SkeletonData, targetSkinName: string, targetSlotName: string, targetAttaName: string);
    public changeCloth() {
        let args: changeClothArgs = this._makeChangeClothArgs.apply(this, arguments);
        if (args.targetSkeletonData) {
            let skeletonDataReal = args.skeleton.skeletonData.getRuntimeData();
            let targetSkeletonDataReal = args.targetSkeletonData.getRuntimeData();
            let targetSkin: any;
            if (args.targetSkinName) {
                targetSkin = targetSkeletonDataReal.findSkin(args.targetSkinName);
            }
            else {
                targetSkin = targetSkeletonDataReal.skins[0];
            }
            let slotIndex = skeletonDataReal.findSlotIndex(args.slotName);
            let targetSlotIndex = targetSkeletonDataReal.findSlotIndex(args.targetSlotName);
            if (targetSkin && targetSlotIndex>0 && slotIndex>0) {
                let attachment = targetSkin.getAttachment(targetSlotIndex, args.targetAttaName);
                // let slot = args.skeleton.findSlot(args.slotName);
                // if (slot) slot.setAttachment(attachment);
                let defaultSkin: sp.spine.Skin = skeletonDataReal.findSkin("default");
                defaultSkin.setAttachment(slotIndex, args.attaName, attachment);
            }
        }
        else if (args.targetSkeletonName) {
            resources.load(args.targetSkeletonName, sp.SkeletonData, (err, skeletonData) => {
                if (err) {
                    return;
                }
                let skeletonDataReal = args.skeleton.skeletonData.getRuntimeData();
                let targetSkeletonDataReal = skeletonData.getRuntimeData();
                let targetSkin: any;
                if (args.targetSkinName) {
                    targetSkin = targetSkeletonDataReal.findSkin(args.targetSkinName);
                }
                else {
                    targetSkin = targetSkeletonDataReal.skins[0];
                }
                let slotIndex = skeletonDataReal.findSlotIndex(args.slotName);
                let targetSlotIndex = targetSkeletonDataReal.findSlotIndex(args.targetSlotName);
                if (targetSkin && targetSlotIndex>0 && slotIndex>0) {
                    let targetAttachment = targetSkin.getAttachment(targetSlotIndex, args.targetAttaName);
                    // let slot = args.skeleton.findSlot(args.slotName);
                    // if (slot) slot.setAttachment(attachment);
                    let defaultSkin: sp.spine.Skin = skeletonDataReal.findSkin("default");
                    defaultSkin.setAttachment(slotIndex, args.attaName, targetAttachment);
                }
            });
        }
    }
}


