import { _decorator, animation, Button, cclegacy, Component, Label, Node, profiler, resources, sp } from 'cc';
const { ccclass, property } = _decorator;


@ccclass('TestSharedCache')
export class TestSharedCache extends Component {

    @property({ type: sp.Skeleton, tooltip: '动画' })
    spine: sp.Skeleton = null;

    @property({ type: sp.Skeleton, tooltip: '动画' })
    spineArray: sp.Skeleton[] = [];

    onIssue1(){
        for(let i=0; i<this.spineArray.length; i++){
            let spine = this.spineArray[i];
            resources.load('spine/gou', sp.SkeletonData, (err, res) => {
                if (err) {
                    console.error(err);
                    return;
                }
                spine.skeletonData = res;
                spine.setAnimation(0, 'idle', true);
            })
        }
    }
    onIssue2(){
        for(let i=0; i<this.spineArray.length; i++){
            let spine = this.spineArray[i];
            spine.node.active = false;
            resources.load('spine/jiangshi', sp.SkeletonData, (err, res) => {
                spine.node.active = true;
                if (err) {
                    console.error(err);
                    return;
                }
                spine.skeletonData = res;
                let id = Math.floor(Math.random() * 100) % 17 + 1;
                spine.setSkin('skin2');
                spine.setAnimation(0, 'idle', true);
            })
        }
    }
}


