import { _decorator, Component, director, find, instantiate, log, Node, Prefab, resources } from 'cc';
import { DialogTs } from './scripts/DialogTs';
const { ccclass, property } = _decorator;

@ccclass('DialogUtil')
export class DialogUtil {
    private static _self: DialogUtil = null;
    private _dialogPfbs: Prefab[] = null;
    private _retryLoadCount: number = 0;
    public static get INST(): DialogUtil {
        if (!this._self) {
            this._self = new DialogUtil();
            resources.loadDir("dialogs", Prefab, (err, pfbs) => {
                this._self._dialogPfbs = pfbs;
            });
        }
        return this._self;
    }

    public showDialog(pfbName: string, options?: DialogOpt) {
        if (this._dialogPfbs == null) {
            // info("资源正在加载...");
            if (this._retryLoadCount < 5) {
                setTimeout(() => {
                    this._retryLoadCount++;
                    this.showDialog(pfbName, options);
                }, 500);
            } else {
                this._retryLoadCount = 0;
            }
            return;
        }
        
        const pfb = this._dialogPfbs.find((d, idx) => d.name == pfbName);
        let dialogInst = instantiate(pfb);
        dialogInst.name = "DIALOG_INST";
        let dialogTs = dialogInst.getComponent(DialogTs);
        dialogTs.buildDialog(options);
        director.getScene().addChild(dialogInst);

    }
}

export interface DialogOpt {
    title?:string;
    content?:string;
}


