import { _decorator, Component, Label, log, Node, tween, v3, Widget } from 'cc';
import { DialogOpt } from '../DialogUtil';
const { ccclass, property } = _decorator;

@ccclass('DialogTs')
export class DialogTs extends Component {

    @property(Label)
    public titleLb:Label=null;
    @property(Label)
    public contentLb:Label=null;
    @property(Widget)
    dlgWidget: Widget = null;
    start() {
        tween(this.dlgWidget!.node).show().to(0.3, { scale: v3(1.0, 1.0, 1.0) }, { easing: "smooth" }).start();
    }

    protected onLoad(): void {
        this.dlgWidget!.node.setScale(v3());
        tween(this.dlgWidget!.node).hide().start();
    }

    public buildDialog(options: DialogOpt){
        if(options?.title){
            this.titleLb.string = options.title;
        }
        if(options?.content){
            this.contentLb.string=options.content;
        }
    }

    public confirmBtnClick(evt:Event,data:string){
        log("弹窗-关闭按钮点击了");
        this.node.destroy();
    }

    public btnClickCbk(evt:Event,data:string){
        log("弹窗-按钮"+data+"点击了");
    }

    update(deltaTime: number) {
        
    }
}


