/*!
 * uniLib - d.ts for Description
 * @licence uniLib - v0.1.0 (2021-01-22)
 * qq:93749937 | Licence: helojo
 */
type Long = protobuf.Long;

/** Namespace Pmd. */
declare namespace Pmd {

    /** FrameHeader enum. */
    enum FrameHeader {
        Bitmask_None = 0,
        Bitmask_Compress = 1,
        Bitmask_Encrypt = 2,
        Bitmask_Header = 4,
        Bitmask_NoHeadLen = 8,
        Bitmask_Reconnect = 16
    }

    /** Properties of a ForwardNullUserPmd_CS. */
    interface IForwardNullUserPmd_CS {

        /** ForwardNullUserPmd_CS byCmd */
        byCmd?: (number|null);

        /** ForwardNullUserPmd_CS byParam */
        byParam?: (number|null);

        /** ForwardNullUserPmd_CS seq */
        seq?: (number|null);

        /** ForwardNullUserPmd_CS fid */
        fid?: (number|Long|null);

        /** ForwardNullUserPmd_CS data */
        data?: (Uint8Array|null);

        /** ForwardNullUserPmd_CS prototype */
        prototype?: (number|Long|null);

        /** ForwardNullUserPmd_CS bitmask */
        bitmask?: (number|null);

        /** ForwardNullUserPmd_CS time */
        time?: (number|null);
    }

    /** Represents a ForwardNullUserPmd_CS. */
    class ForwardNullUserPmd_CS implements IForwardNullUserPmd_CS {

        /**
         * Constructs a new ForwardNullUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IForwardNullUserPmd_CS);

        /** ForwardNullUserPmd_CS byCmd. */
        public byCmd: number;

        /** ForwardNullUserPmd_CS byParam. */
        public byParam: number;

        /** ForwardNullUserPmd_CS seq. */
        public seq: number;

        /** ForwardNullUserPmd_CS fid. */
        public fid: (number|Long);

        /** ForwardNullUserPmd_CS data. */
        public data: Uint8Array;

        /** ForwardNullUserPmd_CS prototype. */
        public prototype: (number|Long);

        /** ForwardNullUserPmd_CS bitmask. */
        public bitmask: number;

        /** ForwardNullUserPmd_CS time. */
        public time: number;

        /**
         * Creates a new ForwardNullUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ForwardNullUserPmd_CS instance
         */
        public static create(properties?: Pmd.IForwardNullUserPmd_CS): Pmd.ForwardNullUserPmd_CS;

        /**
         * Encodes the specified ForwardNullUserPmd_CS message. Does not implicitly {@link Pmd.ForwardNullUserPmd_CS.verify|verify} messages.
         * @param message ForwardNullUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IForwardNullUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ForwardNullUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.ForwardNullUserPmd_CS.verify|verify} messages.
         * @param message ForwardNullUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IForwardNullUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ForwardNullUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ForwardNullUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ForwardNullUserPmd_CS;

        /**
         * Decodes a ForwardNullUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ForwardNullUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ForwardNullUserPmd_CS;

        /**
         * Verifies a ForwardNullUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ForwardNullUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ForwardNullUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ForwardNullUserPmd_CS;

        /**
         * Creates a plain object from a ForwardNullUserPmd_CS message. Also converts values to other types if specified.
         * @param message ForwardNullUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ForwardNullUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ForwardNullUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** PlatCommand enum. */
    enum PlatCommand {
        PlatCommand_Null = 0,
        PlatCommand_Logger = 245,
        PlatCommand_Lobby = 246,
        PlatCommand_Push = 247,
        PlatCommand_Gm = 248,
        PlatCommand_Monitor = 249,
        PlatCommand_Login = 250,
        PlatCommand_Forward = 251,
        PlatCommand_Sdk = 252,
        PlatCommand_Chat = 253,
        PlatCommand_Image = 254
    }

    /** Properties of a Null. */
    interface INull {
    }

    /** Represents a Null. */
    class Null implements INull {

        /**
         * Constructs a new Null.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.INull);

        /**
         * Creates a new Null instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Null instance
         */
        public static create(properties?: Pmd.INull): Pmd.Null;

        /**
         * Encodes the specified Null message. Does not implicitly {@link Pmd.Null.verify|verify} messages.
         * @param message Null message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.INull, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified Null message, length delimited. Does not implicitly {@link Pmd.Null.verify|verify} messages.
         * @param message Null message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.INull, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a Null message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Null
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.Null;

        /**
         * Decodes a Null message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Null
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.Null;

        /**
         * Verifies a Null message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Null message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Null
         */
        public static fromObject(object: { [k: string]: any }): Pmd.Null;

        /**
         * Creates a plain object from a Null message. Also converts values to other types if specified.
         * @param message Null
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.Null, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Null to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace Null {

        /** Param enum. */
        enum Param {
            ForwardNullUserPmd_CS = 0,
            TickRequestNullUserPmd_CS = 1,
            TickReturnNullUserPmd_CS = 2,
            RequestCloseNullUserPmd_CS = 3,
            FrameHeaderNullUserPmd_CS = 4,
            CheckVersionUserPmd_CS = 5,
            ForwardBwNullUserPmd_CS = 6,
            SetTickTimeoutNullUserPmd_CS = 7,
            SetPingTimeNullUserPmd_CS = 8,
            ForwardToZoneNullUserPmd_CS = 9,
            MaxDefualtNullUserPmd = 15,
            StartFrameSyncNullUserPmd_CS = 16,
            BroadListFrameSyncNullUserPmd_S = 17,
            RequestUpFrameSyncNullUserPmd_C = 18,
            HistoryListFrameSyncNullUserPmd_S = 19,
            StopFrameSyncNullUserPmd_SC = 20,
            ForwardNullUserListPmd_CS = 21,
            JsonCompressNullUserPmd_CS = 101
        }
    }

    /** Properties of a TickRequestNullUserPmd_CS. */
    interface ITickRequestNullUserPmd_CS {

        /** TickRequestNullUserPmd_CS requesttime */
        requesttime?: (number|null);
    }

    /** Represents a TickRequestNullUserPmd_CS. */
    class TickRequestNullUserPmd_CS implements ITickRequestNullUserPmd_CS {

        /**
         * Constructs a new TickRequestNullUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ITickRequestNullUserPmd_CS);

        /** TickRequestNullUserPmd_CS requesttime. */
        public requesttime: number;

        /**
         * Creates a new TickRequestNullUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TickRequestNullUserPmd_CS instance
         */
        public static create(properties?: Pmd.ITickRequestNullUserPmd_CS): Pmd.TickRequestNullUserPmd_CS;

        /**
         * Encodes the specified TickRequestNullUserPmd_CS message. Does not implicitly {@link Pmd.TickRequestNullUserPmd_CS.verify|verify} messages.
         * @param message TickRequestNullUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ITickRequestNullUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified TickRequestNullUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.TickRequestNullUserPmd_CS.verify|verify} messages.
         * @param message TickRequestNullUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ITickRequestNullUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a TickRequestNullUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TickRequestNullUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.TickRequestNullUserPmd_CS;

        /**
         * Decodes a TickRequestNullUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TickRequestNullUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.TickRequestNullUserPmd_CS;

        /**
         * Verifies a TickRequestNullUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TickRequestNullUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TickRequestNullUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.TickRequestNullUserPmd_CS;

        /**
         * Creates a plain object from a TickRequestNullUserPmd_CS message. Also converts values to other types if specified.
         * @param message TickRequestNullUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.TickRequestNullUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TickRequestNullUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TickReturnNullUserPmd_CS. */
    interface ITickReturnNullUserPmd_CS {

        /** TickReturnNullUserPmd_CS requesttime */
        requesttime?: (number|null);

        /** TickReturnNullUserPmd_CS mytime */
        mytime?: (number|null);
    }

    /** Represents a TickReturnNullUserPmd_CS. */
    class TickReturnNullUserPmd_CS implements ITickReturnNullUserPmd_CS {

        /**
         * Constructs a new TickReturnNullUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ITickReturnNullUserPmd_CS);

        /** TickReturnNullUserPmd_CS requesttime. */
        public requesttime: number;

        /** TickReturnNullUserPmd_CS mytime. */
        public mytime: number;

        /**
         * Creates a new TickReturnNullUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TickReturnNullUserPmd_CS instance
         */
        public static create(properties?: Pmd.ITickReturnNullUserPmd_CS): Pmd.TickReturnNullUserPmd_CS;

        /**
         * Encodes the specified TickReturnNullUserPmd_CS message. Does not implicitly {@link Pmd.TickReturnNullUserPmd_CS.verify|verify} messages.
         * @param message TickReturnNullUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ITickReturnNullUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified TickReturnNullUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.TickReturnNullUserPmd_CS.verify|verify} messages.
         * @param message TickReturnNullUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ITickReturnNullUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a TickReturnNullUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TickReturnNullUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.TickReturnNullUserPmd_CS;

        /**
         * Decodes a TickReturnNullUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TickReturnNullUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.TickReturnNullUserPmd_CS;

        /**
         * Verifies a TickReturnNullUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TickReturnNullUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TickReturnNullUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.TickReturnNullUserPmd_CS;

        /**
         * Creates a plain object from a TickReturnNullUserPmd_CS message. Also converts values to other types if specified.
         * @param message TickReturnNullUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.TickReturnNullUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TickReturnNullUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GameZoneInfo. */
    interface IGameZoneInfo {

        /** GameZoneInfo gameid */
        gameid?: (number|null);

        /** GameZoneInfo zoneid */
        zoneid?: (number|null);

        /** GameZoneInfo gamename */
        gamename?: (string|null);

        /** GameZoneInfo zonename */
        zonename?: (string|null);

        /** GameZoneInfo mysql */
        mysql?: (string|null);

        /** GameZoneInfo redis */
        redis?: (string|null);

        /** GameZoneInfo rethink */
        rethink?: (string|null);

        /** GameZoneInfo mongo */
        mongo?: (string|null);

        /** GameZoneInfo zonestate */
        zonestate?: (number|null);

        /** GameZoneInfo separatezoneuid */
        separatezoneuid?: (boolean|null);

        /** GameZoneInfo lobby */
        lobby?: (string|null);

        /** GameZoneInfo zonetype */
        zonetype?: (number|null);

        /** GameZoneInfo opentime */
        opentime?: (string|null);

        /** GameZoneInfo listenaslobby */
        listenaslobby?: (string|null);

        /** GameZoneInfo dbserverurl */
        dbserverurl?: (string|null);
    }

    /** Represents a GameZoneInfo. */
    class GameZoneInfo implements IGameZoneInfo {

        /**
         * Constructs a new GameZoneInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IGameZoneInfo);

        /** GameZoneInfo gameid. */
        public gameid: number;

        /** GameZoneInfo zoneid. */
        public zoneid: number;

        /** GameZoneInfo gamename. */
        public gamename: string;

        /** GameZoneInfo zonename. */
        public zonename: string;

        /** GameZoneInfo mysql. */
        public mysql: string;

        /** GameZoneInfo redis. */
        public redis: string;

        /** GameZoneInfo rethink. */
        public rethink: string;

        /** GameZoneInfo mongo. */
        public mongo: string;

        /** GameZoneInfo zonestate. */
        public zonestate: number;

        /** GameZoneInfo separatezoneuid. */
        public separatezoneuid: boolean;

        /** GameZoneInfo lobby. */
        public lobby: string;

        /** GameZoneInfo zonetype. */
        public zonetype: number;

        /** GameZoneInfo opentime. */
        public opentime: string;

        /** GameZoneInfo listenaslobby. */
        public listenaslobby: string;

        /** GameZoneInfo dbserverurl. */
        public dbserverurl: string;

        /**
         * Creates a new GameZoneInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GameZoneInfo instance
         */
        public static create(properties?: Pmd.IGameZoneInfo): Pmd.GameZoneInfo;

        /**
         * Encodes the specified GameZoneInfo message. Does not implicitly {@link Pmd.GameZoneInfo.verify|verify} messages.
         * @param message GameZoneInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IGameZoneInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified GameZoneInfo message, length delimited. Does not implicitly {@link Pmd.GameZoneInfo.verify|verify} messages.
         * @param message GameZoneInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IGameZoneInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a GameZoneInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GameZoneInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.GameZoneInfo;

        /**
         * Decodes a GameZoneInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GameZoneInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.GameZoneInfo;

        /**
         * Verifies a GameZoneInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GameZoneInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GameZoneInfo
         */
        public static fromObject(object: { [k: string]: any }): Pmd.GameZoneInfo;

        /**
         * Creates a plain object from a GameZoneInfo message. Also converts values to other types if specified.
         * @param message GameZoneInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.GameZoneInfo, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GameZoneInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlatBaseData. */
    interface IPlatBaseData {

        /** PlatBaseData gamezone */
        gamezone?: (Pmd.IGameZoneInfo|null);

        /** PlatBaseData myaccid */
        myaccid?: (number|Long|null);

        /** PlatBaseData platid */
        platid?: (number|null);

        /** PlatBaseData subplatid */
        subplatid?: (number|null);

        /** PlatBaseData plataccount */
        plataccount?: (string|null);

        /** PlatBaseData session */
        session?: (string|null);

        /** PlatBaseData extdata */
        extdata?: (string|null);

        /** PlatBaseData extdata1 */
        extdata1?: (string|null);

        /** PlatBaseData oldplataccount */
        oldplataccount?: (string|null);

        /** PlatBaseData nickname */
        nickname?: (string|null);

        /** PlatBaseData faceurl */
        faceurl?: (string|null);

        /** PlatBaseData sdkserverid */
        sdkserverid?: (number|Long|null);

        /** PlatBaseData oldplatid */
        oldplatid?: (number|null);

        /** PlatBaseData clienttype */
        clienttype?: (number|null);

        /** PlatBaseData imei */
        imei?: (string|null);

        /** PlatBaseData osname */
        osname?: (string|null);

        /** PlatBaseData gameprops */
        gameprops?: (string|null);

        /** PlatBaseData gender */
        gender?: (number|null);

        /** PlatBaseData platappid */
        platappid?: (string|null);

        /** PlatBaseData bindcode */
        bindcode?: (string|null);

        /** PlatBaseData openid */
        openid?: (string|null);
    }

    /** Represents a PlatBaseData. */
    class PlatBaseData implements IPlatBaseData {

        /**
         * Constructs a new PlatBaseData.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IPlatBaseData);

        /** PlatBaseData gamezone. */
        public gamezone?: (Pmd.IGameZoneInfo|null);

        /** PlatBaseData myaccid. */
        public myaccid: (number|Long);

        /** PlatBaseData platid. */
        public platid: number;

        /** PlatBaseData subplatid. */
        public subplatid: number;

        /** PlatBaseData plataccount. */
        public plataccount: string;

        /** PlatBaseData session. */
        public session: string;

        /** PlatBaseData extdata. */
        public extdata: string;

        /** PlatBaseData extdata1. */
        public extdata1: string;

        /** PlatBaseData oldplataccount. */
        public oldplataccount: string;

        /** PlatBaseData nickname. */
        public nickname: string;

        /** PlatBaseData faceurl. */
        public faceurl: string;

        /** PlatBaseData sdkserverid. */
        public sdkserverid: (number|Long);

        /** PlatBaseData oldplatid. */
        public oldplatid: number;

        /** PlatBaseData clienttype. */
        public clienttype: number;

        /** PlatBaseData imei. */
        public imei: string;

        /** PlatBaseData osname. */
        public osname: string;

        /** PlatBaseData gameprops. */
        public gameprops: string;

        /** PlatBaseData gender. */
        public gender: number;

        /** PlatBaseData platappid. */
        public platappid: string;

        /** PlatBaseData bindcode. */
        public bindcode: string;

        /** PlatBaseData openid. */
        public openid: string;

        /**
         * Creates a new PlatBaseData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlatBaseData instance
         */
        public static create(properties?: Pmd.IPlatBaseData): Pmd.PlatBaseData;

        /**
         * Encodes the specified PlatBaseData message. Does not implicitly {@link Pmd.PlatBaseData.verify|verify} messages.
         * @param message PlatBaseData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IPlatBaseData, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified PlatBaseData message, length delimited. Does not implicitly {@link Pmd.PlatBaseData.verify|verify} messages.
         * @param message PlatBaseData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IPlatBaseData, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a PlatBaseData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlatBaseData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.PlatBaseData;

        /**
         * Decodes a PlatBaseData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlatBaseData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.PlatBaseData;

        /**
         * Verifies a PlatBaseData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlatBaseData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlatBaseData
         */
        public static fromObject(object: { [k: string]: any }): Pmd.PlatBaseData;

        /**
         * Creates a plain object from a PlatBaseData message. Also converts values to other types if specified.
         * @param message PlatBaseData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.PlatBaseData, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlatBaseData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** HttpReturnCode enum. */
    enum HttpReturnCode {
        HttpReturnCode_Null = 0,
        HttpReturnCode_DbError = 2,
        HttpReturnCode_LuaScriptError = 4,
        HttpReturnCode_GameZoneListError = 5,
        HttpReturnCode_SignError = 11,
        HttpReturnCode_ServerShutDown = 12,
        HttpReturnCode_JsonSyntaxError = 13,
        HttpReturnCode_JsonMessageError = 14,
        HttpReturnCode_TokenValueError = 15,
        HttpReturnCode_WaiGuaUidError = 16,
        HttpReturnCode_NoGatewaytDown = 17,
        HttpReturnCode_NoGatewayDown = 17,
        HttpReturnCode_NoSdkServer = 18,
        HttpReturnCode_SdkCheckSignErr = 19,
        HttpReturnCode_Sdk3PartyServerErr = 20,
        HttpReturnCode_ProtobufErr = 21,
        HttpReturnCode_GatewayErr = 22,
        HttpReturnCode_Timeout = 23,
        HttpReturnCode_AccountUsing = 24,
        HttpReturnCode_OnlinePlatidErr = 25
    }

    /** Properties of a UserJsMessageForwardUserPmd_CS. */
    interface IUserJsMessageForwardUserPmd_CS {

        /** UserJsMessageForwardUserPmd_CS msg */
        msg?: (string|null);

        /** UserJsMessageForwardUserPmd_CS msgbytes */
        msgbytes?: (Uint8Array|null);

        /** UserJsMessageForwardUserPmd_CS proto */
        proto?: (string|null);
    }

    /** Represents a UserJsMessageForwardUserPmd_CS. */
    class UserJsMessageForwardUserPmd_CS implements IUserJsMessageForwardUserPmd_CS {

        /**
         * Constructs a new UserJsMessageForwardUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserJsMessageForwardUserPmd_CS);

        /** UserJsMessageForwardUserPmd_CS msg. */
        public msg: string;

        /** UserJsMessageForwardUserPmd_CS msgbytes. */
        public msgbytes: Uint8Array;

        /** UserJsMessageForwardUserPmd_CS proto. */
        public proto: string;

        /**
         * Creates a new UserJsMessageForwardUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserJsMessageForwardUserPmd_CS instance
         */
        public static create(properties?: Pmd.IUserJsMessageForwardUserPmd_CS): Pmd.UserJsMessageForwardUserPmd_CS;

        /**
         * Encodes the specified UserJsMessageForwardUserPmd_CS message. Does not implicitly {@link Pmd.UserJsMessageForwardUserPmd_CS.verify|verify} messages.
         * @param message UserJsMessageForwardUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserJsMessageForwardUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserJsMessageForwardUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.UserJsMessageForwardUserPmd_CS.verify|verify} messages.
         * @param message UserJsMessageForwardUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserJsMessageForwardUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserJsMessageForwardUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserJsMessageForwardUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserJsMessageForwardUserPmd_CS;

        /**
         * Decodes a UserJsMessageForwardUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserJsMessageForwardUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserJsMessageForwardUserPmd_CS;

        /**
         * Verifies a UserJsMessageForwardUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserJsMessageForwardUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserJsMessageForwardUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserJsMessageForwardUserPmd_CS;

        /**
         * Creates a plain object from a UserJsMessageForwardUserPmd_CS message. Also converts values to other types if specified.
         * @param message UserJsMessageForwardUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserJsMessageForwardUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserJsMessageForwardUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a BroadcastJsMessageForwardUserPmd_CS. */
    interface IBroadcastJsMessageForwardUserPmd_CS {

        /** BroadcastJsMessageForwardUserPmd_CS msg */
        msg?: (string|null);

        /** BroadcastJsMessageForwardUserPmd_CS msgbytes */
        msgbytes?: (Uint8Array|null);

        /** BroadcastJsMessageForwardUserPmd_CS proto */
        proto?: (string|null);

        /** BroadcastJsMessageForwardUserPmd_CS userlist */
        userlist?: ((number|Long)[]|null);
    }

    /** Represents a BroadcastJsMessageForwardUserPmd_CS. */
    class BroadcastJsMessageForwardUserPmd_CS implements IBroadcastJsMessageForwardUserPmd_CS {

        /**
         * Constructs a new BroadcastJsMessageForwardUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IBroadcastJsMessageForwardUserPmd_CS);

        /** BroadcastJsMessageForwardUserPmd_CS msg. */
        public msg: string;

        /** BroadcastJsMessageForwardUserPmd_CS msgbytes. */
        public msgbytes: Uint8Array;

        /** BroadcastJsMessageForwardUserPmd_CS proto. */
        public proto: string;

        /** BroadcastJsMessageForwardUserPmd_CS userlist. */
        public userlist: (number|Long)[];

        /**
         * Creates a new BroadcastJsMessageForwardUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BroadcastJsMessageForwardUserPmd_CS instance
         */
        public static create(properties?: Pmd.IBroadcastJsMessageForwardUserPmd_CS): Pmd.BroadcastJsMessageForwardUserPmd_CS;

        /**
         * Encodes the specified BroadcastJsMessageForwardUserPmd_CS message. Does not implicitly {@link Pmd.BroadcastJsMessageForwardUserPmd_CS.verify|verify} messages.
         * @param message BroadcastJsMessageForwardUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IBroadcastJsMessageForwardUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified BroadcastJsMessageForwardUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.BroadcastJsMessageForwardUserPmd_CS.verify|verify} messages.
         * @param message BroadcastJsMessageForwardUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IBroadcastJsMessageForwardUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a BroadcastJsMessageForwardUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BroadcastJsMessageForwardUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.BroadcastJsMessageForwardUserPmd_CS;

        /**
         * Decodes a BroadcastJsMessageForwardUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BroadcastJsMessageForwardUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.BroadcastJsMessageForwardUserPmd_CS;

        /**
         * Verifies a BroadcastJsMessageForwardUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BroadcastJsMessageForwardUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BroadcastJsMessageForwardUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.BroadcastJsMessageForwardUserPmd_CS;

        /**
         * Creates a plain object from a BroadcastJsMessageForwardUserPmd_CS message. Also converts values to other types if specified.
         * @param message BroadcastJsMessageForwardUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.BroadcastJsMessageForwardUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BroadcastJsMessageForwardUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a WebSocketForwardUserPmd_C. */
    interface IWebSocketForwardUserPmd_C {

        /** WebSocketForwardUserPmd_C accountid */
        accountid: (number|Long);
    }

    /** Represents a WebSocketForwardUserPmd_C. */
    class WebSocketForwardUserPmd_C implements IWebSocketForwardUserPmd_C {

        /**
         * Constructs a new WebSocketForwardUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IWebSocketForwardUserPmd_C);

        /** WebSocketForwardUserPmd_C accountid. */
        public accountid: (number|Long);

        /**
         * Creates a new WebSocketForwardUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns WebSocketForwardUserPmd_C instance
         */
        public static create(properties?: Pmd.IWebSocketForwardUserPmd_C): Pmd.WebSocketForwardUserPmd_C;

        /**
         * Encodes the specified WebSocketForwardUserPmd_C message. Does not implicitly {@link Pmd.WebSocketForwardUserPmd_C.verify|verify} messages.
         * @param message WebSocketForwardUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IWebSocketForwardUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified WebSocketForwardUserPmd_C message, length delimited. Does not implicitly {@link Pmd.WebSocketForwardUserPmd_C.verify|verify} messages.
         * @param message WebSocketForwardUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IWebSocketForwardUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a WebSocketForwardUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns WebSocketForwardUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.WebSocketForwardUserPmd_C;

        /**
         * Decodes a WebSocketForwardUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns WebSocketForwardUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.WebSocketForwardUserPmd_C;

        /**
         * Verifies a WebSocketForwardUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a WebSocketForwardUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns WebSocketForwardUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.WebSocketForwardUserPmd_C;

        /**
         * Creates a plain object from a WebSocketForwardUserPmd_C message. Also converts values to other types if specified.
         * @param message WebSocketForwardUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.WebSocketForwardUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this WebSocketForwardUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a WebSocketForwardUserPmd_S. */
    interface IWebSocketForwardUserPmd_S {

        /** WebSocketForwardUserPmd_S accountid */
        accountid: (number|Long);

        /** WebSocketForwardUserPmd_S jsongatewayurl */
        jsongatewayurl: string;

        /** WebSocketForwardUserPmd_S tokenid */
        tokenid: (number|Long);

        /** WebSocketForwardUserPmd_S logintempid */
        logintempid: (number|Long);

        /** WebSocketForwardUserPmd_S gatewayurl */
        gatewayurl: string;

        /** WebSocketForwardUserPmd_S gatewayurltcp */
        gatewayurltcp: string;
    }

    /** Represents a WebSocketForwardUserPmd_S. */
    class WebSocketForwardUserPmd_S implements IWebSocketForwardUserPmd_S {

        /**
         * Constructs a new WebSocketForwardUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IWebSocketForwardUserPmd_S);

        /** WebSocketForwardUserPmd_S accountid. */
        public accountid: (number|Long);

        /** WebSocketForwardUserPmd_S jsongatewayurl. */
        public jsongatewayurl: string;

        /** WebSocketForwardUserPmd_S tokenid. */
        public tokenid: (number|Long);

        /** WebSocketForwardUserPmd_S logintempid. */
        public logintempid: (number|Long);

        /** WebSocketForwardUserPmd_S gatewayurl. */
        public gatewayurl: string;

        /** WebSocketForwardUserPmd_S gatewayurltcp. */
        public gatewayurltcp: string;

        /**
         * Creates a new WebSocketForwardUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns WebSocketForwardUserPmd_S instance
         */
        public static create(properties?: Pmd.IWebSocketForwardUserPmd_S): Pmd.WebSocketForwardUserPmd_S;

        /**
         * Encodes the specified WebSocketForwardUserPmd_S message. Does not implicitly {@link Pmd.WebSocketForwardUserPmd_S.verify|verify} messages.
         * @param message WebSocketForwardUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IWebSocketForwardUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified WebSocketForwardUserPmd_S message, length delimited. Does not implicitly {@link Pmd.WebSocketForwardUserPmd_S.verify|verify} messages.
         * @param message WebSocketForwardUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IWebSocketForwardUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a WebSocketForwardUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns WebSocketForwardUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.WebSocketForwardUserPmd_S;

        /**
         * Decodes a WebSocketForwardUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns WebSocketForwardUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.WebSocketForwardUserPmd_S;

        /**
         * Verifies a WebSocketForwardUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a WebSocketForwardUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns WebSocketForwardUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.WebSocketForwardUserPmd_S;

        /**
         * Creates a plain object from a WebSocketForwardUserPmd_S message. Also converts values to other types if specified.
         * @param message WebSocketForwardUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.WebSocketForwardUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this WebSocketForwardUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Login. */
    interface ILogin {
    }

    /** Represents a Login. */
    class Login implements ILogin {

        /**
         * Constructs a new Login.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ILogin);

        /**
         * Creates a new Login instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Login instance
         */
        public static create(properties?: Pmd.ILogin): Pmd.Login;

        /**
         * Encodes the specified Login message. Does not implicitly {@link Pmd.Login.verify|verify} messages.
         * @param message Login message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ILogin, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified Login message, length delimited. Does not implicitly {@link Pmd.Login.verify|verify} messages.
         * @param message Login message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ILogin, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a Login message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Login
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.Login;

        /**
         * Decodes a Login message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Login
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.Login;

        /**
         * Verifies a Login message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Login message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Login
         */
        public static fromObject(object: { [k: string]: any }): Pmd.Login;

        /**
         * Creates a plain object from a Login message. Also converts values to other types if specified.
         * @param message Login
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.Login, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Login to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace Login {

        /** Param enum. */
        enum Param {
            AccountTokenVerifyLoginUserPmd_CS = 1,
            AccountTokenVerifyReturnLoginUserPmd_S = 2,
            ZoneInfoListLoginUserPmd_S = 3,
            UserLoginRequestLoginUserPmd_C = 4,
            UserLoginReturnFailLoginUserPmd_S = 5,
            UserLoginReturnOkLoginUserPmd_S = 6,
            UserLoginTokenLoginUserPmd_C = 7,
            ClientLogUrlLoginUserPmd_S = 8,
            MessageBoxLoginUserPmd_S = 9,
            RequestAccountRegisterLoginUserPmd_C = 10,
            ReturnAccountRegisterLoginUserPmd_S = 11,
            UserLogoutTokenLoginUserPmd_C = 12,
            UserLoginReconnectLoginUserPmd_C = 13,
            ReconnectKickoutLoginUserPmd_S = 14,
            ServerKickoutLoginUserPmd_S = 15,
            RequestZoneInfoListLoginUserPmd_C = 16,
            SetServerLangLoginUserPmd_C = 17,
            RequestClientIPLoginUserPmd_C = 18,
            ReturnClientIPLoginUserPmd_S = 19,
            ReconnectErrorLoginUserPmd_S = 20,
            CheckVersionLoginUserPmd_C = 21,
            PushAccountVerifyLoginUserPmd_C = 22,
            BehaviorClientVerifyLoginUserPmd_C = 23,
            RequestUserZoneInfoLoginUserPmd_C = 24,
            RequestUserZoneInfoLoginUserPmd_S = 25,
            MobileRegistRequestRandCodeLoginUserPmd_C = 26,
            MobileRegistReturnRandCodeLoginUserPmd_S = 27,
            MobileRegistRequestCreateAccountLoginUserPmd_C = 28,
            MobileRegistReturnCreateAccountFailLoginUserPmd_S = 29,
            RequestSupoortGameListLoginUserPmd_C = 30,
            ReturnSupoortGameListLoginUserPmd_S = 31,
            UserRequestPlatTokenByPasswordLoginUserPmd_C = 32,
            UserRequestPlatTokenByThirdLoginUserPmd_C = 33,
            UserRequestPlatTokenLoginOkLoginUserPmd_S = 34,
            UserRequestPlatTokenLoginFailLoginUserPmd_S = 35,
            EmailRegistRequestCreateAccountLoginUserPmd_C = 36,
            EmailRegistReturnCreateAccountLoginUserPmd_S = 37,
            UserLoginReconnectOkLoginUserPmd_S = 38,
            GameServerShutDownLoginUserPmd_S = 39,
            OnlineNumWaitingLoginUserPmd_S = 40,
            OnlineStateLoginUserPmd_CS = 41,
            ServerDebugLevelLoginUserPmd_S = 42,
            ServerShutDownLoginUserPmd_S = 43,
            RequestZoneStateLoginUserPmd_CS = 44,
            ClientConfigUpdateLoginUserPmd_S = 45
        }
    }

    /** Properties of an AccountTokenVerifyLoginUserPmd_CS. */
    interface IAccountTokenVerifyLoginUserPmd_CS {

        /** AccountTokenVerifyLoginUserPmd_CS account */
        account: string;

        /** AccountTokenVerifyLoginUserPmd_CS token */
        token: string;

        /** AccountTokenVerifyLoginUserPmd_CS version */
        version: number;

        /** AccountTokenVerifyLoginUserPmd_CS gameid */
        gameid?: (number|null);

        /** AccountTokenVerifyLoginUserPmd_CS mid */
        mid?: (string|null);

        /** AccountTokenVerifyLoginUserPmd_CS platid */
        platid?: (number|null);

        /** AccountTokenVerifyLoginUserPmd_CS zoneid */
        zoneid?: (number|null);

        /** AccountTokenVerifyLoginUserPmd_CS gameversion */
        gameversion?: (number|null);

        /** AccountTokenVerifyLoginUserPmd_CS compress */
        compress?: (string|null);

        /** AccountTokenVerifyLoginUserPmd_CS encrypt */
        encrypt?: (string|null);

        /** AccountTokenVerifyLoginUserPmd_CS encryptkey */
        encryptkey?: (string|null);
    }

    /** Represents an AccountTokenVerifyLoginUserPmd_CS. */
    class AccountTokenVerifyLoginUserPmd_CS implements IAccountTokenVerifyLoginUserPmd_CS {

        /**
         * Constructs a new AccountTokenVerifyLoginUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IAccountTokenVerifyLoginUserPmd_CS);

        /** AccountTokenVerifyLoginUserPmd_CS account. */
        public account: string;

        /** AccountTokenVerifyLoginUserPmd_CS token. */
        public token: string;

        /** AccountTokenVerifyLoginUserPmd_CS version. */
        public version: number;

        /** AccountTokenVerifyLoginUserPmd_CS gameid. */
        public gameid: number;

        /** AccountTokenVerifyLoginUserPmd_CS mid. */
        public mid: string;

        /** AccountTokenVerifyLoginUserPmd_CS platid. */
        public platid: number;

        /** AccountTokenVerifyLoginUserPmd_CS zoneid. */
        public zoneid: number;

        /** AccountTokenVerifyLoginUserPmd_CS gameversion. */
        public gameversion: number;

        /** AccountTokenVerifyLoginUserPmd_CS compress. */
        public compress: string;

        /** AccountTokenVerifyLoginUserPmd_CS encrypt. */
        public encrypt: string;

        /** AccountTokenVerifyLoginUserPmd_CS encryptkey. */
        public encryptkey: string;

        /**
         * Creates a new AccountTokenVerifyLoginUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AccountTokenVerifyLoginUserPmd_CS instance
         */
        public static create(properties?: Pmd.IAccountTokenVerifyLoginUserPmd_CS): Pmd.AccountTokenVerifyLoginUserPmd_CS;

        /**
         * Encodes the specified AccountTokenVerifyLoginUserPmd_CS message. Does not implicitly {@link Pmd.AccountTokenVerifyLoginUserPmd_CS.verify|verify} messages.
         * @param message AccountTokenVerifyLoginUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IAccountTokenVerifyLoginUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified AccountTokenVerifyLoginUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.AccountTokenVerifyLoginUserPmd_CS.verify|verify} messages.
         * @param message AccountTokenVerifyLoginUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IAccountTokenVerifyLoginUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes an AccountTokenVerifyLoginUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AccountTokenVerifyLoginUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.AccountTokenVerifyLoginUserPmd_CS;

        /**
         * Decodes an AccountTokenVerifyLoginUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AccountTokenVerifyLoginUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.AccountTokenVerifyLoginUserPmd_CS;

        /**
         * Verifies an AccountTokenVerifyLoginUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AccountTokenVerifyLoginUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AccountTokenVerifyLoginUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.AccountTokenVerifyLoginUserPmd_CS;

        /**
         * Creates a plain object from an AccountTokenVerifyLoginUserPmd_CS message. Also converts values to other types if specified.
         * @param message AccountTokenVerifyLoginUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.AccountTokenVerifyLoginUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AccountTokenVerifyLoginUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PushAccountVerifyLoginUserPmd_C. */
    interface IPushAccountVerifyLoginUserPmd_C {

        /** PushAccountVerifyLoginUserPmd_C accid */
        accid?: (number|Long|null);

        /** PushAccountVerifyLoginUserPmd_C account */
        account?: (string|null);

        /** PushAccountVerifyLoginUserPmd_C zoneid */
        zoneid?: (number|null);

        /** PushAccountVerifyLoginUserPmd_C token */
        token?: (string|null);

        /** PushAccountVerifyLoginUserPmd_C version */
        version?: (number|null);

        /** PushAccountVerifyLoginUserPmd_C mid */
        mid?: (string|null);

        /** PushAccountVerifyLoginUserPmd_C gameversion */
        gameversion?: (number|null);

        /** PushAccountVerifyLoginUserPmd_C compress */
        compress?: (string|null);

        /** PushAccountVerifyLoginUserPmd_C encrypt */
        encrypt?: (string|null);

        /** PushAccountVerifyLoginUserPmd_C encryptkey */
        encryptkey?: (string|null);
    }

    /** Represents a PushAccountVerifyLoginUserPmd_C. */
    class PushAccountVerifyLoginUserPmd_C implements IPushAccountVerifyLoginUserPmd_C {

        /**
         * Constructs a new PushAccountVerifyLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IPushAccountVerifyLoginUserPmd_C);

        /** PushAccountVerifyLoginUserPmd_C accid. */
        public accid: (number|Long);

        /** PushAccountVerifyLoginUserPmd_C account. */
        public account: string;

        /** PushAccountVerifyLoginUserPmd_C zoneid. */
        public zoneid: number;

        /** PushAccountVerifyLoginUserPmd_C token. */
        public token: string;

        /** PushAccountVerifyLoginUserPmd_C version. */
        public version: number;

        /** PushAccountVerifyLoginUserPmd_C mid. */
        public mid: string;

        /** PushAccountVerifyLoginUserPmd_C gameversion. */
        public gameversion: number;

        /** PushAccountVerifyLoginUserPmd_C compress. */
        public compress: string;

        /** PushAccountVerifyLoginUserPmd_C encrypt. */
        public encrypt: string;

        /** PushAccountVerifyLoginUserPmd_C encryptkey. */
        public encryptkey: string;

        /**
         * Creates a new PushAccountVerifyLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PushAccountVerifyLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IPushAccountVerifyLoginUserPmd_C): Pmd.PushAccountVerifyLoginUserPmd_C;

        /**
         * Encodes the specified PushAccountVerifyLoginUserPmd_C message. Does not implicitly {@link Pmd.PushAccountVerifyLoginUserPmd_C.verify|verify} messages.
         * @param message PushAccountVerifyLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IPushAccountVerifyLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified PushAccountVerifyLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.PushAccountVerifyLoginUserPmd_C.verify|verify} messages.
         * @param message PushAccountVerifyLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IPushAccountVerifyLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a PushAccountVerifyLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PushAccountVerifyLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.PushAccountVerifyLoginUserPmd_C;

        /**
         * Decodes a PushAccountVerifyLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PushAccountVerifyLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.PushAccountVerifyLoginUserPmd_C;

        /**
         * Verifies a PushAccountVerifyLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PushAccountVerifyLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PushAccountVerifyLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.PushAccountVerifyLoginUserPmd_C;

        /**
         * Creates a plain object from a PushAccountVerifyLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message PushAccountVerifyLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.PushAccountVerifyLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PushAccountVerifyLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** VerifyReturnReason enum. */
    enum VerifyReturnReason {
        LoginOk = 0,
        TokenFindError = 1,
        TokenDiffError = 2,
        VersionError = 3
    }

    /** Properties of an AccountTokenVerifyReturnLoginUserPmd_S. */
    interface IAccountTokenVerifyReturnLoginUserPmd_S {

        /** AccountTokenVerifyReturnLoginUserPmd_S retcode */
        retcode: Pmd.VerifyReturnReason;

        /** AccountTokenVerifyReturnLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents an AccountTokenVerifyReturnLoginUserPmd_S. */
    class AccountTokenVerifyReturnLoginUserPmd_S implements IAccountTokenVerifyReturnLoginUserPmd_S {

        /**
         * Constructs a new AccountTokenVerifyReturnLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IAccountTokenVerifyReturnLoginUserPmd_S);

        /** AccountTokenVerifyReturnLoginUserPmd_S retcode. */
        public retcode: Pmd.VerifyReturnReason;

        /** AccountTokenVerifyReturnLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new AccountTokenVerifyReturnLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AccountTokenVerifyReturnLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IAccountTokenVerifyReturnLoginUserPmd_S): Pmd.AccountTokenVerifyReturnLoginUserPmd_S;

        /**
         * Encodes the specified AccountTokenVerifyReturnLoginUserPmd_S message. Does not implicitly {@link Pmd.AccountTokenVerifyReturnLoginUserPmd_S.verify|verify} messages.
         * @param message AccountTokenVerifyReturnLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IAccountTokenVerifyReturnLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified AccountTokenVerifyReturnLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.AccountTokenVerifyReturnLoginUserPmd_S.verify|verify} messages.
         * @param message AccountTokenVerifyReturnLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IAccountTokenVerifyReturnLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes an AccountTokenVerifyReturnLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AccountTokenVerifyReturnLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.AccountTokenVerifyReturnLoginUserPmd_S;

        /**
         * Decodes an AccountTokenVerifyReturnLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AccountTokenVerifyReturnLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.AccountTokenVerifyReturnLoginUserPmd_S;

        /**
         * Verifies an AccountTokenVerifyReturnLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AccountTokenVerifyReturnLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AccountTokenVerifyReturnLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.AccountTokenVerifyReturnLoginUserPmd_S;

        /**
         * Creates a plain object from an AccountTokenVerifyReturnLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message AccountTokenVerifyReturnLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.AccountTokenVerifyReturnLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AccountTokenVerifyReturnLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** ZoneState enum. */
    enum ZoneState {
        Shutdown = 0,
        Normal = 1,
        Fullly = 2,
        Starting = 3
    }

    /** ZoneInfoBitMask enum. */
    enum ZoneInfoBitMask {
        ZoneInfoBitMask_None = 0,
        ZoneInfoBitMask_Normal = 1,
        ZoneInfoBitMask_SandBox = 2,
        ZoneInfoBitMask_NoOpen = 4
    }

    /** Properties of a ZoneInfo. */
    interface IZoneInfo {

        /** ZoneInfo zoneid */
        zoneid?: (number|null);

        /** ZoneInfo zonename */
        zonename?: (string|null);

        /** ZoneInfo state */
        state?: (Pmd.ZoneState|null);

        /** ZoneInfo opentime */
        opentime?: (string|null);

        /** ZoneInfo gameid */
        gameid?: (number|null);

        /** ZoneInfo iconurl */
        iconurl?: (string|null);

        /** ZoneInfo bitmask */
        bitmask?: (number|null);

        /** ZoneInfo gamename */
        gamename?: (string|null);

        /** ZoneInfo newzoneid */
        newzoneid?: (number|null);

        /** ZoneInfo onlinenum */
        onlinenum?: (number|null);

        /** ZoneInfo nextopentime */
        nextopentime?: (string|null);
    }

    /** Represents a ZoneInfo. */
    class ZoneInfo implements IZoneInfo {

        /**
         * Constructs a new ZoneInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IZoneInfo);

        /** ZoneInfo zoneid. */
        public zoneid: number;

        /** ZoneInfo zonename. */
        public zonename: string;

        /** ZoneInfo state. */
        public state: Pmd.ZoneState;

        /** ZoneInfo opentime. */
        public opentime: string;

        /** ZoneInfo gameid. */
        public gameid: number;

        /** ZoneInfo iconurl. */
        public iconurl: string;

        /** ZoneInfo bitmask. */
        public bitmask: number;

        /** ZoneInfo gamename. */
        public gamename: string;

        /** ZoneInfo newzoneid. */
        public newzoneid: number;

        /** ZoneInfo onlinenum. */
        public onlinenum: number;

        /** ZoneInfo nextopentime. */
        public nextopentime: string;

        /**
         * Creates a new ZoneInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ZoneInfo instance
         */
        public static create(properties?: Pmd.IZoneInfo): Pmd.ZoneInfo;

        /**
         * Encodes the specified ZoneInfo message. Does not implicitly {@link Pmd.ZoneInfo.verify|verify} messages.
         * @param message ZoneInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IZoneInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ZoneInfo message, length delimited. Does not implicitly {@link Pmd.ZoneInfo.verify|verify} messages.
         * @param message ZoneInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IZoneInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ZoneInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ZoneInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ZoneInfo;

        /**
         * Decodes a ZoneInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ZoneInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ZoneInfo;

        /**
         * Verifies a ZoneInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ZoneInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ZoneInfo
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ZoneInfo;

        /**
         * Creates a plain object from a ZoneInfo message. Also converts values to other types if specified.
         * @param message ZoneInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ZoneInfo, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ZoneInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ZoneInfoListLoginUserPmd_S. */
    interface IZoneInfoListLoginUserPmd_S {

        /** ZoneInfoListLoginUserPmd_S gamename */
        gamename?: (string|null);

        /** ZoneInfoListLoginUserPmd_S gameid */
        gameid?: (number|null);

        /** ZoneInfoListLoginUserPmd_S zonelist */
        zonelist?: (Pmd.IZoneInfo[]|null);

        /** ZoneInfoListLoginUserPmd_S zoneid */
        zoneid?: (number|null);

        /** ZoneInfoListLoginUserPmd_S bestzoneid */
        bestzoneid?: (number|null);
    }

    /** Represents a ZoneInfoListLoginUserPmd_S. */
    class ZoneInfoListLoginUserPmd_S implements IZoneInfoListLoginUserPmd_S {

        /**
         * Constructs a new ZoneInfoListLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IZoneInfoListLoginUserPmd_S);

        /** ZoneInfoListLoginUserPmd_S gamename. */
        public gamename: string;

        /** ZoneInfoListLoginUserPmd_S gameid. */
        public gameid: number;

        /** ZoneInfoListLoginUserPmd_S zonelist. */
        public zonelist: Pmd.IZoneInfo[];

        /** ZoneInfoListLoginUserPmd_S zoneid. */
        public zoneid: number;

        /** ZoneInfoListLoginUserPmd_S bestzoneid. */
        public bestzoneid: number;

        /**
         * Creates a new ZoneInfoListLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ZoneInfoListLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IZoneInfoListLoginUserPmd_S): Pmd.ZoneInfoListLoginUserPmd_S;

        /**
         * Encodes the specified ZoneInfoListLoginUserPmd_S message. Does not implicitly {@link Pmd.ZoneInfoListLoginUserPmd_S.verify|verify} messages.
         * @param message ZoneInfoListLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IZoneInfoListLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ZoneInfoListLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ZoneInfoListLoginUserPmd_S.verify|verify} messages.
         * @param message ZoneInfoListLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IZoneInfoListLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ZoneInfoListLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ZoneInfoListLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ZoneInfoListLoginUserPmd_S;

        /**
         * Decodes a ZoneInfoListLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ZoneInfoListLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ZoneInfoListLoginUserPmd_S;

        /**
         * Verifies a ZoneInfoListLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ZoneInfoListLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ZoneInfoListLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ZoneInfoListLoginUserPmd_S;

        /**
         * Creates a plain object from a ZoneInfoListLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ZoneInfoListLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ZoneInfoListLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ZoneInfoListLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestZoneInfoListLoginUserPmd_C. */
    interface IRequestZoneInfoListLoginUserPmd_C {

        /** RequestZoneInfoListLoginUserPmd_C gameid */
        gameid: number;
    }

    /** Represents a RequestZoneInfoListLoginUserPmd_C. */
    class RequestZoneInfoListLoginUserPmd_C implements IRequestZoneInfoListLoginUserPmd_C {

        /**
         * Constructs a new RequestZoneInfoListLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestZoneInfoListLoginUserPmd_C);

        /** RequestZoneInfoListLoginUserPmd_C gameid. */
        public gameid: number;

        /**
         * Creates a new RequestZoneInfoListLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestZoneInfoListLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IRequestZoneInfoListLoginUserPmd_C): Pmd.RequestZoneInfoListLoginUserPmd_C;

        /**
         * Encodes the specified RequestZoneInfoListLoginUserPmd_C message. Does not implicitly {@link Pmd.RequestZoneInfoListLoginUserPmd_C.verify|verify} messages.
         * @param message RequestZoneInfoListLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestZoneInfoListLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestZoneInfoListLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestZoneInfoListLoginUserPmd_C.verify|verify} messages.
         * @param message RequestZoneInfoListLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestZoneInfoListLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestZoneInfoListLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestZoneInfoListLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestZoneInfoListLoginUserPmd_C;

        /**
         * Decodes a RequestZoneInfoListLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestZoneInfoListLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestZoneInfoListLoginUserPmd_C;

        /**
         * Verifies a RequestZoneInfoListLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestZoneInfoListLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestZoneInfoListLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestZoneInfoListLoginUserPmd_C;

        /**
         * Creates a plain object from a RequestZoneInfoListLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message RequestZoneInfoListLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestZoneInfoListLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestZoneInfoListLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestUserZoneInfoLoginUserPmd_C. */
    interface IRequestUserZoneInfoLoginUserPmd_C {

        /** RequestUserZoneInfoLoginUserPmd_C gameid */
        gameid: number;
    }

    /** Represents a RequestUserZoneInfoLoginUserPmd_C. */
    class RequestUserZoneInfoLoginUserPmd_C implements IRequestUserZoneInfoLoginUserPmd_C {

        /**
         * Constructs a new RequestUserZoneInfoLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestUserZoneInfoLoginUserPmd_C);

        /** RequestUserZoneInfoLoginUserPmd_C gameid. */
        public gameid: number;

        /**
         * Creates a new RequestUserZoneInfoLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestUserZoneInfoLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IRequestUserZoneInfoLoginUserPmd_C): Pmd.RequestUserZoneInfoLoginUserPmd_C;

        /**
         * Encodes the specified RequestUserZoneInfoLoginUserPmd_C message. Does not implicitly {@link Pmd.RequestUserZoneInfoLoginUserPmd_C.verify|verify} messages.
         * @param message RequestUserZoneInfoLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestUserZoneInfoLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestUserZoneInfoLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestUserZoneInfoLoginUserPmd_C.verify|verify} messages.
         * @param message RequestUserZoneInfoLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestUserZoneInfoLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestUserZoneInfoLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestUserZoneInfoLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestUserZoneInfoLoginUserPmd_C;

        /**
         * Decodes a RequestUserZoneInfoLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestUserZoneInfoLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestUserZoneInfoLoginUserPmd_C;

        /**
         * Verifies a RequestUserZoneInfoLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestUserZoneInfoLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestUserZoneInfoLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestUserZoneInfoLoginUserPmd_C;

        /**
         * Creates a plain object from a RequestUserZoneInfoLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message RequestUserZoneInfoLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestUserZoneInfoLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestUserZoneInfoLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserZoneInfo. */
    interface IUserZoneInfo {

        /** UserZoneInfo charname */
        charname: string;

        /** UserZoneInfo zoneinfo */
        zoneinfo: Pmd.IZoneInfo;

        /** UserZoneInfo onlinenum */
        onlinenum: number;
    }

    /** Represents a UserZoneInfo. */
    class UserZoneInfo implements IUserZoneInfo {

        /**
         * Constructs a new UserZoneInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserZoneInfo);

        /** UserZoneInfo charname. */
        public charname: string;

        /** UserZoneInfo zoneinfo. */
        public zoneinfo: Pmd.IZoneInfo;

        /** UserZoneInfo onlinenum. */
        public onlinenum: number;

        /**
         * Creates a new UserZoneInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserZoneInfo instance
         */
        public static create(properties?: Pmd.IUserZoneInfo): Pmd.UserZoneInfo;

        /**
         * Encodes the specified UserZoneInfo message. Does not implicitly {@link Pmd.UserZoneInfo.verify|verify} messages.
         * @param message UserZoneInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserZoneInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserZoneInfo message, length delimited. Does not implicitly {@link Pmd.UserZoneInfo.verify|verify} messages.
         * @param message UserZoneInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserZoneInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserZoneInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserZoneInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserZoneInfo;

        /**
         * Decodes a UserZoneInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserZoneInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserZoneInfo;

        /**
         * Verifies a UserZoneInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserZoneInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserZoneInfo
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserZoneInfo;

        /**
         * Creates a plain object from a UserZoneInfo message. Also converts values to other types if specified.
         * @param message UserZoneInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserZoneInfo, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserZoneInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestUserZoneInfoLoginUserPmd_S. */
    interface IRequestUserZoneInfoLoginUserPmd_S {

        /** RequestUserZoneInfoLoginUserPmd_S userzoneinfo */
        userzoneinfo?: (Pmd.IUserZoneInfo[]|null);
    }

    /** Represents a RequestUserZoneInfoLoginUserPmd_S. */
    class RequestUserZoneInfoLoginUserPmd_S implements IRequestUserZoneInfoLoginUserPmd_S {

        /**
         * Constructs a new RequestUserZoneInfoLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestUserZoneInfoLoginUserPmd_S);

        /** RequestUserZoneInfoLoginUserPmd_S userzoneinfo. */
        public userzoneinfo: Pmd.IUserZoneInfo[];

        /**
         * Creates a new RequestUserZoneInfoLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestUserZoneInfoLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IRequestUserZoneInfoLoginUserPmd_S): Pmd.RequestUserZoneInfoLoginUserPmd_S;

        /**
         * Encodes the specified RequestUserZoneInfoLoginUserPmd_S message. Does not implicitly {@link Pmd.RequestUserZoneInfoLoginUserPmd_S.verify|verify} messages.
         * @param message RequestUserZoneInfoLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestUserZoneInfoLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestUserZoneInfoLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.RequestUserZoneInfoLoginUserPmd_S.verify|verify} messages.
         * @param message RequestUserZoneInfoLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestUserZoneInfoLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestUserZoneInfoLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestUserZoneInfoLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestUserZoneInfoLoginUserPmd_S;

        /**
         * Decodes a RequestUserZoneInfoLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestUserZoneInfoLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestUserZoneInfoLoginUserPmd_S;

        /**
         * Verifies a RequestUserZoneInfoLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestUserZoneInfoLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestUserZoneInfoLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestUserZoneInfoLoginUserPmd_S;

        /**
         * Creates a plain object from a RequestUserZoneInfoLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message RequestUserZoneInfoLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestUserZoneInfoLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestUserZoneInfoLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MobileRegistRequestRandCodeLoginUserPmd_C. */
    interface IMobileRegistRequestRandCodeLoginUserPmd_C {

        /** MobileRegistRequestRandCodeLoginUserPmd_C mobilenum */
        mobilenum: string;

        /** MobileRegistRequestRandCodeLoginUserPmd_C gameid */
        gameid: number;
    }

    /** Represents a MobileRegistRequestRandCodeLoginUserPmd_C. */
    class MobileRegistRequestRandCodeLoginUserPmd_C implements IMobileRegistRequestRandCodeLoginUserPmd_C {

        /**
         * Constructs a new MobileRegistRequestRandCodeLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IMobileRegistRequestRandCodeLoginUserPmd_C);

        /** MobileRegistRequestRandCodeLoginUserPmd_C mobilenum. */
        public mobilenum: string;

        /** MobileRegistRequestRandCodeLoginUserPmd_C gameid. */
        public gameid: number;

        /**
         * Creates a new MobileRegistRequestRandCodeLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MobileRegistRequestRandCodeLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IMobileRegistRequestRandCodeLoginUserPmd_C): Pmd.MobileRegistRequestRandCodeLoginUserPmd_C;

        /**
         * Encodes the specified MobileRegistRequestRandCodeLoginUserPmd_C message. Does not implicitly {@link Pmd.MobileRegistRequestRandCodeLoginUserPmd_C.verify|verify} messages.
         * @param message MobileRegistRequestRandCodeLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IMobileRegistRequestRandCodeLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified MobileRegistRequestRandCodeLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.MobileRegistRequestRandCodeLoginUserPmd_C.verify|verify} messages.
         * @param message MobileRegistRequestRandCodeLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IMobileRegistRequestRandCodeLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a MobileRegistRequestRandCodeLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MobileRegistRequestRandCodeLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.MobileRegistRequestRandCodeLoginUserPmd_C;

        /**
         * Decodes a MobileRegistRequestRandCodeLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MobileRegistRequestRandCodeLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.MobileRegistRequestRandCodeLoginUserPmd_C;

        /**
         * Verifies a MobileRegistRequestRandCodeLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MobileRegistRequestRandCodeLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MobileRegistRequestRandCodeLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.MobileRegistRequestRandCodeLoginUserPmd_C;

        /**
         * Creates a plain object from a MobileRegistRequestRandCodeLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message MobileRegistRequestRandCodeLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.MobileRegistRequestRandCodeLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MobileRegistRequestRandCodeLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MobileRegistReturnRandCodeLoginUserPmd_S. */
    interface IMobileRegistReturnRandCodeLoginUserPmd_S {

        /** MobileRegistReturnRandCodeLoginUserPmd_S retcode */
        retcode: number;

        /** MobileRegistReturnRandCodeLoginUserPmd_S desc */
        desc?: (string|null);

        /** MobileRegistReturnRandCodeLoginUserPmd_S timeout */
        timeout?: (number|Long|null);
    }

    /** Represents a MobileRegistReturnRandCodeLoginUserPmd_S. */
    class MobileRegistReturnRandCodeLoginUserPmd_S implements IMobileRegistReturnRandCodeLoginUserPmd_S {

        /**
         * Constructs a new MobileRegistReturnRandCodeLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IMobileRegistReturnRandCodeLoginUserPmd_S);

        /** MobileRegistReturnRandCodeLoginUserPmd_S retcode. */
        public retcode: number;

        /** MobileRegistReturnRandCodeLoginUserPmd_S desc. */
        public desc: string;

        /** MobileRegistReturnRandCodeLoginUserPmd_S timeout. */
        public timeout: (number|Long);

        /**
         * Creates a new MobileRegistReturnRandCodeLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MobileRegistReturnRandCodeLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IMobileRegistReturnRandCodeLoginUserPmd_S): Pmd.MobileRegistReturnRandCodeLoginUserPmd_S;

        /**
         * Encodes the specified MobileRegistReturnRandCodeLoginUserPmd_S message. Does not implicitly {@link Pmd.MobileRegistReturnRandCodeLoginUserPmd_S.verify|verify} messages.
         * @param message MobileRegistReturnRandCodeLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IMobileRegistReturnRandCodeLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified MobileRegistReturnRandCodeLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.MobileRegistReturnRandCodeLoginUserPmd_S.verify|verify} messages.
         * @param message MobileRegistReturnRandCodeLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IMobileRegistReturnRandCodeLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a MobileRegistReturnRandCodeLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MobileRegistReturnRandCodeLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.MobileRegistReturnRandCodeLoginUserPmd_S;

        /**
         * Decodes a MobileRegistReturnRandCodeLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MobileRegistReturnRandCodeLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.MobileRegistReturnRandCodeLoginUserPmd_S;

        /**
         * Verifies a MobileRegistReturnRandCodeLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MobileRegistReturnRandCodeLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MobileRegistReturnRandCodeLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.MobileRegistReturnRandCodeLoginUserPmd_S;

        /**
         * Creates a plain object from a MobileRegistReturnRandCodeLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message MobileRegistReturnRandCodeLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.MobileRegistReturnRandCodeLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MobileRegistReturnRandCodeLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MobileRegistRequestCreateAccountLoginUserPmd_C. */
    interface IMobileRegistRequestCreateAccountLoginUserPmd_C {

        /** MobileRegistRequestCreateAccountLoginUserPmd_C mobilenum */
        mobilenum: string;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C randcode */
        randcode: string;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C password */
        password: string;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C gameid */
        gameid: number;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C parent */
        parent?: (number|Long|null);
    }

    /** Represents a MobileRegistRequestCreateAccountLoginUserPmd_C. */
    class MobileRegistRequestCreateAccountLoginUserPmd_C implements IMobileRegistRequestCreateAccountLoginUserPmd_C {

        /**
         * Constructs a new MobileRegistRequestCreateAccountLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IMobileRegistRequestCreateAccountLoginUserPmd_C);

        /** MobileRegistRequestCreateAccountLoginUserPmd_C mobilenum. */
        public mobilenum: string;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C randcode. */
        public randcode: string;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C password. */
        public password: string;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C gameid. */
        public gameid: number;

        /** MobileRegistRequestCreateAccountLoginUserPmd_C parent. */
        public parent: (number|Long);

        /**
         * Creates a new MobileRegistRequestCreateAccountLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MobileRegistRequestCreateAccountLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IMobileRegistRequestCreateAccountLoginUserPmd_C): Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Encodes the specified MobileRegistRequestCreateAccountLoginUserPmd_C message. Does not implicitly {@link Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C.verify|verify} messages.
         * @param message MobileRegistRequestCreateAccountLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IMobileRegistRequestCreateAccountLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified MobileRegistRequestCreateAccountLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C.verify|verify} messages.
         * @param message MobileRegistRequestCreateAccountLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IMobileRegistRequestCreateAccountLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a MobileRegistRequestCreateAccountLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MobileRegistRequestCreateAccountLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Decodes a MobileRegistRequestCreateAccountLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MobileRegistRequestCreateAccountLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Verifies a MobileRegistRequestCreateAccountLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MobileRegistRequestCreateAccountLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MobileRegistRequestCreateAccountLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Creates a plain object from a MobileRegistRequestCreateAccountLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message MobileRegistRequestCreateAccountLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.MobileRegistRequestCreateAccountLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MobileRegistRequestCreateAccountLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MobileRegistReturnCreateAccountFailLoginUserPmd_S. */
    interface IMobileRegistReturnCreateAccountFailLoginUserPmd_S {

        /** MobileRegistReturnCreateAccountFailLoginUserPmd_S retcode */
        retcode: number;

        /** MobileRegistReturnCreateAccountFailLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents a MobileRegistReturnCreateAccountFailLoginUserPmd_S. */
    class MobileRegistReturnCreateAccountFailLoginUserPmd_S implements IMobileRegistReturnCreateAccountFailLoginUserPmd_S {

        /**
         * Constructs a new MobileRegistReturnCreateAccountFailLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IMobileRegistReturnCreateAccountFailLoginUserPmd_S);

        /** MobileRegistReturnCreateAccountFailLoginUserPmd_S retcode. */
        public retcode: number;

        /** MobileRegistReturnCreateAccountFailLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new MobileRegistReturnCreateAccountFailLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MobileRegistReturnCreateAccountFailLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IMobileRegistReturnCreateAccountFailLoginUserPmd_S): Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S;

        /**
         * Encodes the specified MobileRegistReturnCreateAccountFailLoginUserPmd_S message. Does not implicitly {@link Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S.verify|verify} messages.
         * @param message MobileRegistReturnCreateAccountFailLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IMobileRegistReturnCreateAccountFailLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified MobileRegistReturnCreateAccountFailLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S.verify|verify} messages.
         * @param message MobileRegistReturnCreateAccountFailLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IMobileRegistReturnCreateAccountFailLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a MobileRegistReturnCreateAccountFailLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MobileRegistReturnCreateAccountFailLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S;

        /**
         * Decodes a MobileRegistReturnCreateAccountFailLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MobileRegistReturnCreateAccountFailLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S;

        /**
         * Verifies a MobileRegistReturnCreateAccountFailLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MobileRegistReturnCreateAccountFailLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MobileRegistReturnCreateAccountFailLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S;

        /**
         * Creates a plain object from a MobileRegistReturnCreateAccountFailLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message MobileRegistReturnCreateAccountFailLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.MobileRegistReturnCreateAccountFailLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MobileRegistReturnCreateAccountFailLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an EmailRegistRequestCreateAccountLoginUserPmd_C. */
    interface IEmailRegistRequestCreateAccountLoginUserPmd_C {

        /** EmailRegistRequestCreateAccountLoginUserPmd_C email */
        email: string;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C password */
        password: string;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C gameid */
        gameid: number;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C isbind */
        isbind?: (boolean|null);

        /** EmailRegistRequestCreateAccountLoginUserPmd_C uid */
        uid?: (number|Long|null);

        /** EmailRegistRequestCreateAccountLoginUserPmd_C parent */
        parent?: (number|Long|null);

        /** EmailRegistRequestCreateAccountLoginUserPmd_C mobilenum */
        mobilenum?: (string|null);
    }

    /** Represents an EmailRegistRequestCreateAccountLoginUserPmd_C. */
    class EmailRegistRequestCreateAccountLoginUserPmd_C implements IEmailRegistRequestCreateAccountLoginUserPmd_C {

        /**
         * Constructs a new EmailRegistRequestCreateAccountLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IEmailRegistRequestCreateAccountLoginUserPmd_C);

        /** EmailRegistRequestCreateAccountLoginUserPmd_C email. */
        public email: string;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C password. */
        public password: string;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C gameid. */
        public gameid: number;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C isbind. */
        public isbind: boolean;

        /** EmailRegistRequestCreateAccountLoginUserPmd_C uid. */
        public uid: (number|Long);

        /** EmailRegistRequestCreateAccountLoginUserPmd_C parent. */
        public parent: (number|Long);

        /** EmailRegistRequestCreateAccountLoginUserPmd_C mobilenum. */
        public mobilenum: string;

        /**
         * Creates a new EmailRegistRequestCreateAccountLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EmailRegistRequestCreateAccountLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IEmailRegistRequestCreateAccountLoginUserPmd_C): Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Encodes the specified EmailRegistRequestCreateAccountLoginUserPmd_C message. Does not implicitly {@link Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C.verify|verify} messages.
         * @param message EmailRegistRequestCreateAccountLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IEmailRegistRequestCreateAccountLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified EmailRegistRequestCreateAccountLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C.verify|verify} messages.
         * @param message EmailRegistRequestCreateAccountLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IEmailRegistRequestCreateAccountLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes an EmailRegistRequestCreateAccountLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EmailRegistRequestCreateAccountLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Decodes an EmailRegistRequestCreateAccountLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EmailRegistRequestCreateAccountLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Verifies an EmailRegistRequestCreateAccountLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EmailRegistRequestCreateAccountLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EmailRegistRequestCreateAccountLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C;

        /**
         * Creates a plain object from an EmailRegistRequestCreateAccountLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message EmailRegistRequestCreateAccountLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.EmailRegistRequestCreateAccountLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EmailRegistRequestCreateAccountLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an EmailRegistReturnCreateAccountLoginUserPmd_S. */
    interface IEmailRegistReturnCreateAccountLoginUserPmd_S {

        /** EmailRegistReturnCreateAccountLoginUserPmd_S retcode */
        retcode: number;

        /** EmailRegistReturnCreateAccountLoginUserPmd_S desc */
        desc?: (string|null);

        /** EmailRegistReturnCreateAccountLoginUserPmd_S uid */
        uid?: (number|Long|null);
    }

    /** Represents an EmailRegistReturnCreateAccountLoginUserPmd_S. */
    class EmailRegistReturnCreateAccountLoginUserPmd_S implements IEmailRegistReturnCreateAccountLoginUserPmd_S {

        /**
         * Constructs a new EmailRegistReturnCreateAccountLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IEmailRegistReturnCreateAccountLoginUserPmd_S);

        /** EmailRegistReturnCreateAccountLoginUserPmd_S retcode. */
        public retcode: number;

        /** EmailRegistReturnCreateAccountLoginUserPmd_S desc. */
        public desc: string;

        /** EmailRegistReturnCreateAccountLoginUserPmd_S uid. */
        public uid: (number|Long);

        /**
         * Creates a new EmailRegistReturnCreateAccountLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EmailRegistReturnCreateAccountLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IEmailRegistReturnCreateAccountLoginUserPmd_S): Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S;

        /**
         * Encodes the specified EmailRegistReturnCreateAccountLoginUserPmd_S message. Does not implicitly {@link Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S.verify|verify} messages.
         * @param message EmailRegistReturnCreateAccountLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IEmailRegistReturnCreateAccountLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified EmailRegistReturnCreateAccountLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S.verify|verify} messages.
         * @param message EmailRegistReturnCreateAccountLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IEmailRegistReturnCreateAccountLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes an EmailRegistReturnCreateAccountLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EmailRegistReturnCreateAccountLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S;

        /**
         * Decodes an EmailRegistReturnCreateAccountLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EmailRegistReturnCreateAccountLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S;

        /**
         * Verifies an EmailRegistReturnCreateAccountLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EmailRegistReturnCreateAccountLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EmailRegistReturnCreateAccountLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S;

        /**
         * Creates a plain object from an EmailRegistReturnCreateAccountLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message EmailRegistReturnCreateAccountLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.EmailRegistReturnCreateAccountLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EmailRegistReturnCreateAccountLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserRequestPlatTokenByPasswordLoginUserPmd_C. */
    interface IUserRequestPlatTokenByPasswordLoginUserPmd_C {

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C gameid */
        gameid: number;

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C platid */
        platid: number;

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C account */
        account: string;

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C password */
        password: string;
    }

    /** Represents a UserRequestPlatTokenByPasswordLoginUserPmd_C. */
    class UserRequestPlatTokenByPasswordLoginUserPmd_C implements IUserRequestPlatTokenByPasswordLoginUserPmd_C {

        /**
         * Constructs a new UserRequestPlatTokenByPasswordLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserRequestPlatTokenByPasswordLoginUserPmd_C);

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C gameid. */
        public gameid: number;

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C platid. */
        public platid: number;

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C account. */
        public account: string;

        /** UserRequestPlatTokenByPasswordLoginUserPmd_C password. */
        public password: string;

        /**
         * Creates a new UserRequestPlatTokenByPasswordLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserRequestPlatTokenByPasswordLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IUserRequestPlatTokenByPasswordLoginUserPmd_C): Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C;

        /**
         * Encodes the specified UserRequestPlatTokenByPasswordLoginUserPmd_C message. Does not implicitly {@link Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C.verify|verify} messages.
         * @param message UserRequestPlatTokenByPasswordLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserRequestPlatTokenByPasswordLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserRequestPlatTokenByPasswordLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C.verify|verify} messages.
         * @param message UserRequestPlatTokenByPasswordLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserRequestPlatTokenByPasswordLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserRequestPlatTokenByPasswordLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserRequestPlatTokenByPasswordLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C;

        /**
         * Decodes a UserRequestPlatTokenByPasswordLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserRequestPlatTokenByPasswordLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C;

        /**
         * Verifies a UserRequestPlatTokenByPasswordLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserRequestPlatTokenByPasswordLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserRequestPlatTokenByPasswordLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C;

        /**
         * Creates a plain object from a UserRequestPlatTokenByPasswordLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message UserRequestPlatTokenByPasswordLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserRequestPlatTokenByPasswordLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserRequestPlatTokenByPasswordLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserRequestPlatTokenByThirdLoginUserPmd_C. */
    interface IUserRequestPlatTokenByThirdLoginUserPmd_C {

        /** UserRequestPlatTokenByThirdLoginUserPmd_C platinfo */
        platinfo: Pmd.IPlatInfo;

        /** UserRequestPlatTokenByThirdLoginUserPmd_C gameid */
        gameid: number;
    }

    /** Represents a UserRequestPlatTokenByThirdLoginUserPmd_C. */
    class UserRequestPlatTokenByThirdLoginUserPmd_C implements IUserRequestPlatTokenByThirdLoginUserPmd_C {

        /**
         * Constructs a new UserRequestPlatTokenByThirdLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserRequestPlatTokenByThirdLoginUserPmd_C);

        /** UserRequestPlatTokenByThirdLoginUserPmd_C platinfo. */
        public platinfo: Pmd.IPlatInfo;

        /** UserRequestPlatTokenByThirdLoginUserPmd_C gameid. */
        public gameid: number;

        /**
         * Creates a new UserRequestPlatTokenByThirdLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserRequestPlatTokenByThirdLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IUserRequestPlatTokenByThirdLoginUserPmd_C): Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C;

        /**
         * Encodes the specified UserRequestPlatTokenByThirdLoginUserPmd_C message. Does not implicitly {@link Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C.verify|verify} messages.
         * @param message UserRequestPlatTokenByThirdLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserRequestPlatTokenByThirdLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserRequestPlatTokenByThirdLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C.verify|verify} messages.
         * @param message UserRequestPlatTokenByThirdLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserRequestPlatTokenByThirdLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserRequestPlatTokenByThirdLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserRequestPlatTokenByThirdLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C;

        /**
         * Decodes a UserRequestPlatTokenByThirdLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserRequestPlatTokenByThirdLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C;

        /**
         * Verifies a UserRequestPlatTokenByThirdLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserRequestPlatTokenByThirdLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserRequestPlatTokenByThirdLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C;

        /**
         * Creates a plain object from a UserRequestPlatTokenByThirdLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message UserRequestPlatTokenByThirdLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserRequestPlatTokenByThirdLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserRequestPlatTokenByThirdLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserRequestPlatTokenLoginOkLoginUserPmd_S. */
    interface IUserRequestPlatTokenLoginOkLoginUserPmd_S {

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S uid */
        uid: (number|Long);

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platkey */
        platkey: string;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platlogin */
        platlogin: string;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platloginlife */
        platloginlife: number;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S timezonename */
        timezonename: string;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S timezoneoffset */
        timezoneoffset?: (number|null);

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platinfo */
        platinfo?: (Pmd.IPlatInfo|null);
    }

    /** Represents a UserRequestPlatTokenLoginOkLoginUserPmd_S. */
    class UserRequestPlatTokenLoginOkLoginUserPmd_S implements IUserRequestPlatTokenLoginOkLoginUserPmd_S {

        /**
         * Constructs a new UserRequestPlatTokenLoginOkLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserRequestPlatTokenLoginOkLoginUserPmd_S);

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S uid. */
        public uid: (number|Long);

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platkey. */
        public platkey: string;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platlogin. */
        public platlogin: string;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platloginlife. */
        public platloginlife: number;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S timezonename. */
        public timezonename: string;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S timezoneoffset. */
        public timezoneoffset: number;

        /** UserRequestPlatTokenLoginOkLoginUserPmd_S platinfo. */
        public platinfo?: (Pmd.IPlatInfo|null);

        /**
         * Creates a new UserRequestPlatTokenLoginOkLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserRequestPlatTokenLoginOkLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IUserRequestPlatTokenLoginOkLoginUserPmd_S): Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S;

        /**
         * Encodes the specified UserRequestPlatTokenLoginOkLoginUserPmd_S message. Does not implicitly {@link Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S.verify|verify} messages.
         * @param message UserRequestPlatTokenLoginOkLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserRequestPlatTokenLoginOkLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserRequestPlatTokenLoginOkLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S.verify|verify} messages.
         * @param message UserRequestPlatTokenLoginOkLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserRequestPlatTokenLoginOkLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserRequestPlatTokenLoginOkLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserRequestPlatTokenLoginOkLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S;

        /**
         * Decodes a UserRequestPlatTokenLoginOkLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserRequestPlatTokenLoginOkLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S;

        /**
         * Verifies a UserRequestPlatTokenLoginOkLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserRequestPlatTokenLoginOkLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserRequestPlatTokenLoginOkLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S;

        /**
         * Creates a plain object from a UserRequestPlatTokenLoginOkLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message UserRequestPlatTokenLoginOkLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserRequestPlatTokenLoginOkLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserRequestPlatTokenLoginOkLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserRequestPlatTokenLoginFailLoginUserPmd_S. */
    interface IUserRequestPlatTokenLoginFailLoginUserPmd_S {

        /** UserRequestPlatTokenLoginFailLoginUserPmd_S retcode */
        retcode: number;

        /** UserRequestPlatTokenLoginFailLoginUserPmd_S desc */
        desc: string;
    }

    /** Represents a UserRequestPlatTokenLoginFailLoginUserPmd_S. */
    class UserRequestPlatTokenLoginFailLoginUserPmd_S implements IUserRequestPlatTokenLoginFailLoginUserPmd_S {

        /**
         * Constructs a new UserRequestPlatTokenLoginFailLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserRequestPlatTokenLoginFailLoginUserPmd_S);

        /** UserRequestPlatTokenLoginFailLoginUserPmd_S retcode. */
        public retcode: number;

        /** UserRequestPlatTokenLoginFailLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new UserRequestPlatTokenLoginFailLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserRequestPlatTokenLoginFailLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IUserRequestPlatTokenLoginFailLoginUserPmd_S): Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S;

        /**
         * Encodes the specified UserRequestPlatTokenLoginFailLoginUserPmd_S message. Does not implicitly {@link Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S.verify|verify} messages.
         * @param message UserRequestPlatTokenLoginFailLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserRequestPlatTokenLoginFailLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserRequestPlatTokenLoginFailLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S.verify|verify} messages.
         * @param message UserRequestPlatTokenLoginFailLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserRequestPlatTokenLoginFailLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserRequestPlatTokenLoginFailLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserRequestPlatTokenLoginFailLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S;

        /**
         * Decodes a UserRequestPlatTokenLoginFailLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserRequestPlatTokenLoginFailLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S;

        /**
         * Verifies a UserRequestPlatTokenLoginFailLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserRequestPlatTokenLoginFailLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserRequestPlatTokenLoginFailLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S;

        /**
         * Creates a plain object from a UserRequestPlatTokenLoginFailLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message UserRequestPlatTokenLoginFailLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserRequestPlatTokenLoginFailLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserRequestPlatTokenLoginFailLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserLoginRequestLoginUserPmd_C. */
    interface IUserLoginRequestLoginUserPmd_C {

        /** UserLoginRequestLoginUserPmd_C gameid */
        gameid: number;

        /** UserLoginRequestLoginUserPmd_C zoneid */
        zoneid: number;

        /** UserLoginRequestLoginUserPmd_C gameversion */
        gameversion: number;

        /** UserLoginRequestLoginUserPmd_C mid */
        mid?: (string|null);
    }

    /** Represents a UserLoginRequestLoginUserPmd_C. */
    class UserLoginRequestLoginUserPmd_C implements IUserLoginRequestLoginUserPmd_C {

        /**
         * Constructs a new UserLoginRequestLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLoginRequestLoginUserPmd_C);

        /** UserLoginRequestLoginUserPmd_C gameid. */
        public gameid: number;

        /** UserLoginRequestLoginUserPmd_C zoneid. */
        public zoneid: number;

        /** UserLoginRequestLoginUserPmd_C gameversion. */
        public gameversion: number;

        /** UserLoginRequestLoginUserPmd_C mid. */
        public mid: string;

        /**
         * Creates a new UserLoginRequestLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLoginRequestLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IUserLoginRequestLoginUserPmd_C): Pmd.UserLoginRequestLoginUserPmd_C;

        /**
         * Encodes the specified UserLoginRequestLoginUserPmd_C message. Does not implicitly {@link Pmd.UserLoginRequestLoginUserPmd_C.verify|verify} messages.
         * @param message UserLoginRequestLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLoginRequestLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLoginRequestLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.UserLoginRequestLoginUserPmd_C.verify|verify} messages.
         * @param message UserLoginRequestLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLoginRequestLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLoginRequestLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLoginRequestLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLoginRequestLoginUserPmd_C;

        /**
         * Decodes a UserLoginRequestLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLoginRequestLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLoginRequestLoginUserPmd_C;

        /**
         * Verifies a UserLoginRequestLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLoginRequestLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLoginRequestLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLoginRequestLoginUserPmd_C;

        /**
         * Creates a plain object from a UserLoginRequestLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message UserLoginRequestLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLoginRequestLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLoginRequestLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** LoginReturnFailReason enum. */
    enum LoginReturnFailReason {
        Password = 1,
        ServerShutdown = 2,
        VersionTooLow = 3,
        UserTokenFind = 4,
        UserTokenTempId = 5,
        UserTokenTimeOut = 6,
        LoginDulicate = 7,
        NoGatewaytDown = 8,
        AccountUsing = 9,
        GatewayUserMax = 10,
        WaiGuaPunish = 11,
        ServerStartTime = 12
    }

    /** Properties of a UserLoginReturnFailLoginUserPmd_S. */
    interface IUserLoginReturnFailLoginUserPmd_S {

        /** UserLoginReturnFailLoginUserPmd_S retcode */
        retcode?: (Pmd.LoginReturnFailReason|null);

        /** UserLoginReturnFailLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents a UserLoginReturnFailLoginUserPmd_S. */
    class UserLoginReturnFailLoginUserPmd_S implements IUserLoginReturnFailLoginUserPmd_S {

        /**
         * Constructs a new UserLoginReturnFailLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLoginReturnFailLoginUserPmd_S);

        /** UserLoginReturnFailLoginUserPmd_S retcode. */
        public retcode: Pmd.LoginReturnFailReason;

        /** UserLoginReturnFailLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new UserLoginReturnFailLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLoginReturnFailLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IUserLoginReturnFailLoginUserPmd_S): Pmd.UserLoginReturnFailLoginUserPmd_S;

        /**
         * Encodes the specified UserLoginReturnFailLoginUserPmd_S message. Does not implicitly {@link Pmd.UserLoginReturnFailLoginUserPmd_S.verify|verify} messages.
         * @param message UserLoginReturnFailLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLoginReturnFailLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLoginReturnFailLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.UserLoginReturnFailLoginUserPmd_S.verify|verify} messages.
         * @param message UserLoginReturnFailLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLoginReturnFailLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLoginReturnFailLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLoginReturnFailLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLoginReturnFailLoginUserPmd_S;

        /**
         * Decodes a UserLoginReturnFailLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLoginReturnFailLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLoginReturnFailLoginUserPmd_S;

        /**
         * Verifies a UserLoginReturnFailLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLoginReturnFailLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLoginReturnFailLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLoginReturnFailLoginUserPmd_S;

        /**
         * Creates a plain object from a UserLoginReturnFailLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message UserLoginReturnFailLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLoginReturnFailLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLoginReturnFailLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserLoginReturnOkLoginUserPmd_S. */
    interface IUserLoginReturnOkLoginUserPmd_S {

        /** UserLoginReturnOkLoginUserPmd_S accountid */
        accountid: (number|Long);

        /** UserLoginReturnOkLoginUserPmd_S logintempid */
        logintempid?: (number|Long|null);

        /** UserLoginReturnOkLoginUserPmd_S tokenid */
        tokenid?: (number|Long|null);

        /** UserLoginReturnOkLoginUserPmd_S gatewayurl */
        gatewayurl?: (string|null);

        /** UserLoginReturnOkLoginUserPmd_S gameid */
        gameid?: (number|null);

        /** UserLoginReturnOkLoginUserPmd_S zoneid */
        zoneid?: (number|null);

        /** UserLoginReturnOkLoginUserPmd_S separatezoneuid */
        separatezoneuid?: (boolean|null);

        /** UserLoginReturnOkLoginUserPmd_S zoneuid */
        zoneuid?: (string|null);

        /** UserLoginReturnOkLoginUserPmd_S gatewayurltcp */
        gatewayurltcp?: (string|null);

        /** UserLoginReturnOkLoginUserPmd_S gatewayurlws */
        gatewayurlws?: (string|null);

        /** UserLoginReturnOkLoginUserPmd_S configmd5 */
        configmd5?: (string|null);

        /** UserLoginReturnOkLoginUserPmd_S configurl */
        configurl?: (string|null);

        /** UserLoginReturnOkLoginUserPmd_S minversion */
        minversion?: (string|null);
    }

    /** Represents a UserLoginReturnOkLoginUserPmd_S. */
    class UserLoginReturnOkLoginUserPmd_S implements IUserLoginReturnOkLoginUserPmd_S {

        /**
         * Constructs a new UserLoginReturnOkLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLoginReturnOkLoginUserPmd_S);

        /** UserLoginReturnOkLoginUserPmd_S accountid. */
        public accountid: (number|Long);

        /** UserLoginReturnOkLoginUserPmd_S logintempid. */
        public logintempid: (number|Long);

        /** UserLoginReturnOkLoginUserPmd_S tokenid. */
        public tokenid: (number|Long);

        /** UserLoginReturnOkLoginUserPmd_S gatewayurl. */
        public gatewayurl: string;

        /** UserLoginReturnOkLoginUserPmd_S gameid. */
        public gameid: number;

        /** UserLoginReturnOkLoginUserPmd_S zoneid. */
        public zoneid: number;

        /** UserLoginReturnOkLoginUserPmd_S separatezoneuid. */
        public separatezoneuid: boolean;

        /** UserLoginReturnOkLoginUserPmd_S zoneuid. */
        public zoneuid: string;

        /** UserLoginReturnOkLoginUserPmd_S gatewayurltcp. */
        public gatewayurltcp: string;

        /** UserLoginReturnOkLoginUserPmd_S gatewayurlws. */
        public gatewayurlws: string;

        /** UserLoginReturnOkLoginUserPmd_S configmd5. */
        public configmd5: string;

        /** UserLoginReturnOkLoginUserPmd_S configurl. */
        public configurl: string;

        /** UserLoginReturnOkLoginUserPmd_S minversion. */
        public minversion: string;

        /**
         * Creates a new UserLoginReturnOkLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLoginReturnOkLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IUserLoginReturnOkLoginUserPmd_S): Pmd.UserLoginReturnOkLoginUserPmd_S;

        /**
         * Encodes the specified UserLoginReturnOkLoginUserPmd_S message. Does not implicitly {@link Pmd.UserLoginReturnOkLoginUserPmd_S.verify|verify} messages.
         * @param message UserLoginReturnOkLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLoginReturnOkLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLoginReturnOkLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.UserLoginReturnOkLoginUserPmd_S.verify|verify} messages.
         * @param message UserLoginReturnOkLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLoginReturnOkLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLoginReturnOkLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLoginReturnOkLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLoginReturnOkLoginUserPmd_S;

        /**
         * Decodes a UserLoginReturnOkLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLoginReturnOkLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLoginReturnOkLoginUserPmd_S;

        /**
         * Verifies a UserLoginReturnOkLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLoginReturnOkLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLoginReturnOkLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLoginReturnOkLoginUserPmd_S;

        /**
         * Creates a plain object from a UserLoginReturnOkLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message UserLoginReturnOkLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLoginReturnOkLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLoginReturnOkLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserLoginTokenLoginUserPmd_C. */
    interface IUserLoginTokenLoginUserPmd_C {

        /** UserLoginTokenLoginUserPmd_C gameid */
        gameid?: (number|null);

        /** UserLoginTokenLoginUserPmd_C zoneid */
        zoneid?: (number|null);

        /** UserLoginTokenLoginUserPmd_C accountid */
        accountid?: (number|Long|null);

        /** UserLoginTokenLoginUserPmd_C logintempid */
        logintempid?: (number|Long|null);

        /** UserLoginTokenLoginUserPmd_C timestamp */
        timestamp?: (number|null);

        /** UserLoginTokenLoginUserPmd_C tokenmd5 */
        tokenmd5?: (string|null);

        /** UserLoginTokenLoginUserPmd_C compress */
        compress?: (string|null);

        /** UserLoginTokenLoginUserPmd_C encrypt */
        encrypt?: (string|null);

        /** UserLoginTokenLoginUserPmd_C encryptkey */
        encryptkey?: (string|null);

        /** UserLoginTokenLoginUserPmd_C version */
        version?: (number|null);

        /** UserLoginTokenLoginUserPmd_C compressmin */
        compressmin?: (number|null);

        /** UserLoginTokenLoginUserPmd_C lastseq */
        lastseq?: (number|null);

        /** UserLoginTokenLoginUserPmd_C charid */
        charid?: (number|null);

        /** UserLoginTokenLoginUserPmd_C bundleid */
        bundleid?: (number|null);

        /** UserLoginTokenLoginUserPmd_C zipmd5 */
        zipmd5?: (string|null);

        /** UserLoginTokenLoginUserPmd_C configmd5 */
        configmd5?: (string|null);

        /** UserLoginTokenLoginUserPmd_C bundlename */
        bundlename?: (string|null);

        /** UserLoginTokenLoginUserPmd_C url */
        url?: (string|null);
    }

    /** Represents a UserLoginTokenLoginUserPmd_C. */
    class UserLoginTokenLoginUserPmd_C implements IUserLoginTokenLoginUserPmd_C {

        /**
         * Constructs a new UserLoginTokenLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLoginTokenLoginUserPmd_C);

        /** UserLoginTokenLoginUserPmd_C gameid. */
        public gameid: number;

        /** UserLoginTokenLoginUserPmd_C zoneid. */
        public zoneid: number;

        /** UserLoginTokenLoginUserPmd_C accountid. */
        public accountid: (number|Long);

        /** UserLoginTokenLoginUserPmd_C logintempid. */
        public logintempid: (number|Long);

        /** UserLoginTokenLoginUserPmd_C timestamp. */
        public timestamp: number;

        /** UserLoginTokenLoginUserPmd_C tokenmd5. */
        public tokenmd5: string;

        /** UserLoginTokenLoginUserPmd_C compress. */
        public compress: string;

        /** UserLoginTokenLoginUserPmd_C encrypt. */
        public encrypt: string;

        /** UserLoginTokenLoginUserPmd_C encryptkey. */
        public encryptkey: string;

        /** UserLoginTokenLoginUserPmd_C version. */
        public version: number;

        /** UserLoginTokenLoginUserPmd_C compressmin. */
        public compressmin: number;

        /** UserLoginTokenLoginUserPmd_C lastseq. */
        public lastseq: number;

        /** UserLoginTokenLoginUserPmd_C charid. */
        public charid: number;

        /** UserLoginTokenLoginUserPmd_C bundleid. */
        public bundleid: number;

        /** UserLoginTokenLoginUserPmd_C zipmd5. */
        public zipmd5: string;

        /** UserLoginTokenLoginUserPmd_C configmd5. */
        public configmd5: string;

        /** UserLoginTokenLoginUserPmd_C bundlename. */
        public bundlename: string;

        /** UserLoginTokenLoginUserPmd_C url. */
        public url: string;

        /**
         * Creates a new UserLoginTokenLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLoginTokenLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IUserLoginTokenLoginUserPmd_C): Pmd.UserLoginTokenLoginUserPmd_C;

        /**
         * Encodes the specified UserLoginTokenLoginUserPmd_C message. Does not implicitly {@link Pmd.UserLoginTokenLoginUserPmd_C.verify|verify} messages.
         * @param message UserLoginTokenLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLoginTokenLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLoginTokenLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.UserLoginTokenLoginUserPmd_C.verify|verify} messages.
         * @param message UserLoginTokenLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLoginTokenLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLoginTokenLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLoginTokenLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLoginTokenLoginUserPmd_C;

        /**
         * Decodes a UserLoginTokenLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLoginTokenLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLoginTokenLoginUserPmd_C;

        /**
         * Verifies a UserLoginTokenLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLoginTokenLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLoginTokenLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLoginTokenLoginUserPmd_C;

        /**
         * Creates a plain object from a UserLoginTokenLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message UserLoginTokenLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLoginTokenLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLoginTokenLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserLoginReconnectLoginUserPmd_C. */
    interface IUserLoginReconnectLoginUserPmd_C {

        /** UserLoginReconnectLoginUserPmd_C accountid */
        accountid?: (number|Long|null);

        /** UserLoginReconnectLoginUserPmd_C timestamp */
        timestamp?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C tokenmd5 */
        tokenmd5?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C logintempid */
        logintempid?: (number|Long|null);

        /** UserLoginReconnectLoginUserPmd_C gameid */
        gameid?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C zoneid */
        zoneid?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C compress */
        compress?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C encrypt */
        encrypt?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C encryptkey */
        encryptkey?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C version */
        version?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C compressmin */
        compressmin?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C lastseq */
        lastseq?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C charid */
        charid?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C bundleid */
        bundleid?: (number|null);

        /** UserLoginReconnectLoginUserPmd_C zipmd5 */
        zipmd5?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C configmd5 */
        configmd5?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C bundlename */
        bundlename?: (string|null);

        /** UserLoginReconnectLoginUserPmd_C url */
        url?: (string|null);
    }

    /** Represents a UserLoginReconnectLoginUserPmd_C. */
    class UserLoginReconnectLoginUserPmd_C implements IUserLoginReconnectLoginUserPmd_C {

        /**
         * Constructs a new UserLoginReconnectLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLoginReconnectLoginUserPmd_C);

        /** UserLoginReconnectLoginUserPmd_C accountid. */
        public accountid: (number|Long);

        /** UserLoginReconnectLoginUserPmd_C timestamp. */
        public timestamp: number;

        /** UserLoginReconnectLoginUserPmd_C tokenmd5. */
        public tokenmd5: string;

        /** UserLoginReconnectLoginUserPmd_C logintempid. */
        public logintempid: (number|Long);

        /** UserLoginReconnectLoginUserPmd_C gameid. */
        public gameid: number;

        /** UserLoginReconnectLoginUserPmd_C zoneid. */
        public zoneid: number;

        /** UserLoginReconnectLoginUserPmd_C compress. */
        public compress: string;

        /** UserLoginReconnectLoginUserPmd_C encrypt. */
        public encrypt: string;

        /** UserLoginReconnectLoginUserPmd_C encryptkey. */
        public encryptkey: string;

        /** UserLoginReconnectLoginUserPmd_C version. */
        public version: number;

        /** UserLoginReconnectLoginUserPmd_C compressmin. */
        public compressmin: number;

        /** UserLoginReconnectLoginUserPmd_C lastseq. */
        public lastseq: number;

        /** UserLoginReconnectLoginUserPmd_C charid. */
        public charid: number;

        /** UserLoginReconnectLoginUserPmd_C bundleid. */
        public bundleid: number;

        /** UserLoginReconnectLoginUserPmd_C zipmd5. */
        public zipmd5: string;

        /** UserLoginReconnectLoginUserPmd_C configmd5. */
        public configmd5: string;

        /** UserLoginReconnectLoginUserPmd_C bundlename. */
        public bundlename: string;

        /** UserLoginReconnectLoginUserPmd_C url. */
        public url: string;

        /**
         * Creates a new UserLoginReconnectLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLoginReconnectLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IUserLoginReconnectLoginUserPmd_C): Pmd.UserLoginReconnectLoginUserPmd_C;

        /**
         * Encodes the specified UserLoginReconnectLoginUserPmd_C message. Does not implicitly {@link Pmd.UserLoginReconnectLoginUserPmd_C.verify|verify} messages.
         * @param message UserLoginReconnectLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLoginReconnectLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLoginReconnectLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.UserLoginReconnectLoginUserPmd_C.verify|verify} messages.
         * @param message UserLoginReconnectLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLoginReconnectLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLoginReconnectLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLoginReconnectLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLoginReconnectLoginUserPmd_C;

        /**
         * Decodes a UserLoginReconnectLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLoginReconnectLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLoginReconnectLoginUserPmd_C;

        /**
         * Verifies a UserLoginReconnectLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLoginReconnectLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLoginReconnectLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLoginReconnectLoginUserPmd_C;

        /**
         * Creates a plain object from a UserLoginReconnectLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message UserLoginReconnectLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLoginReconnectLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLoginReconnectLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ClientLogUrlLoginUserPmd_S. */
    interface IClientLogUrlLoginUserPmd_S {

        /** ClientLogUrlLoginUserPmd_S loglevel */
        loglevel: string;

        /** ClientLogUrlLoginUserPmd_S logurl */
        logurl: string;

        /** ClientLogUrlLoginUserPmd_S distinct */
        distinct: boolean;
    }

    /** Represents a ClientLogUrlLoginUserPmd_S. */
    class ClientLogUrlLoginUserPmd_S implements IClientLogUrlLoginUserPmd_S {

        /**
         * Constructs a new ClientLogUrlLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IClientLogUrlLoginUserPmd_S);

        /** ClientLogUrlLoginUserPmd_S loglevel. */
        public loglevel: string;

        /** ClientLogUrlLoginUserPmd_S logurl. */
        public logurl: string;

        /** ClientLogUrlLoginUserPmd_S distinct. */
        public distinct: boolean;

        /**
         * Creates a new ClientLogUrlLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ClientLogUrlLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IClientLogUrlLoginUserPmd_S): Pmd.ClientLogUrlLoginUserPmd_S;

        /**
         * Encodes the specified ClientLogUrlLoginUserPmd_S message. Does not implicitly {@link Pmd.ClientLogUrlLoginUserPmd_S.verify|verify} messages.
         * @param message ClientLogUrlLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IClientLogUrlLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ClientLogUrlLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ClientLogUrlLoginUserPmd_S.verify|verify} messages.
         * @param message ClientLogUrlLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IClientLogUrlLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ClientLogUrlLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ClientLogUrlLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ClientLogUrlLoginUserPmd_S;

        /**
         * Decodes a ClientLogUrlLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ClientLogUrlLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ClientLogUrlLoginUserPmd_S;

        /**
         * Verifies a ClientLogUrlLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ClientLogUrlLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ClientLogUrlLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ClientLogUrlLoginUserPmd_S;

        /**
         * Creates a plain object from a ClientLogUrlLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ClientLogUrlLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ClientLogUrlLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ClientLogUrlLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a MessageBoxLoginUserPmd_S. */
    interface IMessageBoxLoginUserPmd_S {

        /** MessageBoxLoginUserPmd_S btnleft */
        btnleft?: (string|null);

        /** MessageBoxLoginUserPmd_S btnmiddle */
        btnmiddle?: (string|null);

        /** MessageBoxLoginUserPmd_S btnright */
        btnright?: (string|null);

        /** MessageBoxLoginUserPmd_S info */
        info?: (string|null);
    }

    /** Represents a MessageBoxLoginUserPmd_S. */
    class MessageBoxLoginUserPmd_S implements IMessageBoxLoginUserPmd_S {

        /**
         * Constructs a new MessageBoxLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IMessageBoxLoginUserPmd_S);

        /** MessageBoxLoginUserPmd_S btnleft. */
        public btnleft: string;

        /** MessageBoxLoginUserPmd_S btnmiddle. */
        public btnmiddle: string;

        /** MessageBoxLoginUserPmd_S btnright. */
        public btnright: string;

        /** MessageBoxLoginUserPmd_S info. */
        public info: string;

        /**
         * Creates a new MessageBoxLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MessageBoxLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IMessageBoxLoginUserPmd_S): Pmd.MessageBoxLoginUserPmd_S;

        /**
         * Encodes the specified MessageBoxLoginUserPmd_S message. Does not implicitly {@link Pmd.MessageBoxLoginUserPmd_S.verify|verify} messages.
         * @param message MessageBoxLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IMessageBoxLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified MessageBoxLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.MessageBoxLoginUserPmd_S.verify|verify} messages.
         * @param message MessageBoxLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IMessageBoxLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a MessageBoxLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MessageBoxLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.MessageBoxLoginUserPmd_S;

        /**
         * Decodes a MessageBoxLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MessageBoxLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.MessageBoxLoginUserPmd_S;

        /**
         * Verifies a MessageBoxLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MessageBoxLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MessageBoxLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.MessageBoxLoginUserPmd_S;

        /**
         * Creates a plain object from a MessageBoxLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message MessageBoxLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.MessageBoxLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MessageBoxLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestAccountRegisterLoginUserPmd_C. */
    interface IRequestAccountRegisterLoginUserPmd_C {

        /** RequestAccountRegisterLoginUserPmd_C account */
        account: string;

        /** RequestAccountRegisterLoginUserPmd_C password */
        password: string;

        /** RequestAccountRegisterLoginUserPmd_C code */
        code?: (string|null);
    }

    /** Represents a RequestAccountRegisterLoginUserPmd_C. */
    class RequestAccountRegisterLoginUserPmd_C implements IRequestAccountRegisterLoginUserPmd_C {

        /**
         * Constructs a new RequestAccountRegisterLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestAccountRegisterLoginUserPmd_C);

        /** RequestAccountRegisterLoginUserPmd_C account. */
        public account: string;

        /** RequestAccountRegisterLoginUserPmd_C password. */
        public password: string;

        /** RequestAccountRegisterLoginUserPmd_C code. */
        public code: string;

        /**
         * Creates a new RequestAccountRegisterLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestAccountRegisterLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IRequestAccountRegisterLoginUserPmd_C): Pmd.RequestAccountRegisterLoginUserPmd_C;

        /**
         * Encodes the specified RequestAccountRegisterLoginUserPmd_C message. Does not implicitly {@link Pmd.RequestAccountRegisterLoginUserPmd_C.verify|verify} messages.
         * @param message RequestAccountRegisterLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestAccountRegisterLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestAccountRegisterLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestAccountRegisterLoginUserPmd_C.verify|verify} messages.
         * @param message RequestAccountRegisterLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestAccountRegisterLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestAccountRegisterLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestAccountRegisterLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestAccountRegisterLoginUserPmd_C;

        /**
         * Decodes a RequestAccountRegisterLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestAccountRegisterLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestAccountRegisterLoginUserPmd_C;

        /**
         * Verifies a RequestAccountRegisterLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestAccountRegisterLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestAccountRegisterLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestAccountRegisterLoginUserPmd_C;

        /**
         * Creates a plain object from a RequestAccountRegisterLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message RequestAccountRegisterLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestAccountRegisterLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestAccountRegisterLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnAccountRegisterLoginUserPmd_S. */
    interface IReturnAccountRegisterLoginUserPmd_S {

        /** ReturnAccountRegisterLoginUserPmd_S account */
        account: string;

        /** ReturnAccountRegisterLoginUserPmd_S accountid */
        accountid: (number|Long);
    }

    /** Represents a ReturnAccountRegisterLoginUserPmd_S. */
    class ReturnAccountRegisterLoginUserPmd_S implements IReturnAccountRegisterLoginUserPmd_S {

        /**
         * Constructs a new ReturnAccountRegisterLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnAccountRegisterLoginUserPmd_S);

        /** ReturnAccountRegisterLoginUserPmd_S account. */
        public account: string;

        /** ReturnAccountRegisterLoginUserPmd_S accountid. */
        public accountid: (number|Long);

        /**
         * Creates a new ReturnAccountRegisterLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnAccountRegisterLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IReturnAccountRegisterLoginUserPmd_S): Pmd.ReturnAccountRegisterLoginUserPmd_S;

        /**
         * Encodes the specified ReturnAccountRegisterLoginUserPmd_S message. Does not implicitly {@link Pmd.ReturnAccountRegisterLoginUserPmd_S.verify|verify} messages.
         * @param message ReturnAccountRegisterLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnAccountRegisterLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnAccountRegisterLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnAccountRegisterLoginUserPmd_S.verify|verify} messages.
         * @param message ReturnAccountRegisterLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnAccountRegisterLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnAccountRegisterLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnAccountRegisterLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnAccountRegisterLoginUserPmd_S;

        /**
         * Decodes a ReturnAccountRegisterLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnAccountRegisterLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnAccountRegisterLoginUserPmd_S;

        /**
         * Verifies a ReturnAccountRegisterLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnAccountRegisterLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnAccountRegisterLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnAccountRegisterLoginUserPmd_S;

        /**
         * Creates a plain object from a ReturnAccountRegisterLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ReturnAccountRegisterLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnAccountRegisterLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnAccountRegisterLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserLogoutTokenLoginUserPmd_C. */
    interface IUserLogoutTokenLoginUserPmd_C {
    }

    /** Represents a UserLogoutTokenLoginUserPmd_C. */
    class UserLogoutTokenLoginUserPmd_C implements IUserLogoutTokenLoginUserPmd_C {

        /**
         * Constructs a new UserLogoutTokenLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLogoutTokenLoginUserPmd_C);

        /**
         * Creates a new UserLogoutTokenLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLogoutTokenLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IUserLogoutTokenLoginUserPmd_C): Pmd.UserLogoutTokenLoginUserPmd_C;

        /**
         * Encodes the specified UserLogoutTokenLoginUserPmd_C message. Does not implicitly {@link Pmd.UserLogoutTokenLoginUserPmd_C.verify|verify} messages.
         * @param message UserLogoutTokenLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLogoutTokenLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLogoutTokenLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.UserLogoutTokenLoginUserPmd_C.verify|verify} messages.
         * @param message UserLogoutTokenLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLogoutTokenLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLogoutTokenLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLogoutTokenLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLogoutTokenLoginUserPmd_C;

        /**
         * Decodes a UserLogoutTokenLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLogoutTokenLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLogoutTokenLoginUserPmd_C;

        /**
         * Verifies a UserLogoutTokenLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLogoutTokenLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLogoutTokenLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLogoutTokenLoginUserPmd_C;

        /**
         * Creates a plain object from a UserLogoutTokenLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message UserLogoutTokenLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLogoutTokenLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLogoutTokenLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReconnectKickoutLoginUserPmd_S. */
    interface IReconnectKickoutLoginUserPmd_S {

        /** ReconnectKickoutLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents a ReconnectKickoutLoginUserPmd_S. */
    class ReconnectKickoutLoginUserPmd_S implements IReconnectKickoutLoginUserPmd_S {

        /**
         * Constructs a new ReconnectKickoutLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReconnectKickoutLoginUserPmd_S);

        /** ReconnectKickoutLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new ReconnectKickoutLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReconnectKickoutLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IReconnectKickoutLoginUserPmd_S): Pmd.ReconnectKickoutLoginUserPmd_S;

        /**
         * Encodes the specified ReconnectKickoutLoginUserPmd_S message. Does not implicitly {@link Pmd.ReconnectKickoutLoginUserPmd_S.verify|verify} messages.
         * @param message ReconnectKickoutLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReconnectKickoutLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReconnectKickoutLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ReconnectKickoutLoginUserPmd_S.verify|verify} messages.
         * @param message ReconnectKickoutLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReconnectKickoutLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReconnectKickoutLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReconnectKickoutLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReconnectKickoutLoginUserPmd_S;

        /**
         * Decodes a ReconnectKickoutLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReconnectKickoutLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReconnectKickoutLoginUserPmd_S;

        /**
         * Verifies a ReconnectKickoutLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReconnectKickoutLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReconnectKickoutLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReconnectKickoutLoginUserPmd_S;

        /**
         * Creates a plain object from a ReconnectKickoutLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ReconnectKickoutLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReconnectKickoutLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReconnectKickoutLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReconnectErrorLoginUserPmd_S. */
    interface IReconnectErrorLoginUserPmd_S {

        /** ReconnectErrorLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents a ReconnectErrorLoginUserPmd_S. */
    class ReconnectErrorLoginUserPmd_S implements IReconnectErrorLoginUserPmd_S {

        /**
         * Constructs a new ReconnectErrorLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReconnectErrorLoginUserPmd_S);

        /** ReconnectErrorLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new ReconnectErrorLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReconnectErrorLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IReconnectErrorLoginUserPmd_S): Pmd.ReconnectErrorLoginUserPmd_S;

        /**
         * Encodes the specified ReconnectErrorLoginUserPmd_S message. Does not implicitly {@link Pmd.ReconnectErrorLoginUserPmd_S.verify|verify} messages.
         * @param message ReconnectErrorLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReconnectErrorLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReconnectErrorLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ReconnectErrorLoginUserPmd_S.verify|verify} messages.
         * @param message ReconnectErrorLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReconnectErrorLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReconnectErrorLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReconnectErrorLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReconnectErrorLoginUserPmd_S;

        /**
         * Decodes a ReconnectErrorLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReconnectErrorLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReconnectErrorLoginUserPmd_S;

        /**
         * Verifies a ReconnectErrorLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReconnectErrorLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReconnectErrorLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReconnectErrorLoginUserPmd_S;

        /**
         * Creates a plain object from a ReconnectErrorLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ReconnectErrorLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReconnectErrorLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReconnectErrorLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ServerKickoutLoginUserPmd_S. */
    interface IServerKickoutLoginUserPmd_S {

        /** ServerKickoutLoginUserPmd_S accountid */
        accountid: (number|Long);

        /** ServerKickoutLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents a ServerKickoutLoginUserPmd_S. */
    class ServerKickoutLoginUserPmd_S implements IServerKickoutLoginUserPmd_S {

        /**
         * Constructs a new ServerKickoutLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IServerKickoutLoginUserPmd_S);

        /** ServerKickoutLoginUserPmd_S accountid. */
        public accountid: (number|Long);

        /** ServerKickoutLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new ServerKickoutLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ServerKickoutLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IServerKickoutLoginUserPmd_S): Pmd.ServerKickoutLoginUserPmd_S;

        /**
         * Encodes the specified ServerKickoutLoginUserPmd_S message. Does not implicitly {@link Pmd.ServerKickoutLoginUserPmd_S.verify|verify} messages.
         * @param message ServerKickoutLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IServerKickoutLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ServerKickoutLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ServerKickoutLoginUserPmd_S.verify|verify} messages.
         * @param message ServerKickoutLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IServerKickoutLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ServerKickoutLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ServerKickoutLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ServerKickoutLoginUserPmd_S;

        /**
         * Decodes a ServerKickoutLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ServerKickoutLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ServerKickoutLoginUserPmd_S;

        /**
         * Verifies a ServerKickoutLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ServerKickoutLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ServerKickoutLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ServerKickoutLoginUserPmd_S;

        /**
         * Creates a plain object from a ServerKickoutLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ServerKickoutLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ServerKickoutLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ServerKickoutLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlatInfo. */
    interface IPlatInfo {

        /** PlatInfo account */
        account: string;

        /** PlatInfo platid */
        platid: number;

        /** PlatInfo email */
        email?: (string|null);

        /** PlatInfo gender */
        gender?: (string|null);

        /** PlatInfo nickname */
        nickname?: (string|null);

        /** PlatInfo timestamp */
        timestamp?: (string|null);

        /** PlatInfo sign */
        sign?: (string|null);

        /** PlatInfo faceurl */
        faceurl?: (string|null);

        /** PlatInfo extdata */
        extdata?: (string|null);

        /** PlatInfo uid */
        uid?: (string|null);

        /** PlatInfo imei */
        imei?: (string|null);

        /** PlatInfo osname */
        osname?: (string|null);

        /** PlatInfo platappid */
        platappid?: (string|null);

        /** PlatInfo bindcode */
        bindcode?: (string|null);

        /** PlatInfo onetoken */
        onetoken?: (string|null);

        /** PlatInfo forwardtoken */
        forwardtoken?: (string|null);
    }

    /** Represents a PlatInfo. */
    class PlatInfo implements IPlatInfo {

        /**
         * Constructs a new PlatInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IPlatInfo);

        /** PlatInfo account. */
        public account: string;

        /** PlatInfo platid. */
        public platid: number;

        /** PlatInfo email. */
        public email: string;

        /** PlatInfo gender. */
        public gender: string;

        /** PlatInfo nickname. */
        public nickname: string;

        /** PlatInfo timestamp. */
        public timestamp: string;

        /** PlatInfo sign. */
        public sign: string;

        /** PlatInfo faceurl. */
        public faceurl: string;

        /** PlatInfo extdata. */
        public extdata: string;

        /** PlatInfo uid. */
        public uid: string;

        /** PlatInfo imei. */
        public imei: string;

        /** PlatInfo osname. */
        public osname: string;

        /** PlatInfo platappid. */
        public platappid: string;

        /** PlatInfo bindcode. */
        public bindcode: string;

        /** PlatInfo onetoken. */
        public onetoken: string;

        /** PlatInfo forwardtoken. */
        public forwardtoken: string;

        /**
         * Creates a new PlatInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlatInfo instance
         */
        public static create(properties?: Pmd.IPlatInfo): Pmd.PlatInfo;

        /**
         * Encodes the specified PlatInfo message. Does not implicitly {@link Pmd.PlatInfo.verify|verify} messages.
         * @param message PlatInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IPlatInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified PlatInfo message, length delimited. Does not implicitly {@link Pmd.PlatInfo.verify|verify} messages.
         * @param message PlatInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IPlatInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a PlatInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlatInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.PlatInfo;

        /**
         * Decodes a PlatInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlatInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.PlatInfo;

        /**
         * Verifies a PlatInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlatInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlatInfo
         */
        public static fromObject(object: { [k: string]: any }): Pmd.PlatInfo;

        /**
         * Creates a plain object from a PlatInfo message. Also converts values to other types if specified.
         * @param message PlatInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.PlatInfo, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlatInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ThirdPlatLoginUserPmd_C. */
    interface IThirdPlatLoginUserPmd_C {

        /** ThirdPlatLoginUserPmd_C platinfo */
        platinfo: Pmd.IPlatInfo;

        /** ThirdPlatLoginUserPmd_C gameid */
        gameid: number;

        /** ThirdPlatLoginUserPmd_C sid */
        sid: string;

        /** ThirdPlatLoginUserPmd_C uid */
        uid: string;
    }

    /** Represents a ThirdPlatLoginUserPmd_C. */
    class ThirdPlatLoginUserPmd_C implements IThirdPlatLoginUserPmd_C {

        /**
         * Constructs a new ThirdPlatLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IThirdPlatLoginUserPmd_C);

        /** ThirdPlatLoginUserPmd_C platinfo. */
        public platinfo: Pmd.IPlatInfo;

        /** ThirdPlatLoginUserPmd_C gameid. */
        public gameid: number;

        /** ThirdPlatLoginUserPmd_C sid. */
        public sid: string;

        /** ThirdPlatLoginUserPmd_C uid. */
        public uid: string;

        /**
         * Creates a new ThirdPlatLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ThirdPlatLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IThirdPlatLoginUserPmd_C): Pmd.ThirdPlatLoginUserPmd_C;

        /**
         * Encodes the specified ThirdPlatLoginUserPmd_C message. Does not implicitly {@link Pmd.ThirdPlatLoginUserPmd_C.verify|verify} messages.
         * @param message ThirdPlatLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IThirdPlatLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ThirdPlatLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.ThirdPlatLoginUserPmd_C.verify|verify} messages.
         * @param message ThirdPlatLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IThirdPlatLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ThirdPlatLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ThirdPlatLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ThirdPlatLoginUserPmd_C;

        /**
         * Decodes a ThirdPlatLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ThirdPlatLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ThirdPlatLoginUserPmd_C;

        /**
         * Verifies a ThirdPlatLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ThirdPlatLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ThirdPlatLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ThirdPlatLoginUserPmd_C;

        /**
         * Creates a plain object from a ThirdPlatLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message ThirdPlatLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ThirdPlatLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ThirdPlatLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** PlatType enum. */
    enum PlatType {
        PlatType_Normal = 0,
        PlatType_UC = 4,
        PlatType_LeZhuan = 67,
        PlatType_WeChat = 68,
        PlatType_Play68 = 69,
        PlatType_AiBei = 70,
        PlatType_Facebook = 71,
        PlatType_GooglePlay = 72,
        PlatType_XingZhiZhu = 73,
        PlatType_HuoWu = 74,
        PlatType_CaiGuo = 77,
        PlatType_1758 = 79,
        PlatType_DAPAI = 80,
        PlatType_HILE = 82,
        PlatType_AAY = 86,
        PlatType_WEIYOU = 90,
        PlatType_9g = 99,
        PlatType_MOBILE = 129,
        PlatType_XueChi = 133,
        PlatType_Egret = 134,
        PlatType_AoXin = 140,
        PlatType_HUOSU = 145,
        PlatType_RONGQIANG = 151,
        PlatType_WXApp = 152,
        PlatType_RongQiangApp = 153
    }

    /** Properties of a SetServerLangLoginUserPmd_C. */
    interface ISetServerLangLoginUserPmd_C {

        /** SetServerLangLoginUserPmd_C lang */
        lang: string;

        /** SetServerLangLoginUserPmd_C gameregion */
        gameregion: number;
    }

    /** Represents a SetServerLangLoginUserPmd_C. */
    class SetServerLangLoginUserPmd_C implements ISetServerLangLoginUserPmd_C {

        /**
         * Constructs a new SetServerLangLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ISetServerLangLoginUserPmd_C);

        /** SetServerLangLoginUserPmd_C lang. */
        public lang: string;

        /** SetServerLangLoginUserPmd_C gameregion. */
        public gameregion: number;

        /**
         * Creates a new SetServerLangLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns SetServerLangLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.ISetServerLangLoginUserPmd_C): Pmd.SetServerLangLoginUserPmd_C;

        /**
         * Encodes the specified SetServerLangLoginUserPmd_C message. Does not implicitly {@link Pmd.SetServerLangLoginUserPmd_C.verify|verify} messages.
         * @param message SetServerLangLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ISetServerLangLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified SetServerLangLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.SetServerLangLoginUserPmd_C.verify|verify} messages.
         * @param message SetServerLangLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ISetServerLangLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a SetServerLangLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns SetServerLangLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.SetServerLangLoginUserPmd_C;

        /**
         * Decodes a SetServerLangLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns SetServerLangLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.SetServerLangLoginUserPmd_C;

        /**
         * Verifies a SetServerLangLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a SetServerLangLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns SetServerLangLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.SetServerLangLoginUserPmd_C;

        /**
         * Creates a plain object from a SetServerLangLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message SetServerLangLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.SetServerLangLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this SetServerLangLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestClientIPLoginUserPmd_C. */
    interface IRequestClientIPLoginUserPmd_C {
    }

    /** Represents a RequestClientIPLoginUserPmd_C. */
    class RequestClientIPLoginUserPmd_C implements IRequestClientIPLoginUserPmd_C {

        /**
         * Constructs a new RequestClientIPLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestClientIPLoginUserPmd_C);

        /**
         * Creates a new RequestClientIPLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestClientIPLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IRequestClientIPLoginUserPmd_C): Pmd.RequestClientIPLoginUserPmd_C;

        /**
         * Encodes the specified RequestClientIPLoginUserPmd_C message. Does not implicitly {@link Pmd.RequestClientIPLoginUserPmd_C.verify|verify} messages.
         * @param message RequestClientIPLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestClientIPLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestClientIPLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestClientIPLoginUserPmd_C.verify|verify} messages.
         * @param message RequestClientIPLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestClientIPLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestClientIPLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestClientIPLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestClientIPLoginUserPmd_C;

        /**
         * Decodes a RequestClientIPLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestClientIPLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestClientIPLoginUserPmd_C;

        /**
         * Verifies a RequestClientIPLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestClientIPLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestClientIPLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestClientIPLoginUserPmd_C;

        /**
         * Creates a plain object from a RequestClientIPLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message RequestClientIPLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestClientIPLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestClientIPLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnClientIPLoginUserPmd_S. */
    interface IReturnClientIPLoginUserPmd_S {

        /** ReturnClientIPLoginUserPmd_S pstrip */
        pstrip: string;
    }

    /** Represents a ReturnClientIPLoginUserPmd_S. */
    class ReturnClientIPLoginUserPmd_S implements IReturnClientIPLoginUserPmd_S {

        /**
         * Constructs a new ReturnClientIPLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnClientIPLoginUserPmd_S);

        /** ReturnClientIPLoginUserPmd_S pstrip. */
        public pstrip: string;

        /**
         * Creates a new ReturnClientIPLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnClientIPLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IReturnClientIPLoginUserPmd_S): Pmd.ReturnClientIPLoginUserPmd_S;

        /**
         * Encodes the specified ReturnClientIPLoginUserPmd_S message. Does not implicitly {@link Pmd.ReturnClientIPLoginUserPmd_S.verify|verify} messages.
         * @param message ReturnClientIPLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnClientIPLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnClientIPLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnClientIPLoginUserPmd_S.verify|verify} messages.
         * @param message ReturnClientIPLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnClientIPLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnClientIPLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnClientIPLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnClientIPLoginUserPmd_S;

        /**
         * Decodes a ReturnClientIPLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnClientIPLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnClientIPLoginUserPmd_S;

        /**
         * Verifies a ReturnClientIPLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnClientIPLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnClientIPLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnClientIPLoginUserPmd_S;

        /**
         * Creates a plain object from a ReturnClientIPLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ReturnClientIPLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnClientIPLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnClientIPLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CheckVersionLoginUserPmd_C. */
    interface ICheckVersionLoginUserPmd_C {

        /** CheckVersionLoginUserPmd_C default_charid */
        default_charid?: (number|null);

        /** CheckVersionLoginUserPmd_C version */
        version?: (number|null);
    }

    /** Represents a CheckVersionLoginUserPmd_C. */
    class CheckVersionLoginUserPmd_C implements ICheckVersionLoginUserPmd_C {

        /**
         * Constructs a new CheckVersionLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ICheckVersionLoginUserPmd_C);

        /** CheckVersionLoginUserPmd_C default_charid. */
        public default_charid: number;

        /** CheckVersionLoginUserPmd_C version. */
        public version: number;

        /**
         * Creates a new CheckVersionLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CheckVersionLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.ICheckVersionLoginUserPmd_C): Pmd.CheckVersionLoginUserPmd_C;

        /**
         * Encodes the specified CheckVersionLoginUserPmd_C message. Does not implicitly {@link Pmd.CheckVersionLoginUserPmd_C.verify|verify} messages.
         * @param message CheckVersionLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ICheckVersionLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified CheckVersionLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.CheckVersionLoginUserPmd_C.verify|verify} messages.
         * @param message CheckVersionLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ICheckVersionLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a CheckVersionLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CheckVersionLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.CheckVersionLoginUserPmd_C;

        /**
         * Decodes a CheckVersionLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CheckVersionLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.CheckVersionLoginUserPmd_C;

        /**
         * Verifies a CheckVersionLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CheckVersionLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CheckVersionLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.CheckVersionLoginUserPmd_C;

        /**
         * Creates a plain object from a CheckVersionLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message CheckVersionLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.CheckVersionLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CheckVersionLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a BehaviorClientVerifyLoginUserPmd_C. */
    interface IBehaviorClientVerifyLoginUserPmd_C {

        /** BehaviorClientVerifyLoginUserPmd_C account */
        account: string;

        /** BehaviorClientVerifyLoginUserPmd_C token */
        token: string;

        /** BehaviorClientVerifyLoginUserPmd_C version */
        version: number;

        /** BehaviorClientVerifyLoginUserPmd_C gameid */
        gameid?: (number|null);

        /** BehaviorClientVerifyLoginUserPmd_C mid */
        mid?: (string|null);

        /** BehaviorClientVerifyLoginUserPmd_C platid */
        platid?: (number|null);

        /** BehaviorClientVerifyLoginUserPmd_C zoneid */
        zoneid?: (number|null);

        /** BehaviorClientVerifyLoginUserPmd_C gameversion */
        gameversion?: (number|null);

        /** BehaviorClientVerifyLoginUserPmd_C compress */
        compress?: (string|null);

        /** BehaviorClientVerifyLoginUserPmd_C encrypt */
        encrypt?: (string|null);

        /** BehaviorClientVerifyLoginUserPmd_C encryptkey */
        encryptkey?: (string|null);
    }

    /** Represents a BehaviorClientVerifyLoginUserPmd_C. */
    class BehaviorClientVerifyLoginUserPmd_C implements IBehaviorClientVerifyLoginUserPmd_C {

        /**
         * Constructs a new BehaviorClientVerifyLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IBehaviorClientVerifyLoginUserPmd_C);

        /** BehaviorClientVerifyLoginUserPmd_C account. */
        public account: string;

        /** BehaviorClientVerifyLoginUserPmd_C token. */
        public token: string;

        /** BehaviorClientVerifyLoginUserPmd_C version. */
        public version: number;

        /** BehaviorClientVerifyLoginUserPmd_C gameid. */
        public gameid: number;

        /** BehaviorClientVerifyLoginUserPmd_C mid. */
        public mid: string;

        /** BehaviorClientVerifyLoginUserPmd_C platid. */
        public platid: number;

        /** BehaviorClientVerifyLoginUserPmd_C zoneid. */
        public zoneid: number;

        /** BehaviorClientVerifyLoginUserPmd_C gameversion. */
        public gameversion: number;

        /** BehaviorClientVerifyLoginUserPmd_C compress. */
        public compress: string;

        /** BehaviorClientVerifyLoginUserPmd_C encrypt. */
        public encrypt: string;

        /** BehaviorClientVerifyLoginUserPmd_C encryptkey. */
        public encryptkey: string;

        /**
         * Creates a new BehaviorClientVerifyLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BehaviorClientVerifyLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IBehaviorClientVerifyLoginUserPmd_C): Pmd.BehaviorClientVerifyLoginUserPmd_C;

        /**
         * Encodes the specified BehaviorClientVerifyLoginUserPmd_C message. Does not implicitly {@link Pmd.BehaviorClientVerifyLoginUserPmd_C.verify|verify} messages.
         * @param message BehaviorClientVerifyLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IBehaviorClientVerifyLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified BehaviorClientVerifyLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.BehaviorClientVerifyLoginUserPmd_C.verify|verify} messages.
         * @param message BehaviorClientVerifyLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IBehaviorClientVerifyLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a BehaviorClientVerifyLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BehaviorClientVerifyLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.BehaviorClientVerifyLoginUserPmd_C;

        /**
         * Decodes a BehaviorClientVerifyLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BehaviorClientVerifyLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.BehaviorClientVerifyLoginUserPmd_C;

        /**
         * Verifies a BehaviorClientVerifyLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BehaviorClientVerifyLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BehaviorClientVerifyLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.BehaviorClientVerifyLoginUserPmd_C;

        /**
         * Creates a plain object from a BehaviorClientVerifyLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message BehaviorClientVerifyLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.BehaviorClientVerifyLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BehaviorClientVerifyLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestSupoortGameListLoginUserPmd_C. */
    interface IRequestSupoortGameListLoginUserPmd_C {
    }

    /** Represents a RequestSupoortGameListLoginUserPmd_C. */
    class RequestSupoortGameListLoginUserPmd_C implements IRequestSupoortGameListLoginUserPmd_C {

        /**
         * Constructs a new RequestSupoortGameListLoginUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestSupoortGameListLoginUserPmd_C);

        /**
         * Creates a new RequestSupoortGameListLoginUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestSupoortGameListLoginUserPmd_C instance
         */
        public static create(properties?: Pmd.IRequestSupoortGameListLoginUserPmd_C): Pmd.RequestSupoortGameListLoginUserPmd_C;

        /**
         * Encodes the specified RequestSupoortGameListLoginUserPmd_C message. Does not implicitly {@link Pmd.RequestSupoortGameListLoginUserPmd_C.verify|verify} messages.
         * @param message RequestSupoortGameListLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestSupoortGameListLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestSupoortGameListLoginUserPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestSupoortGameListLoginUserPmd_C.verify|verify} messages.
         * @param message RequestSupoortGameListLoginUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestSupoortGameListLoginUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestSupoortGameListLoginUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestSupoortGameListLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestSupoortGameListLoginUserPmd_C;

        /**
         * Decodes a RequestSupoortGameListLoginUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestSupoortGameListLoginUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestSupoortGameListLoginUserPmd_C;

        /**
         * Verifies a RequestSupoortGameListLoginUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestSupoortGameListLoginUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestSupoortGameListLoginUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestSupoortGameListLoginUserPmd_C;

        /**
         * Creates a plain object from a RequestSupoortGameListLoginUserPmd_C message. Also converts values to other types if specified.
         * @param message RequestSupoortGameListLoginUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestSupoortGameListLoginUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestSupoortGameListLoginUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnSupoortGameListLoginUserPmd_S_Game. */
    interface IReturnSupoortGameListLoginUserPmd_S_Game {

        /** ReturnSupoortGameListLoginUserPmd_S_Game gamename */
        gamename?: (string|null);

        /** ReturnSupoortGameListLoginUserPmd_S_Game gameid */
        gameid: number;
    }

    /** Represents a ReturnSupoortGameListLoginUserPmd_S_Game. */
    class ReturnSupoortGameListLoginUserPmd_S_Game implements IReturnSupoortGameListLoginUserPmd_S_Game {

        /**
         * Constructs a new ReturnSupoortGameListLoginUserPmd_S_Game.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnSupoortGameListLoginUserPmd_S_Game);

        /** ReturnSupoortGameListLoginUserPmd_S_Game gamename. */
        public gamename: string;

        /** ReturnSupoortGameListLoginUserPmd_S_Game gameid. */
        public gameid: number;

        /**
         * Creates a new ReturnSupoortGameListLoginUserPmd_S_Game instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnSupoortGameListLoginUserPmd_S_Game instance
         */
        public static create(properties?: Pmd.IReturnSupoortGameListLoginUserPmd_S_Game): Pmd.ReturnSupoortGameListLoginUserPmd_S_Game;

        /**
         * Encodes the specified ReturnSupoortGameListLoginUserPmd_S_Game message. Does not implicitly {@link Pmd.ReturnSupoortGameListLoginUserPmd_S_Game.verify|verify} messages.
         * @param message ReturnSupoortGameListLoginUserPmd_S_Game message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnSupoortGameListLoginUserPmd_S_Game, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnSupoortGameListLoginUserPmd_S_Game message, length delimited. Does not implicitly {@link Pmd.ReturnSupoortGameListLoginUserPmd_S_Game.verify|verify} messages.
         * @param message ReturnSupoortGameListLoginUserPmd_S_Game message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnSupoortGameListLoginUserPmd_S_Game, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnSupoortGameListLoginUserPmd_S_Game message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnSupoortGameListLoginUserPmd_S_Game
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnSupoortGameListLoginUserPmd_S_Game;

        /**
         * Decodes a ReturnSupoortGameListLoginUserPmd_S_Game message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnSupoortGameListLoginUserPmd_S_Game
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnSupoortGameListLoginUserPmd_S_Game;

        /**
         * Verifies a ReturnSupoortGameListLoginUserPmd_S_Game message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnSupoortGameListLoginUserPmd_S_Game message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnSupoortGameListLoginUserPmd_S_Game
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnSupoortGameListLoginUserPmd_S_Game;

        /**
         * Creates a plain object from a ReturnSupoortGameListLoginUserPmd_S_Game message. Also converts values to other types if specified.
         * @param message ReturnSupoortGameListLoginUserPmd_S_Game
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnSupoortGameListLoginUserPmd_S_Game, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnSupoortGameListLoginUserPmd_S_Game to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnSupoortGameListLoginUserPmd_S. */
    interface IReturnSupoortGameListLoginUserPmd_S {

        /** ReturnSupoortGameListLoginUserPmd_S gamelist */
        gamelist?: (Pmd.IReturnSupoortGameListLoginUserPmd_S_Game[]|null);
    }

    /** Represents a ReturnSupoortGameListLoginUserPmd_S. */
    class ReturnSupoortGameListLoginUserPmd_S implements IReturnSupoortGameListLoginUserPmd_S {

        /**
         * Constructs a new ReturnSupoortGameListLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnSupoortGameListLoginUserPmd_S);

        /** ReturnSupoortGameListLoginUserPmd_S gamelist. */
        public gamelist: Pmd.IReturnSupoortGameListLoginUserPmd_S_Game[];

        /**
         * Creates a new ReturnSupoortGameListLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnSupoortGameListLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IReturnSupoortGameListLoginUserPmd_S): Pmd.ReturnSupoortGameListLoginUserPmd_S;

        /**
         * Encodes the specified ReturnSupoortGameListLoginUserPmd_S message. Does not implicitly {@link Pmd.ReturnSupoortGameListLoginUserPmd_S.verify|verify} messages.
         * @param message ReturnSupoortGameListLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnSupoortGameListLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnSupoortGameListLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnSupoortGameListLoginUserPmd_S.verify|verify} messages.
         * @param message ReturnSupoortGameListLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnSupoortGameListLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnSupoortGameListLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnSupoortGameListLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnSupoortGameListLoginUserPmd_S;

        /**
         * Decodes a ReturnSupoortGameListLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnSupoortGameListLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnSupoortGameListLoginUserPmd_S;

        /**
         * Verifies a ReturnSupoortGameListLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnSupoortGameListLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnSupoortGameListLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnSupoortGameListLoginUserPmd_S;

        /**
         * Creates a plain object from a ReturnSupoortGameListLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ReturnSupoortGameListLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnSupoortGameListLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnSupoortGameListLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a UserLoginReconnectOkLoginUserPmd_S. */
    interface IUserLoginReconnectOkLoginUserPmd_S {

        /** UserLoginReconnectOkLoginUserPmd_S accid */
        accid?: (number|Long|null);
    }

    /** Represents a UserLoginReconnectOkLoginUserPmd_S. */
    class UserLoginReconnectOkLoginUserPmd_S implements IUserLoginReconnectOkLoginUserPmd_S {

        /**
         * Constructs a new UserLoginReconnectOkLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IUserLoginReconnectOkLoginUserPmd_S);

        /** UserLoginReconnectOkLoginUserPmd_S accid. */
        public accid: (number|Long);

        /**
         * Creates a new UserLoginReconnectOkLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns UserLoginReconnectOkLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IUserLoginReconnectOkLoginUserPmd_S): Pmd.UserLoginReconnectOkLoginUserPmd_S;

        /**
         * Encodes the specified UserLoginReconnectOkLoginUserPmd_S message. Does not implicitly {@link Pmd.UserLoginReconnectOkLoginUserPmd_S.verify|verify} messages.
         * @param message UserLoginReconnectOkLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IUserLoginReconnectOkLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified UserLoginReconnectOkLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.UserLoginReconnectOkLoginUserPmd_S.verify|verify} messages.
         * @param message UserLoginReconnectOkLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IUserLoginReconnectOkLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a UserLoginReconnectOkLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns UserLoginReconnectOkLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.UserLoginReconnectOkLoginUserPmd_S;

        /**
         * Decodes a UserLoginReconnectOkLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns UserLoginReconnectOkLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.UserLoginReconnectOkLoginUserPmd_S;

        /**
         * Verifies a UserLoginReconnectOkLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a UserLoginReconnectOkLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns UserLoginReconnectOkLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.UserLoginReconnectOkLoginUserPmd_S;

        /**
         * Creates a plain object from a UserLoginReconnectOkLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message UserLoginReconnectOkLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.UserLoginReconnectOkLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this UserLoginReconnectOkLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GameServerShutDownLoginUserPmd_S. */
    interface IGameServerShutDownLoginUserPmd_S {

        /** GameServerShutDownLoginUserPmd_S desc */
        desc?: (string|null);
    }

    /** Represents a GameServerShutDownLoginUserPmd_S. */
    class GameServerShutDownLoginUserPmd_S implements IGameServerShutDownLoginUserPmd_S {

        /**
         * Constructs a new GameServerShutDownLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IGameServerShutDownLoginUserPmd_S);

        /** GameServerShutDownLoginUserPmd_S desc. */
        public desc: string;

        /**
         * Creates a new GameServerShutDownLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GameServerShutDownLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IGameServerShutDownLoginUserPmd_S): Pmd.GameServerShutDownLoginUserPmd_S;

        /**
         * Encodes the specified GameServerShutDownLoginUserPmd_S message. Does not implicitly {@link Pmd.GameServerShutDownLoginUserPmd_S.verify|verify} messages.
         * @param message GameServerShutDownLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IGameServerShutDownLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified GameServerShutDownLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.GameServerShutDownLoginUserPmd_S.verify|verify} messages.
         * @param message GameServerShutDownLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IGameServerShutDownLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a GameServerShutDownLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GameServerShutDownLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.GameServerShutDownLoginUserPmd_S;

        /**
         * Decodes a GameServerShutDownLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GameServerShutDownLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.GameServerShutDownLoginUserPmd_S;

        /**
         * Verifies a GameServerShutDownLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GameServerShutDownLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GameServerShutDownLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.GameServerShutDownLoginUserPmd_S;

        /**
         * Creates a plain object from a GameServerShutDownLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message GameServerShutDownLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.GameServerShutDownLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GameServerShutDownLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of an OnlineNumWaitingLoginUserPmd_S. */
    interface IOnlineNumWaitingLoginUserPmd_S {

        /** OnlineNumWaitingLoginUserPmd_S playingnum */
        playingnum: number;

        /** OnlineNumWaitingLoginUserPmd_S waitingnum */
        waitingnum: number;

        /** OnlineNumWaitingLoginUserPmd_S mynum */
        mynum: number;
    }

    /** Represents an OnlineNumWaitingLoginUserPmd_S. */
    class OnlineNumWaitingLoginUserPmd_S implements IOnlineNumWaitingLoginUserPmd_S {

        /**
         * Constructs a new OnlineNumWaitingLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IOnlineNumWaitingLoginUserPmd_S);

        /** OnlineNumWaitingLoginUserPmd_S playingnum. */
        public playingnum: number;

        /** OnlineNumWaitingLoginUserPmd_S waitingnum. */
        public waitingnum: number;

        /** OnlineNumWaitingLoginUserPmd_S mynum. */
        public mynum: number;

        /**
         * Creates a new OnlineNumWaitingLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OnlineNumWaitingLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IOnlineNumWaitingLoginUserPmd_S): Pmd.OnlineNumWaitingLoginUserPmd_S;

        /**
         * Encodes the specified OnlineNumWaitingLoginUserPmd_S message. Does not implicitly {@link Pmd.OnlineNumWaitingLoginUserPmd_S.verify|verify} messages.
         * @param message OnlineNumWaitingLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IOnlineNumWaitingLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified OnlineNumWaitingLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.OnlineNumWaitingLoginUserPmd_S.verify|verify} messages.
         * @param message OnlineNumWaitingLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IOnlineNumWaitingLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes an OnlineNumWaitingLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OnlineNumWaitingLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.OnlineNumWaitingLoginUserPmd_S;

        /**
         * Decodes an OnlineNumWaitingLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OnlineNumWaitingLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.OnlineNumWaitingLoginUserPmd_S;

        /**
         * Verifies an OnlineNumWaitingLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OnlineNumWaitingLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OnlineNumWaitingLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.OnlineNumWaitingLoginUserPmd_S;

        /**
         * Creates a plain object from an OnlineNumWaitingLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message OnlineNumWaitingLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.OnlineNumWaitingLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OnlineNumWaitingLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** OnlineState enum. */
    enum OnlineState {
        OnlineState_Offline = 0,
        OnlineState_Online = 1,
        OnlineState_Slow = 2,
        OnlineState_Leave = 3,
        OnlineState_Calling = 4
    }

    /** Properties of an OnlineStateLoginUserPmd_CS. */
    interface IOnlineStateLoginUserPmd_CS {

        /** OnlineStateLoginUserPmd_CS state */
        state?: (number|null);

        /** OnlineStateLoginUserPmd_CS accid */
        accid?: (number|null);
    }

    /** Represents an OnlineStateLoginUserPmd_CS. */
    class OnlineStateLoginUserPmd_CS implements IOnlineStateLoginUserPmd_CS {

        /**
         * Constructs a new OnlineStateLoginUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IOnlineStateLoginUserPmd_CS);

        /** OnlineStateLoginUserPmd_CS state. */
        public state: number;

        /** OnlineStateLoginUserPmd_CS accid. */
        public accid: number;

        /**
         * Creates a new OnlineStateLoginUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns OnlineStateLoginUserPmd_CS instance
         */
        public static create(properties?: Pmd.IOnlineStateLoginUserPmd_CS): Pmd.OnlineStateLoginUserPmd_CS;

        /**
         * Encodes the specified OnlineStateLoginUserPmd_CS message. Does not implicitly {@link Pmd.OnlineStateLoginUserPmd_CS.verify|verify} messages.
         * @param message OnlineStateLoginUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IOnlineStateLoginUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified OnlineStateLoginUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.OnlineStateLoginUserPmd_CS.verify|verify} messages.
         * @param message OnlineStateLoginUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IOnlineStateLoginUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes an OnlineStateLoginUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns OnlineStateLoginUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.OnlineStateLoginUserPmd_CS;

        /**
         * Decodes an OnlineStateLoginUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns OnlineStateLoginUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.OnlineStateLoginUserPmd_CS;

        /**
         * Verifies an OnlineStateLoginUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an OnlineStateLoginUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns OnlineStateLoginUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.OnlineStateLoginUserPmd_CS;

        /**
         * Creates a plain object from an OnlineStateLoginUserPmd_CS message. Also converts values to other types if specified.
         * @param message OnlineStateLoginUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.OnlineStateLoginUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this OnlineStateLoginUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ServerDebugLevelLoginUserPmd_S. */
    interface IServerDebugLevelLoginUserPmd_S {

        /** ServerDebugLevelLoginUserPmd_S level */
        level?: (number|null);
    }

    /** Represents a ServerDebugLevelLoginUserPmd_S. */
    class ServerDebugLevelLoginUserPmd_S implements IServerDebugLevelLoginUserPmd_S {

        /**
         * Constructs a new ServerDebugLevelLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IServerDebugLevelLoginUserPmd_S);

        /** ServerDebugLevelLoginUserPmd_S level. */
        public level: number;

        /**
         * Creates a new ServerDebugLevelLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ServerDebugLevelLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IServerDebugLevelLoginUserPmd_S): Pmd.ServerDebugLevelLoginUserPmd_S;

        /**
         * Encodes the specified ServerDebugLevelLoginUserPmd_S message. Does not implicitly {@link Pmd.ServerDebugLevelLoginUserPmd_S.verify|verify} messages.
         * @param message ServerDebugLevelLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IServerDebugLevelLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ServerDebugLevelLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ServerDebugLevelLoginUserPmd_S.verify|verify} messages.
         * @param message ServerDebugLevelLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IServerDebugLevelLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ServerDebugLevelLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ServerDebugLevelLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ServerDebugLevelLoginUserPmd_S;

        /**
         * Decodes a ServerDebugLevelLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ServerDebugLevelLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ServerDebugLevelLoginUserPmd_S;

        /**
         * Verifies a ServerDebugLevelLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ServerDebugLevelLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ServerDebugLevelLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ServerDebugLevelLoginUserPmd_S;

        /**
         * Creates a plain object from a ServerDebugLevelLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ServerDebugLevelLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ServerDebugLevelLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ServerDebugLevelLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ServerShutDownLoginUserPmd_S. */
    interface IServerShutDownLoginUserPmd_S {

        /** ServerShutDownLoginUserPmd_S servertime */
        servertime?: (number|null);

        /** ServerShutDownLoginUserPmd_S lefttime */
        lefttime?: (number|null);

        /** ServerShutDownLoginUserPmd_S desc */
        desc?: (string|null);

        /** ServerShutDownLoginUserPmd_S gameid */
        gameid?: (number|null);

        /** ServerShutDownLoginUserPmd_S zoneid */
        zoneid?: (number|null);

        /** ServerShutDownLoginUserPmd_S gmid */
        gmid?: (number|null);

        /** ServerShutDownLoginUserPmd_S clientid */
        clientid?: (number|Long|null);

        /** ServerShutDownLoginUserPmd_S retcode */
        retcode?: (number|null);

        /** ServerShutDownLoginUserPmd_S retdesc */
        retdesc?: (string|null);
    }

    /** Represents a ServerShutDownLoginUserPmd_S. */
    class ServerShutDownLoginUserPmd_S implements IServerShutDownLoginUserPmd_S {

        /**
         * Constructs a new ServerShutDownLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IServerShutDownLoginUserPmd_S);

        /** ServerShutDownLoginUserPmd_S servertime. */
        public servertime: number;

        /** ServerShutDownLoginUserPmd_S lefttime. */
        public lefttime: number;

        /** ServerShutDownLoginUserPmd_S desc. */
        public desc: string;

        /** ServerShutDownLoginUserPmd_S gameid. */
        public gameid: number;

        /** ServerShutDownLoginUserPmd_S zoneid. */
        public zoneid: number;

        /** ServerShutDownLoginUserPmd_S gmid. */
        public gmid: number;

        /** ServerShutDownLoginUserPmd_S clientid. */
        public clientid: (number|Long);

        /** ServerShutDownLoginUserPmd_S retcode. */
        public retcode: number;

        /** ServerShutDownLoginUserPmd_S retdesc. */
        public retdesc: string;

        /**
         * Creates a new ServerShutDownLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ServerShutDownLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IServerShutDownLoginUserPmd_S): Pmd.ServerShutDownLoginUserPmd_S;

        /**
         * Encodes the specified ServerShutDownLoginUserPmd_S message. Does not implicitly {@link Pmd.ServerShutDownLoginUserPmd_S.verify|verify} messages.
         * @param message ServerShutDownLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IServerShutDownLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ServerShutDownLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ServerShutDownLoginUserPmd_S.verify|verify} messages.
         * @param message ServerShutDownLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IServerShutDownLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ServerShutDownLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ServerShutDownLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ServerShutDownLoginUserPmd_S;

        /**
         * Decodes a ServerShutDownLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ServerShutDownLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ServerShutDownLoginUserPmd_S;

        /**
         * Verifies a ServerShutDownLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ServerShutDownLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ServerShutDownLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ServerShutDownLoginUserPmd_S;

        /**
         * Creates a plain object from a ServerShutDownLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ServerShutDownLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ServerShutDownLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ServerShutDownLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestZoneStateLoginUserPmd_CS. */
    interface IRequestZoneStateLoginUserPmd_CS {

        /** RequestZoneStateLoginUserPmd_CS gameid */
        gameid?: (number|null);

        /** RequestZoneStateLoginUserPmd_CS startzoneid */
        startzoneid?: (number|null);

        /** RequestZoneStateLoginUserPmd_CS endzoneid */
        endzoneid?: (number|null);

        /** RequestZoneStateLoginUserPmd_CS zoneinfo */
        zoneinfo?: (Pmd.IZoneInfo[]|null);
    }

    /** Represents a RequestZoneStateLoginUserPmd_CS. */
    class RequestZoneStateLoginUserPmd_CS implements IRequestZoneStateLoginUserPmd_CS {

        /**
         * Constructs a new RequestZoneStateLoginUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestZoneStateLoginUserPmd_CS);

        /** RequestZoneStateLoginUserPmd_CS gameid. */
        public gameid: number;

        /** RequestZoneStateLoginUserPmd_CS startzoneid. */
        public startzoneid: number;

        /** RequestZoneStateLoginUserPmd_CS endzoneid. */
        public endzoneid: number;

        /** RequestZoneStateLoginUserPmd_CS zoneinfo. */
        public zoneinfo: Pmd.IZoneInfo[];

        /**
         * Creates a new RequestZoneStateLoginUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestZoneStateLoginUserPmd_CS instance
         */
        public static create(properties?: Pmd.IRequestZoneStateLoginUserPmd_CS): Pmd.RequestZoneStateLoginUserPmd_CS;

        /**
         * Encodes the specified RequestZoneStateLoginUserPmd_CS message. Does not implicitly {@link Pmd.RequestZoneStateLoginUserPmd_CS.verify|verify} messages.
         * @param message RequestZoneStateLoginUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestZoneStateLoginUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestZoneStateLoginUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.RequestZoneStateLoginUserPmd_CS.verify|verify} messages.
         * @param message RequestZoneStateLoginUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestZoneStateLoginUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestZoneStateLoginUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestZoneStateLoginUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestZoneStateLoginUserPmd_CS;

        /**
         * Decodes a RequestZoneStateLoginUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestZoneStateLoginUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestZoneStateLoginUserPmd_CS;

        /**
         * Verifies a RequestZoneStateLoginUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestZoneStateLoginUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestZoneStateLoginUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestZoneStateLoginUserPmd_CS;

        /**
         * Creates a plain object from a RequestZoneStateLoginUserPmd_CS message. Also converts values to other types if specified.
         * @param message RequestZoneStateLoginUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestZoneStateLoginUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestZoneStateLoginUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ClientConfigUpdateLoginUserPmd_S. */
    interface IClientConfigUpdateLoginUserPmd_S {

        /** ClientConfigUpdateLoginUserPmd_S config */
        config?: (string|null);

        /** ClientConfigUpdateLoginUserPmd_S zipmd5 */
        zipmd5?: (string|null);
    }

    /** Represents a ClientConfigUpdateLoginUserPmd_S. */
    class ClientConfigUpdateLoginUserPmd_S implements IClientConfigUpdateLoginUserPmd_S {

        /**
         * Constructs a new ClientConfigUpdateLoginUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IClientConfigUpdateLoginUserPmd_S);

        /** ClientConfigUpdateLoginUserPmd_S config. */
        public config: string;

        /** ClientConfigUpdateLoginUserPmd_S zipmd5. */
        public zipmd5: string;

        /**
         * Creates a new ClientConfigUpdateLoginUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ClientConfigUpdateLoginUserPmd_S instance
         */
        public static create(properties?: Pmd.IClientConfigUpdateLoginUserPmd_S): Pmd.ClientConfigUpdateLoginUserPmd_S;

        /**
         * Encodes the specified ClientConfigUpdateLoginUserPmd_S message. Does not implicitly {@link Pmd.ClientConfigUpdateLoginUserPmd_S.verify|verify} messages.
         * @param message ClientConfigUpdateLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IClientConfigUpdateLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ClientConfigUpdateLoginUserPmd_S message, length delimited. Does not implicitly {@link Pmd.ClientConfigUpdateLoginUserPmd_S.verify|verify} messages.
         * @param message ClientConfigUpdateLoginUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IClientConfigUpdateLoginUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ClientConfigUpdateLoginUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ClientConfigUpdateLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ClientConfigUpdateLoginUserPmd_S;

        /**
         * Decodes a ClientConfigUpdateLoginUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ClientConfigUpdateLoginUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ClientConfigUpdateLoginUserPmd_S;

        /**
         * Verifies a ClientConfigUpdateLoginUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ClientConfigUpdateLoginUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ClientConfigUpdateLoginUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ClientConfigUpdateLoginUserPmd_S;

        /**
         * Creates a plain object from a ClientConfigUpdateLoginUserPmd_S message. Also converts values to other types if specified.
         * @param message ClientConfigUpdateLoginUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ClientConfigUpdateLoginUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ClientConfigUpdateLoginUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CreatePlatOrderRequestSdkPmd_C. */
    interface ICreatePlatOrderRequestSdkPmd_C {

        /** CreatePlatOrderRequestSdkPmd_C data */
        data: Pmd.IPlatBaseData;

        /** CreatePlatOrderRequestSdkPmd_C gameorder */
        gameorder?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C roleid */
        roleid?: (number|Long|null);

        /** CreatePlatOrderRequestSdkPmd_C rolename */
        rolename?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C originalmoney */
        originalmoney?: (number|null);

        /** CreatePlatOrderRequestSdkPmd_C ordermoney */
        ordermoney?: (number|null);

        /** CreatePlatOrderRequestSdkPmd_C goodid */
        goodid?: (number|null);

        /** CreatePlatOrderRequestSdkPmd_C goodnum */
        goodnum?: (number|null);

        /** CreatePlatOrderRequestSdkPmd_C goodname */
        goodname?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C gooddesc */
        gooddesc?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C redirecturl */
        redirecturl?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C payplatid */
        payplatid?: (number|null);

        /** CreatePlatOrderRequestSdkPmd_C extdata */
        extdata?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C appgoodid */
        appgoodid?: (string|null);

        /** CreatePlatOrderRequestSdkPmd_C rolelevel */
        rolelevel?: (number|null);
    }

    /** Represents a CreatePlatOrderRequestSdkPmd_C. */
    class CreatePlatOrderRequestSdkPmd_C implements ICreatePlatOrderRequestSdkPmd_C {

        /**
         * Constructs a new CreatePlatOrderRequestSdkPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ICreatePlatOrderRequestSdkPmd_C);

        /** CreatePlatOrderRequestSdkPmd_C data. */
        public data: Pmd.IPlatBaseData;

        /** CreatePlatOrderRequestSdkPmd_C gameorder. */
        public gameorder: string;

        /** CreatePlatOrderRequestSdkPmd_C roleid. */
        public roleid: (number|Long);

        /** CreatePlatOrderRequestSdkPmd_C rolename. */
        public rolename: string;

        /** CreatePlatOrderRequestSdkPmd_C originalmoney. */
        public originalmoney: number;

        /** CreatePlatOrderRequestSdkPmd_C ordermoney. */
        public ordermoney: number;

        /** CreatePlatOrderRequestSdkPmd_C goodid. */
        public goodid: number;

        /** CreatePlatOrderRequestSdkPmd_C goodnum. */
        public goodnum: number;

        /** CreatePlatOrderRequestSdkPmd_C goodname. */
        public goodname: string;

        /** CreatePlatOrderRequestSdkPmd_C gooddesc. */
        public gooddesc: string;

        /** CreatePlatOrderRequestSdkPmd_C redirecturl. */
        public redirecturl: string;

        /** CreatePlatOrderRequestSdkPmd_C payplatid. */
        public payplatid: number;

        /** CreatePlatOrderRequestSdkPmd_C extdata. */
        public extdata: string;

        /** CreatePlatOrderRequestSdkPmd_C appgoodid. */
        public appgoodid: string;

        /** CreatePlatOrderRequestSdkPmd_C rolelevel. */
        public rolelevel: number;

        /**
         * Creates a new CreatePlatOrderRequestSdkPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CreatePlatOrderRequestSdkPmd_C instance
         */
        public static create(properties?: Pmd.ICreatePlatOrderRequestSdkPmd_C): Pmd.CreatePlatOrderRequestSdkPmd_C;

        /**
         * Encodes the specified CreatePlatOrderRequestSdkPmd_C message. Does not implicitly {@link Pmd.CreatePlatOrderRequestSdkPmd_C.verify|verify} messages.
         * @param message CreatePlatOrderRequestSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ICreatePlatOrderRequestSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified CreatePlatOrderRequestSdkPmd_C message, length delimited. Does not implicitly {@link Pmd.CreatePlatOrderRequestSdkPmd_C.verify|verify} messages.
         * @param message CreatePlatOrderRequestSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ICreatePlatOrderRequestSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a CreatePlatOrderRequestSdkPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CreatePlatOrderRequestSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.CreatePlatOrderRequestSdkPmd_C;

        /**
         * Decodes a CreatePlatOrderRequestSdkPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CreatePlatOrderRequestSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.CreatePlatOrderRequestSdkPmd_C;

        /**
         * Verifies a CreatePlatOrderRequestSdkPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CreatePlatOrderRequestSdkPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CreatePlatOrderRequestSdkPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.CreatePlatOrderRequestSdkPmd_C;

        /**
         * Creates a plain object from a CreatePlatOrderRequestSdkPmd_C message. Also converts values to other types if specified.
         * @param message CreatePlatOrderRequestSdkPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.CreatePlatOrderRequestSdkPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CreatePlatOrderRequestSdkPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a CreatePlatOrderReturnSdkPmd_S. */
    interface ICreatePlatOrderReturnSdkPmd_S {

        /** CreatePlatOrderReturnSdkPmd_S data */
        data: Pmd.IPlatBaseData;

        /** CreatePlatOrderReturnSdkPmd_S gameorder */
        gameorder?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S roleid */
        roleid?: (number|Long|null);

        /** CreatePlatOrderReturnSdkPmd_S originalmoney */
        originalmoney?: (number|null);

        /** CreatePlatOrderReturnSdkPmd_S ordermoney */
        ordermoney?: (number|null);

        /** CreatePlatOrderReturnSdkPmd_S goodid */
        goodid?: (number|null);

        /** CreatePlatOrderReturnSdkPmd_S goodnum */
        goodnum?: (number|null);

        /** CreatePlatOrderReturnSdkPmd_S result */
        result?: (number|null);

        /** CreatePlatOrderReturnSdkPmd_S noticeurl */
        noticeurl?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S platorder */
        platorder?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S sign */
        sign?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S redirecturl */
        redirecturl?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S payplatid */
        payplatid?: (number|null);

        /** CreatePlatOrderReturnSdkPmd_S extdata */
        extdata?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S appgoodid */
        appgoodid?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S gamemoneyold */
        gamemoneyold?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S gamemoney */
        gamemoney?: (number|Long|null);

        /** CreatePlatOrderReturnSdkPmd_S createtime */
        createtime?: (string|null);

        /** CreatePlatOrderReturnSdkPmd_S rolelevel */
        rolelevel?: (number|null);
    }

    /** Represents a CreatePlatOrderReturnSdkPmd_S. */
    class CreatePlatOrderReturnSdkPmd_S implements ICreatePlatOrderReturnSdkPmd_S {

        /**
         * Constructs a new CreatePlatOrderReturnSdkPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ICreatePlatOrderReturnSdkPmd_S);

        /** CreatePlatOrderReturnSdkPmd_S data. */
        public data: Pmd.IPlatBaseData;

        /** CreatePlatOrderReturnSdkPmd_S gameorder. */
        public gameorder: string;

        /** CreatePlatOrderReturnSdkPmd_S roleid. */
        public roleid: (number|Long);

        /** CreatePlatOrderReturnSdkPmd_S originalmoney. */
        public originalmoney: number;

        /** CreatePlatOrderReturnSdkPmd_S ordermoney. */
        public ordermoney: number;

        /** CreatePlatOrderReturnSdkPmd_S goodid. */
        public goodid: number;

        /** CreatePlatOrderReturnSdkPmd_S goodnum. */
        public goodnum: number;

        /** CreatePlatOrderReturnSdkPmd_S result. */
        public result: number;

        /** CreatePlatOrderReturnSdkPmd_S noticeurl. */
        public noticeurl: string;

        /** CreatePlatOrderReturnSdkPmd_S platorder. */
        public platorder: string;

        /** CreatePlatOrderReturnSdkPmd_S sign. */
        public sign: string;

        /** CreatePlatOrderReturnSdkPmd_S redirecturl. */
        public redirecturl: string;

        /** CreatePlatOrderReturnSdkPmd_S payplatid. */
        public payplatid: number;

        /** CreatePlatOrderReturnSdkPmd_S extdata. */
        public extdata: string;

        /** CreatePlatOrderReturnSdkPmd_S appgoodid. */
        public appgoodid: string;

        /** CreatePlatOrderReturnSdkPmd_S gamemoneyold. */
        public gamemoneyold: string;

        /** CreatePlatOrderReturnSdkPmd_S gamemoney. */
        public gamemoney: (number|Long);

        /** CreatePlatOrderReturnSdkPmd_S createtime. */
        public createtime: string;

        /** CreatePlatOrderReturnSdkPmd_S rolelevel. */
        public rolelevel: number;

        /**
         * Creates a new CreatePlatOrderReturnSdkPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CreatePlatOrderReturnSdkPmd_S instance
         */
        public static create(properties?: Pmd.ICreatePlatOrderReturnSdkPmd_S): Pmd.CreatePlatOrderReturnSdkPmd_S;

        /**
         * Encodes the specified CreatePlatOrderReturnSdkPmd_S message. Does not implicitly {@link Pmd.CreatePlatOrderReturnSdkPmd_S.verify|verify} messages.
         * @param message CreatePlatOrderReturnSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ICreatePlatOrderReturnSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified CreatePlatOrderReturnSdkPmd_S message, length delimited. Does not implicitly {@link Pmd.CreatePlatOrderReturnSdkPmd_S.verify|verify} messages.
         * @param message CreatePlatOrderReturnSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ICreatePlatOrderReturnSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a CreatePlatOrderReturnSdkPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CreatePlatOrderReturnSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.CreatePlatOrderReturnSdkPmd_S;

        /**
         * Decodes a CreatePlatOrderReturnSdkPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CreatePlatOrderReturnSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.CreatePlatOrderReturnSdkPmd_S;

        /**
         * Verifies a CreatePlatOrderReturnSdkPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CreatePlatOrderReturnSdkPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CreatePlatOrderReturnSdkPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.CreatePlatOrderReturnSdkPmd_S;

        /**
         * Creates a plain object from a CreatePlatOrderReturnSdkPmd_S message. Also converts values to other types if specified.
         * @param message CreatePlatOrderReturnSdkPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.CreatePlatOrderReturnSdkPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CreatePlatOrderReturnSdkPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RechargeQueryRequestIOSSdkPmd_C. */
    interface IRechargeQueryRequestIOSSdkPmd_C {

        /** RechargeQueryRequestIOSSdkPmd_C data */
        data: Pmd.IPlatBaseData;

        /** RechargeQueryRequestIOSSdkPmd_C gameorder */
        gameorder?: (string|null);

        /** RechargeQueryRequestIOSSdkPmd_C roleid */
        roleid?: (number|Long|null);

        /** RechargeQueryRequestIOSSdkPmd_C originalmoney */
        originalmoney?: (number|null);

        /** RechargeQueryRequestIOSSdkPmd_C ordermoney */
        ordermoney?: (number|null);

        /** RechargeQueryRequestIOSSdkPmd_C token */
        token?: (string|null);

        /** RechargeQueryRequestIOSSdkPmd_C extdata */
        extdata?: (string|null);

        /** RechargeQueryRequestIOSSdkPmd_C payplatid */
        payplatid?: (number|null);
    }

    /** Represents a RechargeQueryRequestIOSSdkPmd_C. */
    class RechargeQueryRequestIOSSdkPmd_C implements IRechargeQueryRequestIOSSdkPmd_C {

        /**
         * Constructs a new RechargeQueryRequestIOSSdkPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRechargeQueryRequestIOSSdkPmd_C);

        /** RechargeQueryRequestIOSSdkPmd_C data. */
        public data: Pmd.IPlatBaseData;

        /** RechargeQueryRequestIOSSdkPmd_C gameorder. */
        public gameorder: string;

        /** RechargeQueryRequestIOSSdkPmd_C roleid. */
        public roleid: (number|Long);

        /** RechargeQueryRequestIOSSdkPmd_C originalmoney. */
        public originalmoney: number;

        /** RechargeQueryRequestIOSSdkPmd_C ordermoney. */
        public ordermoney: number;

        /** RechargeQueryRequestIOSSdkPmd_C token. */
        public token: string;

        /** RechargeQueryRequestIOSSdkPmd_C extdata. */
        public extdata: string;

        /** RechargeQueryRequestIOSSdkPmd_C payplatid. */
        public payplatid: number;

        /**
         * Creates a new RechargeQueryRequestIOSSdkPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RechargeQueryRequestIOSSdkPmd_C instance
         */
        public static create(properties?: Pmd.IRechargeQueryRequestIOSSdkPmd_C): Pmd.RechargeQueryRequestIOSSdkPmd_C;

        /**
         * Encodes the specified RechargeQueryRequestIOSSdkPmd_C message. Does not implicitly {@link Pmd.RechargeQueryRequestIOSSdkPmd_C.verify|verify} messages.
         * @param message RechargeQueryRequestIOSSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRechargeQueryRequestIOSSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RechargeQueryRequestIOSSdkPmd_C message, length delimited. Does not implicitly {@link Pmd.RechargeQueryRequestIOSSdkPmd_C.verify|verify} messages.
         * @param message RechargeQueryRequestIOSSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRechargeQueryRequestIOSSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RechargeQueryRequestIOSSdkPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RechargeQueryRequestIOSSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RechargeQueryRequestIOSSdkPmd_C;

        /**
         * Decodes a RechargeQueryRequestIOSSdkPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RechargeQueryRequestIOSSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RechargeQueryRequestIOSSdkPmd_C;

        /**
         * Verifies a RechargeQueryRequestIOSSdkPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RechargeQueryRequestIOSSdkPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RechargeQueryRequestIOSSdkPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RechargeQueryRequestIOSSdkPmd_C;

        /**
         * Creates a plain object from a RechargeQueryRequestIOSSdkPmd_C message. Also converts values to other types if specified.
         * @param message RechargeQueryRequestIOSSdkPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RechargeQueryRequestIOSSdkPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RechargeQueryRequestIOSSdkPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestQueryPlatPointSdkPmd_C. */
    interface IRequestQueryPlatPointSdkPmd_C {

        /** RequestQueryPlatPointSdkPmd_C data */
        data: Pmd.IPlatBaseData;

        /** RequestQueryPlatPointSdkPmd_C gameorder */
        gameorder?: (string|null);
    }

    /** Represents a RequestQueryPlatPointSdkPmd_C. */
    class RequestQueryPlatPointSdkPmd_C implements IRequestQueryPlatPointSdkPmd_C {

        /**
         * Constructs a new RequestQueryPlatPointSdkPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestQueryPlatPointSdkPmd_C);

        /** RequestQueryPlatPointSdkPmd_C data. */
        public data: Pmd.IPlatBaseData;

        /** RequestQueryPlatPointSdkPmd_C gameorder. */
        public gameorder: string;

        /**
         * Creates a new RequestQueryPlatPointSdkPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestQueryPlatPointSdkPmd_C instance
         */
        public static create(properties?: Pmd.IRequestQueryPlatPointSdkPmd_C): Pmd.RequestQueryPlatPointSdkPmd_C;

        /**
         * Encodes the specified RequestQueryPlatPointSdkPmd_C message. Does not implicitly {@link Pmd.RequestQueryPlatPointSdkPmd_C.verify|verify} messages.
         * @param message RequestQueryPlatPointSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestQueryPlatPointSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestQueryPlatPointSdkPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestQueryPlatPointSdkPmd_C.verify|verify} messages.
         * @param message RequestQueryPlatPointSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestQueryPlatPointSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestQueryPlatPointSdkPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestQueryPlatPointSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestQueryPlatPointSdkPmd_C;

        /**
         * Decodes a RequestQueryPlatPointSdkPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestQueryPlatPointSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestQueryPlatPointSdkPmd_C;

        /**
         * Verifies a RequestQueryPlatPointSdkPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestQueryPlatPointSdkPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestQueryPlatPointSdkPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestQueryPlatPointSdkPmd_C;

        /**
         * Creates a plain object from a RequestQueryPlatPointSdkPmd_C message. Also converts values to other types if specified.
         * @param message RequestQueryPlatPointSdkPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestQueryPlatPointSdkPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestQueryPlatPointSdkPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnQueryPlatPointSdkPmd_S. */
    interface IReturnQueryPlatPointSdkPmd_S {

        /** ReturnQueryPlatPointSdkPmd_S data */
        data: Pmd.IPlatBaseData;

        /** ReturnQueryPlatPointSdkPmd_S gameorder */
        gameorder: string;

        /** ReturnQueryPlatPointSdkPmd_S balance */
        balance: (number|Long);

        /** ReturnQueryPlatPointSdkPmd_S ret */
        ret: number;

        /** ReturnQueryPlatPointSdkPmd_S retdesc */
        retdesc?: (string|null);

        /** ReturnQueryPlatPointSdkPmd_S money */
        money?: (number|null);
    }

    /** Represents a ReturnQueryPlatPointSdkPmd_S. */
    class ReturnQueryPlatPointSdkPmd_S implements IReturnQueryPlatPointSdkPmd_S {

        /**
         * Constructs a new ReturnQueryPlatPointSdkPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnQueryPlatPointSdkPmd_S);

        /** ReturnQueryPlatPointSdkPmd_S data. */
        public data: Pmd.IPlatBaseData;

        /** ReturnQueryPlatPointSdkPmd_S gameorder. */
        public gameorder: string;

        /** ReturnQueryPlatPointSdkPmd_S balance. */
        public balance: (number|Long);

        /** ReturnQueryPlatPointSdkPmd_S ret. */
        public ret: number;

        /** ReturnQueryPlatPointSdkPmd_S retdesc. */
        public retdesc: string;

        /** ReturnQueryPlatPointSdkPmd_S money. */
        public money: number;

        /**
         * Creates a new ReturnQueryPlatPointSdkPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnQueryPlatPointSdkPmd_S instance
         */
        public static create(properties?: Pmd.IReturnQueryPlatPointSdkPmd_S): Pmd.ReturnQueryPlatPointSdkPmd_S;

        /**
         * Encodes the specified ReturnQueryPlatPointSdkPmd_S message. Does not implicitly {@link Pmd.ReturnQueryPlatPointSdkPmd_S.verify|verify} messages.
         * @param message ReturnQueryPlatPointSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnQueryPlatPointSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnQueryPlatPointSdkPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnQueryPlatPointSdkPmd_S.verify|verify} messages.
         * @param message ReturnQueryPlatPointSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnQueryPlatPointSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnQueryPlatPointSdkPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnQueryPlatPointSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnQueryPlatPointSdkPmd_S;

        /**
         * Decodes a ReturnQueryPlatPointSdkPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnQueryPlatPointSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnQueryPlatPointSdkPmd_S;

        /**
         * Verifies a ReturnQueryPlatPointSdkPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnQueryPlatPointSdkPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnQueryPlatPointSdkPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnQueryPlatPointSdkPmd_S;

        /**
         * Creates a plain object from a ReturnQueryPlatPointSdkPmd_S message. Also converts values to other types if specified.
         * @param message ReturnQueryPlatPointSdkPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnQueryPlatPointSdkPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnQueryPlatPointSdkPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestRedeemPlatPointSdkPmd_C. */
    interface IRequestRedeemPlatPointSdkPmd_C {

        /** RequestRedeemPlatPointSdkPmd_C data */
        data: Pmd.IPlatBaseData;

        /** RequestRedeemPlatPointSdkPmd_C gameorder */
        gameorder?: (string|null);

        /** RequestRedeemPlatPointSdkPmd_C goodid */
        goodid?: (number|null);

        /** RequestRedeemPlatPointSdkPmd_C money */
        money?: (number|null);

        /** RequestRedeemPlatPointSdkPmd_C extdata */
        extdata?: (string|null);
    }

    /** Represents a RequestRedeemPlatPointSdkPmd_C. */
    class RequestRedeemPlatPointSdkPmd_C implements IRequestRedeemPlatPointSdkPmd_C {

        /**
         * Constructs a new RequestRedeemPlatPointSdkPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestRedeemPlatPointSdkPmd_C);

        /** RequestRedeemPlatPointSdkPmd_C data. */
        public data: Pmd.IPlatBaseData;

        /** RequestRedeemPlatPointSdkPmd_C gameorder. */
        public gameorder: string;

        /** RequestRedeemPlatPointSdkPmd_C goodid. */
        public goodid: number;

        /** RequestRedeemPlatPointSdkPmd_C money. */
        public money: number;

        /** RequestRedeemPlatPointSdkPmd_C extdata. */
        public extdata: string;

        /**
         * Creates a new RequestRedeemPlatPointSdkPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestRedeemPlatPointSdkPmd_C instance
         */
        public static create(properties?: Pmd.IRequestRedeemPlatPointSdkPmd_C): Pmd.RequestRedeemPlatPointSdkPmd_C;

        /**
         * Encodes the specified RequestRedeemPlatPointSdkPmd_C message. Does not implicitly {@link Pmd.RequestRedeemPlatPointSdkPmd_C.verify|verify} messages.
         * @param message RequestRedeemPlatPointSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestRedeemPlatPointSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestRedeemPlatPointSdkPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestRedeemPlatPointSdkPmd_C.verify|verify} messages.
         * @param message RequestRedeemPlatPointSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestRedeemPlatPointSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestRedeemPlatPointSdkPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestRedeemPlatPointSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestRedeemPlatPointSdkPmd_C;

        /**
         * Decodes a RequestRedeemPlatPointSdkPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestRedeemPlatPointSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestRedeemPlatPointSdkPmd_C;

        /**
         * Verifies a RequestRedeemPlatPointSdkPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestRedeemPlatPointSdkPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestRedeemPlatPointSdkPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestRedeemPlatPointSdkPmd_C;

        /**
         * Creates a plain object from a RequestRedeemPlatPointSdkPmd_C message. Also converts values to other types if specified.
         * @param message RequestRedeemPlatPointSdkPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestRedeemPlatPointSdkPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestRedeemPlatPointSdkPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnRedeemPlatPointSdkPmd_S. */
    interface IReturnRedeemPlatPointSdkPmd_S {

        /** ReturnRedeemPlatPointSdkPmd_S data */
        data: Pmd.IPlatBaseData;

        /** ReturnRedeemPlatPointSdkPmd_S gameorder */
        gameorder: string;

        /** ReturnRedeemPlatPointSdkPmd_S goodid */
        goodid: number;

        /** ReturnRedeemPlatPointSdkPmd_S money */
        money: number;

        /** ReturnRedeemPlatPointSdkPmd_S balance */
        balance: (number|Long);

        /** ReturnRedeemPlatPointSdkPmd_S ret */
        ret: number;

        /** ReturnRedeemPlatPointSdkPmd_S retdesc */
        retdesc?: (string|null);
    }

    /** Represents a ReturnRedeemPlatPointSdkPmd_S. */
    class ReturnRedeemPlatPointSdkPmd_S implements IReturnRedeemPlatPointSdkPmd_S {

        /**
         * Constructs a new ReturnRedeemPlatPointSdkPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnRedeemPlatPointSdkPmd_S);

        /** ReturnRedeemPlatPointSdkPmd_S data. */
        public data: Pmd.IPlatBaseData;

        /** ReturnRedeemPlatPointSdkPmd_S gameorder. */
        public gameorder: string;

        /** ReturnRedeemPlatPointSdkPmd_S goodid. */
        public goodid: number;

        /** ReturnRedeemPlatPointSdkPmd_S money. */
        public money: number;

        /** ReturnRedeemPlatPointSdkPmd_S balance. */
        public balance: (number|Long);

        /** ReturnRedeemPlatPointSdkPmd_S ret. */
        public ret: number;

        /** ReturnRedeemPlatPointSdkPmd_S retdesc. */
        public retdesc: string;

        /**
         * Creates a new ReturnRedeemPlatPointSdkPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnRedeemPlatPointSdkPmd_S instance
         */
        public static create(properties?: Pmd.IReturnRedeemPlatPointSdkPmd_S): Pmd.ReturnRedeemPlatPointSdkPmd_S;

        /**
         * Encodes the specified ReturnRedeemPlatPointSdkPmd_S message. Does not implicitly {@link Pmd.ReturnRedeemPlatPointSdkPmd_S.verify|verify} messages.
         * @param message ReturnRedeemPlatPointSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnRedeemPlatPointSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnRedeemPlatPointSdkPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnRedeemPlatPointSdkPmd_S.verify|verify} messages.
         * @param message ReturnRedeemPlatPointSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnRedeemPlatPointSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnRedeemPlatPointSdkPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnRedeemPlatPointSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnRedeemPlatPointSdkPmd_S;

        /**
         * Decodes a ReturnRedeemPlatPointSdkPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnRedeemPlatPointSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnRedeemPlatPointSdkPmd_S;

        /**
         * Verifies a ReturnRedeemPlatPointSdkPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnRedeemPlatPointSdkPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnRedeemPlatPointSdkPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnRedeemPlatPointSdkPmd_S;

        /**
         * Creates a plain object from a ReturnRedeemPlatPointSdkPmd_S message. Also converts values to other types if specified.
         * @param message ReturnRedeemPlatPointSdkPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnRedeemPlatPointSdkPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnRedeemPlatPointSdkPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestRedeemBackPlatPointSdkPmd_C. */
    interface IRequestRedeemBackPlatPointSdkPmd_C {

        /** RequestRedeemBackPlatPointSdkPmd_C data */
        data: Pmd.IPlatBaseData;

        /** RequestRedeemBackPlatPointSdkPmd_C gameorder */
        gameorder?: (string|null);

        /** RequestRedeemBackPlatPointSdkPmd_C point */
        point?: (number|null);

        /** RequestRedeemBackPlatPointSdkPmd_C money */
        money?: (number|null);

        /** RequestRedeemBackPlatPointSdkPmd_C extdata */
        extdata?: (string|null);
    }

    /** Represents a RequestRedeemBackPlatPointSdkPmd_C. */
    class RequestRedeemBackPlatPointSdkPmd_C implements IRequestRedeemBackPlatPointSdkPmd_C {

        /**
         * Constructs a new RequestRedeemBackPlatPointSdkPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestRedeemBackPlatPointSdkPmd_C);

        /** RequestRedeemBackPlatPointSdkPmd_C data. */
        public data: Pmd.IPlatBaseData;

        /** RequestRedeemBackPlatPointSdkPmd_C gameorder. */
        public gameorder: string;

        /** RequestRedeemBackPlatPointSdkPmd_C point. */
        public point: number;

        /** RequestRedeemBackPlatPointSdkPmd_C money. */
        public money: number;

        /** RequestRedeemBackPlatPointSdkPmd_C extdata. */
        public extdata: string;

        /**
         * Creates a new RequestRedeemBackPlatPointSdkPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestRedeemBackPlatPointSdkPmd_C instance
         */
        public static create(properties?: Pmd.IRequestRedeemBackPlatPointSdkPmd_C): Pmd.RequestRedeemBackPlatPointSdkPmd_C;

        /**
         * Encodes the specified RequestRedeemBackPlatPointSdkPmd_C message. Does not implicitly {@link Pmd.RequestRedeemBackPlatPointSdkPmd_C.verify|verify} messages.
         * @param message RequestRedeemBackPlatPointSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestRedeemBackPlatPointSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestRedeemBackPlatPointSdkPmd_C message, length delimited. Does not implicitly {@link Pmd.RequestRedeemBackPlatPointSdkPmd_C.verify|verify} messages.
         * @param message RequestRedeemBackPlatPointSdkPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestRedeemBackPlatPointSdkPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestRedeemBackPlatPointSdkPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestRedeemBackPlatPointSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestRedeemBackPlatPointSdkPmd_C;

        /**
         * Decodes a RequestRedeemBackPlatPointSdkPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestRedeemBackPlatPointSdkPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestRedeemBackPlatPointSdkPmd_C;

        /**
         * Verifies a RequestRedeemBackPlatPointSdkPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestRedeemBackPlatPointSdkPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestRedeemBackPlatPointSdkPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestRedeemBackPlatPointSdkPmd_C;

        /**
         * Creates a plain object from a RequestRedeemBackPlatPointSdkPmd_C message. Also converts values to other types if specified.
         * @param message RequestRedeemBackPlatPointSdkPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestRedeemBackPlatPointSdkPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestRedeemBackPlatPointSdkPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnRedeemBackPlatPointSdkPmd_S. */
    interface IReturnRedeemBackPlatPointSdkPmd_S {

        /** ReturnRedeemBackPlatPointSdkPmd_S data */
        data: Pmd.IPlatBaseData;

        /** ReturnRedeemBackPlatPointSdkPmd_S gameorder */
        gameorder: string;

        /** ReturnRedeemBackPlatPointSdkPmd_S balance */
        balance: (number|Long);

        /** ReturnRedeemBackPlatPointSdkPmd_S money */
        money?: (number|null);

        /** ReturnRedeemBackPlatPointSdkPmd_S ret */
        ret: number;

        /** ReturnRedeemBackPlatPointSdkPmd_S retdesc */
        retdesc?: (string|null);
    }

    /** Represents a ReturnRedeemBackPlatPointSdkPmd_S. */
    class ReturnRedeemBackPlatPointSdkPmd_S implements IReturnRedeemBackPlatPointSdkPmd_S {

        /**
         * Constructs a new ReturnRedeemBackPlatPointSdkPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnRedeemBackPlatPointSdkPmd_S);

        /** ReturnRedeemBackPlatPointSdkPmd_S data. */
        public data: Pmd.IPlatBaseData;

        /** ReturnRedeemBackPlatPointSdkPmd_S gameorder. */
        public gameorder: string;

        /** ReturnRedeemBackPlatPointSdkPmd_S balance. */
        public balance: (number|Long);

        /** ReturnRedeemBackPlatPointSdkPmd_S money. */
        public money: number;

        /** ReturnRedeemBackPlatPointSdkPmd_S ret. */
        public ret: number;

        /** ReturnRedeemBackPlatPointSdkPmd_S retdesc. */
        public retdesc: string;

        /**
         * Creates a new ReturnRedeemBackPlatPointSdkPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnRedeemBackPlatPointSdkPmd_S instance
         */
        public static create(properties?: Pmd.IReturnRedeemBackPlatPointSdkPmd_S): Pmd.ReturnRedeemBackPlatPointSdkPmd_S;

        /**
         * Encodes the specified ReturnRedeemBackPlatPointSdkPmd_S message. Does not implicitly {@link Pmd.ReturnRedeemBackPlatPointSdkPmd_S.verify|verify} messages.
         * @param message ReturnRedeemBackPlatPointSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnRedeemBackPlatPointSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnRedeemBackPlatPointSdkPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnRedeemBackPlatPointSdkPmd_S.verify|verify} messages.
         * @param message ReturnRedeemBackPlatPointSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnRedeemBackPlatPointSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnRedeemBackPlatPointSdkPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnRedeemBackPlatPointSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnRedeemBackPlatPointSdkPmd_S;

        /**
         * Decodes a ReturnRedeemBackPlatPointSdkPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnRedeemBackPlatPointSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnRedeemBackPlatPointSdkPmd_S;

        /**
         * Verifies a ReturnRedeemBackPlatPointSdkPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnRedeemBackPlatPointSdkPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnRedeemBackPlatPointSdkPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnRedeemBackPlatPointSdkPmd_S;

        /**
         * Creates a plain object from a ReturnRedeemBackPlatPointSdkPmd_S message. Also converts values to other types if specified.
         * @param message ReturnRedeemBackPlatPointSdkPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnRedeemBackPlatPointSdkPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnRedeemBackPlatPointSdkPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a ReturnErrorCodeSdkPmd_S. */
    interface IReturnErrorCodeSdkPmd_S {

        /** ReturnErrorCodeSdkPmd_S data */
        data?: (Pmd.IPlatBaseData|null);

        /** ReturnErrorCodeSdkPmd_S ret */
        ret?: (number|null);

        /** ReturnErrorCodeSdkPmd_S retdesc */
        retdesc?: (string|null);
    }

    /** Represents a ReturnErrorCodeSdkPmd_S. */
    class ReturnErrorCodeSdkPmd_S implements IReturnErrorCodeSdkPmd_S {

        /**
         * Constructs a new ReturnErrorCodeSdkPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IReturnErrorCodeSdkPmd_S);

        /** ReturnErrorCodeSdkPmd_S data. */
        public data?: (Pmd.IPlatBaseData|null);

        /** ReturnErrorCodeSdkPmd_S ret. */
        public ret: number;

        /** ReturnErrorCodeSdkPmd_S retdesc. */
        public retdesc: string;

        /**
         * Creates a new ReturnErrorCodeSdkPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ReturnErrorCodeSdkPmd_S instance
         */
        public static create(properties?: Pmd.IReturnErrorCodeSdkPmd_S): Pmd.ReturnErrorCodeSdkPmd_S;

        /**
         * Encodes the specified ReturnErrorCodeSdkPmd_S message. Does not implicitly {@link Pmd.ReturnErrorCodeSdkPmd_S.verify|verify} messages.
         * @param message ReturnErrorCodeSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IReturnErrorCodeSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified ReturnErrorCodeSdkPmd_S message, length delimited. Does not implicitly {@link Pmd.ReturnErrorCodeSdkPmd_S.verify|verify} messages.
         * @param message ReturnErrorCodeSdkPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IReturnErrorCodeSdkPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a ReturnErrorCodeSdkPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ReturnErrorCodeSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.ReturnErrorCodeSdkPmd_S;

        /**
         * Decodes a ReturnErrorCodeSdkPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ReturnErrorCodeSdkPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.ReturnErrorCodeSdkPmd_S;

        /**
         * Verifies a ReturnErrorCodeSdkPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ReturnErrorCodeSdkPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ReturnErrorCodeSdkPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.ReturnErrorCodeSdkPmd_S;

        /**
         * Creates a plain object from a ReturnErrorCodeSdkPmd_S message. Also converts values to other types if specified.
         * @param message ReturnErrorCodeSdkPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.ReturnErrorCodeSdkPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ReturnErrorCodeSdkPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestBindAccountSdkPmd_CS. */
    interface IRequestBindAccountSdkPmd_CS {

        /** RequestBindAccountSdkPmd_CS data */
        data?: (Pmd.IPlatBaseData|null);

        /** RequestBindAccountSdkPmd_CS ret */
        ret?: (number|null);
    }

    /** Represents a RequestBindAccountSdkPmd_CS. */
    class RequestBindAccountSdkPmd_CS implements IRequestBindAccountSdkPmd_CS {

        /**
         * Constructs a new RequestBindAccountSdkPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestBindAccountSdkPmd_CS);

        /** RequestBindAccountSdkPmd_CS data. */
        public data?: (Pmd.IPlatBaseData|null);

        /** RequestBindAccountSdkPmd_CS ret. */
        public ret: number;

        /**
         * Creates a new RequestBindAccountSdkPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestBindAccountSdkPmd_CS instance
         */
        public static create(properties?: Pmd.IRequestBindAccountSdkPmd_CS): Pmd.RequestBindAccountSdkPmd_CS;

        /**
         * Encodes the specified RequestBindAccountSdkPmd_CS message. Does not implicitly {@link Pmd.RequestBindAccountSdkPmd_CS.verify|verify} messages.
         * @param message RequestBindAccountSdkPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestBindAccountSdkPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestBindAccountSdkPmd_CS message, length delimited. Does not implicitly {@link Pmd.RequestBindAccountSdkPmd_CS.verify|verify} messages.
         * @param message RequestBindAccountSdkPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestBindAccountSdkPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestBindAccountSdkPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestBindAccountSdkPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestBindAccountSdkPmd_CS;

        /**
         * Decodes a RequestBindAccountSdkPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestBindAccountSdkPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestBindAccountSdkPmd_CS;

        /**
         * Verifies a RequestBindAccountSdkPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestBindAccountSdkPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestBindAccountSdkPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestBindAccountSdkPmd_CS;

        /**
         * Creates a plain object from a RequestBindAccountSdkPmd_CS message. Also converts values to other types if specified.
         * @param message RequestBindAccountSdkPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestBindAccountSdkPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestBindAccountSdkPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a Chat. */
    interface IChat {
    }

    /** Represents a Chat. */
    class Chat implements IChat {

        /**
         * Constructs a new Chat.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IChat);

        /**
         * Creates a new Chat instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Chat instance
         */
        public static create(properties?: Pmd.IChat): Pmd.Chat;

        /**
         * Encodes the specified Chat message. Does not implicitly {@link Pmd.Chat.verify|verify} messages.
         * @param message Chat message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IChat, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified Chat message, length delimited. Does not implicitly {@link Pmd.Chat.verify|verify} messages.
         * @param message Chat message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IChat, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a Chat message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Chat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.Chat;

        /**
         * Decodes a Chat message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Chat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.Chat;

        /**
         * Verifies a Chat message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Chat message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Chat
         */
        public static fromObject(object: { [k: string]: any }): Pmd.Chat;

        /**
         * Creates a plain object from a Chat message. Also converts values to other types if specified.
         * @param message Chat
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.Chat, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Chat to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace Chat {

        /** Param enum. */
        enum Param {
            CommonChatUserPmd_CS = 1,
            GMCommandChatUserPmd_C = 2,
            GMCommandListChatUserPmd_S = 4,
            PrivateChatUserPmd_CS = 5,
            CurrentGmLevelChatUserPmd_S = 6,
            stAddHideButtonBookChatUserPmd_S = 7,
            stAddHideButtonChatUserPmd_S = 8,
            stAddHideButtonNewFunctionChatUserPmd_S = 9,
            stAddHideButtonServerHotKeyChatUserPmd_S = 10,
            stCommonChatUserPmd_CS = 11,
            stMessageBoxChatUserPmd_S = 12
        }
    }

    /** ChatType enum. */
    enum ChatType {
        ChatType_Map = 2
    }

    /** Properties of a CommonChatUserPmd_CS. */
    interface ICommonChatUserPmd_CS {

        /** CommonChatUserPmd_CS id */
        id?: (number|Long|null);

        /** CommonChatUserPmd_CS name */
        name?: (string|null);

        /** CommonChatUserPmd_CS sexman */
        sexman?: (boolean|null);

        /** CommonChatUserPmd_CS chatpos */
        chatpos?: (number|null);

        /** CommonChatUserPmd_CS chattype */
        chattype?: (number|null);

        /** CommonChatUserPmd_CS info */
        info: string;

        /** CommonChatUserPmd_CS time */
        time?: (number|Long|null);
    }

    /** Represents a CommonChatUserPmd_CS. */
    class CommonChatUserPmd_CS implements ICommonChatUserPmd_CS {

        /**
         * Constructs a new CommonChatUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.ICommonChatUserPmd_CS);

        /** CommonChatUserPmd_CS id. */
        public id: (number|Long);

        /** CommonChatUserPmd_CS name. */
        public name: string;

        /** CommonChatUserPmd_CS sexman. */
        public sexman: boolean;

        /** CommonChatUserPmd_CS chatpos. */
        public chatpos: number;

        /** CommonChatUserPmd_CS chattype. */
        public chattype: number;

        /** CommonChatUserPmd_CS info. */
        public info: string;

        /** CommonChatUserPmd_CS time. */
        public time: (number|Long);

        /**
         * Creates a new CommonChatUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CommonChatUserPmd_CS instance
         */
        public static create(properties?: Pmd.ICommonChatUserPmd_CS): Pmd.CommonChatUserPmd_CS;

        /**
         * Encodes the specified CommonChatUserPmd_CS message. Does not implicitly {@link Pmd.CommonChatUserPmd_CS.verify|verify} messages.
         * @param message CommonChatUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.ICommonChatUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified CommonChatUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.CommonChatUserPmd_CS.verify|verify} messages.
         * @param message CommonChatUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.ICommonChatUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a CommonChatUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CommonChatUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.CommonChatUserPmd_CS;

        /**
         * Decodes a CommonChatUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CommonChatUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.CommonChatUserPmd_CS;

        /**
         * Verifies a CommonChatUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CommonChatUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CommonChatUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.CommonChatUserPmd_CS;

        /**
         * Creates a plain object from a CommonChatUserPmd_CS message. Also converts values to other types if specified.
         * @param message CommonChatUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.CommonChatUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CommonChatUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    namespace CommonChatUserPmd_CS {

        /** ChatType enum. */
        enum ChatType {
            ChatType_None = 0,
            ChatType_Lobby = 1,
            ChatType_Room = 2,
            ChatType_Robot = 4
        }

        /** ChatPos enum. */
        enum ChatPos {
            ChatPos_None = 0,
            ChatPos_Normal = 1,
            ChatPos_Sys = 2,
            ChatPos_Tips = 4,
            ChatPos_Pop = 8,
            ChatPos_Private = 16,
            ChatPos_Important = 32,
            ChatPos_Honor = 64,
            ChatPos_Gm = 128
        }
    }

    /** Properties of a GMCommandChatUserPmd_C. */
    interface IGMCommandChatUserPmd_C {

        /** GMCommandChatUserPmd_C charid */
        charid?: (number|Long|null);

        /** GMCommandChatUserPmd_C charname */
        charname?: (string|null);

        /** GMCommandChatUserPmd_C method */
        method: string;

        /** GMCommandChatUserPmd_C params */
        params?: (string|null);
    }

    /** Represents a GMCommandChatUserPmd_C. */
    class GMCommandChatUserPmd_C implements IGMCommandChatUserPmd_C {

        /**
         * Constructs a new GMCommandChatUserPmd_C.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IGMCommandChatUserPmd_C);

        /** GMCommandChatUserPmd_C charid. */
        public charid: (number|Long);

        /** GMCommandChatUserPmd_C charname. */
        public charname: string;

        /** GMCommandChatUserPmd_C method. */
        public method: string;

        /** GMCommandChatUserPmd_C params. */
        public params: string;

        /**
         * Creates a new GMCommandChatUserPmd_C instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GMCommandChatUserPmd_C instance
         */
        public static create(properties?: Pmd.IGMCommandChatUserPmd_C): Pmd.GMCommandChatUserPmd_C;

        /**
         * Encodes the specified GMCommandChatUserPmd_C message. Does not implicitly {@link Pmd.GMCommandChatUserPmd_C.verify|verify} messages.
         * @param message GMCommandChatUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IGMCommandChatUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified GMCommandChatUserPmd_C message, length delimited. Does not implicitly {@link Pmd.GMCommandChatUserPmd_C.verify|verify} messages.
         * @param message GMCommandChatUserPmd_C message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IGMCommandChatUserPmd_C, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a GMCommandChatUserPmd_C message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GMCommandChatUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.GMCommandChatUserPmd_C;

        /**
         * Decodes a GMCommandChatUserPmd_C message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GMCommandChatUserPmd_C
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.GMCommandChatUserPmd_C;

        /**
         * Verifies a GMCommandChatUserPmd_C message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GMCommandChatUserPmd_C message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GMCommandChatUserPmd_C
         */
        public static fromObject(object: { [k: string]: any }): Pmd.GMCommandChatUserPmd_C;

        /**
         * Creates a plain object from a GMCommandChatUserPmd_C message. Also converts values to other types if specified.
         * @param message GMCommandChatUserPmd_C
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.GMCommandChatUserPmd_C, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GMCommandChatUserPmd_C to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GMHelpInfo. */
    interface IGMHelpInfo {

        /** GMHelpInfo method */
        method: string;

        /** GMHelpInfo example */
        example: string;
    }

    /** Represents a GMHelpInfo. */
    class GMHelpInfo implements IGMHelpInfo {

        /**
         * Constructs a new GMHelpInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IGMHelpInfo);

        /** GMHelpInfo method. */
        public method: string;

        /** GMHelpInfo example. */
        public example: string;

        /**
         * Creates a new GMHelpInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GMHelpInfo instance
         */
        public static create(properties?: Pmd.IGMHelpInfo): Pmd.GMHelpInfo;

        /**
         * Encodes the specified GMHelpInfo message. Does not implicitly {@link Pmd.GMHelpInfo.verify|verify} messages.
         * @param message GMHelpInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IGMHelpInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified GMHelpInfo message, length delimited. Does not implicitly {@link Pmd.GMHelpInfo.verify|verify} messages.
         * @param message GMHelpInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IGMHelpInfo, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a GMHelpInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GMHelpInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.GMHelpInfo;

        /**
         * Decodes a GMHelpInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GMHelpInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.GMHelpInfo;

        /**
         * Verifies a GMHelpInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GMHelpInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GMHelpInfo
         */
        public static fromObject(object: { [k: string]: any }): Pmd.GMHelpInfo;

        /**
         * Creates a plain object from a GMHelpInfo message. Also converts values to other types if specified.
         * @param message GMHelpInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.GMHelpInfo, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GMHelpInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a GMCommandListChatUserPmd_S. */
    interface IGMCommandListChatUserPmd_S {

        /** GMCommandListChatUserPmd_S list */
        list?: (Pmd.IGMHelpInfo[]|null);
    }

    /** Represents a GMCommandListChatUserPmd_S. */
    class GMCommandListChatUserPmd_S implements IGMCommandListChatUserPmd_S {

        /**
         * Constructs a new GMCommandListChatUserPmd_S.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IGMCommandListChatUserPmd_S);

        /** GMCommandListChatUserPmd_S list. */
        public list: Pmd.IGMHelpInfo[];

        /**
         * Creates a new GMCommandListChatUserPmd_S instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GMCommandListChatUserPmd_S instance
         */
        public static create(properties?: Pmd.IGMCommandListChatUserPmd_S): Pmd.GMCommandListChatUserPmd_S;

        /**
         * Encodes the specified GMCommandListChatUserPmd_S message. Does not implicitly {@link Pmd.GMCommandListChatUserPmd_S.verify|verify} messages.
         * @param message GMCommandListChatUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IGMCommandListChatUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified GMCommandListChatUserPmd_S message, length delimited. Does not implicitly {@link Pmd.GMCommandListChatUserPmd_S.verify|verify} messages.
         * @param message GMCommandListChatUserPmd_S message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IGMCommandListChatUserPmd_S, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a GMCommandListChatUserPmd_S message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GMCommandListChatUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.GMCommandListChatUserPmd_S;

        /**
         * Decodes a GMCommandListChatUserPmd_S message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GMCommandListChatUserPmd_S
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.GMCommandListChatUserPmd_S;

        /**
         * Verifies a GMCommandListChatUserPmd_S message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GMCommandListChatUserPmd_S message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GMCommandListChatUserPmd_S
         */
        public static fromObject(object: { [k: string]: any }): Pmd.GMCommandListChatUserPmd_S;

        /**
         * Creates a plain object from a GMCommandListChatUserPmd_S message. Also converts values to other types if specified.
         * @param message GMCommandListChatUserPmd_S
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.GMCommandListChatUserPmd_S, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GMCommandListChatUserPmd_S to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PrivateChatUserPmd_CS. */
    interface IPrivateChatUserPmd_CS {

        /** PrivateChatUserPmd_CS id */
        id?: (number|Long|null);

        /** PrivateChatUserPmd_CS name */
        name?: (string|null);

        /** PrivateChatUserPmd_CS sexman */
        sexman?: (boolean|null);

        /** PrivateChatUserPmd_CS info */
        info: string;

        /** PrivateChatUserPmd_CS time */
        time?: (number|Long|null);
    }

    /** Represents a PrivateChatUserPmd_CS. */
    class PrivateChatUserPmd_CS implements IPrivateChatUserPmd_CS {

        /**
         * Constructs a new PrivateChatUserPmd_CS.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IPrivateChatUserPmd_CS);

        /** PrivateChatUserPmd_CS id. */
        public id: (number|Long);

        /** PrivateChatUserPmd_CS name. */
        public name: string;

        /** PrivateChatUserPmd_CS sexman. */
        public sexman: boolean;

        /** PrivateChatUserPmd_CS info. */
        public info: string;

        /** PrivateChatUserPmd_CS time. */
        public time: (number|Long);

        /**
         * Creates a new PrivateChatUserPmd_CS instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PrivateChatUserPmd_CS instance
         */
        public static create(properties?: Pmd.IPrivateChatUserPmd_CS): Pmd.PrivateChatUserPmd_CS;

        /**
         * Encodes the specified PrivateChatUserPmd_CS message. Does not implicitly {@link Pmd.PrivateChatUserPmd_CS.verify|verify} messages.
         * @param message PrivateChatUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IPrivateChatUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified PrivateChatUserPmd_CS message, length delimited. Does not implicitly {@link Pmd.PrivateChatUserPmd_CS.verify|verify} messages.
         * @param message PrivateChatUserPmd_CS message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IPrivateChatUserPmd_CS, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a PrivateChatUserPmd_CS message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PrivateChatUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.PrivateChatUserPmd_CS;

        /**
         * Decodes a PrivateChatUserPmd_CS message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PrivateChatUserPmd_CS
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.PrivateChatUserPmd_CS;

        /**
         * Verifies a PrivateChatUserPmd_CS message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PrivateChatUserPmd_CS message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PrivateChatUserPmd_CS
         */
        public static fromObject(object: { [k: string]: any }): Pmd.PrivateChatUserPmd_CS;

        /**
         * Creates a plain object from a PrivateChatUserPmd_CS message. Also converts values to other types if specified.
         * @param message PrivateChatUserPmd_CS
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.PrivateChatUserPmd_CS, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PrivateChatUserPmd_CS to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a HttpPackage. */
    interface IHttpPackage {

        /** HttpPackage do */
        "do": string;

        /** HttpPackage data */
        data: google.protobuf.IAny;

        /** HttpPackage gameid */
        gameid: number;

        /** HttpPackage zoneid */
        zoneid: number;

        /** HttpPackage uid */
        uid?: (string|null);

        /** HttpPackage sid */
        sid?: (string|null);

        /** HttpPackage unigame_plat_login */
        unigame_plat_login?: (string|null);

        /** HttpPackage unigame_plat_timestamp */
        unigame_plat_timestamp: (number|Long);
    }

    /** Represents a HttpPackage. */
    class HttpPackage implements IHttpPackage {

        /**
         * Constructs a new HttpPackage.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IHttpPackage);

        /** HttpPackage do. */
        public do: string;

        /** HttpPackage data. */
        public data: google.protobuf.IAny;

        /** HttpPackage gameid. */
        public gameid: number;

        /** HttpPackage zoneid. */
        public zoneid: number;

        /** HttpPackage uid. */
        public uid: string;

        /** HttpPackage sid. */
        public sid: string;

        /** HttpPackage unigame_plat_login. */
        public unigame_plat_login: string;

        /** HttpPackage unigame_plat_timestamp. */
        public unigame_plat_timestamp: (number|Long);

        /**
         * Creates a new HttpPackage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HttpPackage instance
         */
        public static create(properties?: Pmd.IHttpPackage): Pmd.HttpPackage;

        /**
         * Encodes the specified HttpPackage message. Does not implicitly {@link Pmd.HttpPackage.verify|verify} messages.
         * @param message HttpPackage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IHttpPackage, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified HttpPackage message, length delimited. Does not implicitly {@link Pmd.HttpPackage.verify|verify} messages.
         * @param message HttpPackage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IHttpPackage, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a HttpPackage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HttpPackage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.HttpPackage;

        /**
         * Decodes a HttpPackage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HttpPackage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.HttpPackage;

        /**
         * Verifies a HttpPackage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HttpPackage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HttpPackage
         */
        public static fromObject(object: { [k: string]: any }): Pmd.HttpPackage;

        /**
         * Creates a plain object from a HttpPackage message. Also converts values to other types if specified.
         * @param message HttpPackage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.HttpPackage, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HttpPackage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a HttpPackageReturn. */
    interface IHttpPackageReturn {

        /** HttpPackageReturn do */
        "do": string;

        /** HttpPackageReturn data */
        data: google.protobuf.IAny;

        /** HttpPackageReturn gameid */
        gameid: number;

        /** HttpPackageReturn zoneid */
        zoneid?: (number|null);

        /** HttpPackageReturn err_no */
        err_no?: (Pmd.HttpReturnCode|null);
    }

    /** Represents a HttpPackageReturn. */
    class HttpPackageReturn implements IHttpPackageReturn {

        /**
         * Constructs a new HttpPackageReturn.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IHttpPackageReturn);

        /** HttpPackageReturn do. */
        public do: string;

        /** HttpPackageReturn data. */
        public data: google.protobuf.IAny;

        /** HttpPackageReturn gameid. */
        public gameid: number;

        /** HttpPackageReturn zoneid. */
        public zoneid: number;

        /** HttpPackageReturn err_no. */
        public err_no: Pmd.HttpReturnCode;

        /**
         * Creates a new HttpPackageReturn instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HttpPackageReturn instance
         */
        public static create(properties?: Pmd.IHttpPackageReturn): Pmd.HttpPackageReturn;

        /**
         * Encodes the specified HttpPackageReturn message. Does not implicitly {@link Pmd.HttpPackageReturn.verify|verify} messages.
         * @param message HttpPackageReturn message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IHttpPackageReturn, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified HttpPackageReturn message, length delimited. Does not implicitly {@link Pmd.HttpPackageReturn.verify|verify} messages.
         * @param message HttpPackageReturn message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IHttpPackageReturn, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a HttpPackageReturn message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HttpPackageReturn
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.HttpPackageReturn;

        /**
         * Decodes a HttpPackageReturn message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HttpPackageReturn
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.HttpPackageReturn;

        /**
         * Verifies a HttpPackageReturn message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HttpPackageReturn message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HttpPackageReturn
         */
        public static fromObject(object: { [k: string]: any }): Pmd.HttpPackageReturn;

        /**
         * Creates a plain object from a HttpPackageReturn message. Also converts values to other types if specified.
         * @param message HttpPackageReturn
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.HttpPackageReturn, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HttpPackageReturn to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestZoneList. */
    interface IRequestZoneList {

        /** RequestZoneList gamename */
        gamename?: (string|null);

        /** RequestZoneList gameid */
        gameid: number;

        /** RequestZoneList zonelist */
        zonelist?: (Pmd.IZoneInfo[]|null);
    }

    /** Represents a RequestZoneList. */
    class RequestZoneList implements IRequestZoneList {

        /**
         * Constructs a new RequestZoneList.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestZoneList);

        /** RequestZoneList gamename. */
        public gamename: string;

        /** RequestZoneList gameid. */
        public gameid: number;

        /** RequestZoneList zonelist. */
        public zonelist: Pmd.IZoneInfo[];

        /**
         * Creates a new RequestZoneList instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestZoneList instance
         */
        public static create(properties?: Pmd.IRequestZoneList): Pmd.RequestZoneList;

        /**
         * Encodes the specified RequestZoneList message. Does not implicitly {@link Pmd.RequestZoneList.verify|verify} messages.
         * @param message RequestZoneList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestZoneList, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestZoneList message, length delimited. Does not implicitly {@link Pmd.RequestZoneList.verify|verify} messages.
         * @param message RequestZoneList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestZoneList, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestZoneList message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestZoneList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestZoneList;

        /**
         * Decodes a RequestZoneList message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestZoneList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestZoneList;

        /**
         * Verifies a RequestZoneList message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestZoneList message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestZoneList
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestZoneList;

        /**
         * Creates a plain object from a RequestZoneList message. Also converts values to other types if specified.
         * @param message RequestZoneList
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestZoneList, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestZoneList to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestSelectZone. */
    interface IRequestSelectZone {
    }

    /** Represents a RequestSelectZone. */
    class RequestSelectZone implements IRequestSelectZone {

        /**
         * Constructs a new RequestSelectZone.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestSelectZone);

        /**
         * Creates a new RequestSelectZone instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestSelectZone instance
         */
        public static create(properties?: Pmd.IRequestSelectZone): Pmd.RequestSelectZone;

        /**
         * Encodes the specified RequestSelectZone message. Does not implicitly {@link Pmd.RequestSelectZone.verify|verify} messages.
         * @param message RequestSelectZone message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestSelectZone, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestSelectZone message, length delimited. Does not implicitly {@link Pmd.RequestSelectZone.verify|verify} messages.
         * @param message RequestSelectZone message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestSelectZone, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestSelectZone message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestSelectZone
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestSelectZone;

        /**
         * Decodes a RequestSelectZone message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestSelectZone
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestSelectZone;

        /**
         * Verifies a RequestSelectZone message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestSelectZone message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestSelectZone
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestSelectZone;

        /**
         * Creates a plain object from a RequestSelectZone message. Also converts values to other types if specified.
         * @param message RequestSelectZone
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestSelectZone, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestSelectZone to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a RequestSelectZoneReturn. */
    interface IRequestSelectZoneReturn {

        /** RequestSelectZoneReturn gatewayurl */
        gatewayurl: string;

        /** RequestSelectZoneReturn separatezoneuid */
        separatezoneuid?: (boolean|null);

        /** RequestSelectZoneReturn uid */
        uid?: (number|Long|null);
    }

    /** Represents a RequestSelectZoneReturn. */
    class RequestSelectZoneReturn implements IRequestSelectZoneReturn {

        /**
         * Constructs a new RequestSelectZoneReturn.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IRequestSelectZoneReturn);

        /** RequestSelectZoneReturn gatewayurl. */
        public gatewayurl: string;

        /** RequestSelectZoneReturn separatezoneuid. */
        public separatezoneuid: boolean;

        /** RequestSelectZoneReturn uid. */
        public uid: (number|Long);

        /**
         * Creates a new RequestSelectZoneReturn instance using the specified properties.
         * @param [properties] Properties to set
         * @returns RequestSelectZoneReturn instance
         */
        public static create(properties?: Pmd.IRequestSelectZoneReturn): Pmd.RequestSelectZoneReturn;

        /**
         * Encodes the specified RequestSelectZoneReturn message. Does not implicitly {@link Pmd.RequestSelectZoneReturn.verify|verify} messages.
         * @param message RequestSelectZoneReturn message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IRequestSelectZoneReturn, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified RequestSelectZoneReturn message, length delimited. Does not implicitly {@link Pmd.RequestSelectZoneReturn.verify|verify} messages.
         * @param message RequestSelectZoneReturn message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IRequestSelectZoneReturn, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a RequestSelectZoneReturn message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns RequestSelectZoneReturn
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.RequestSelectZoneReturn;

        /**
         * Decodes a RequestSelectZoneReturn message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns RequestSelectZoneReturn
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.RequestSelectZoneReturn;

        /**
         * Verifies a RequestSelectZoneReturn message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a RequestSelectZoneReturn message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns RequestSelectZoneReturn
         */
        public static fromObject(object: { [k: string]: any }): Pmd.RequestSelectZoneReturn;

        /**
         * Creates a plain object from a RequestSelectZoneReturn message. Also converts values to other types if specified.
         * @param message RequestSelectZoneReturn
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.RequestSelectZoneReturn, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this RequestSelectZoneReturn to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlatTokenLogin. */
    interface IPlatTokenLogin {

        /** PlatTokenLogin platinfo */
        platinfo: Pmd.IPlatInfo;
    }

    /** Represents a PlatTokenLogin. */
    class PlatTokenLogin implements IPlatTokenLogin {

        /**
         * Constructs a new PlatTokenLogin.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IPlatTokenLogin);

        /** PlatTokenLogin platinfo. */
        public platinfo: Pmd.IPlatInfo;

        /**
         * Creates a new PlatTokenLogin instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlatTokenLogin instance
         */
        public static create(properties?: Pmd.IPlatTokenLogin): Pmd.PlatTokenLogin;

        /**
         * Encodes the specified PlatTokenLogin message. Does not implicitly {@link Pmd.PlatTokenLogin.verify|verify} messages.
         * @param message PlatTokenLogin message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IPlatTokenLogin, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified PlatTokenLogin message, length delimited. Does not implicitly {@link Pmd.PlatTokenLogin.verify|verify} messages.
         * @param message PlatTokenLogin message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IPlatTokenLogin, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a PlatTokenLogin message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlatTokenLogin
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.PlatTokenLogin;

        /**
         * Decodes a PlatTokenLogin message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlatTokenLogin
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.PlatTokenLogin;

        /**
         * Verifies a PlatTokenLogin message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlatTokenLogin message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlatTokenLogin
         */
        public static fromObject(object: { [k: string]: any }): Pmd.PlatTokenLogin;

        /**
         * Creates a plain object from a PlatTokenLogin message. Also converts values to other types if specified.
         * @param message PlatTokenLogin
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.PlatTokenLogin, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlatTokenLogin to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a PlatTokenLoginReturn. */
    interface IPlatTokenLoginReturn {

        /** PlatTokenLoginReturn platinfo */
        platinfo?: (Pmd.IPlatInfo|null);

        /** PlatTokenLoginReturn uid */
        uid: string;

        /** PlatTokenLoginReturn sid */
        sid: string;

        /** PlatTokenLoginReturn unigame_plat_key */
        unigame_plat_key: string;

        /** PlatTokenLoginReturn unigame_plat_login */
        unigame_plat_login: string;

        /** PlatTokenLoginReturn unigame_plat_login_life */
        unigame_plat_login_life: number;

        /** PlatTokenLoginReturn timezone_name */
        timezone_name?: (string|null);

        /** PlatTokenLoginReturn timezone_offset */
        timezone_offset: number;
    }

    /** Represents a PlatTokenLoginReturn. */
    class PlatTokenLoginReturn implements IPlatTokenLoginReturn {

        /**
         * Constructs a new PlatTokenLoginReturn.
         * @param [properties] Properties to set
         */
        constructor(properties?: Pmd.IPlatTokenLoginReturn);

        /** PlatTokenLoginReturn platinfo. */
        public platinfo?: (Pmd.IPlatInfo|null);

        /** PlatTokenLoginReturn uid. */
        public uid: string;

        /** PlatTokenLoginReturn sid. */
        public sid: string;

        /** PlatTokenLoginReturn unigame_plat_key. */
        public unigame_plat_key: string;

        /** PlatTokenLoginReturn unigame_plat_login. */
        public unigame_plat_login: string;

        /** PlatTokenLoginReturn unigame_plat_login_life. */
        public unigame_plat_login_life: number;

        /** PlatTokenLoginReturn timezone_name. */
        public timezone_name: string;

        /** PlatTokenLoginReturn timezone_offset. */
        public timezone_offset: number;

        /**
         * Creates a new PlatTokenLoginReturn instance using the specified properties.
         * @param [properties] Properties to set
         * @returns PlatTokenLoginReturn instance
         */
        public static create(properties?: Pmd.IPlatTokenLoginReturn): Pmd.PlatTokenLoginReturn;

        /**
         * Encodes the specified PlatTokenLoginReturn message. Does not implicitly {@link Pmd.PlatTokenLoginReturn.verify|verify} messages.
         * @param message PlatTokenLoginReturn message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: Pmd.IPlatTokenLoginReturn, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Encodes the specified PlatTokenLoginReturn message, length delimited. Does not implicitly {@link Pmd.PlatTokenLoginReturn.verify|verify} messages.
         * @param message PlatTokenLoginReturn message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: Pmd.IPlatTokenLoginReturn, writer?: protobuf.Writer): protobuf.Writer;

        /**
         * Decodes a PlatTokenLoginReturn message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns PlatTokenLoginReturn
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: (protobuf.Reader|Uint8Array), length?: number): Pmd.PlatTokenLoginReturn;

        /**
         * Decodes a PlatTokenLoginReturn message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns PlatTokenLoginReturn
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: (protobuf.Reader|Uint8Array)): Pmd.PlatTokenLoginReturn;

        /**
         * Verifies a PlatTokenLoginReturn message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a PlatTokenLoginReturn message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns PlatTokenLoginReturn
         */
        public static fromObject(object: { [k: string]: any }): Pmd.PlatTokenLoginReturn;

        /**
         * Creates a plain object from a PlatTokenLoginReturn message. Also converts values to other types if specified.
         * @param message PlatTokenLoginReturn
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: Pmd.PlatTokenLoginReturn, options?: protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this PlatTokenLoginReturn to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}

/** Namespace google. */
declare namespace google {

    /** Namespace protobuf. */
    namespace protobuf {

        /** Properties of an Any. */
        interface IAny {

            /** Any type_url */
            type_url?: (string|null);

            /** Any value */
            value?: (Uint8Array|null);
        }

        /** Represents an Any. */
        class Any implements IAny {

            /**
             * Constructs a new Any.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IAny);

            /** Any type_url. */
            public type_url: string;

            /** Any value. */
            public value: Uint8Array;

            /**
             * Creates a new Any instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Any instance
             */
            public static create(properties?: google.protobuf.IAny): google.protobuf.Any;

            /**
             * Encodes the specified Any message. Does not implicitly {@link google.protobuf.Any.verify|verify} messages.
             * @param message Any message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IAny, writer?: any): any;

            /**
             * Encodes the specified Any message, length delimited. Does not implicitly {@link google.protobuf.Any.verify|verify} messages.
             * @param message Any message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IAny, writer?: any): any;

            /**
             * Decodes an Any message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Any
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: (any|Uint8Array), length?: number): google.protobuf.Any;

            /**
             * Decodes an Any message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Any
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: (any|Uint8Array)): google.protobuf.Any;

            /**
             * Verifies an Any message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an Any message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Any
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.Any;

            /**
             * Creates a plain object from an Any message. Also converts values to other types if specified.
             * @param message Any
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.Any, options?:any): { [k: string]: any };

            /**
             * Converts this Any to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }
}

declare module Pmd {
    enum ChatType {
        ChatType_Map = 2,
    }
    class Chat {
        GetType(): string;
    }
    module Chat {
        enum Param {
            CommonChatUserPmd_CS = 1,
            GMCommandChatUserPmd_C = 2,
            GMCommandListChatUserPmd_S = 4,
            PrivateChatUserPmd_CS = 5,
            CurrentGmLevelChatUserPmd_S = 6,
            stAddHideButtonBookChatUserPmd_S = 7,
            stAddHideButtonChatUserPmd_S = 8,
            stAddHideButtonNewFunctionChatUserPmd_S = 9,
            stAddHideButtonServerHotKeyChatUserPmd_S = 10,
            stCommonChatUserPmd_CS = 11,
            stMessageBoxChatUserPmd_S = 12,
        }
    }
    class CommonChatUserPmd_CS {
        id: number;
        name: string;
        sexman: boolean;
        chatpos: number;
        chattype: number;
        info: string;
        /**
         * 增加时间戳
         */
        time: number;
        GetType(): string;
    }
    module CommonChatUserPmd_CS {
        enum ChatType {
            /**
             * 世界聊天
             */
            ChatType_None = 0,
            /**
             * 大厅聊天
             */
            ChatType_Lobby = 1,
            /**
             * 房间聊天
             */
            ChatType_Room = 2,
            /**
             * 机器人聊天
             */
            ChatType_Robot = 4,
        }
    }
    module CommonChatUserPmd_CS {
        enum ChatPos {
            /**
             * 普通聊天输出
             */
            ChatPos_None = 0,
            /**
             * 普通聊天输出
             */
            ChatPos_Normal = 1,
            /**
             * 系统提示输出
             */
            ChatPos_Sys = 2,
            /**
             * 冒泡提示
             */
            ChatPos_Tips = 4,
            /**
             * 右下角弹出
             */
            ChatPos_Pop = 8,
            /**
             * 私聊输出
             */
            ChatPos_Private = 16,
            /**
             * 重要信息，屏幕中央输出(电视)
             */
            ChatPos_Important = 32,
            /**
             * 荣耀信息
             */
            ChatPos_Honor = 64,
            /**
             * GM系统公告输出位置
             */
            ChatPos_Gm = 128,
            /**
             * VIP
             */
            ChatPos_GmVip = 144,
            /**
             * 固定显
             */
            ChatPos_ImportantDown = 160,
        }
    }
    class GMCommandChatUserPmd_C {
        charid: number;
        charname: string;
        method: string;
        params: string;
        GetType(): string;
    }
    class GMHelpInfo {
        method: string;
        example: string;
        GetType(): string;
    }
    class GMCommandListChatUserPmd_S {
        /**
         * [packed=true]
         */
        list: GMHelpInfo[];
        GetType(): string;
    }
    class PrivateChatUserPmd_CS {
        id: number;
        name: string;
        sexman: boolean;
        info: string;
        /**
         * 增加时间戳
         */
        time: number;
        GetType(): string;
    }
    /**
     * 玩家当前gm权限
     */
    class CurrentGmLevelChatUserPmd_S {
        /**
         * 权限等级,0表示无权限
         */
        gmlevel: number;
        GetType(): string;
    }
    /**
     * 服务器端发送右边提示
     */
    class stAddHideButtonBookChatUserPmd_S {
        /**
         * 生存时间，以秒为单位
         */
        lifetime: number;
        /**
         * 窗口id
         */
        bookid: number;
        /**
         * 资源id
         */
        iconid: number;
        /**
         * 是否点开就关闭
         */
        close: number;
        /**
         * 悬浮提示
         */
        tips: string;
        GetType(): string;
    }
    /**
     * 服务器端发送右边提示
     */
    class stAddHideButtonChatUserPmd_S {
        /**
         * 生存时间，以秒为单位
         */
        lifetime: number;
        /**
         * 窗口id
         */
        hotkeyid: number;
        /**
         * 资源id
         */
        iconid: number;
        /**
         * tab页面
         */
        tabid: number;
        /**
         * tab页面
         */
        tabframe: number;
        /**
         * 是否点开就关闭
         */
        close: number;
        /**
         * 悬浮提示
         */
        tips: string;
        GetType(): string;
    }
    /**
     * 服务器端发送右边未使用功能帮助
     */
    class stAddHideButtonNewFunctionChatUserPmd_S {
        /**
         * 生存时间，以秒为单位
         */
        lifetime: number;
        /**
         * 功能id
         */
        functionid: number;
        /**
         * 资源id
         */
        iconid: number;
        /**
         * 是否点开就关闭
         */
        close: number;
        /**
         * 悬浮提示
         */
        tips: string;
        GetType(): string;
    }
    /**
     * 服务器端发送右边ServerHotKey功能
     */
    class stAddHideButtonServerHotKeyChatUserPmd_S {
        /**
         * 生存时间，以秒为单位
         */
        lifetime: number;
        serverhotkeyid: number;
        /**
         * 资源id
         */
        iconid: number;
        /**
         * 是否点开就关闭
         */
        close: number;
        /**
         * 悬浮提示
         */
        tips: string;
        GetType(): string;
    }
    class stCommonChatUserPmd_CS {
        /**
         * CHATTYPE
         */
        byChatType: number;
        byChatColor: number;
        byItemNum: number;
        byChatPos: number;
        reserved: number;
        country: number;
        function: number;
        dwOPDes: number;
        levelOrder: number;
        vipflag: number;
        wdOldZoneID: number;
        byBitmask: number;
        byUserCmd: number;
        byUserParam: number;
        szInfo: string;
        /**
         * 职业enumProfession
         */
        profession: number;
        /**
         * 性别enmCharSex
         */
        sex: number;
        /**
         * 时间(unix时间戳)
         */
        timestamp: number;
        /**
         * 名字
         */
        name: string;
        GetType(): string;
    }
    /**
     * 系统对话框，支持打开指定窗口
     */
    class stMessageBoxChatUserPmd_S {
        buttons: string;
        /**
         * 聊天信息
         */
        szInfo: string;
        data0: number;
        data1: number;
        data2: number;
        GetType(): string;
    }
}

declare module Pmd {
    class Forward {
        GetType(): string;
    }
    module Forward {
        enum Param {
            UserJsMessageForwardUserPmd_CS = 1,
            BroadcastJsMessageForwardUserPmd_CS = 2,
            /**
             * LoginLobbyRes							= 3;
             */
            WebSocketForwardUserPmd_C = 4,
            WebSocketForwardUserPmd_S = 5,
            BehaviorMessageForwardUserPmd_CS = 6,
            PushMessageForwardUserPmd_S = 7,
        }
    }
    /**
     * 长连接时玩家跟区服务器的通信是通过网关转发的,统一用这个消息互相传递
     */
    class UserJsMessageForwardUserPmd_CS {
        /**
         * json消息内容
         */
        msg: string;
        /**
         * json消息用bytes
         */
        msgbytes: any;
        /**
         * 按字符串格式序列化的proto协议
         */
        proto: string;
        GetType(): string;
    }
    /**
     * 长连接时玩家跟区服务器的通信是通过网关转发的,统一用这个消息互相传递
     */
    class BroadcastJsMessageForwardUserPmd_CS {
        /**
         * json消息内容
         */
        msg: string;
        /**
         * json消息用bytes
         */
        msgbytes: any;
        /**
         * 按字符串格式序列化的proto协议
         */
        proto: string;
        userlist: number[];
        GetType(): string;
    }
    /**
     * HTTP请求切换到websocket链接
     */
    class WebSocketForwardUserPmd_C {
        /**
         * accountid和平台返回给客户端的uid:string是完全不同的两个概念。如果没有在别处提供accountid，此处可临时将uid强转为uint64使用
         */
        accountid: number;
        GetType(): string;
    }
    class WebSocketForwardUserPmd_S {
        accountid: number;
        jsongatewayurl: string;
        tokenid: number;
        logintempid: number;
        gatewayurl: string;
        gatewayurltcp: string;
        GetType(): string;
    }
    /**
     * 长连接时玩家跟区服务器的通信是通过网关转发的,统一用这个消息互相传递
     */
    class BehaviorMessageForwardUserPmd_CS {
        /**
         * 文本格式
         */
        msg: string[];
        /**
         * 消息类型
         */
        type: BehaviorMessageForwardUserPmd_CS.Type;
        GetType(): string;
    }
    module BehaviorMessageForwardUserPmd_CS {
        enum Type {
            /**
             * 普通编辑器消息
             */
            NormalText = 1,
            /**
             * 上传行为树
             */
            UploadTree = 2,
        }
    }
    class PushMessageForwardUserPmd_S {
        type: number;
        title: string;
        desc: string;
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 服务器版本号
         */
        version: number;
        GetType(): string;
    }
}

/// <reference path="pmd.d.ts" />
declare module Pmd {
    enum VerifyReturnReason {
        /**
         * 登录成功
         */
        LoginOk = 0,
        /**
         * 服务器没有token
         */
        TokenFindError = 1,
        /**
         * token错误
         */
        TokenDiffError = 2,
        /**
         * 版本验证
         */
        VersionError = 3,
    }
    /**
     * 区服务器状态
     */
    enum ZoneState {
        /**
         * 关闭状态ZoneState_Shutdown
         */
        Shutdown = 0,
        /**
         * 正常运行ZoneState_Normal
         */
        Normal = 1,
        /**
         * 爆满ZoneState_Fullly
         */
        Fullly = 2,
        /**
         * 正在启动ZoneState_Starting
         */
        Starting = 3,
    }
    enum ZoneInfoBitMask {
        ZoneInfoBitMask_None = 0,
        /**
         * 正常运营
         */
        ZoneInfoBitMask_Normal = 1,
        /**
         * 支持沙箱模式
         */
        ZoneInfoBitMask_SandBox = 2,
        /**
         * 暂未开放
         */
        ZoneInfoBitMask_NoOpen = 4,
    }
    enum LoginReturnFailReason {
        /**
         * 密码错误
         */
        Password = 1,
        /**
         * 区服务器已关闭
         */
        ServerShutdown = 2,
        /**
         * 客户端游戏版本号太低
         */
        VersionTooLow = 3,
        /**
         * 没有找到登录token,需要重新平台验证
         */
        UserTokenFind = 4,
        /**
         * token错误
         */
        UserTokenTempId = 5,
        /**
         * token已过期
         */
        UserTokenTimeOut = 6,
        /**
         * 重复登录
         */
        LoginDulicate = 7,
        /**
         * 没有可用网关
         */
        NoGatewaytDown = 8,
        /**
         * 账号正在使用中
         */
        AccountUsing = 9,
        /**
         * 网关人数满
         */
        GatewayUserMax = 10,
        /**
         * 外挂惩罚
         */
        WaiGuaPunish = 11,
        /**
         * 未到开服时间
         */
        ServerStartTime = 12,
    }
    /**
     * 平台枚举
     */
    enum PlatType {
        /**
         * 本平台
         */
        PlatType_Normal = 0,
        /**
         * UC平台
         */
        PlatType_UC = 4,
        /**
         * 手上活
         */
        PlatType_LeZhuan = 67,
        /**
         * 微信
         */
        PlatType_WeChat = 68,
        /**
         * play68
         */
        PlatType_Play68 = 69,
        /**
         * 爱贝云
         */
        PlatType_AiBei = 70,
        /**
         * Facebook
         */
        PlatType_Facebook = 71,
        /**
         * GooglePlay
         */
        PlatType_GooglePlay = 72,
        /**
         * 性之助（就叫这个名字）
         */
        PlatType_XingZhiZhu = 73,
        /**
         * 火舞
         */
        PlatType_HuoWu = 74,
        /**
         * 彩果
         */
        PlatType_CaiGuo = 77,
        /**
         * 1758
         */
        PlatType_1758 = 79,
        /**
         * 达派手机助手
         */
        PlatType_DAPAI = 80,
        /**
         * 嗨乐app
         */
        PlatType_HILE = 82,
        /**
         * 爱爱游
         */
        PlatType_AAY = 86,
        /**
         * 微游联盟
         */
        PlatType_WEIYOU = 90,
        /**
         * 万游在线
         */
        PlatType_9g = 99,
        /**
         * 手机
         */
        PlatType_MOBILE = 129,
        /**
         * 雪池
         */
        PlatType_XueChi = 133,
        /**
         * 白鹭开放平台
         */
        PlatType_Egret = 134,
        /**
         * 鎏信
         */
        PlatType_AoXin = 140,
        /**
         * 火速,云游平台
         */
        PlatType_HUOSU = 145,
        /**
         * 荣强网络
         */
        PlatType_RONGQIANG = 151,
        /**
         * AAAapp
         */
        PlatType_WXApp = 152,
        /**
         * 荣强app
         */
        PlatType_RongQiangApp = 153,
    }
    /**
     * 玩家在线状态
     */
    enum OnlineState {
        /**
         * 离线
         */
        OnlineState_Offline = 0,
        /**
         * 在线
         */
        OnlineState_Online = 1,
        /**
         * 网络差
         */
        OnlineState_Slow = 2,
        /**
         * 离开,切后台
         */
        OnlineState_Leave = 3,
        /**
         * 电话中
         */
        OnlineState_Calling = 4,
    }
    class Login {
        GetType(): string;
    }
    module Login {
        enum Param {
            AccountTokenVerifyLoginUserPmd_CS = 1,
            AccountTokenVerifyReturnLoginUserPmd_S = 2,
            ZoneInfoListLoginUserPmd_S = 3,
            UserLoginRequestLoginUserPmd_C = 4,
            UserLoginReturnFailLoginUserPmd_S = 5,
            UserLoginReturnOkLoginUserPmd_S = 6,
            UserLoginTokenLoginUserPmd_C = 7,
            ClientLogUrlLoginUserPmd_S = 8,
            MessageBoxLoginUserPmd_S = 9,
            RequestAccountRegisterLoginUserPmd_C = 10,
            ReturnAccountRegisterLoginUserPmd_S = 11,
            UserLogoutTokenLoginUserPmd_C = 12,
            UserLoginReconnectLoginUserPmd_C = 13,
            ReconnectKickoutLoginUserPmd_S = 14,
            ServerKickoutLoginUserPmd_S = 15,
            RequestZoneInfoListLoginUserPmd_C = 16,
            SetServerLangLoginUserPmd_C = 17,
            RequestClientIPLoginUserPmd_C = 18,
            ReturnClientIPLoginUserPmd_S = 19,
            ReconnectErrorLoginUserPmd_S = 20,
            CheckVersionLoginUserPmd_C = 21,
            PushAccountVerifyLoginUserPmd_C = 22,
            BehaviorClientVerifyLoginUserPmd_C = 23,
            RequestUserZoneInfoLoginUserPmd_C = 24,
            RequestUserZoneInfoLoginUserPmd_S = 25,
            MobileRegistRequestRandCodeLoginUserPmd_C = 26,
            MobileRegistReturnRandCodeLoginUserPmd_S = 27,
            MobileRegistRequestCreateAccountLoginUserPmd_C = 28,
            MobileRegistReturnCreateAccountFailLoginUserPmd_S = 29,
            RequestSupoortGameListLoginUserPmd_C = 30,
            ReturnSupoortGameListLoginUserPmd_S = 31,
            UserRequestPlatTokenByPasswordLoginUserPmd_C = 32,
            UserRequestPlatTokenByThirdLoginUserPmd_C = 33,
            UserRequestPlatTokenLoginOkLoginUserPmd_S = 34,
            UserRequestPlatTokenLoginFailLoginUserPmd_S = 35,
            EmailRegistRequestCreateAccountLoginUserPmd_C = 36,
            EmailRegistReturnCreateAccountLoginUserPmd_S = 37,
            UserLoginReconnectOkLoginUserPmd_S = 38,
            GameServerShutDownLoginUserPmd_S = 39,
            /**
             * 本网关实时在线人数,用来排队,目前MMO项目用
             */
            OnlineNumWaitingLoginUserPmd_S = 40,
            /**
             * 玩家在线状态
             */
            OnlineStateLoginUserPmd_CS = 41,
            /**
             * 当前服务器的调试等级,0表示发布状态
             */
            ServerDebugLevelLoginUserPmd_S = 42,
            /**
             * 工具停机
             */
            ServerShutDownLoginUserPmd_S = 43,
            /**
             * 获取某个区的状态信息
             */
            RequestZoneStateLoginUserPmd_CS = 44,
            /**
             * 客户端配置
             */
            ClientConfigUpdateLoginUserPmd_S = 45,
            /**
             * 邮箱注册获取验证码
             */
            EmailRegistRequestRandCodeLoginUserPmd_C = 46,
            EmailRegistRequestRandCodeLoginUserPmd_S = 47,
        }
    }
    /**
     * 客户端发给登录服务器的登录验证消息
     */
    class AccountTokenVerifyLoginUserPmd_CS {
        /**
         * 平台账号
         */
        account: string;
        /**
         * token 可以是第三方认证
         */
        token: string;
        /**
         * 当前客户端login版本号Version_Login
         */
        version: number;
        /**
         * if filled, will send ZoneInfoListLoginUserPmd_S for select, else auto select zone
         */
        gameid: number;
        /**
         * 机器码
         */
        mid: string;
        /**
         * 平台编号
         */
        platid: number;
        /**
         * if filled, will auto login UserLoginRequestLoginUserPmd_C, UserLoginTokenLoginSmd_SC
         */
        zoneid: number;
        /**
         * 当前客户端game版本号Version_Login
         */
        gameversion: number;
        /**
         * 压缩算法
         */
        compress: string;
        /**
         * 加密算法
         */
        encrypt: string;
        /**
         * 加密key
         */
        encryptkey: string;
        GetType(): string;
    }
    /**
     * 推送客户端连接上来的认证信息,简单验证,主要用来分配网关
     */
    class PushAccountVerifyLoginUserPmd_C {
        accid: number;
        /**
         * 账号id
         */
        account: string;
        /**
         * 这里约定为每个游戏的gameid,这个消息本身的gameid为4000,约定为推送服务器
         */
        zoneid: number;
        /**
         * token 默认约定即可(暂时不用)
         */
        token: string;
        /**
         * 当前客户端login版本号Version_Login(暂时不用)
         */
        version: number;
        /**
         * 机器码
         */
        mid: string;
        /**
         * 当前客户端game版本号Version_Login(暂时不用)
         */
        gameversion: number;
        /**
         * 压缩算法(暂时不用)
         */
        compress: string;
        /**
         * 加密算法(暂时不用)
         */
        encrypt: string;
        /**
         * 加密key(暂时不用)
         */
        encryptkey: string;
        GetType(): string;
    }
    /**
     * 登录服务器返回给客户端的认证结果
     */
    class AccountTokenVerifyReturnLoginUserPmd_S {
        /**
         * 返回值
         */
        retcode: VerifyReturnReason;
        /**
         * 返回错误描述,正确时不填
         */
        desc: string;
        GetType(): string;
    }
    /**
     * 区服务器信息
     */
    class ZoneInfo {
        /**
         * 区编号
         */
        zoneid: number;
        /**
         * 区名称
         */
        zonename: string;
        state: ZoneState;
        opentime: string;
        /**
         * 大厅服务器使用，MMO无视,为了兼容，不能修改尖
         */
        gameid: number;
        /**
         * 大厅服务器使用，MMO无视,为了兼容，不能修改尖
         */
        iconurl: string;
        /**
         * 掩码模式,ZoneInfoBitMask
         */
        bitmask: number;
        /**
         * 大厅服务器使用，MMO无视,为了兼容，不能修改尖
         */
        gamename: string;
        /**
         * 合区使用
         */
        newzoneid: number;
        /**
         * 在线人数
         */
        onlinenum: number;
        /**
         * 在线人数
         */
        nextopentime: string;
        GetType(): string;
    }
    /**
     * 区服务器信息列表,选区列表
     */
    class ZoneInfoListLoginUserPmd_S {
        /**
         * 游戏名称,(区别与区名)
         */
        gamename: string;
        /**
         * 游戏编号
         */
        gameid: number;
        zonelist: ZoneInfo[];
        /**
         * 大厅服务器使用，MMO无视,为了兼容，不能修改尖
         */
        zoneid: number;
        /**
         * 人数最少的，而且是在线的区
         */
        bestzoneid: number;
        GetType(): string;
    }
    /**
     * 请求区服务器信息列表,选区列表
     */
    class RequestZoneInfoListLoginUserPmd_C {
        /**
         * 游戏编号
         */
        gameid: number;
        GetType(): string;
    }
    /**
     * 请求玩有在所有区的角色信息，及区在线信息
     */
    class RequestUserZoneInfoLoginUserPmd_C {
        /**
         * 游戏编号
         */
        gameid: number;
        GetType(): string;
    }
    class UserZoneInfo {
        /**
         * 角色信息，如果为&quot;&quot;说明在这个区里没有角色
         */
        charname: string;
        zoneinfo: ZoneInfo;
        /**
         * 在线人数
         */
        onlinenum: number;
        GetType(): string;
    }
    class RequestUserZoneInfoLoginUserPmd_S {
        /**
         * 玩家在各个区里的角色信息及区在线信息
         */
        userzoneinfo: UserZoneInfo[];
        GetType(): string;
    }
    /**
     * 客户端发到登录服务器
     */
    class MobileRegistRequestRandCodeLoginUserPmd_C {
        /**
         * 客户端填写的手机号
         */
        mobilenum: string;
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 操作类型: 0不检查, 1注册, 2重置密码
         */
        optype: number;
        /**
         * 邀请者accid
         */
        inviteraccid: number;
        /**
         * 邀请码
         */
        invitationcode: string;
        GetType(): string;
    }
    class MobileRegistReturnRandCodeLoginUserPmd_S {
        /**
         * 0表示成功,1表示手机号码填写有误,2表示请求发送短信速度过快,3表示短信服务器未开
         */
        retcode: number;
        /**
         * 错误描述
         */
        desc: string;
        /**
         * 超时时间
         */
        timeout: number;
        GetType(): string;
    }
    /**
     * 客户端发到登录服务器,如果创建成功,直接登录
     */
    class MobileRegistRequestCreateAccountLoginUserPmd_C {
        /**
         * 手机号
         */
        mobilenum: string;
        /**
         * 随机码
         */
        randcode: string;
        /**
         * 密码
         */
        password: string;
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 邀请者uid
         */
        parent: number;
        /**
         * 0代表注册，1代表重置，重置一定需要已经有帐号
         */
        optype: number;
        /**
         * 客户端机器码
         */
        imei: string;
        /**
         * 系统名称
         */
        osname: string;
        GetType(): string;
    }
    /**
     * 手机注册失败返回, 当成功后，返回UserRequestPlatTokenLoginOkLoginUserPmd_S协议，客户端直接选区
     */
    class MobileRegistReturnCreateAccountFailLoginUserPmd_S {
        /**
         * 0表示成功,1表示手机号码填写有误,2表示数日频率过快,3表示验证码错误
         */
        retcode: number;
        /**
         * 错误描述
         */
        desc: string;
        GetType(): string;
    }
    /**
     * 请求获取邮件验证码
     */
    class EmailRegistRequestRandCodeLoginUserPmd_C {
        /**
         * 客户端填写的邮箱
         */
        email: string;
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 操作类型: 0不检查, 1注册, 2重置密码
         */
        optype: number;
        GetType(): string;
    }
    class EmailRegistRequestRandCodeLoginUserPmd_S {
        /**
         * 0表示成功
         */
        retcode: number;
        /**
         * 错误描述
         */
        desc: string;
        GetType(): string;
    }
    /**
     * 请求邮箱注册//客户端发到登录服务器
     */
    class EmailRegistRequestCreateAccountLoginUserPmd_C {
        /**
         * 客户端填写的email url
         */
        email: string;
        /**
         * 密码
         */
        password: string;
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 是否以游客模式绑定？
         */
        isbind: boolean;
        /**
         * 需要替换绑定的uid
         */
        uid: number;
        /**
         * 邀请者uid
         */
        parent: number;
        /**
         * 手机号
         */
        mobilenum: string;
        /**
         * 随机码
         */
        randcode: string;
        /**
         * 0代表注册，1代表重置，重置一定需要已经有帐号
         */
        optype: number;
        /**
         * 客户端机器码
         */
        imei: number;
        /**
         * 系统名称
         */
        osname: string;
        GetType(): string;
    }
    /**
     * 当邮箱注册失败后，会返回，当成功后，返回UserRequestPlatTokenLoginOkLoginUserPmd_S协议，客户端直接选区 //客户端发到登录服务器
     */
    class EmailRegistReturnCreateAccountLoginUserPmd_S {
        /**
         * 0表示成功，1表示失败
         */
        retcode: number;
        /**
         * 原因描述
         */
        desc: string;
        /**
         * 分配的uid
         */
        uid: number;
        GetType(): string;
    }
    /**
     * 玩家使用密码登录验证请求
     */
    class UserRequestPlatTokenByPasswordLoginUserPmd_C {
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 平台id, 手机号注册登录：129
         */
        platid: number;
        /**
         * 账户信息，手机号注册为用户手机号
         */
        account: string;
        /**
         * 密码
         */
        password: string;
        /**
         * 客户端机器码
         */
        imei: string;
        /**
         * 系统名称
         */
        osname: string;
        GetType(): string;
    }
    /**
     * 玩家第三方验证登录请求
     */
    class UserRequestPlatTokenByThirdLoginUserPmd_C {
        /**
         * 平台用户信息
         */
        platinfo: Pmd.PlatInfo;
        /**
         * 游戏编号
         */
        gameid: number;
        GetType(): string;
    }
    /**
     * 玩家请求登录成功返回
     */
    class UserRequestPlatTokenLoginOkLoginUserPmd_S {
        /**
         * 平台分配的uid
         */
        uid: number;
        /**
         * 平台登录密钥，用于上行消息URL签名
         */
        platkey: string;
        /**
         * 平台登录token，用于上行消息
         */
        platlogin: string;
        /**
         * 平台登录token从现在开始多少秒后过期，过期后或服务器返回HttpReturnCode_SignError时客户端需要重新走登录流程
         */
        platloginlife: number;
        /**
         * 时区的名字
         */
        timezonename: string;
        /**
         * 服务器时区相对于UTC的时间偏移量,单位是秒
         */
        timezoneoffset: number;
        /**
         * 平台验证后的反悔的信息
         */
        platinfo: Pmd.PlatInfo;
        GetType(): string;
    }
    /**
     * 玩家请求登录失败返回
     */
    class UserRequestPlatTokenLoginFailLoginUserPmd_S {
        retcode: number;
        /**
         * 验证失败描述信息
         */
        desc: string;
        /**
         * 二次登录随机码 用于非独立账号绑定用
         */
        bindcode: string;
        GetType(): string;
    }
    /**
     * 由游戏服 发起的获取 跳转登录授权token
     */
    class ForwardLoginRequestTokenLoginUserPmd_C {
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 区id
         */
        zoneid: number;
        /**
         * 账号
         */
        plataccount: string;
        /**
         * 秒级时间戳
         */
        timestamp: number;
        /**
         * 签名
         */
        sign: string;
        GetType(): string;
    }
    class ForwardLoginRequestTokenLoginUserPmd_S {
        /**
         * 0表示成功
         */
        retcode: number;
        /**
         * 错误描述
         */
        desc: string;
        /**
         * 跳转token
         */
        forwardtoken: string;
        GetType(): string;
    }
    /**
     * 请求登录某个区,发给LoginServer
     */
    class UserLoginRequestLoginUserPmd_C {
        /**
         * 游戏编号
         */
        gameid: number;
        /**
         * 区编号
         */
        zoneid: number;
        /**
         * 客户端游戏版本号Version_Game
         */
        gameversion: number;
        /**
         * 机器码
         */
        mid: string;
        GetType(): string;
    }
    /**
     * 登录某个区的错误返回,LoginServer返回
     */
    class UserLoginReturnFailLoginUserPmd_S {
        retcode: LoginReturnFailReason;
        /**
         * 错误描述
         */
        desc: string;
        GetType(): string;
    }
    /**
     * 登录某个区正确时的返回,LoginServer返回
     */
    class UserLoginReturnOkLoginUserPmd_S {
        /**
         * 账号
         */
        accountid: number;
        /**
         * 生成一个临时编号,用于校验,登录网关时传上去
         */
        logintempid: number;
        /**
         * 随机token
         */
        tokenid: number;
        /**
         * 登录的网关地址,接下来断开连接后马上登录这个地址
         */
        gatewayurl: string;
        /**
         * 游戏编号
         */
        gameid: number;
        /**
         * 区编号
         */
        zoneid: number;
        separatezoneuid: boolean;
        zoneuid: string;
        /**
         * 登录的网关地址tcp,
         */
        gatewayurltcp: string;
        /**
         * 登录的网关ws,
         */
        gatewayurlws: string;
        /**
         * config.json的md5
         */
        configmd5: string;
        /**
         * config.json的url
         */
        configurl: string;
        /**
         * 能支持的最小版本号,低于这个客户端就必须更新
         */
        minversion: string;
        GetType(): string;
    }
    /**
     *  发给网关的登录消息,这个消息也可以指定是否尝试断线重连
     *  只有在游戏中断开时
     */
    class UserLoginTokenLoginUserPmd_C {
        gameid: number;
        zoneid: number;
        accountid: number;
        logintempid: number;
        /**
         * 客户端时间戳
         */
        timestamp: number;
        /**
         * md5(string(accountid) + string(logintempid) + string(timestamp) + string(PlatTokenLoginReturn.unigame_plat_key))
         */
        tokenmd5: string;
        /**
         * 压缩算法
         */
        compress: string;
        /**
         * 加密算法
         */
        encrypt: string;
        /**
         * 加密key
         */
        encryptkey: string;
        /**
         * 客户端版本号
         */
        version: number;
        /**
         * 最小压缩字节数,低于这个数的不压缩
         */
        compressmin: number;
        /**
         * 0表示不支持断线重连登录,非0表示支持断线重连,并且指定最后一个收到并且确定处理的消息序列号,服务器会尝试从这个消息号后全部重发一遍,失败的话还是走登录流程
         */
        lastseq: number;
        /**
         * 断线重连时可以直接指定用哪个角色登录
         */
        charid: number;
        /**
         * 当前的客户端包id
         */
        bundleid: number;
        /**
         * 客户端代码zip包md5
         */
        zipmd5: string;
        /**
         * config.josn的md5
         */
        configmd5: string;
        /**
         * 当前的客户端包名bundleid_version mj_1.0.1
         */
        bundlename: string;
        /**
         * gameGatewayUrl,尽量让玩家跟房主一个url,防止被攻击
         */
        url: string;
        GetType(): string;
    }
    /**
     * 发给网关的断线重连消息
     */
    class UserLoginReconnectLoginUserPmd_C {
        accountid: number;
        /**
         * 客户端时间戳
         */
        timestamp: number;
        /**
         * md5(string(accountid) + string(logintempid) + string(timestamp) + string(PlatTokenLoginReturn.unigame_plat_key))
         */
        tokenmd5: string;
        /**
         * 端游用
         */
        logintempid: number;
        /**
         * 游戏Id
         */
        gameid: number;
        /**
         * 区Id
         */
        zoneid: number;
        /**
         * 压缩算法
         */
        compress: string;
        /**
         * 加密算法
         */
        encrypt: string;
        /**
         * 加密key
         */
        encryptkey: string;
        /**
         * 客户端版本号
         */
        version: number;
        /**
         * 最小压缩字节数,低于这个数的不压缩
         */
        compressmin: number;
        /**
         * 0表示登录,非0表示断线重连,并且指定最后一个收到并且确定处理的消息序列号,服务器会尝试从这个消息号后全部重发一遍,失败的话还是走登录流程
         */
        lastseq: number;
        /**
         * 断线重连时可以直接指定用哪个角色登录
         */
        charid: number;
        /**
         * 当前的客户端包id
         */
        bundleid: number;
        /**
         * 客户端代码zip包md5
         */
        zipmd5: string;
        /**
         * config.josn的md5
         */
        configmd5: string;
        /**
         * 当前的客户端包名bundleid_version mj_1.0.1
         */
        bundlename: string;
        /**
         * gameGatewayUrl,尽量让玩家跟房主一个url,防止被攻击
         */
        url: string;
        GetType(): string;
    }
    /**
     * 通知客户端发送日志的地址和日志级别
     */
    class ClientLogUrlLoginUserPmd_S {
        /**
         * 日志几遍,Debug,Info,Error
         */
        loglevel: string;
        /**
         * 日志地址
         */
        logurl: string;
        /**
         * 相同日志信息的日志只发一遍
         */
        distinct: boolean;
        GetType(): string;
    }
    class MessageBoxLoginUserPmd_S {
        btnleft: string;
        btnmiddle: string;
        btnright: string;
        info: string;
        GetType(): string;
    }
    /**
     * 请求注册帐号
     */
    class RequestAccountRegisterLoginUserPmd_C {
        /**
         * 账号
         */
        account: string;
        /**
         * 密码
         */
        password: string;
        /**
         * 验证码
         */
        code: string;
        GetType(): string;
    }
    /**
     * 请求注册帐号
     */
    class ReturnAccountRegisterLoginUserPmd_S {
        /**
         * 账号
         */
        account: string;
        /**
         * 账号ID
         */
        accountid: number;
        GetType(): string;
    }
    /**
     * 发给网关的主动退出消息
     */
    class UserLogoutTokenLoginUserPmd_C {
        GetType(): string;
    }
    /**
     * 如果是重连成功需要给老的客户度发送踢下线消息，否则会永远抢下去
     */
    class ReconnectKickoutLoginUserPmd_S {
        /**
         * 描述
         */
        desc: string;
        GetType(): string;
    }
    class ReconnectErrorLoginUserPmd_S {
        /**
         * 描述
         */
        desc: string;
        GetType(): string;
    }
    /**
     * 服务器主动踢玩家下线
     */
    class ServerKickoutLoginUserPmd_S {
        /**
         * 踢下线的玩家
         */
        accountid: number;
        /**
         * 描述
         */
        desc: string;
        GetType(): string;
    }
    /**
     * 第三方平台登录
     */
    class ThirdPlatLoginUserPmd_C {
        /**
         * 平台用户信息
         */
        platinfo: Pmd.PlatInfo;
        /**
         * 游戏编号
         */
        gameid: number;
        /**
         * 签名id
         */
        sid: string;
        /**
         * 用户ID
         */
        uid: string;
        GetType(): string;
    }
    /**
     * 通知服务器所采用的编码方式和区域信息
     */
    class SetServerLangLoginUserPmd_C {
        lang: string;
        /**
         * 游戏运营区域
         */
        gameregion: number;
        GetType(): string;
    }
    /**
     * 客户端请求得到自己的IP
     */
    class RequestClientIPLoginUserPmd_C {
        GetType(): string;
    }
    /**
     * 返回客户端IP
     */
    class ReturnClientIPLoginUserPmd_S {
        pstrip: string;
        GetType(): string;
    }
    class CheckVersionLoginUserPmd_C {
        /**
         * 保留字段
         */
        default_charid: number;
        version: number;
        GetType(): string;
    }
    class BehaviorClientVerifyLoginUserPmd_C {
        /**
         * 平台账号
         */
        account: string;
        /**
         * token 可以是第三方认证
         */
        token: string;
        /**
         * 当前客户端login版本号Version_Login
         */
        version: number;
        /**
         * if filled, will send ZoneInfoListLoginUserPmd_S for select, else auto select zone
         */
        gameid: number;
        /**
         * 机器码
         */
        mid: string;
        /**
         * 平台编号
         */
        platid: number;
        /**
         * if filled, will auto login UserLoginRequestLoginUserPmd_C, UserLoginTokenLoginSmd_SC
         */
        zoneid: number;
        /**
         * 当前客户端game版本号Version_Login
         */
        gameversion: number;
        /**
         * 压缩算法
         */
        compress: string;
        /**
         * 加密算法
         */
        encrypt: string;
        /**
         * 加密key
         */
        encryptkey: string;
        GetType(): string;
    }
    class RequestSupoortGameListLoginUserPmd_C {
        GetType(): string;
    }
    class ReturnSupoortGameListLoginUserPmd_S_Game {
        /**
         * 游戏名称,(区别与区名)
         */
        gamename: string;
        /**
         * 游戏编号
         */
        gameid: number;
        GetType(): string;
    }
    class ReturnSupoortGameListLoginUserPmd_S {
        gamelist: ReturnSupoortGameListLoginUserPmd_S_Game[];
        GetType(): string;
    }
    /**
     * 发给网关的断线重连消息
     */
    class UserLoginReconnectOkLoginUserPmd_S {
        /**
         * accid//发给unilight用
         */
        accid: number;
        GetType(): string;
    }
    /**
     * 发给网关的断线重连消息
     */
    class GameServerShutDownLoginUserPmd_S {
        /**
         * 停服原因,不填就提示,游戏服务器维护,请稍后进入
         */
        desc: string;
        GetType(): string;
    }
    class OnlineNumWaitingLoginUserPmd_S {
        /**
         * 已进入人数
         */
        playingnum: number;
        /**
         * 排队总人数
         */
        waitingnum: number;
        /**
         * 我的排队位置
         */
        mynum: number;
        GetType(): string;
    }
    class OnlineStateLoginUserPmd_CS {
        /**
         * OnlineState
         */
        state: number;
        /**
         * 账号id,如果是自己,可以不填
         */
        accid: number;
        GetType(): string;
    }
    class ServerDebugLevelLoginUserPmd_S {
        /**
         * 状态,0表示非调试,1表示服务器日志调试,2表示客户端日志调试,3表示带GM指令调试,默认不发是0
         */
        level: number;
        GetType(): string;
    }
    class ServerShutDownLoginUserPmd_S {
        /**
         * 服务器当前时间,uniixtime
         */
        servertime: number;
        /**
         * 倒计时时间
         */
        lefttime: number;
        /**
         * 停机原因
         */
        desc: string;
        /**
         * 20161202添加，后面为gm需要字段
         */
        gameid: number;
        zoneid: number;
        gmid: number;
        clientid: number;
        /**
         * 0成功，其他失败
         */
        retcode: number;
        /**
         * 失败描述
         */
        retdesc: string;
        GetType(): string;
    }
    class RequestZoneStateLoginUserPmd_CS {
        gameid: number;
        startzoneid: number;
        endzoneid: number;
        zoneinfo: ZoneInfo[];
        GetType(): string;
    }
    /**
     * 返回客户端配置config
     */
    class ClientConfigUpdateLoginUserPmd_S {
        /**
         * 配置地址
         */
        config: string;
        /**
         * game_crc.zip
         */
        zipmd5: string;
        /**
         * native config contecnt
         */
        nativeconfig: string;
        GetType(): string;
    }
}

declare module Pmd {
    enum FrameHeader {
        Bitmask_None = 0,
        /**
         * 压缩
         */
        Bitmask_Compress = 1,
        /**
         * 加密
         */
        Bitmask_Encrypt = 2,
        /**
         * 嵌套消息头
         */
        Bitmask_Header = 4,
        /**
         * data结构里不包含,data长度的描述,新版协议支持,只需要在第一个消息里设置
         */
        Bitmask_NoHeadLen = 8,
        /**
         * 本次连接支持断线重连标志,只需要在第一个消息里设置
         */
        Bitmask_Reconnect = 16,
    }
    class Null {
        GetType(): string;
    }
    module Null {
        enum Param {
            ForwardNullUserPmd_CS = 0,
            TickRequestNullUserPmd_CS = 1,
            TickReturnNullUserPmd_CS = 2,
            RequestCloseNullUserPmd_CS = 3,
            FrameHeaderNullUserPmd_CS = 4,
            CheckVersionUserPmd_CS = 5,
            ForwardBwNullUserPmd_CS = 6,
            SetTickTimeoutNullUserPmd_CS = 7,
            SetPingTimeNullUserPmd_CS = 8,
            /**
             * 直接根据区信息转发
             */
            ForwardToZoneNullUserPmd_CS = 9,
            /**
             * 这里为了节省流量,特殊处理系,15以下为系统用,以上也可以被应用层使用
             */
            MaxDefualtNullUserPmd = 15,
            StartFrameSyncNullUserPmd_CS = 16,
            BroadListFrameSyncNullUserPmd_S = 17,
            RequestUpFrameSyncNullUserPmd_C = 18,
            HistoryListFrameSyncNullUserPmd_S = 19,
            StopFrameSyncNullUserPmd_SC = 20,
            ForwardNullUserListPmd_CS = 21,
            /**
             * 尝试消息
             *  json压缩约定消息
             */
            JsonCompressNullUserPmd_CS = 101,
        }
    }
    class ForwardNullUserPmd_CS {
        byCmd: number;
        byParam: number;
        /**
         * 发送序列号,断线重连用
         */
        seq: number;
        /**
         * server used for forward
         */
        fid: number;
        data: any;
        /**
         * 0:proto,1:json,2:http
         */
        prototype: number;
        /**
         * FrameHeader位枚举
         */
        bitmask: number;
        /**
         * client use
         */
        time: number;
        GetType(): string;
    }
    class ForwardNullUserListPmd_CS {
        byCmd: number;
        byParam: number;
        /**
         * 发送序列号,断线重连用
         */
        seq: number;
        /**
         * server userlist for forward
         */
        userlist: number;
        data: any;
        /**
         * 0:proto,1:json,2:http
         */
        prototype: number;
        /**
         * FrameHeader位枚举
         */
        bitmask: number;
        /**
         * client use
         */
        time: number;
        GetType(): string;
    }
    class TickRequestNullUserPmd_CS {
        /**
         * 当前请求消息的本地时间,秒
         */
        requesttime: number;
        GetType(): string;
    }
    class TickReturnNullUserPmd_CS {
        /**
         * 对方的请求时间原封返回
         */
        requesttime: number;
        /**
         * 当前应答的本地时间,秒,必须填,用来防止加速
         */
        mytime: number;
        GetType(): string;
    }
    class SetPingTimeNullUserPmd_CS {
        /**
         * 当前ping值,毫秒
         */
        pingmsec: number;
        /**
         * 玩家id,不填表示自己
         */
        accid: number;
        GetType(): string;
    }
    /**
     * 设置心跳超时检测时间,每个游戏可能会不一样,这个时间也决定了ping值得刷新时间
     */
    class SetTickTimeoutNullUserPmd_CS {
        sec: number;
        /**
         * 连续探测超过几次就断开
         */
        times: number;
        GetType(): string;
    }
    class RequestCloseNullUserPmd_CS {
        reason: string;
        GetType(): string;
    }
    /**
     * websocket帧头
     */
    class FrameHeaderNullUserPmd_CS {
        /**
         * FrameHeader位枚举
         */
        bitmask: number;
        data: any;
        GetType(): string;
    }
    /**
     * websocket帧头
     */
    class CheckVersionUserPmd_CS {
        versionserver: number;
        versionclient: number;
        GetType(): string;
    }
    class ForwardBwNullUserPmd_CS {
        data: any;
        GetType(): string;
    }
    class ForwardToZoneNullUserPmd_CS {
        gameid: number;
        zoneid: number;
        accid: number;
        data: any;
        GetType(): string;
    }
    class UserInitData {
        x: number;
        y: number;
        z: number;
        data: string;
        GetType(): string;
    }
    class FrameSyncData {
        /**
         * 房间内临时用户编号,也可以是accountid,但是为了后期后话流量,可以选择用更小的id
         */
        tempid: number;
        data: string;
        /**
         * 玩家初始化信息
         */
        init: UserInitData;
        GetType(): string;
    }
    /**
     * TODO: MaxDefaultNullUserPmd
     */
    class MaxDefualtNullUserPmd {
        GetType(): string;
    }
    /**
     * 帧同步启动
     */
    class StartFrameSyncNullUserPmd_CS {
        /**
         * 频率,毫秒,1000/msec=帧率
         */
        msec: number;
        /**
         * 随机种子
         */
        randseed: number;
        /**
         * 起始数据
         */
        initdata: string;
        /**
         * 如果填了这个,表示帧同步数据可以通过网关转发,而不用经过unilight,提高ping值
         */
        roomid: number;
        GetType(): string;
    }
    /**
     * 帧同步下发
     */
    class BroadListFrameSyncNullUserPmd_S {
        /**
         * 当前帧计数
         */
        framenum: number;
        datalist: FrameSyncData[];
        GetType(): string;
    }
    /**
     * 帧同步上行
     */
    class RequestUpFrameSyncNullUserPmd_C {
        data: string;
        GetType(): string;
    }
    class HistoryFrameSyncData {
        /**
         * 当前帧计数
         */
        framenum: number;
        datalist: FrameSyncData[];
        GetType(): string;
    }
    /**
     * 帧同步历史列表
     */
    class HistoryListFrameSyncNullUserPmd_S {
        datalist: HistoryFrameSyncData[];
        /**
         * 因为列表可能会很大,需要分段发送,就需要有个结束标志
         */
        finished: boolean;
        GetType(): string;
    }
    /**
     * 帧同步结束,上发结算消息
     */
    class StopFrameSyncNullUserPmd_SC {
        /**
         * 结算数据
         */
        resultdata: string;
        GetType(): string;
    }
    class JsonCompressKey {
        key: string;
        /**
         * 嵌套描述
         */
        json: JsonCompressKey[];
        GetType(): string;
    }
    /**
     * json压缩约定消息
     */
    class JsonCompressNullUserPmd_CS {
        key: string;
        json: JsonCompressKey[];
        /**
         * 0表示不省略,1表示省略,默认不省略,default省略,{} ,&quot;&quot;,0
         */
        omit: number;
        /**
         * 0表示重置,1表示添加
         */
        add: number;
        /**
         * 消息列表
         */
        msglist: string[];
        GetType(): string;
    }
}

declare module Pmd {
    /**
     * 平台登录一级消息
     */
    enum PlatCommand {
        PlatCommand_Null = 0,
        /**
         * 日志服务器
         */
        PlatCommand_Logger = 245,
        /**
         * 大厅服务器
         */
        PlatCommand_Lobby = 246,
        /**
         * 推送服务器
         */
        PlatCommand_Push = 247,
        /**
         * GM服务器
         */
        PlatCommand_Gm = 248,
        /**
         * 监控消息
         */
        PlatCommand_Monitor = 249,
        /**
         * 登录消息
         */
        PlatCommand_Login = 250,
        /**
         * 登录转发消息
         */
        PlatCommand_Forward = 251,
        /**
         * 第三方对接服务器间消息
         */
        PlatCommand_Sdk = 252,
        /**
         * 聊天消息
         */
        PlatCommand_Chat = 253,
        /**
         * 图片服务器
         */
        PlatCommand_Image = 254,
    }
    /**
     * HTTP请求错误返回定义
     */
    enum HttpReturnCode {
        /**
         * 无错误
         */
        HttpReturnCode_Null = 0,
        /**
         * 通用错误
         */
        HttpReturnCode_NormalErr = 1,
        /**
         * 数据库出错
         */
        HttpReturnCode_DbError = 2,
        /**
         * 需要绑定账号
         */
        HttpReturnCode_NeedBind = 3,
        /**
         * lua脚本错误
         */
        HttpReturnCode_LuaScriptError = 4,
        /**
         * 找不到游戏区列表
         */
        HttpReturnCode_GameZoneListError = 5,
        /**
         * 已经注册过了
         */
        HttpReturnCode_IsRegisteredError = 6,
        /**
         * 当前账号未注册
         */
        HttpReturnCode_NoRegisteredError = 7,
        /**
         * 签名检查错误，需要重新登录
         */
        HttpReturnCode_SignError = 11,
        /**
         * 服务器未开
         */
        HttpReturnCode_ServerShutDown = 12,
        /**
         * Json语法格式错误
         */
        HttpReturnCode_JsonSyntaxError = 13,
        /**
         * Json消息格式错误
         */
        HttpReturnCode_JsonMessageError = 14,
        /**
         * tokenvalue为空
         */
        HttpReturnCode_TokenValueError = 15,
        /**
         * uid与登录uid不同
         */
        HttpReturnCode_WaiGuaUidError = 16,
        /**
         * [过期字段]
         */
        HttpReturnCode_NoGatewaytDown = 17,
        /**
         * 没有可用网关
         */
        HttpReturnCode_NoGatewayDown = 17,
        /**
         * 没有可用Sdk服务器
         */
        HttpReturnCode_NoSdkServer = 18,
        /**
         * 签名错误
         */
        HttpReturnCode_SdkCheckSignErr = 19,
        /**
         * 第三方服务器验证错误
         */
        HttpReturnCode_Sdk3PartyServerErr = 20,
        /**
         * proto解析错误
         */
        HttpReturnCode_ProtobufErr = 21,
        /**
         * 网关错误
         */
        HttpReturnCode_GatewayErr = 22,
        /**
         * 响应超时,目前设置为20秒
         */
        HttpReturnCode_Timeout = 23,
        /**
         * 账号正在使用中
         */
        HttpReturnCode_AccountUsing = 24,
        /**
         * 线上时，platid＝0被限制
         */
        HttpReturnCode_OnlinePlatidErr = 25,
        /**
         * 绑定账号失败
         */
        HttpReturnCode_BindAccountErr = 26,
    }
    /**
     * 服务器类型
     */
    enum TaskType {
        /**
         * 未知
         */
        TaskType_Null = 0,
        /**
         * 监控服务器
         */
        TaskType_Monitor = 1,
        /**
         * 登录服务器
         */
        TaskType_Login = 2,
        /**
         * 名字验证服务器,这里因为有名字冲突，只能加后缀了
         */
        TaskType_NameS = 3,
        /**
         * SDK服务器
         */
        TaskType_Sdk = 4,
        /**
         * GM服务器
         */
        TaskType_Gm = 5,
        /**
         * 网关服务器
         */
        TaskType_Gateway = 6,
        /**
         * 游戏区服务器
         */
        TaskType_GameZone = 7,
    }
    enum ServerType {
        UNKNOWNSERVER = 0,
        SUPERSERVER = 1,
        LOGINSERVER = 10,
        RECORDSERVER = 11,
        SESSIONSERVER = 20,
        SCENESSERVER = 21,
        GATEWAYSERVER = 22,
        INFOSERVER = 23,
        HTTPSERVER = 24,
        CHANGESERVER = 25,
        USERSERVER = 26,
        BILLSERVER = 27,
        NAMESERVER = 28,
        MONITORSERVER = 29,
        GMSERVER = 30,
        STATERSERVER = 31,
        SOUNDSERVER = 32,
        BILLSERVER_ALIPAY = 33,
        BILLSERVER_JUNKA = 34,
        BILLSERVER_TIANXIATONG = 35,
        BILLSERVER_ZONGYOU = 36,
        BILLSERVER_OFFLINE = 37,
        BILLSERVER_MESSAGE = 38,
        BILLSERVER_ZQB = 39,
        WEBGATESERVER = 40,
        BILLSERVER_BAIDU = 41,
        BILLSERVER_SHUN = 42,
        SDKSERVER = 43,
        LOGGERSERVER = 44,
        UNILIGHT = 45,
        MAX_SERVERTYPE = 46,
        UnknownServer = 0,
        /**
         * SuperServer		= 1;//会有namespace冲突,先屏蔽
         */
        LoginServer = 10,
        /**
         * RecordServer		= 11;//会有namespace冲突,先屏蔽
         * SessionServer		= 20;//会有namespace冲突,先屏蔽
         * SceneServer		= 21;//会有namespace冲突,先屏蔽
         */
        GatewayServer = 22,
        InfoServer = 23,
        HttpsServer = 24,
        ChangeServer = 25,
        UserServer = 26,
        BillServer = 27,
        NameServer = 28,
        MonitorServer = 29,
        GmServer = 30,
        StateServer = 31,
        SoundServer = 32,
        WebGateServer = 40,
        SdkServer = 43,
        LoggerServer = 44,
        UniServer = 45,
    }
    enum NetType {
        /**
         * 近程路由，电信区连电信服务器，网通区连网通服务器
         */
        NetType_near = 0,
        /**
         * 远端路由，电信区连网通服务器，网通区连电信服务器
         */
        NetType_far = 1,
        /**
         * 电信
         */
        NetType_CTC = 2,
        /**
         * 网通
         */
        NetType_CNC = 3,
    }
    /**
     * 机器人id断定义
     */
    enum RobotUid {
        /**
         * 最小id
         */
        RobotUid_begin = 10000,
        /**
         * 最大id
         */
        RobotUid_end = 20000,
    }
    /**
     * 游戏类型信息,以后可能会扩充
     */
    class GameZoneInfo {
        /**
         * 游戏编号
         */
        gameid: number;
        /**
         * 区编号
         */
        zoneid: number;
        /**
         * 游戏名称
         */
        gamename: string;
        /**
         * 区名称
         */
        zonename: string;
        /**
         * MySQL数据库,不填表示从配置文件读取
         */
        mysql: string;
        /**
         * Redis数据库,不填表示从配置文件读取
         */
        redis: string;
        /**
         * RethinkDB数据库,不填表示从配置文件读取
         */
        rethink: string;
        /**
         * MongoDB数据库,不填表示从配置文件读取
         */
        mongo: string;
        /**
         * 当前区服状态0表示关闭,1表示正常,2表示无权限
         */
        zonestate: number;
        /**
         * 是否以区为单位分uid，方便合区
         */
        separatezoneuid: boolean;
        /**
         * 大厅服务器配置,如果是大厅服务器,则用这个url监听,如果是unilight,则用来连大厅
         */
        lobby: string;
        /**
         * 区类型，0标识正式区，1标识沙盒测试区，2标识其他测试区
         */
        zonetype: number;
        /**
         * 开服时间
         */
        opentime: string;
        /**
         * 大厅服务器配置,用来监听unilight的链接进来
         */
        listenaslobby: string;
        /**
         * 通过配置，区可以连上dbserver
         */
        dbserverurl: string;
        GetType(): string;
    }
    /**
     * 平台用户信息
     */
    class PlatInfo {
        /**
         * 用户账号。platid为PlatType_Normal时，account可以缺省为客户端机器码
         */
        account: string;
        /**
         * 平台id 从PlatType改成int类型
         */
        platid: number;
        email: string;
        /**
         * 性别
         */
        gender: string;
        /**
         * 昵称
         */
        nickname: string;
        /**
         * 时间戳
         */
        timestamp: string;
        /**
         * 平台签名串
         */
        sign: string;
        /**
         * 平台头像
         */
        faceurl: string;
        /**
         * 增加一个扩展字段，特殊平台自行组装json
         */
        extdata: string;
        /**
         * 平台id(兼容老的处理方式)
         */
        uid: string;
        /**
         * 客户端机器码
         */
        imei: string;
        /**
         * 系统名称
         */
        osname: string;
        /**
         * 为了支持多个公众号
         */
        platappid: string;
        /**
         * 二次登录随机码 用于非独立账号绑定用
         */
        bindcode: string;
        /**
         * 临时token,用来绕过第三方验证,由login直接认证通过,第三方服务器出问题时用
         */
        onetoken: string;
        /**
         * 跳转登录token
         */
        forwardtoken: string;
        GetType(): string;
    }
    class ServerName {
        Super: string;
        Login: string;
        Record: string;
        Session: string;
        Scene: string;
        Gateway: string;
        Info: string;
        Https: string;
        Change: string;
        User: string;
        Bill: string;
        Name: string;
        Monitor: string;
        GmServer: string;
        State: string;
        Sound: string;
        WebGate: string;
        Sdk: string;
        Logger: string;
        Uni: string;
        GetType(): string;
    }
    class ServerInfo {
        /**
         * down机区
         */
        zoneid: number;
        /**
         * down机服务器id
         */
        serverid: number;
        /**
         * down机服务器类型
         */
        servertype: number;
        /**
         * 协议号
         */
        protocol: number;
        /**
         * 编译时间
         */
        buildtime: number;
        /**
         * svn 版本号
         */
        svnversion: number;
        data1: number;
        /**
         * 服务器状态ServerInfoState
         */
        funcion: number;
        reserve0: number;
        reserve1: number;
        reserve2: number;
        reserve3: number;
        /**
         * down机服务器ip
         */
        serverip: number;
        /**
         * down机影响人数
         */
        usernum: number;
        /**
         * down机服务器时间
         */
        time: number;
        GetType(): string;
    }
}

/// <reference path="pmd.d.ts" />
declare module Pmd {
    /**
     * 游戏接入时，需要特别注意一下注明需要回传给客户端的字段
     */
    class Sdk {
        GetType(): string;
    }
    module Sdk {
        enum Param {
            StartUpGameRequestSdkPmd_C = 1,
            StartUpGameReturnSdkPmd_S = 2,
            SupportGamePlatListSdkPmd_S = 3,
            UserLoginPlatRequestSdkPmd_C = 4,
            UserLoginPlatReturnSdkPmd_S = 5,
            CreatePlatOrderRequestSdkPmd_C = 6,
            CreatePlatOrderReturnSdkPmd_S = 7,
            NotifyRechargeRequestSdkPmd_S = 8,
            NotifyRechargeReturnSdkPmd_C = 9,
            RechargeQueryRequestIOSSdkPmd_C = 10,
            RequestQueryPlatPointSdkPmd_C = 11,
            ReturnQueryPlatPointSdkPmd_S = 12,
            RequestRedeemPlatPointSdkPmd_C = 13,
            ReturnRedeemPlatPointSdkPmd_S = 14,
            ReturnErrorCodeSdkPmd_S = 15,
            RequestBindAccountSdkPmd_CS = 16,
            RequestBindPlatInfoSdkPmd_CS = 17,
            RequestAccidByPlatinfoSdkPmd_CS = 18,
            RequestRedeemBackPlatPointSdkPmd_C = 19,
            ReturnRedeemBackPlatPointSdkPmd_S = 20,
            RequestUnbindAccountSdkPmd_CS = 21,
            NotifyTapJoyRequestSdkPmd_S = 22,
            PushMsgRequestSdkPmd_C = 23,
            PushMsgReturnSdkPmd_S = 24,
            BindAccountPhoneSdkPmd_CS = 25,
            RequestMobileRegistRandCodeSdkPmd_CS = 26,
            /**
             * 转发微信公众号推送过来的信息，由微信平台处理，此处只转发
             */
            RequestWechatMsgSdkPmd_CS = 27,
            /**
             * 根据平台账号查询角色信息
             */
            SearchUserListSdkPmd_CS = 28,
            /**
             * 预登陆，将玩家点击的房间号，群号推送给游戏, 登陆服发送过来sdk清空预登陆信息
             */
            NotifyPreLoginInfoSdkPmd_CS = 29,
            /**
             * 获取微信二维码
             */
            RequestQrcodeURLSdkPmd_CS = 30,
            /**
             * 查询玩家的钻石消耗
             */
            DiamondConsumSdkPmd_CS = 31,
            /**
             * 通过sdk奖励玩家,如果渠道没有指定发奖的角色，需要游戏自行判断，
             */
            RewardUserSdkPmd_CS = 32,
            /**
             * 通过微信公众号发红包
             */
            SendRedPackSdkPmd_CS = 43,
            PlatSignDataSdkPmd_CS = 44,
            /**
             * 向某一个游戏请求玩家具体信息
             */
            RequestUserInfoSdkPmd_SC = 45,
            /**
             * 查询角色ID是否已经绑定代理
             */
            CheckUserInfoBindSdkPmd_CS = 46,
            /**
             * 查询区服列表
             */
            QueryGamezoneListSdkPmd_CS = 75,
            /**
             * tcg
             *  游戏服务器启动时向渠道注册
             */
            ServerRegisterSdkPmd_CS = 76,
            /**
             * 游戏服务器向渠道发送心跳包
             */
            ServerHeartBeatSdkPmd_CS = 77,
            /**
             * 冻结玩家平台币
             */
            BookTransactionSdkPmd_CS = 78,
            /**
             * 交易结算，玩家下线、离开时请求渠道方进行结算
             */
            BatchTransactionSdkPmd_CS = 79,
            /**
             * 请求平台机器人配置
             */
            AndroidConfigSdkPmd_CS = 80,
            /**
             * 玩家间发生红包的请求
             */
            RequestC2CSendRedPackSdkPmd_CS = 81,
            /**
             * 玩家间发生红包的操作结果
             */
            ReturnC2CSendRedPackSdkPmd_CS = 82,
            /**
             * 领取玩家间发送的红包
             */
            RecvC2CRedPackSdkPmd_CS = 83,
            /**
             * 玩家间发送的红包未领取退款
             */
            RefundC2CRedPackSdkPmd_CS = 84,
            /**
             * 针对已经登录的玩家，如果有依赖其他渠道的信息，需要其他渠道授权获取，发送该协议
             */
            RequestReAuthSdkPmd_C = 85,
            /**
             * 重新授权的返回
             */
            ReturnReAuthSdkPmd_S = 86,
            /**
             * 渠道请求处罚玩家
             */
            PlatRequestPunishSdkPmd_CS = 87,
            /**
             * 解除绑定
             */
            RequestUnbundingSdkPmd_CS = 88,
            /**
             * HK
             *  平台请求兑换游戏币，类似代理给玩家充值
             */
            PlatRedeemSdkPmd_CS = 33,
            /**
             * 平台请求查询玩家游戏币
             */
            PlatQueryBalanceSdkPmd_CS = 34,
            /**
             * 平台请求游戏记录
             */
            PlatQueryGamerecordSdkPmd_CS = 35,
            /**
             * 暂时适应香港捕鱼
             */
            GameRecord = 36,
            /**
             * 渠道用户列表
             */
            PlatQueryUserListSdkPmd_CS = 37,
            /**
             * 渠道报表
             */
            PlatQueryPlatReportSdkPmd_CS = 38,
            /**
             * 渠道每日报表
             */
            PlatQueryPlatDailySdkPmd_CS = 39,
            PlatUserInfo = 40,
            PlatReport = 41,
            PlatDailyData = 42,
            /**
             * 查询玩家每日数据
             */
            PlatUserDailySdkPmd_CS = 50,
            /**
             * 查询玩家指定日期的数据
             */
            PlatUserReportSdkPmd_CS = 52,
            UserDailyData = 51,
            /**
             * 登陆服和sdk通信的通用协议
             */
            ForwardCommandSdkPmd_CS = 53,
            /**
             * 获取牌局详细数据
             */
            UserBettingDetailSdkPmd_CS = 60,
            /**
             * 获取玩家购买历史记录
             */
            UserPurchaseRecordSdkPmd_CS = 61,
            /**
             * 平台请求游戏创建角色
             */
            PlatCreateRoleSdkPmd_CS = 62,
            /**
             * 游戏请求平台创建账号
             */
            CreatePlatAccountSdkPmd_CS = 63,
            PurchaseData = 64,
            UserBettingData = 65,
            /**
             * 平台请求玩家的金币变动日志
             */
            PlatQueryCoinRecordSdkPmd_CS = 66,
            /**
             * 金币记录
             */
            UserCoinRecord = 67,
            /**
             * 修改渠道账号密码
             */
            ChangePlatPasswdSdkPmd_CS = 68,
            /**
             * 请求每局详情
             */
            PlatQueryRoundDetailSdkPmd_CS = 69,
            RoundData = 70,
            /**
             * 渠道请求修改玩家信息
             */
            PlatModifyUserInfoSdkPmd_CS = 71,
            /**
             * 查询子游戏信息
             */
            PlatQuerySubgamesSdkPmd_CS = 72,
            /**
             * 发送福利
             */
            SendWelfareSdkPmd_CS = 73,
            /**
             * 解密数据，部分渠道的数据需后端解密
             */
            DecryptDataSdkPmd_CS = 74,
            /**
             * 上传数据
             */
            UploadDataSdkPmd_CS = 90,
            /**
             * 游戏请求提现
             */
            RequestDrawcashSdkPmd_CS = 91,
            /**
             * 平台提现结果
             */
            DrawcashResultSdkPmd_CS = 92,
        }
    }
    /**
     * 区服务器请求连接登录服务器的第一个消息
     */
    class StartUpGameRequestSdkPmd_C {
        key: string;
        version: number;
        /**
         * 压缩算法
         */
        compress: string;
        /**
         * 加密算法
         */
        encrypt: string;
        /**
         * 加密key
         */
        encryptkey: string;
        GetType(): string;
    }
    /**
     * 返回给区服务器的连接验证状态,这里也发送区信息的原因是考虑游戏服务器可能连接名字验证服务器比连接登录服务器快
     */
    class StartUpGameReturnSdkPmd_S {
        /**
         * 返回成功标志
         */
        ret: boolean;
        /**
         * 返回描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     * 平台信息
     */
    class SdkPlatInfo {
        /**
         * 平台类型编号
         */
        platid: number;
        /**
         * 平台名称
         */
        platname: string;
        GetType(): string;
    }
    /**
     * 平台编号列表
     */
    class GamePlatList {
        /**
         * 游戏类型
         */
        gamezone: Pmd.GameZoneInfo;
        /**
         * 平台编号列表
         */
        Platinfo: SdkPlatInfo[];
        GetType(): string;
    }
    /**
     * 当前支持的平台个数
     */
    class SupportGamePlatListSdkPmd_S {
        /**
         * 支持的平台编号列表
         */
        list: GamePlatList[];
        GetType(): string;
    }
    /**
     * 玩家登录平台的基础信息
     */
    class PlatBaseData {
        /**
         * 游戏类型
         */
        gamezone: Pmd.GameZoneInfo;
        /**
         * 这个需要在后面的返回中原样返回，用于游戏平台查找对应的客户端连接,登录验证时充当logintempid
         */
        myaccid: number;
        /**
         * 平台编号
         */
        platid: number;
        /**
         * 子平台编号
         */
        subplatid: number;
        /**
         * 需要回传给游戏客户端，渠道相关的信息都在这个字段，账号信息,如果是ID，也需要转换成字符串，如果是id和account都有，就需要&quot;id|account&quot;链接
         */
        plataccount: string;
        /**
         * 需要回传给游戏客户端,玩家SESSION，或者创建订单时的签名,部分平台有这个
         */
        session: string;
        /**
         * 扩展数据长度
         */
        extdata: string;
        /**
         * 扩展数据长度
         */
        extdata1: string;
        /**
         * 此账号是游客账号转正式账号时的游客账号，只有第一转的时候有用；@20160628现用于存储unionid
         */
        oldplataccount: string;
        /**
         * 平台昵称
         */
        nickname: string;
        /**
         * 平台头像
         */
        faceurl: string;
        /**
         * sdk服务器临时编号
         */
        sdkserverid: number;
        /**
         * @20160628如果当前是通过微信移动授权，则该字段返回相应的微信公众号授权的platid
         */
        oldplatid: number;
        /**
         * 客户端类型，http：0， 1为新的http tcp:为2
         */
        clienttype: number;
        /**
         * 机型号相关imei
         */
        imei: string;
        /**
         * 系统名称
         */
        osname: string;
        /**
         * 游戏属性，根据需要存取，json字符串{&quot;inviterid&quot;:20982032},{&quot;roomid&quot;:&quot;3001_100506&quot;}
         */
        gameprops: string;
        /**
         * 性别，1男，2女， 0未知
         */
        gender: number;
        /**
         * 渠道appid
         */
        platappid: string;
        /**
         * 绑定其他账号 绑定码
         */
        bindcode: string;
        GetType(): string;
    }
    /**
     * 玩家请求登录给sdk服务器
     */
    class UserLoginPlatRequestSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 标志出PlatBaseData里面session的格式,默认0是json,1表示字符串
         */
        sessiontype: number;
        /**
         * 操作类型 默认为登录校验、1为游戏服过来请求绑定校验  -- 需要原样返回
         */
        optype: number;
        GetType(): string;
    }
    /**
     * 针对已登录的玩家要求重新授权，授权的渠道可能跟登录的渠道不一致，用以使用其他渠道支付，发红包等（比如：支付宝领红包）
     */
    class RequestReAuthSdkPmd_C {
        /**
         * 玩家平台账号基础信息，
         */
        data: PlatBaseData;
        sessiontype: number;
        session: string;
        /**
         * 如果platbasedata里面不方便临时修改渠道ID，则存在此处指定需要授权的渠道
         */
        platid: number;
        GetType(): string;
    }
    /**
     * 重新授权返回
     */
    class ReturnReAuthSdkPmd_S {
        data: PlatBaseData;
        /**
         * 新渠道ID
         */
        platid: number;
        /**
         * 新渠道账号
         */
        plataccount: string;
        /**
         * 渠道账号的相关信息
         */
        session: string;
        /**
         * 0成功
         */
        ret: number;
        /**
         * 描述
         */
        retdesc: string;
        GetType(): string;
    }
    class RequestUnbundingSdkPmd_CS {
        data: PlatBaseData;
        platid: number;
        charid: number;
        ret: number;
        retdesc: string;
        GetType(): string;
    }
    /**
     * 渠道请求处罚或解除处罚玩家,(游戏返回处理结果的协议中原来传过去的数据最好原样返回)
     */
    class PlatRequestPunishSdkPmd_CS {
        /**
         * 渠道账号存在的话会传入到plataccount
         */
        data: PlatBaseData;
        sdktmpid: number;
        clientid: number;
        /**
         * 可能根据角色名称查询
         */
        charname: string;
        /**
         * 角色ID
         */
        charid: number;
        /**
         * 1处罚2解除处罚
         */
        action: number;
        /**
         * 处罚类型1警告，2禁言，3自言自语，4关禁闭，5踢下线，6封号,7提出房间，8拉黑(拉黑后不能再登录，解除或者到期后才能登录)
         */
        ptype: number;
        /**
         * 开始时间戳
         */
        stime: number;
        /**
         * 结束时间戳
         */
        etime: number;
        /**
         * 原因
         */
        reason: string;
        /**
         * 游戏处理本次请求的结果0,成功，其他失败
         */
        ret: number;
        /**
         * 失败描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     * 玩家请求登录从sdk服务器返回
     */
    class UserLoginPlatReturnSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 返回状态,0表示成功,其他参考HttpReturnCode
         */
        ret: number;
        /**
         * 错误描述
         */
        retdesc: string;
        /**
         * sdk告知登录服 玩家是否需要二次绑定 1需要
         */
        reauth: number;
        /**
         * 操作类型 默认为登录校验、1为游戏服过来请求绑定校验
         */
        optype: number;
        GetType(): string;
    }
    /**
     * 创建订单号，有些需要于第三方沟通，有的不需要
     */
    class CreatePlatOrderRequestSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 用户在游戏内部游戏服上的角色ID
         */
        roleid: number;
        /**
         * 用户在游戏内部游戏服上的角色名称
         */
        rolename: string;
        /**
         * 原价(格式:0.00),购买时应用传入的单价*总数,总原价
         */
        originalmoney: number;
        /**
         * 实际价格(格式:0.00),购买时应用传入的单价*总数,总实际 价格
         */
        ordermoney: number;
        /**
         * 用户买了什么商品
         */
        goodid: number;
        /**
         * 用户买了多少个
         */
        goodnum: number;
        /**
         * 商品名称
         */
        goodname: string;
        /**
         * 商品描述
         */
        gooddesc: string;
        /**
         * 客户端跳转url
         */
        redirecturl: string;
        /**
         * 支付平台id
         */
        payplatid: number;
        /**
         * 做了兼容，方便以后别的平台有特殊需求
         */
        extdata: string;
        /**
         * 渠道上配置的商品ID
         */
        appgoodid: string;
        /**
         * 角色等级，add at 20161102
         */
        rolelevel: number;
        /**
         * 不填或0或1表示支付宝,2表示微信,之后再加网银等
         */
        subplatid: number;
        GetType(): string;
    }
    /**
     * 创建订单号，有些需要于第三方沟通，有的不需要
     */
    class CreatePlatOrderReturnSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 用户在游戏内部游戏服上的角色ID
         */
        roleid: number;
        /**
         * 原价(格式:0.00),购买时应用传入的单价*总数,总原价
         */
        originalmoney: number;
        /**
         * 实际价格(格式:0.00),购买时应用传入的单价*总数,总实际 价格
         */
        ordermoney: number;
        /**
         * 需要回传给客户端，实际的游戏内加的道具id,0表示货币
         */
        goodid: number;
        /**
         * 实际的游戏内加的道具数量,实际上是游戏货币的数量
         */
        goodnum: number;
        /**
         * 返回值,0表示成功,1表示失败
         */
        result: number;
        /**
         * 需要回传给客户端，回调通知url,sdk回调地址
         */
        noticeurl: string;
        /**
         * 渠道订单号
         */
        platorder: string;
        /**
         * 需要回传给客户端，客户端传给第三方支付时所需签名
         */
        sign: string;
        /**
         * 客户端跳转url
         */
        redirecturl: string;
        /**
         * 支付平台id
         */
        payplatid: number;
        /**
         * 做了兼容，方便以后别的平台有特殊需求
         */
        extdata: string;
        /**
         * 需要回传给客户端，用户买了什么商品,苹果商店等配置的id,客户端用
         */
        appgoodid: string;
        /**
         * 已废弃,兼容使用
         */
        gamemoneyold: string;
        /**
         * 用户买的商品,能换多少游戏币,只用来客户端显示,棋牌游戏为筹码
         */
        gamemoney: number;
        /**
         * 需要回传给客户端，订单创建时间，用字符串兼容所有格式的时间
         */
        createtime: string;
        rolelevel: number;
        GetType(): string;
    }
    class Bankcard {
        /**
         * 银行卡ID, 暂时不用
         */
        id: number;
        /**
         * 银行名称
         */
        name: string;
        /**
         * 支行名称
         */
        branch: string;
        /**
         * 省份
         */
        province: string;
        /**
         * 城市
         */
        city: string;
        /**
         * 开户名
         */
        username: string;
        /**
         * 卡号
         */
        cardno: string;
        /**
         * 银行卡在支付宝的索引, 暂时不用
         */
        cardindex: string;
        GetType(): string;
    }
    class RequestDrawcashSdkPmd_CS {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 提现金额，单位分
         */
        amount: number;
        /**
         * 用户在游戏内部游戏服上的角色ID
         */
        roleid: number;
        /**
         * 用户在游戏内部游戏服上的角色名称
         */
        rolename: string;
        /**
         * 提现平台ID
         */
        platid: number;
        /**
         * 银行卡信息
         */
        card: Bankcard;
        /**
         * 0申请成功，其他失败
         */
        retcode: number;
        /**
         * 失败描述
         */
        retdesc: string;
        GetType(): string;
    }
    class DrawcashResultSdkPmd_CS {
        /**
         * 基础数据
         */
        data: PlatBaseData;
        /**
         * 游戏提现订单
         */
        gameorder: string;
        /**
         * 平台提现订单，
         */
        platorder: string;
        /**
         * 提现金额
         */
        amount: number;
        platid: number;
        /**
         * 提现结果，0成功，其他失败
         */
        retcode: number;
        /**
         * 提现失败描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     *  代理通知游戏服有玩家充值
     *  对于协议里面的部分字段，比如玩家ID，商品ID等字段需要看平台充值协议，可能平台只能提供一个订单ID参数。
     *  这时候就在平台上实现内部订单号生成，通过订单号来查找这些信息。
     *  平台回调sdk后通知游戏,AS2PSRechargeCommand
     */
    class NotifyRechargeRequestSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 平台订单号
         */
        platorder: string;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 用户在游戏内部游戏服上的角色ID
         */
        roleid: number;
        /**
         * 原价(格式:0.00),购买时应用传入的单价*总数,总原价
         */
        originalmoney: number;
        /**
         * 实际价格(格式:0.00),购买时应用传入的单价*总数,总实际 价格
         */
        ordermoney: number;
        /**
         * 用户买了什么商品
         */
        goodid: number;
        /**
         * 用户买了多少个
         */
        goodnum: number;
        /**
         * 购买状态, 1, 处理中;2 支付成功;3支付失败,4登录失效,5表示金额是查询的余额
         */
        result: number;
        /**
         * 扩展数据长度
         */
        extdata: string;
        /**
         * 充值类型，0玩家充值，1沙箱充值（非rmb充值）,2玩家补偿
         */
        type: number;
        /**
         * 角色等级，游戏转发给monitor的时候加上角色等级
         */
        rolelevel: number;
        GetType(): string;
    }
    /**
     * 平台回调sdk后通知游戏平台,PS2ASRechargeCommand
     */
    class NotifyRechargeReturnSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 平台订单号
         */
        platorder: string;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 用户在游戏内部游戏服上的角色ID
         */
        roleid: number;
        /**
         * 购买状态, 0, 支付成功, 1, 处理中;2 支付成功(兼容老版本);3支付失败
         */
        result: number;
        /**
         * 扩展数据长度
         */
        extdata: string;
        GetType(): string;
    }
    /**
     * ISO用，玩家请求充值后通知sdk服务器去苹果服务器查询,PS2ASRechargeQueryCommand
     */
    class RechargeQueryRequestIOSSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 用户在游戏内部游戏服上的角色ID
         */
        roleid: number;
        /**
         * 原价(格式:0.00),购买时应用传入的单价*总数,总原价
         */
        originalmoney: number;
        /**
         * 实际价格(格式:0.00),购买时应用传入的单价*总数,总实际 价格
         */
        ordermoney: number;
        /**
         * 查询凭证
         */
        token: string;
        /**
         * 扩展数据长度
         */
        extdata: string;
        /**
         * 支付平台
         */
        payplatid: number;
        GetType(): string;
    }
    /**
     * 第三方平台帐号中剩余点数查询请求
     */
    class RequestQueryPlatPointSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        GetType(): string;
    }
    /**
     * 第三方平台帐号中剩余点数返回
     */
    class ReturnQueryPlatPointSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 剩余点数
         */
        balance: number;
        /**
         * 登录结果, 0 表示成功
         */
        ret: number;
        /**
         * 返回描述
         */
        retdesc: string;
        money: number;
        GetType(): string;
    }
    /**
     * 第三方平台帐号中点数兑换请求
     */
    class RequestRedeemPlatPointSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 游戏商品id
         */
        goodid: number;
        /**
         * 以分为单位的人民币
         */
        money: number;
        /**
         * 一个扩展字段方便特殊平台
         */
        extdata: string;
        GetType(): string;
    }
    /**
     * 第三方平台帐号中点数兑换返回
     */
    class ReturnRedeemPlatPointSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 游戏商品id
         */
        goodid: number;
        /**
         * 以分为单位的人民币
         */
        money: number;
        /**
         * 玩家第三方平台所剩余点数
         */
        balance: number;
        /**
         * 登录结果, 0 表示成功, 1表示失败
         */
        ret: number;
        /**
         * 返回描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     * 将本平台游戏币兑换成第三方平台币请求
     */
    class RequestRedeemBackPlatPointSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 兑出平台货币
         */
        point: number;
        /**
         * 以分为单位的人民币
         */
        money: number;
        /**
         * 一个扩展字段方便特殊平台
         */
        extdata: string;
        GetType(): string;
    }
    /**
     * 将本平台游戏币兑换成第三方平台币返回
     */
    class ReturnRedeemBackPlatPointSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 玩家第三方平台所剩余点数
         */
        balance: number;
        /**
         * 以分为单位的人民币
         */
        money: number;
        /**
         * 登录结果, 0 表示成功, 1表示失败
         */
        ret: number;
        /**
         * 返回描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     * 公共的错误返回，方便调试
     */
    class ReturnErrorCodeSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 登录结果, 0 表示成功
         */
        ret: number;
        /**
         * 返回描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     * 请求绑定账号
     */
    class RequestBindAccountSdkPmd_CS {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 登录结果, 0 表示成功,1表示已经绑定过，2表示账号已经注册过
         */
        ret: number;
        GetType(): string;
    }
    /**
     * 平台基础信息
     */
    class PlatAccountInfo {
        /**
         * 平台编号
         */
        platid: number;
        /**
         * 账号信息,如果是ID，也需要转换成字符串，如果是id和account都有，就需要&quot;id|account&quot;链接
         */
        plataccount: string;
        /**
         * 平台名称
         */
        platname: string;
        GetType(): string;
    }
    /**
     * 账号绑定信息查询
     */
    class RequestBindPlatInfoSdkPmd_CS {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 已绑定平台信息
         */
        bindplat: PlatAccountInfo[];
        /**
         * 0 表示查询成功,1表示数据查询失败
         */
        ret: number;
        GetType(): string;
    }
    /**
     * 能过平台id与plataccount查对应玩家uid
     */
    class RequestAccidByPlatinfoSdkPmd_CS {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 请求平台玩家对应基础信息
         */
        reqdata: PlatBaseData[];
        /**
         * 0 表示查询成功,1表示数据查询失败
         */
        ret: number;
        GetType(): string;
    }
    /**
     * 解除第三方账号绑定
     */
    class RequestUnbindAccountSdkPmd_CS {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 登录结果, 0 表示成功,1表示未绑定过
         */
        ret: number;
        GetType(): string;
    }
    /**
     * 积分墙通知
     */
    class NotifyTapJoyRequestSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 积分
         */
        point: number;
        /**
         * 类型1.Zombie_Offerwall 2.Mission_Complete
         */
        placement: number;
        /**
         * 扩展字段(备用)
         */
        extdata: string;
        GetType(): string;
    }
    /**
     * 消息推送
     */
    class PushMsgRequestSdkPmd_C {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 消息ID，方便游戏处理返回值
         */
        msgid: number;
        /**
         * 设备标识
         */
        tokens: string[];
        /**
         * 推送标题
         */
        title: string;
        /**
         * 推送的消息内容
         */
        message: string;
        /**
         * 预留
         */
        extdata: string;
        GetType(): string;
    }
    /**
     * 消息推送
     */
    class PushMsgReturnSdkPmd_S {
        /**
         * 玩家登录平台的基础信息
         */
        data: PlatBaseData;
        /**
         * 消息ID
         */
        msgid: number;
        ret: number;
        retdesc: string;
        GetType(): string;
    }
    /**
     * 绑定手机号
     */
    class BindAccountPhoneSdkPmd_CS {
        /**
         * 玩家账号基础信息
         */
        data: PlatBaseData;
        /**
         * 玩家手机号
         */
        phone: string;
        /**
         * 验证码，如不填，则表示请求验证码
         */
        code: string;
        /**
         * 返回, 0成功，1验证码错误, 2手机已绑定，3系统错误, 4请求次数太多,5该账号已绑定
         */
        ret: number;
        /**
         * 描述
         */
        retdesc: string;
        GetType(): string;
    }
    class RequestMobileRegistRandCodeSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 客户端填写的手机号
         */
        mobilenum: string;
        /**
         * 随机码, 服务器生成的随机号传给sdkserver发短信，客户端无视
         */
        randcode: string;
        /**
         * 登录临时编号,如果sdkserver出现错误,返回时用,服务器间使用,客户端无视
         */
        logintempid: number;
        /**
         * 登录临时编号,服务器用来标识客户端类别,客户端无视
         */
        clienttype: number;
        /**
         * 返回, 0成功，
         */
        ret: number;
        /**
         * 描述
         */
        retdesc: string;
        GetType(): string;
    }
    class RequestWechatMsgSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 微信推送的taskid,原样返回，否则找不到微信请求的连接
         */
        clientid: number;
        /**
         * 微信请求的requesturi
         */
        requesturi: string;
        /**
         * 微信推送的内容,即post的body
         */
        postbody: string;
        /**
         * 处理结果，0成功，其他是吧
         */
        retcode: number;
        /**
         * 返回内容，sdk将会原样传给微信
         */
        retdesc: string;
        /**
         * sdk的tempid，这个是给loginserver转发使用
         */
        sdktmpid: number;
        GetType(): string;
    }
    class SdkUserInfo {
        /**
         * 区服ID
         */
        zoneid: number;
        /**
         * 区服名称
         */
        zonename: string;
        /**
         * 角色ID
         */
        roleid: number;
        /**
         * 角色名称
         */
        rolename: string;
        phone: string;
        /**
         * 累计充值金额，单位分
         */
        money: number;
        /**
         * 当前金币数
         */
        gold: number;
        /**
         * 累计赢取金币数
         */
        wingold: number;
        /**
         * 百人场赢取金币数
         */
        z100wingold: number;
        /**
         * 森林舞会赢取金币数
         */
        zslwingold: number;
        /**
         * 标准场局数
         */
        playtimes: number;
        /**
         * 注册时间
         */
        createtime: number;
        /**
         * 奖励ID，没有奖励用0
         */
        rewardid: number;
        /**
         * 渠道账号
         */
        plataccount: string;
        /**
         * 胜的次数
         */
        wintimes: number;
        /**
         * 是否首次登录0否，1是
         */
        firstlogin: number;
        GetType(): string;
    }
    class SearchUserListSdkPmd_CS {
        /**
         * 可能没有区服ID，只有Gameid和平台账号plataccount
         */
        data: PlatBaseData;
        /**
         * 客户端ID，游戏原样返回即可
         */
        clientid: number;
        /**
         * 角色列表
         */
        users: SdkUserInfo[];
        /**
         * 角色ID,可能为0
         */
        roleid: number;
        sdktmpid: number;
        /**
         * 设备标识
         */
        imei: string;
        channel: string;
        phone: string;
        GetType(): string;
    }
    class QueryGamezoneListSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 返回的区服信息
         */
        rdata: Pmd.GameZoneInfo[];
        clientid: number;
        sdktmpid: number;
        GetType(): string;
    }
    class RoomNode {
        gameid: number;
        gamename: string;
        zoneid: number;
        zonename: string;
        roomid: number;
        roomnode: string;
        ip: string;
        port: number;
        GetType(): string;
    }
    /**
     * 游戏启动向渠道注册
     */
    class ServerRegisterSdkPmd_CS {
        data: PlatBaseData;
        node: RoomNode;
        ret: number;
        retdesc: string;
        GetType(): string;
    }
    /**
     * 游戏向渠道发送心跳包
     */
    class ServerHeartBeatSdkPmd_CS {
        data: PlatBaseData;
        node: RoomNode;
        ret: number;
        retdesc: string;
        GetType(): string;
    }
    /**
     * 冻结数据
     */
    class BookData {
        /**
         * 渠道账号唯一标识
         */
        plataccount: string;
        /**
         * 冻结游戏币数
         */
        amount: number;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 交易类型
         */
        txtypeid: number;
        /**
         * 标识
         */
        remark: string;
        /**
         * 渠道订单号，冻结后返回，（部分渠道可能没有返回）
         */
        platorder: string;
        /**
         * 当前玩家可冻结金额数，冻结后返回
         */
        balance: number;
        /**
         * 当前冻结的总数
         */
        bookamount: number;
        GetType(): string;
    }
    /**
     * 请求渠道冻结玩家部分游戏币
     */
    class BookTransactionSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 冻结数据
         */
        bdata: BookData[];
        /**
         * 0标识成功，其他失败
         */
        ret: number;
        /**
         * 描述
         */
        retdesc: string;
        GetType(): string;
    }
    /**
     * 结算数据
     */
    class BatchData {
        plataccount: string;
        /**
         * 1加钱， 2减钱
         */
        debit: number;
        /**
         * 加减数额
         */
        amount: number;
        gameorder: string;
        platorder: string;
        txtypeid: number;
        remark: string;
        GetType(): string;
    }
    /**
     * 玩家离开时请求渠道进行玩家游戏结算
     */
    class BatchTransactionSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 解冻之前冻结的游戏币，此处子所以是字符串，为了兼容不同渠道
         */
        unbookorders: string[];
        /**
         * 结算类型
         */
        txtypeid: number;
        remark: string;
        bdata: BatchData[];
        ret: number;
        retdesc: string;
        GetType(): string;
    }
    class AndroidData {
        /**
         * 渠道唯一标识
         */
        plataccount: string;
        /**
         * 可能渠道会传机器人ID
         */
        charid: number;
        charname: string;
        /**
         * 性别
         */
        gender: number;
        /**
         * 机器人玩的局数
         */
        drawnum: number;
        /**
         * 当前积分、金币、钻石
         */
        score: number;
        /**
         * 当小于等于改积分时出局
         */
        outscore: number;
        /**
         * 休息时间
         */
        reposetime: number;
        /**
         * 服务时间
         */
        servicetime: number;
        /**
         * 状态，0整除，1禁止
         */
        state: number;
        /**
         * 入座率
         */
        sitrate: number;
        /**
         * 幸运值
         */
        luckyvalue: number;
        /**
         * ai等级
         */
        robotlevel: number;
        /**
         * ai明细，不一定有
         */
        robotai: string;
        GetType(): string;
    }
    class AndroidConfigSdkPmd_CS {
        data: PlatBaseData;
        node: RoomNode;
        anddata: AndroidData[];
        ret: number;
        retdesc: string;
        GetType(): string;
    }
    class NotifyPreLoginInfoSdkPmd_CS {
        data: PlatBaseData;
        GetType(): string;
    }
    class PlatCreateRoleSdkPmd_CS {
        data: PlatBaseData;
        GetType(): string;
    }
    class CreatePlatAccountSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 不带渠道前缀
         */
        account: string;
        passwd: string;
        /**
         * 1男2女0未知
         */
        gender: number;
        /**
         * 0成功，其他失败
         */
        ret: number;
        /**
         * 失败描述
         */
        desc: string;
        sdktmpid: number;
        /**
         * 所创建的账号归属哪个渠道
         */
        platid: number;
        GetType(): string;
    }
    class ChangePlatPasswdSdkPmd_CS {
        data: PlatBaseData;
        account: string;
        /**
         * 新密码
         */
        passwd: string;
        /**
         * 所修改账号归属的渠道
         */
        platid: number;
        ret: number;
        desc: string;
        sdktmpid: number;
        GetType(): string;
    }
    class PlatQueryCoinRecordSdkPmd_CS {
        data: PlatBaseData;
        platid: number[];
        /**
         * 0所有事务，6转入，7转出, 8输赢, 9活动
         */
        optype: number;
        /**
         * 时间
         */
        start: number;
        end: number;
        curpage: number;
        perpage: number;
        maxpage: number;
        /**
         * 金币变动日志
         */
        rdata: UserCoinRecord[];
        retcode: number;
        retdesc: string;
        sdktmpid: number;
        clientid: number;
        total: number;
        GetType(): string;
    }
    class UserCoinRecord {
        recordid: number;
        charid: number;
        charname: string;
        platid: number;
        plataccount: string;
        optype: number;
        /**
         * 子类型
         */
        acttype: number;
        /**
         * 类型名称
         */
        typename: string;
        /**
         * 行为ID、道具ID、房间类型ID等
         */
        actid: number;
        /**
         * 行为名称、道具名称、房间类型等
         */
        actname: string;
        /**
         * 行为次数、道具数量、房间id等
         */
        actnum: number;
        /**
         * 产出、消耗的货币ID, 赠送和购买的需要通过ID来区分
         */
        coinid: number;
        /**
         * 产出消耗前的数量
         */
        coinpre: number;
        /**
         * 产出、消耗的货币数量
         */
        coinnum: number;
        /**
         * 产出、消耗后剩余的数量
         */
        coinsuf: number;
        subgameid: number;
        /**
         * 牌局ID，如果有则填入,否则填0
         */
        roundid: number;
        /**
         * 记录时间，字符串
         */
        recordtime: string;
        /**
         * 如果是兑入兑出，则加上订单号
         */
        order: string;
        GetType(): string;
    }
    /**
     * 外层消息的gameid zoneid主要是给登陆服使用，里面包装的协议必须包含相应的gameid, zoneid, platid，否则sdk无法判断该请求所属哪个渠道
     */
    class ForwardCommandSdkPmd_CS {
        /**
         * 必须要有值
         */
        gameid: number;
        /**
         * 可能没有值，如果能获取到区服ID，一定得给该字段赋值
         */
        zoneid: number;
        /**
         * 可能没有值,如果能获取到渠道id，一定得给该渠道赋值
         */
        platid: number;
        /**
         * 包装协议的内容{&quot;do&quot;:&quot;MsgName&quot;,&quot;data&quot;:&quot;{xxxxx}&quot;}
         */
        msg: string;
        /**
         * 登录服用来记录sdk请求时使用
         */
        sdktmpid: number;
        /**
         * sdk接收外面请求时使用
         */
        clientid: number;
        GetType(): string;
    }
    class RequestQrcodeURLSdkPmd_CS {
        /**
         * 玩家基础数据
         */
        data: PlatBaseData;
        /**
         * 角色ID
         */
        roleid: number;
        /**
         * 该字段非渠道基础数据里面的platid,因为基础数据客户端没法传，故加次字段
         */
        platid: number;
        /**
         * 返回二维码地址，为空说明获取二维码失败
         */
        qrcodeurl: string;
        /**
         * 返回地址，为空说明获取二维码失败
         */
        qreurl: string;
        /**
         * 给客户端的回调
         */
        extdata: string;
        /**
         * 过期时间
         */
        timeout: number;
        GetType(): string;
    }
    class DiamondConsumSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 查询某个玩家的累计钻石消耗
         */
        diamond: number;
        /**
         * 0表示sdkclienttask, 1表示sdktask
         */
        taskid: number;
        GetType(): string;
    }
    class RewardData {
        itemtype: number;
        /**
         * 道具、物品ID
         */
        itemid: number;
        /**
         * 道具。物品数量
         */
        itemnum: number;
        GetType(): string;
    }
    class RewardUserSdkPmd_CS {
        /**
         * 里面的zoneid如果为0，则需要游戏判断给哪个区服的角色发奖
         */
        data: PlatBaseData;
        /**
         * 如果此处为空，游戏需要根据taskid自行判断发何种奖励
         */
        rdata: RewardData[];
        /**
         * 0成功，1请求无效，2参数错误，3sig错误，101用户尚未创建角色,102奖励已发,103奖励发放失败,104玩家不符合领取条件
         */
        retcode: number;
        /**
         * 描述
         */
        retdesc: string;
        /**
         * 任务或者奖励ID
         */
        taskid: number;
        /**
         * 角色ID,如果为0，则需要游戏自行判断给哪个角色发奖
         */
        roleid: number;
        /**
         * 发奖订单号
         */
        platorder: string;
        /**
         * 1检查，2发奖，3检查并发奖
         */
        action: number;
        /**
         * sdk 使用,游戏服需返回
         */
        clientid: number;
        /**
         * login 使用,游戏服需返回
         */
        sdktmpid: number;
        GetType(): string;
    }
    class PlatRedeemSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 1兑入，2兑出
         */
        optype: number;
        /**
         * 可能没有值
         */
        gameorder: string;
        /**
         * 可能没有值
         */
        platorder: string;
        /**
         * 分
         */
        money: number;
        /**
         * 积分数,可能没有值
         */
        point: number;
        /**
         * http task id，原样返回该字段值
         */
        clientid: number;
        /**
         * 0兑入成功
         */
        retcode: number;
        /**
         * 描述
         */
        retdesc: string;
        /**
         * 为了sdk返回
         */
        sdktmpid: number;
        /**
         * 请求带入带出的游戏id，作为平台时用
         */
        cpid: number;
        GetType(): string;
    }
    class PlatQueryBalanceSdkPmd_CS {
        data: PlatBaseData;
        money: number;
        point: number;
        clientid: number;
        retcode: number;
        retdesc: string;
        /**
         * 为了sdk返回
         */
        sdktmpid: number;
        cpid: number;
        GetType(): string;
    }
    class GameRecord {
        charid: number;
        charname: string;
        platid: number;
        sceneid: number;
        roomid: number;
        /**
         * 投注
         */
        bet: number;
        /**
         * 派彩
         */
        payout: number;
        /**
         * 盈利
         */
        profit: number;
        /**
         * 时间
         */
        time: string;
        /**
         * 玩家登陆IP
         */
        ip: string;
        /**
         * 当时剩余金币
         */
        chips: number;
        /**
         * 牌局ID //20170304新加
         */
        roundid: string;
        /**
         * 投注详情
         */
        betinfo: string;
        /**
         * 牌局结果,开奖明细
         */
        result: string;
        /**
         * 子游戏ID
         */
        gameid: number;
        /**
         * 子游戏名称
         */
        gamename: string;
        /**
         * 是否庄家,0否，1是
         */
        isbanker: number;
        /**
         * 抽水
         */
        pump: number;
        /**
         * 有效投注
         */
        validbet: number;
        GetType(): string;
    }
    class PlatQueryGamerecordSdkPmd_CS {
        data: PlatBaseData;
        platid: number[];
        curpage: number;
        perpage: number;
        maxpage: number;
        rdata: GameRecord[];
        /**
         * http task id，原样返回该字段值
         */
        clientid: number;
        sdktmpid: number;
        /**
         * 时间范围
         */
        start: number;
        /**
         * 时间范围
         */
        end: number;
        /**
         * 牌局ID //20170304新加
         */
        roundid: string;
        /**
         * 派彩范围起始值
         */
        payouts: number;
        /**
         * 派彩范围截止值
         */
        payoute: number;
        /**
         * 服务端返回总条数
         */
        total: number;
        /**
         * 子游戏ID
         */
        subgameid: number;
        GetType(): string;
    }
    /**
     * 香港渠道需求
     * 渠道用户信息
     */
    class PlatUserInfo {
        gameid: number;
        platid: number;
        charid: number;
        charname: string;
        plataccount: string;
        /**
         * 注册时间，字符串
         */
        createtime: string;
        /**
         * 最后一次登录时间，字符串
         */
        lastlogin: string;
        /**
         * 最后一次登录IP,字符串
         */
        lastloginip: string;
        /**
         * 余额
         */
        balance: number;
        /**
         * 累计投注次数
         */
        betnum: number;
        /**
         * 累计投注额
         */
        bet: number;
        /**
         * 累计派彩
         */
        payout: number;
        /**
         * 累计盈余
         */
        profit: number;
        GetType(): string;
    }
    /**
     * 查询用户列表
     */
    class PlatQueryUserListSdkPmd_CS {
        /**
         * 如果基础数据里面指定了Plataccount，则表示查询指定用户的信息,没有的话则查询指定渠道
         */
        data: PlatBaseData;
        /**
         * 子渠道列表
         */
        platid: number[];
        /**
         * 用户列表
         */
        rdata: PlatUserInfo[];
        curpage: number;
        perpage: number;
        maxpage: number;
        clientid: number;
        sdktmpid: number;
        total: number;
        subgameid: number;
        GetType(): string;
    }
    /**
     * 渠道报表数据
     */
    class PlatReport {
        platid: number;
        subplatid: number;
        /**
         * 指定时间内的活跃人数
         */
        dau: number;
        /**
         * 投注人数
         */
        betusers: number;
        /**
         * 投注次数
         */
        betnum: number;
        /**
         * 投注额
         */
        bet: number;
        /**
         * 派彩
         */
        payout: number;
        /**
         * 盈余
         */
        profit: number;
        /**
         * 盈余比例
         */
        percent: number;
        /**
         * 有效投注
         */
        validbet: number;
        GetType(): string;
    }
    /**
     * 查询渠道报表
     */
    class PlatQueryPlatReportSdkPmd_CS {
        data: PlatBaseData;
        platid: number[];
        /**
         * 起始日期
         */
        start: number;
        /**
         * 截止日期
         */
        end: number;
        /**
         * 渠道报表
         */
        rdata: PlatReport[];
        curpage: number;
        perpage: number;
        maxpage: number;
        clientid: number;
        sdktmpid: number;
        total: number;
        /**
         * 子游戏ID
         */
        subgameid: number;
        GetType(): string;
    }
    /**
     * 渠道每日报表数据
     */
    class PlatDailyData {
        date: string;
        platid: number;
        /**
         * 新增用户
         */
        newuser: number;
        /**
         * 活跃用户
         */
        dau: number;
        /**
         * 投注人数
         */
        betusers: number;
        /**
         * 投注次数
         */
        betnum: number;
        /**
         * 投注额
         */
        bet: number;
        /**
         * 派彩
         */
        payout: number;
        /**
         * 盈余
         */
        profit: number;
        /**
         * 盈余比例
         */
        percent: number;
        activesend: number;
        /**
         * 有效投注
         */
        validbet: number;
        GetType(): string;
    }
    /**
     * 渠道每日报表
     */
    class PlatQueryPlatDailySdkPmd_CS {
        data: PlatBaseData;
        /**
         * 渠道列表，回复的数据是这些渠道的综合数据，而不是分渠道的数据
         */
        platid: number[];
        /**
         * 开始日期
         */
        start: number;
        /**
         * 截止日期
         */
        end: number;
        /**
         * 渠道每日报表
         */
        rdata: PlatDailyData[];
        clientid: number;
        sdktmpid: number;
        curpage: number;
        perpage: number;
        maxpage: number;
        total: number;
        /**
         * 子游戏ID
         */
        subgameid: number;
        GetType(): string;
    }
    /**
     * 玩家每日报表
     */
    class PlatUserDailySdkPmd_CS {
        data: PlatBaseData;
        platid: number[];
        /**
         * 时间戳
         */
        start: number;
        /**
         * 时间戳
         */
        end: number;
        /**
         * 玩家每日报表
         */
        rdata: UserDailyData[];
        clientid: number;
        sdktmpid: number;
        curpage: number;
        perpage: number;
        maxpage: number;
        total: number;
        GetType(): string;
    }
    /**
     * 玩家指定日期的报表
     */
    class PlatUserReportSdkPmd_CS {
        data: PlatBaseData;
        plataccount: string[];
        /**
         * 时间戳
         */
        date: number;
        /**
         * 玩家每日报表
         */
        rdata: UserDailyData[];
        clientid: number;
        sdktmpid: number;
        curpage: number;
        perpage: number;
        maxpage: number;
        total: number;
        GetType(): string;
    }
    class UserDailyData {
        /**
         * 日期
         */
        date: string;
        platid: number;
        /**
         * 角色	ID
         */
        charid: number;
        charname: string;
        /**
         * 投注次数
         */
        betnum: number;
        /**
         * 投注额
         */
        bet: number;
        /**
         * 派彩
         */
        payout: number;
        /**
         * 盈余
         */
        profit: number;
        /**
         * 盈余比例
         */
        percent: number;
        GetType(): string;
    }
    class SendRedPackSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 角色ID
         */
        charid: number;
        /**
         * 以分为单位的红包
         */
        money: number;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 活动名称
         */
        actname: string;
        /**
         * 祝福语
         */
        blesswords: string;
        /**
         * 0 表示成功,1发放失败
         */
        ret: number;
        /**
         * 描述
         */
        desc: string;
        /**
         * 0默认红包形式，1企业付款
         */
        sendtype: number;
        GetType(): string;
    }
    class SendWelfareSdkPmd_CS {
        data: PlatBaseData;
        charid: number;
        charname: string;
        /**
         * 发送渠道相关的凭证
         */
        session: string;
        /**
         * 手机号码
         */
        phone: string;
        /**
         * 福利类型，1话费，其他待定
         */
        optype: number;
        /**
         * 发送福利数量，如人民币，单位分
         */
        money: number;
        /**
         * 本次发送的订单号
         */
        gameorder: string;
        /**
         * 祝福语
         */
        blesswords: string;
        ext: string;
        /**
         * 发送完返回，0成功，其他失败
         */
        ret: number;
        /**
         * 发送完返回，失败描述
         */
        desc: string;
        GetType(): string;
    }
    class DecryptDataSdkPmd_CS {
        data: PlatBaseData;
        optype: number;
        /**
         * 原始需解密的数据
         */
        original: string;
        /**
         * 解密后的数据
         */
        decrypt: string;
        ext: string;
        ret: number;
        desc: string;
        code: string;
        GetType(): string;
    }
    class UploadDataSdkPmd_CS {
        data: PlatBaseData;
        charid: number;
        charname: string;
        session: string;
        /**
         * 上传数据的类型，比如积分、金币、排行榜
         */
        optype: number;
        /**
         * 需要上传的数据，游戏自行拼接
         */
        updata: string;
        /**
         * 上传成功0，其他失败
         */
        ret: number;
        desc: string;
        code: string;
        GetType(): string;
    }
    class RequestC2CSendRedPackSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 领取或者发放红包的渠道方账号,可能和登录的账户不一致
         */
        account: string;
        /**
         * 角色ID
         */
        charid: number;
        /**
         * 以分为单位的红包
         */
        money: number;
        /**
         * 游戏订单号
         */
        gameorder: string;
        /**
         * 活动名称
         */
        actname: string;
        /**
         * 祝福语
         */
        blesswords: string;
        /**
         * 0默认红包形式，1企业付款
         */
        sendtype: number;
        /**
         * 回传字段
         */
        extdata: string;
        /**
         * 创建时间
         */
        createtime: string;
        /**
         * 客户端发红包需要的签名
         */
        sign: string;
        /**
         * 回调地址
         */
        notify_url: string;
        /**
         * 是否需要重新授权，0不需要，1需要
         */
        reauth: number;
        /**
         * 0标识可以发红包 其他表示不能发红包
         */
        ret: number;
        /**
         * 返回描述
         */
        desc: string;
        /**
         * 发红包的渠道
         */
        payplatid: number;
        /**
         * 授权需要的参数或签名，json格式
         */
        reauthdata: string;
        GetType(): string;
    }
    class ReturnC2CSendRedPackSdkPmd_CS {
        data: PlatBaseData;
        account: string;
        charid: number;
        money: number;
        /**
         * 该订单需要游戏保存，玩家领取红包的时候需要使用
         */
        gameorder: string;
        /**
         * 该订单需要游戏保存，玩家领取红包的时候需要使用
         */
        platorder: string;
        /**
         * 发红包的时候传来的extdata
         */
        extdata: string;
        /**
         * 0标识发送成功，其他标识发送失败
         */
        ret: number;
        /**
         * 返回描述
         */
        desc: string;
        /**
         * 发红包的渠道
         */
        payplatid: number;
        reauth: number;
        /**
         * 授权需要的参数或签名，json格式
         */
        reauthdata: string;
        GetType(): string;
    }
    class RecvC2CRedPackSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 领取的账户
         */
        account: string;
        charid: number;
        /**
         * 红包金额，单位分
         */
        money: number;
        /**
         * 本次领取的订单号
         */
        gameorder: string;
        /**
         * 上次发红包返回的渠道订单号------特别注意
         */
        platorder: string;
        /**
         * 备注，祝福语，或者红包打款
         */
        blesswords: string;
        extdata: string;
        /**
         * 是否需要重新授权，0不需要，1需要
         */
        reauth: number;
        /**
         * 0成功，其他失败；失败的时候判断是否需要重新授权
         */
        ret: number;
        desc: string;
        /**
         * 发红包的渠道
         */
        payplatid: number;
        /**
         * 授权需要的参数或签名，json格式
         */
        reauthdata: string;
        GetType(): string;
    }
    class RefundC2CRedPackSdkPmd_CS {
        data: PlatBaseData;
        account: string;
        charid: number;
        money: number;
        platorder: string;
        /**
         * 退款原因
         */
        reason: string;
        /**
         * 0标识退款成功
         */
        ret: number;
        /**
         * 描述
         */
        desc: string;
        gameorder: string;
        /**
         * 发红包的渠道
         */
        payplatid: number;
        GetType(): string;
    }
    /**
     * 请求平台签名,不包括下单签名，下单签名在创建订单时会返回
     */
    class PlatSignDataSdkPmd_CS {
        data: PlatBaseData;
        platid: number;
        roleid: number;
        /**
         * 用于区别哪个操作的签名
         */
        action: string;
        /**
         * 需要参与签名的数据，json格式
         */
        signdata: string;
        /**
         * 最终签名
         */
        sign: string;
        /**
         * 部分渠道直接返回链接
         */
        url: string;
        /**
         * 部分渠道需要时间
         */
        time: string;
        extdata: string;
        GetType(): string;
    }
    /**
     * 向某一个游戏请求玩家具体信息
     */
    class RequestUserInfoSdkPmd_SC {
        data: PlatBaseData;
        /**
         * 用户信息
         */
        rdata: PlatUserInfo;
        taskid: number;
        GetType(): string;
    }
    /**
     * 查询用户是否绑定
     */
    class CheckUserInfoBindSdkPmd_CS {
        data: PlatBaseData;
        platid: number;
        roleid: number;
        /**
         * 0绑定，1未绑定
         */
        bind: number;
        taskid: number;
        GetType(): string;
    }
    /**
     * 玩家下注详情
     */
    class UserBettingDetailSdkPmd_CS {
        data: PlatBaseData;
        subgameid: number;
        /**
         * 筛选开始日期
         */
        start: number;
        /**
         * 筛选截止日期
         */
        end: number;
        /**
         * 玩家下注详情
         */
        rdata: UserBettingData[];
        clientid: number;
        sdktmpid: number;
        curpage: number;
        perpage: number;
        maxpage: number;
        retcode: number;
        retdesc: string;
        GetType(): string;
    }
    /**
     * 投注数据
     */
    class UserBettingData {
        /**
         * 账号
         */
        account: string;
        /**
         * 账号ID
         */
        accid: number;
        /**
         * 角色ID
         */
        charid: number;
        charname: string;
        /**
         * 子游戏ID
         */
        subgameid: number;
        /**
         * 子游戏名称
         */
        subgame: string;
        /**
         * 房间ID
         */
        roomid: number;
        /**
         * 牌局ID
         */
        roundid: number;
        /**
         * 带入
         */
        dragin: number;
        /**
         * 带出
         */
        takeout: number;
        /**
         * 盈利
         */
        profit: number;
        /**
         * 抽水
         */
        cut: number;
        /**
         * 时间戳
         */
        ts: number;
        /**
         * 货币类型字符串
         */
        cur: string;
        /**
         * 佣金
         */
        comm: number;
        /**
         * 结束时间
         */
        endtime: number;
        /**
         * 投注ID
         */
        betid: number;
        GetType(): string;
    }
    class PlatQueryRoundDetailSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 牌局ID
         */
        roundid: string;
        rdata: RoundData[];
        retcode: number;
        retdesc: string;
        clientid: number;
        sdktmpid: number;
        GetType(): string;
    }
    class RoundData {
        /**
         * 鱼ID
         */
        fishid: number;
        /**
         * 技能ID
         */
        skillid: number;
        /**
         * 具体描述
         */
        desc: string;
        /**
         * 赔率
         */
        multiple: string;
        /**
         * 击杀数量
         */
        num: number;
        /**
         * 炮台威力
         */
        bulletCost: number;
        /**
         * 获取金额
         */
        chips: number;
        GetType(): string;
    }
    /**
     * 渠道请求修改用户信息
     */
    class PlatModifyUserInfoSdkPmd_CS {
        data: PlatBaseData;
        /**
         * 玩家账号，目前通过myaccid来操作
         */
        account: string;
        charid: number;
        /**
         * 游戏需要原样返回
         */
        clientid: number;
        /**
         * 游戏需要原样返回
         */
        sdktmpid: number;
        /**
         * 6游戏币
         */
        optype: number;
        /**
         * 0设定，1增减（扣除玩家的属性、游戏币需要opnum用负数）
         */
        changetype: number;
        /**
         * 设定、增减数额
         */
        opnum: number;
        /**
         * 0成功，其他标识失败
         */
        retcode: number;
        retdesc: string;
        GetType(): string;
    }
    class PlatQuerySubgamesSdkPmd_CS {
        data: PlatBaseData;
        clientid: number;
        sdktmpid: number;
        games: Pmd.GameZoneInfo[];
        retcode: number;
        retdesc: string;
        GetType(): string;
    }
    /**
     * 查询玩家的消费记录
     */
    class UserPurchaseRecordSdkPmd_CS {
        data: PlatBaseData;
        start: number;
        end: number;
        rdata: PurchaseData[];
        clientid: number;
        sdktmpid: number;
        curpage: number;
        perpage: number;
        maxpage: number;
        retcode: number;
        retdesc: string;
        total: number;
        GetType(): string;
    }
    /**
     * 消费数据
     */
    class PurchaseData {
        account: string;
        accid: number;
        charid: number;
        charname: string;
        gameorder: string;
        platorder: string;
        goodsid: number;
        goodsdesc: string;
        money: number;
        coin: number;
        /**
         * 0成功，1失败
         */
        result: number;
        /**
         * 申请时间戳
         */
        created: number;
        /**
         * 处理时间戳
         */
        updated: number;
        /**
         * 货币单位
         */
        cur: string;
        /**
         * 佣金
         */
        comm: number;
        GetType(): string;
    }
}

/// <reference path="pmd.d.ts" />
/// <reference path="logincommand.d.ts" />
declare module Pmd {
    interface IPlatInfo {
    }
    class HttpPackage {
        /**
         * 消息类型
         */
        do: string;
        /**
         * required any data = 2;						// 应用层消息内容
         *  游戏ID
         */
        gameid: number;
        /**
         * 如果客户端发，服务器照样返回
         */
        zoneid: number;
        /**
         * 可唯一代表一个用户身份的ID，由平台统一生成
         */
        uid: string;
        /**
         * 组合字段：&lt;平台id&gt;::&lt;平台账户&gt;
         */
        sid: string;
        /**
         * 由PlatTokenLoginReturn返回
         */
        unigame_plat_login: string;
        /**
         * 客户端当前UNIX时间戳，单位秒
         */
        unigame_plat_timestamp: number;
        data: any;
        GetType(): string;
    }
    class HttpPackageReturn {
        /**
         * 消息类型
         */
        do: string;
        /**
         * required any data = 2;						// 应用层消息内容
         *  游戏ID
         */
        gameid: number;
        /**
         * 如果客户端发，服务器照样返回
         */
        zoneid: number;
        err_no: Pmd.HttpReturnCode;
        data: any;
        GetType(): string;
    }
    /**
     *  请求区列表【不需要签名】【无时序要求】
     *  返回的内容是ZoneInfoListLoginUserPmd_S的内容，但消息类型标注还是&quot;RequestZoneList&quot;
     *  本消息中的字段均拷贝自ZoneInfoListLoginUserPmd_S，用于接收下行数据，上行请求无须填写
     */
    class RequestZoneList {
        /**
         * 游戏名称,(区别与区名)
         */
        gamename: string;
        /**
         * 游戏编号
         */
        gameid: number;
        zonelist: Pmd.ZoneInfo[];
        GetType(): string;
    }
    /**
     * 选区【必须签名】
     */
    class RequestSelectZone {
        GetType(): string;
    }
    class RequestSelectZoneReturn {
        /**
         * 游戏逻辑服务器的http网关地址
         */
        gatewayurl: string;
        separatezoneuid: boolean;
        uid: number;
        GetType(): string;
    }
    /**
     * 平台登录【不需要签名】
     */
    class PlatTokenLogin {
        /**
         * 平台用户信息
         */
        platinfo: Pmd.PlatInfo;
        GetType(): string;
    }
    class PlatTokenLoginReturn {
        /**
         * 平台用户信息
         */
        platinfo: Pmd.PlatInfo;
        /**
         * 可唯一代表一个用户身份的ID，由平台统一生成
         */
        uid: string;
        /**
         * 组合字段：&lt;平台id&gt;::&lt;平台账户&gt;
         */
        sid: string;
        /**
         * 平台登录密钥，用于上行消息URL签名
         */
        unigame_plat_key: string;
        /**
         * 平台登录token，用于上行消息
         */
        unigame_plat_login: string;
        /**
         * 平台登录token从现在开始多少秒后过期，过期后或服务器返回HttpReturnCode_SignError时客户端需要重新走登录流程
         */
        unigame_plat_login_life: number;
        /**
         * 时区的名字
         */
        timezone_name: string;
        /**
         * unilight服务器时区相对于UTC的时间偏移量，单位秒
         */
        timezone_offset: number;
        GetType(): string;
    }
}

declare module uniLib {
    class Global {
        /**
         * 项目配置
         */
        static gameConfig: GameConfig;
        /**
         * 登录返回信息
         */
        static platTokenLoginReturn: Pmd.PlatTokenLoginReturn;
        /**
         * 服务器登录返回
         */
        static serverLoginState: Pmd.UserLoginReturnOkLoginUserPmd_S;
        static readonly isH5: boolean;
        static readonly isNative: boolean;
        static readonly isWxGame: boolean;
        /**
         * 是否缓存登录数据
         */
        static isCacheToken: boolean;
        /**
         * 是否在游戏中
         */
        static isInGame: boolean;
        static Event(type: string, obj?: any, bubbles?: boolean, cancelable?: boolean): Event;
        static dispatch(type: string, obj?: any, bubbles?: boolean, cancelable?: boolean): void;
        static has(type: string): boolean;
        static on(type: string, listener: Function, thisObject: any, useCapture?: boolean, priority?: number): void;
        static off(type: string, listener: Function, thisObject: any, useCapture?: boolean): void;
    }
}

declare module uniLib {
    /**
     * 游戏配置
     */
    class GameConfig {
        /**
         * 登录url
         */
        login_url: string;
        /**
         * 游戏id
         */
        gameid: number;
        /**
         * 区id
         */
        zoneid: number;
        /**
         * 游戏更新配置url
         */
        config_url: string;
        /**
         * 上传文件服务器url
         */
        upLoad_url: string;
        /**
         * 分享url
         */
        share_url: string;
        /**
         * 商品类型配置
         */
        goods_type: string;
        /**
         * 沙盒模式 0 未开启 1 开启 2 3 4....
         */
        is_sandbox: number;
        /**
         * 是否开启热更新 1开启 0不更新
         */
        hot: number;
        /**
         * 热更超时时间
         */
        hot_timeout: number;
        /**
         * 登录平台id
         */
        platid: number;
        /**
         * 支付平台号
         */
        pay_platid: number;
        /**
         * 微信开放平台appid
         */
        wx_appid: string;
        /**
         * 微信公众平台appid
         */
        wb_appid: string;
        /**
         * 客户端日志是否开启
         */
        log_open: number;
        /**
         * 客户端日志保存数量
         */
        log_num: number;
        /**
         * 客户端日志单个文件大小
         */
        log_size: number;
    }
}

declare module uniLib {
    enum CompressType {
        NONE = 0,
        FLATE = 1,
        ZLIB = 2,
        GZIP = 3,
        LZW = 4,
    }
}

declare module uniLib {
    enum ProtoType {
        JSON = 0,
        PROTOBUF = 1,
    }
}

declare module uniLib {
    class Dispatcher {
        private _funcMap;
        constructor();
        dispatch($noticeType: any, data?: any): boolean;
        addListener(noticeType: any, listener: Function, thisObj: any): void;
        hasListener(noticeType: string): boolean;
        removeListener(noticeType: any, listener: Function, thisObj: any): void;
        private getNoticeIndex(noticeType, listener, thisObj);
    }
}

declare module uniLib {
    /**
     * 自定义事件类
     */
    class Event {
        CLASS_NAME: string;
        private _obj;
        constructor(type: string, obj?: any, bubbles?: boolean, cancelable?: boolean);
        clone(obj?: any): Event;
        toString(): void;
        /**
         * 传参获取
         * @returns {Object}
         */
        readonly param: any;
        type: string;
    }
}

declare module uniLib {
    /**
     * 全局侦听类及消息处理
     */
    class Listener {
        CLASS_NAME: string;
        private static _instance;
        private _dispatcher;
        private isInit;
        constructor();
        static getInstance(): Listener;
        addEventListener(type: string, listener: Function, thisObject: any, useCapture?: boolean, priority?: number): void;
        hasEventListener(type: string): boolean;
        removeEventListener(type: string, listener: Function, thisObject: any, useCapture?: boolean): void;
        dispatchEvent(event: Event): boolean;
        toString(): string;
    }
}

declare module uniLib {
    /**
     * 消息管理器
     */
    class MsgMgr {
        CLASS_NAME: string;
        private static _instance;
        private _dispatcher;
        private isInit;
        constructor();
        static getInstance(): MsgMgr;
        addMsgEvent(msg: string | any, listener: Function, thisObject: any): void;
        hasMsgEvent(msgName: string): boolean;
        rmMsgEvent(msg: string | any, listener: Function, thisObject: any): void;
        doMsgEvent(msgName: string, data: any): boolean;
        toString(): string;
    }
}

declare module uniLib {
    /**
    * 网络管理
    */
    class NetMgr {
        /**
         * http连接
         */
        static http: HttpClient;
        /**
         * socket代理
         */
        static ws: ISocketDelegate;
        /**
         * 游戏ws代理
         */
        static gws: ISocketDelegate;
        private static _gameid;
        private static _zoneid;
        private static _loginUrl;
        private static _platInfo;
        /**
         * 协议类型
         */
        static PROTO_TYPE: ProtoType;
        /**
         * 开启大厅游戏双链接模式
         */
        static OpenDoubleWs: boolean;
        private static readonly platId;
        static readonly uid: string;
        /**
         * 初始化平台信息
         * @param platinfo
         * @param callBack
         * @param thisObj
         */
        static initPlatInfo(platinfo?: Pmd.PlatInfo): Pmd.PlatInfo;
        private static _inited;
        /**
         * 初始化平台网络连接
         * @method uniLib.NetMgr.init
         * @param url {string} 登陆URL
         * @param gameID {number} 游戏ID
         * @param zoneId {number} 区服ID null:自动选区 -1:不自动选区
         * 后续参数可选,推荐先初始化再使用h5platLogin进行登录
         * @param thisObj  当前对象。永远都this
         */
        static init(login_url: string, gameId: number, zoneId: number, protoType?: ProtoType): void;
        static login(callBack?: Function, loginFail?: Function, thisObj?: any): void;
        /**
         *
         * @param info
         */
        static setLoginTokenInfo(info: Pmd.PlatTokenLoginReturn): boolean;
        /**
         * 获取是否已经有token本地数据, TODO:待加入zoneid信息到token的获取
         * @param onGetToken
         * @param thisObj
         * @param platid
         * @param gameId
         * @param zoneid
         */
        static getLoginTokenInfo(onGetToken?: Function, thisObj?: any, platid?: number, gameId?: number, zoneid?: number): Pmd.PlatTokenLoginReturn;
        /**
         *
         * @param info
         */
        static setServerLoginState(info: Pmd.UserLoginReturnOkLoginUserPmd_S): boolean;
        static getServerLoginState(): Pmd.UserLoginReturnOkLoginUserPmd_S;
        /**
         * 登录游戏
         * @param zoneId
         * @param callBack
         * @param loginFail
         * @param thisObj
         */
        static h5platLogin(zoneId?: number, callBack?: Function, loginFail?: Function, thisObj?: any): void;
        /**
         * 初始化平台socket连接
         * @method uniLib.NetMgr.initSocket
         * @param onLogin {Function} 连接ws成功回调
         * @param onLoginFail {Function} 连接ws失败回调
         * @param chatMessage {Function} 聊天消息接收函数
         * @param thisObj  当前对象。永远都this
         * @param compress  数据压缩类型,当前支持3种:CompressUtils.FLATE, CompressUtils.GZIP, CompressUtils.ZLIB
         * @param encrypt 数据加密类型,当前支持2种：aes
         */
        static loginWs(onLogin?: Function, onLoginFail?: Function, thisObj?: any, gameid?: number, zoneid?: number): void;
        /**
         * 检测到断线重连操作
         */
        static CHECK_RECONNECT_EVENT: string;
        /**
         * 断线重连成功
         */
        static RECONNECTED_EVENT: string;
        private static createWs(url, gameid, zoneid, onLogin, onLoginFail, thisObj, socktType?);
        /**
         * 用户第三方平台uid
         */
        static getThirdPlatId(): any;
        /**
         * 登出
         */
        static logout(): void;
        /**
         * 断开socket连接
         */
        static closeLobbyWs(b?: boolean): void;
        /**
         * 关闭游戏连接
         */
        static closeGameWs(): void;
        static reconnet(): void;
        /**
         * 发送短连接消息
         * @method uniLib.NetMgr.httpSend
         * @param msg {any} 消息内容
         * @param callback {function} 发送消息回调
         * @param compress {function} 数据压缩方式
         */
        static httpSend(msg: any, callback?: (response: any) => any, compress?: CompressType): void;
        /**
         * 发送长连接消息
         * @method uniLib.NetMgr.tcpSend
         * @param msg {any} 消息内容
         */
        static lobbySend(msg: any, timeOut?: number): void;
        /**
         * 发送游戏消息
         * @method uniLib.NetMgr.gameSend
         * @param msg {any} 消息内容
         */
        static gameSend(msg: any, timeOut?: number): void;
    }
}

declare module uniLib {
    /**
     * 基于`HTTP`的json通信
     */
    class HttpClient {
        private ZoneList;
        private _loginUrl;
        GatewayUrl: string;
        private _gameid;
        private _zoneid;
        Debug: boolean;
        private OnResponse;
        constructor();
        /**
         * 初始化登陆信息
         */
        init(url: string, gameID: number, zoneId?: number): void;
        initCallBack(callback?: Function, loginFail?: Function, obj?: any): void;
        private _loginCallBackFunction;
        private _loginFail;
        private _loginCallBackObj;
        /**
         * 登陆平台
         */
        h5platLogin(platInfo: Pmd.PlatInfo, callback?: Function, loginFail?: Function, obj?: any, zoneid?: number): void;
        /**
         * 登陆验证
         * @param callback: 登陆回调
         */
        private login(platinfo);
        private _resq;
        /**
         * 底层消息发送
         * @param message: 消息内容
         * @param callback: 消息响应函数，缺省采用`OnResponse`
         */
        sendTo(message: any, callback: (response: any) => void, error?: any, thisObj?: any, compress?: CompressType, url?: string): void;
        static _reconnectTimes: number;
        private onHttpComplete(msg, callback, compress?);
        private onHttpError(event?, data?);
        /**
         * 登陆
         * @param callback: 登陆返回
         */
        private initLogin(loginType, msg, compress?);
        private loginSelectZone(compress?);
        private loginSuccess(data);
        selectZone(zoneId?: number, callBack?: Function, thisObj?: any, compress?: CompressType): void;
    }
}

declare module uniLib {
    class HttpRequest {
        private _xhr;
        url: string;
        private _call;
        private _err;
        private _this;
        private isOriType;
        private _reqType;
        constructor(callBack?: Function, err?: Function, thisObj?: any, reqType?: string);
        open(url: string, data?: any, isFormData?: boolean): void;
        private _dtype;
        dataFormat: string;
        private onCallBack(e?);
        private onHttpError(e?);
        /**
         * 发送数据
         * @param data
         */
        send(data?: any): void;
        destroy(): void;
    }
}

declare module uniLib {
    class ServerState {
        /**
         * 检查服务端返回状态是否异常
         * @param recv
         * @param errorObj
         */
        static checkServerReturnCodeError(recv: any): boolean;
    }
}

declare module uniLib {
    interface ISocket {
        connect(): any;
        send(data: string | ArrayBuffer, timeOut?: number): any;
        close(): any;
        getState(): any;
        refresh(): any;
        setTick(): any;
    }
}

declare module uniLib {
    interface ISocketDelegate {
        onSocketOpen(): any;
        onSocketMessage(data: string | ArrayBuffer): any;
        onSocketError(errMsg: any): any;
        onSocketClosed(msg: string): any;
        connect(): any;
        closeConnect(): any;
        sendPlat(msg: any, toGame?: number, timeOut?: number): any;
        send(msg: any, toGame?: number, timeOut?: number): any;
        isConnected: SocketState;
        socketTag: WsTag;
        loginSuccess(): any;
        loginFail(): any;
        reconnect(): any;
        sendTick(): any;
        setTick(tickSec: number, tickTimes: number): any;
    }
}

declare module uniLib {
    /**
     * 实现socket各个回调接口
     */
    class JsonSocketDelegate implements ISocketDelegate {
        private _socket;
        private _gameid;
        private _zoneid;
        private _url;
        /**
         * 登录成功，在登录成功时回调，断线重连成功不再回调，断线重连通过事件和注册回调触发
         */
        private _onLogin;
        /**
         * 首次登录失败时触发，或设置了断线重连尝试次数时触发一次。触发完失败后delegate需重新创建或重新走初始化流程
         */
        private _onLoginFail;
        private _thisObj;
        private _onReconnected;
        /**
         * soket类型
        */
        socketTag: WsTag;
        constructor(url: string, gameid: number, zoneid: number, onLogin?: Function, onLoginFail?: Function, thisObj?: any, soketType?: WsTag);
        isSocketOpened(): boolean;
        isSocketClosed(): boolean;
        /**
         * 设置重连回调方法
         */
        onReconnected: Function;
        connect(): void;
        closeConnect(): void;
        readonly isConnected: SocketState;
        onSocketOpen(): void;
        loginSuccess(): void;
        loginFail(): void;
        setTick(tickSec: number, tickTimes: number): void;
        onSocketError(errMsg: any): void;
        onSocketClosed(msg: string): void;
        onSocketMessage(data: string | ArrayBuffer): void;
        dispatchMsg(msg: Pmd.ForwardNullUserPmd_CS | any): void;
        /**
         * 客户端发送心跳
         */
        sendTick(): void;
        sendPlat(msg: any, toGame?: number, timeOut?: number): void;
        send(msg: any, toGame?: number, timeOut?: number): void;
        /**
         * 压缩消息 buffer转msg，解包用
         *
         * @param recvBuf
         */
        private bufferToMsg(recvBuf, msgType);
        /**
         * msg转 压缩buffer
         *
         * @param msg
         */
        private msgToBuffer(msg, msgType);
        reconnect(): void;
    }
}

declare module uniLib {
    /**
 * WebSocket的具体实现
 */
    class WbSocket implements ISocket {
        private _url;
        private _delegate;
        private _webSocket;
        /** 尝试重新连接之前要延迟的毫秒数 */
        private reconnectInterval;
        /** 延迟重新连接尝试的最大毫秒数 */
        private maxReconnectInterval;
        /** 重新连接延迟的增加速率。允许重新连接尝试在问题持续时退出 */
        private reconnectDecay;
        /** 关闭并重试前等待连接成功的最长时间（毫秒） */
        private timeoutInterval;
        /** 尝试重新连接的最大次数。如果为空则无限制 */
        private maxReconnectAttempts;
        /** 自启动或上次成功连接后尝试重新连接的次数 */
        private reconnectAttempts;
        /** 链接状态*/
        private readyState;
        /**
         * 超时
        */
        private timedOut;
        /**
         * 强制关闭
        */
        private forcedClose;
        constructor(url: string, delegate: ISocketDelegate);
        connect(reconnectAttempt?: boolean): void;
        private hasReconnected;
        private reconnect();
        refresh(): void;
        /**
         * 心跳时间
        */
        private tickSec;
        /**
         * 心跳超时次数
        */
        private tickTimes;
        /**
         * 消息超时毫秒
         */
        private msgTimeoutMSec;
        /**
         * 最后接收到消息的时间
         */
        private lastRecvTime;
        private lastSendTick;
        private secondTimer;
        setTick(): void;
        private clearTick();
        private onTickActive();
        private checkReconnect();
        /**
         *
         * @param data {string | ArrayBuffer}
         */
        send(data: string | ArrayBuffer, timeOut?: number): void;
        close(): void;
        getState(): SocketState;
    }
}

declare module uniLib {
    /**
     * 网络状态
     */
    enum SocketState {
        /**
         * 连接中
         */
        CONNECTING = 1,
        /**
         * 已连接
         */
        OPEN = 2,
        /**
         * 断开中
         */
        CLOSING = 3,
        /**
         * 已断开
         */
        CLOSED = 4,
    }
}

declare module uniLib {
    const WS_TAG_STR: string[];
    /**
     * 网络标志
     */
    enum WsTag {
        /**
         * 大厅
         */
        LOBBY = 0,
        /**
         * 游戏
         */
        GAME = 1,
    }
}

declare module uniLib {
    /**
    * 浏览器工具
    */
    class BrowersUtils {
        /**
         * 刷新页面
         */
        static reload(): void;
        static redirect(url: string): void;
        static isLocal(): boolean;
        /**
         * 判断对象是否为Null
         */
        isNull(val: any): boolean;
        /**
         * 是否在微信中打开
         */
        static isWechat(): boolean;
        /**
         * 获取xhr
         */
        static getXHR(): any;
        /**
         * 是否PC
         */
        static isPC(): boolean;
        static isAndroid(): boolean;
        /**
         * 根据参数名获取请求get参数
         * @param name {string} 参数名
         */
        static GetRequest(name: string, str?: string): any;
        static GetRequests(s?: string): any;
        static requestFullScreen(): void;
        static exitFullscreen(): void;
        /**
         * 根据参数名获取cookie值
         * @param name {string} 参数名
         */
        static getCookie(name: any): string;
        /**
         * 根据参数名设置cookie值
         * @param name {string} 参数名
         * @param name {any} cookie过期时间
         */
        static setCookie(name: string, value: any, tm?: number): void;
        /**
         * 根据参数名清除cookie值
         * @param name {string} 参数名
         */
        static delCookie(name?: string): void;
        /**
         * 获取当前url
         */
        static getLocationUrl(): string;
        /**
         * 跳转到目标地址
         * @param url {string} 地址
         */
        static redirectUrl(url: string): void;
        /**
         * 跳转到目标地址
         * @param url {string} 地址
         */
        static parentRedirectUrl(url: string): void;
        /**
         * 当前浏览器类型
         */
        static browersType(): string;
        /**
         * 当前平台类型
         */
        static platformType(): string;
        staticisVertical(): boolean;
    }
}

declare module uniLib {
    function getDefinitionByName(name: string): any;
    function hasDefinition(name: string): boolean;
    function test(name: string): void;
    function delDefinitionByName(name: string): void;
    function getQualifiedSuperclassName(value: any): any;
    function getQualifiedClassName(value: any): any;
}

declare module uniLib {
    /**
     * 设备API
     */
    class DeviceUtils {
        /**
         * 系统名称
         */
        static os_name: string;
        /**
         * 系统版本
         */
        static os_version: string;
        /**
         * 设备唯一标示
         */
        static os_uuid: string;
        static setLocalStorage(ky: string, info: any): void;
        static getLocalStorage(ky: string, onGetCallBack?: Function): any;
        static clearLocalStorage(ky?: string): void;
        static sortJson(old: any): any;
    }
}

declare module uniLib {
    const LOG_TAG_STR: string[];
    const enum LOG_TAG {
        HTTP_SEND = 0,
        HTTP_RECV = 1,
        WS_SEND = 2,
        WS_RECV = 3,
        WS_STATE = 4,
    }
    class Log {
        static log(tag: any, ...args: any[]): void;
        static warn(...args: any[]): void;
        static error(...args: any[]): void;
        private static getDateString();
        private static stack(index?);
    }
}

declare module uniLib {
    class MessageUtils {
        static msgFullnamePmd: any;
        static msgValueFullname: {};
        static msgValueShortname: {};
        static msgValueInstance: {};
        static msgShotNameInstance: {};
        static RegisterCommonCommandType(): void;
        /**
         * 注册cmd消息
         */
        static RegisterCmd(sCmd: any): void;
        /**
         * 注册平台命令类型
         * @param cmd
         * @param sCmd
         */
        static RegisterPlatCommandType(cmd: number, sCmd: any): void;
        static getClassName(objOrCtor: any): string;
        static getMessageName(objOrCtor: any, pmd?: boolean | string): string;
        static getPmdMessageInstance(msgName: string): any;
        static GetMessageInstance(bycmd: number, byparam: number): any;
        static GetMessageInstanceByShortName(shortname: string): any;
        static GetMessageInstanceByFullName(fullname: string): any;
        static GetMessageName(bycmd: number, byparam: number): string;
        static GetMessageShotName(bycmd: number, byparam: number): string;
        static dispatchMsg(msgName: string, data: any, delegate: ISocketDelegate): boolean;
        private static dispatchUnCatchedJsonMsg(msg, delegate);
        private static dispatchUnCatchedMsg(msg, delegate);
        static getPlatSocket(url: string, delegate: ISocketDelegate): ISocket;
        static checkErrorCode(recv: any): boolean;
    }
}


declare module uniLib {
    /**
     * 平台系统工具类
     */
    class PlatUtils {
        static isrebooting: boolean;
        /**
         * 重启游戏
         * @param str 提示内容
         * @param yes 确认按钮
         * @param no  取消按钮
         */
        static restart(str?: any, yes?: string, no?: string): void;
    }
}

declare module uniLib {
    class StringUtils {
        /**
         * 字符串是`undefined`、`null`或`""`
         */
        static stringIsNullOrEmpty(value: string): boolean;
        static MD5(message: string): string;
        static ltrim(s: string): string;
        static rtrim(s: string): string;
        static trim(s: string): string;
        static sTrim(str: string): string;
        static checkPhone(tel: string): boolean;
        static checkEmail(email: string): boolean;
        /**
         * 字符串中查找某字符出现次数的位置
         */
        static getPosition(str: string, searchfor: string, count?: number): number;
        /**
         * 远程url修正
         */
        static validNetUrl(url: string): string;
        /**
         * 格式化货币字符串
         * @param num {number} 需要格式化的数
         * @param em {string} 单位暂时支持 万
         * @param bSplit {boolean} 使用单位分隔符
         * @param sl {number} 格式化单位长度
         */
        static formatCurrency(num: number, em?: string, bSplit?: boolean, sl?: number): string;
        /**
         * IP地址解析为整型
         */
        static ip2int(ip: any): number;
        /**
         * 整型解析为IP地址
         */
        static int2ip(num: any): string;
        /**
     * 获取字符串实际长度
     */
        static getStrRealLength(str: string): number;
        /**
         * 时间转为字符串显示
         */
        static time2str(num: number): string;
        private static getNumStr(num);
        /**
         * 格式化货币字符串
         * @param num {number} 需要格式化的数
         * @param bSplit {boolean} 使用单位分隔符 默认false
         * @param txtLen {number} 货币最大显示长度,通过这个值来自动设置单位
         */
        static formatCurrencyByTotalLen(num: number, bSplit?: boolean, txtLen?: number): string;
        /**
         * 货币格式转为普通字符串
         * @param str {string} 货币格式
         */
        static formatCurrencyNomal(str: string): string;
        /**
         *以"mm:ss"的格式返回时间
         * @param t
         * @return
         *
         */
        static formatMMSS(second: number): string;
        /**
         * 以"hh:mm:ss"的格式返回时间
         * @param t
         * @return
         *
         */
        static formatHHMMSS(second: number, splitTag?: string): string;
        /**
         * 是否是网络地址
         * @param url
         * @returns {boolean}
         */
        static isNetUrl(url: string): boolean;
        static formatDDHHMMSS(second: number, splitTag?: string): string;
        /**
         * 字符串键值对方式转为json
         * @param str
         */
        static getVariables(str: string): any;
        /**
         * 字符串实际长度获取方法
         * @param str
         */
        private getStrRealLngth(str);
        static simplifyNum(num: number): string;
        private static removeZero(str, unit);
        static padLeft(str: string, totalWidth: number, paddingChar: string): string;
        private generateUUID();
    }
}

declare module uniLib {
    class md5 {
        constructor();
        private hexcase;
        private b64pad;
        hex_md5(s: any): string;
        private b64_md5(s);
        private any_md5(s, e);
        private hex_hmac_md5(k, d);
        private b64_hmac_md5(k, d);
        private any_hmac_md5(k, d, e);
        private md5_vm_test();
        private rstr_md5(s);
        private rstr_hmac_md5(key, data);
        private rstr2hex(input);
        private rstr2b64(input);
        private rstr2any(input, encoding);
        private str2rstr_utf8(input);
        private str2rstr_utf16le(input);
        private str2rstr_utf16be(input);
        private rstr2binl(input);
        private binl2rstr(input);
        private binl_md5(x, len);
        private md5_cmn(q, a, b, x, s, t);
        private md5_ff(a, b, c, d, x, s, t);
        private md5_gg(a, b, c, d, x, s, t);
        private md5_hh(a, b, c, d, x, s, t);
        private md5_ii(a, b, c, d, x, s, t);
        private safe_add(x, y);
        private bit_rol(num, cnt);
    }
}
