/*
 * @Author: Kuma
 * @Date: 2022-06-13 16:06:08
 * @LastEditTime: 2022-06-13 16:42:58
 * @LastEditors: Kuma
 * @Description: 
 * 
 */

import { _decorator, Component, Node, Camera, v3 } from 'cc';
const { ccclass, property } = _decorator;
 
@ccclass('Main')
export class Main extends Component {
    @property(Node)
    private cube:Node = null;
    @property(Node)
    private label:Node = null;
    @property(Camera)
    private uiCamera:Camera = null;

    start () {
        this.scheduleOnce(()=>{
            this.fixLabelPosition();
        },1)
    }

    private fixLabelPosition(){
        let wpos = this.cube.getWorldPosition();
        let localPos = v3();
        this.uiCamera.convertToUINode(wpos, this.label.parent!, localPos);
        this.label.setPosition(localPos);
    }

}


