import { initPlatform, platformCtrl } from "./platforms/PlatformCtrl";
import { utils } from "./utils/Utils";

@cc._decorator.ccclass
export default class Main extends cc.Component {
    protected start(): void {
        utils.init();
        initPlatform();
        // const host = "http://localhost/qimiaosenlin/flash2php/5_FormTest/";
        const host = "https://tiny.qimiaosenlin.com/uit/";
        const status = this.node.getChildByName("status").getComponent(cc.Label);
        const logo = this.node.getChildByName("logo").getComponent(cc.Sprite);
        this.node.getChildByName("upload").on(cc.Node.EventType.TOUCH_START, () => {
            platformCtrl.chooseImage(filePath => {
                if (filePath) {
                    platformCtrl.uploadFile(host + "receive.php", filePath, "selectMediaTemp", ["参数1", 666, "参数2", "🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)"], res => {
                        console.log(res);//{参数2: '🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)', 参数1: '666', Status: 0, Desc: '保存文件成功！', file: 'upload/20250611141220.png'}
                        if (res) {
                            if (res.file) {
                                status.string = "上传成功！\n" + res.file;

                                cc.assetManager.loadRemote<cc.Texture2D>(host + res.file, { ext: ".png" }, (err, asset) => {
                                    if (asset) {
                                        logo.spriteFrame = new cc.SpriteFrame(asset);
                                    } else {
                                        console.error("loadRemote 失败：" + err);
                                    }
                                });

                            } else {
                                status.string = res.Desc || "上传失败！";
                            }
                        } else {
                            status.string = "上传出错！";
                        }
                    });
                }
            });
        });
    }
}
