import { Form, KVs, requests } from "../utils/Requests";
import { utils } from "../utils/Utils";

export const platformCtrlClasses: { [key: string]: any } = {};
export let platformCtrl: PlatformCtrl;
export function initPlatform(): PlatformCtrl {
    return window["platformCtrl"] = platformCtrl = new platformCtrlClasses[utils.platformInfo.platform]();
}
export default abstract class PlatformCtrl {
    public async chooseImage(finish: (file: Uint8Array | string) => void) {
        const handle = (await (window as any).showOpenFilePicker({ types: [{ accept: { 'image/*': ['.png', '.gif', '.jpeg', '.jpg', '.webp'] } }] }) as Array<FileSystemFileHandle>)[0];
        finish?.(new Uint8Array(await (await handle.getFile()).arrayBuffer()));
    }
    public uploadFile(url: string, file: Uint8Array | string, name: string, kvs: KVs, finish: (res: { Desc: string, file: string }) => void): void {
        console.log("uploadFile " + url + " " + name + " " + JSON.stringify(kvs));//uploadFile https://tiny.qimiaosenlin.com/uit/receive.php selectMediaTemp ["参数1",666,"参数2","🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)"]
        const form = new Form();
        form.append(name, file, "file");
        let i: number = kvs?.length;
        if (i) {
            while ((i -= 2) >= 0) {
                form.append(kvs[i] as string, kvs[i + 1] as string);
            }
        }
        requests.post(url, res => {
            console.log(res);//{"\u53c2\u65702":"\ud83d\udde1\ufe0f1\u0f06\u82cd\u0f12\u767d2\u4e443\u4eba\ud83c\ude33\ud83d\ude0a\u261c\ud83d\udc1f\u53e3\ud83d\udc33\u624b\u03e8\u86a0\u4240\u9680\ue100\uca00\u263b\u263a\ud83d\udc20\u2b50\u10da(\u2032\u25c9\u2765\u25c9\uff40\u10da)","\u53c2\u65701":"666","Status":0,"Desc":"\u4fdd\u5b58\u6587\u4ef6\u6210\u529f\uff01","file":"upload\/20250611141220.png"}
            finish?.(JSON.parse(res));
        }, form);
    }
}