import { nativeTS } from "../utils/NativeTS";
import { KVs } from "../utils/Requests";
import PlatformCtrl, { platformCtrlClasses } from "./PlatformCtrl";

export default class PlatformCtrlApp extends PlatformCtrl {
    private chooseImageFinish: (filePath: string) => void;
    public constructor() {
        super();

        nativeTS.onNative2TS = args => {
            switch (args.op) {
                case "chooseImageFinish":
                    if (this.chooseImageFinish) {
                        this.chooseImageFinish((args as any).filePath as string);
                        this.chooseImageFinish = null;
                    }
                    break;
                default:
                    console.error("未处理的 op：" + args.op);
                    break;
            }
        };
    }
    public async chooseImage(finish: (file: string) => void) {
        this.chooseImageFinish = finish;
        nativeTS.ts2native("chooseImage");
    }
    public uploadFile(url: string, file: string, name: string, kvs: KVs, finish: (res: { Desc: string, file: string }) => void): void {
        super.uploadFile(url, jsb.fileUtils.getDataFromFile(file), name, kvs, finish);
    }
}
platformCtrlClasses["android"] = PlatformCtrlApp;