import { KVs, requests } from "../utils/Requests";
import PlatformCtrl, { platformCtrlClasses } from "./PlatformCtrl";

export default class PlatformCtrlWX extends PlatformCtrl {
    public async chooseImage(finish: (file: string) => void) {
        if (wx.chooseMedia) {
            wx.chooseMedia({
                count: 1,
                mediaType: ["image"],
                sourceType: ["album"],
                success: res => {
                    console.log("chooseMedia success", JSON.stringify(res, undefined, "\t"));
                    // {
                    //     "errMsg": "chooseMedia:ok",
                    //     "failedCount": 0,
                    //     "type": "image",
                    //     "tempFiles": [
                    //         {
                    //             "tempFilePath": "http://tmp/Zv07dwBxPL0ye321669fd1a4cddbfd802aff6938fad3.png",
                    //             "size": 43438,
                    //             "fileType": "image"
                    //         }
                    //     ]
                    // }
                    const tempFile = res.tempFiles?.[0];
                    if (tempFile?.fileType == "image") {
                        if (tempFile.tempFilePath) {
                            console.log("tempFilePath=" + tempFile.tempFilePath);//http://tmp/Zv07dwBxPL0ye321669fd1a4cddbfd802aff6938fad3.png
                            finish?.(tempFile.tempFilePath);
                            return;
                        } else {
                            console.error("选取文件失败！");
                        }
                    } else {
                        console.error("文件类型不正确：" + tempFile?.fileType);
                    }
                    finish?.(null);
                },
                fail: res => {
                    console.error("chooseMedia fail", JSON.stringify(res, undefined, "\t"));
                    finish?.(null);
                }
            });
        } else {
            console.error("无 wx.chooseMedia");
            finish?.(null);
        }
    }
    public uploadFile(url: string, file: string, name: string, kvs: KVs, finish: (res: { Desc: string, file: string }) => void): void {
        if (wx.uploadFile) {
            wx.uploadFile({
                url: url,
                filePath: file,
                name: name,
                formData: requests.json(kvs),
                success: res => {
                    console.log("uploadFile success", JSON.stringify(res, undefined, "\t"));
                    // {
                    //     "statusCode": 200,
                    //     "data": "{\"\\u53c2\\u65702\":\"\\ud83d\\udde1\\ufe0f1\\u0f06\\u82cd\\u0f12\\u767d2\\u4e443\\u4eba\\ud83c\\ude33\\ud83d\\ude0a\\u261c\\ud83d\\udc1f\\u53e3\\ud83d\\udc33\\u624b\\u03e8\\u86a0\\u4240\\u9680\\ue100\\uca00\\u263b\\u263a\\ud83d\\udc20\\u2b50\\u10da(\\u2032\\u25c9\\u2765\\u25c9\\uff40\\u10da)\",\"\\u53c2\\u65701\":\"666\",\"Status\":0,\"Desc\":\"\\u4fdd\\u5b58\\u6587\\u4ef6\\u6210\\u529f\\uff01\",\"file\":\"upload\\/20250611140744.png\"}",
                    //     "header": {
                    //         "Date": "Wed, 11 Jun 2025 06:07:44 GMT",
                    //         "Content-Type": "text/html; charset=utf-8",
                    //         "Content-Length": "374",
                    //         "Connection": "keep-alive",
                    //         "Access-Control-Allow-Origin": "*",
                    //         "Cache-Control": "no-cache, must-revalidate",
                    //         "Vary": "Accept-Encoding",
                    //         "Server": "Microsoft-IIS/7.5"
                    //     },
                    //     "cookies": [],
                    //     "errMsg": "uploadFile:ok"
                    // }
                    finish?.(JSON.parse(res?.data));
                },
                fail: res => {
                    console.error("uploadFile fail", JSON.stringify(res, undefined, "\t"));
                    finish?.(null);
                }
            });
        } else {
            console.error("无 wx.uploadFile");
        }
    }
}
platformCtrlClasses["wechatgame"] = PlatformCtrlWX;