//尝试通过分析 ByteArray 的前 2 个字节获取文件类型
export const contentTypes = new (class {
    //public UNKNOWN="unknown";
    public JPG = "jpg";
    public PNG = "png";
    public GIF = "gif";
    public BMP = "bmp";
    public SWF = "swf";
    public MP3 = "mp3";
    public FLV = "flv";
    public WAV = "wav";
    public MID = "mid";
    public RAR = "rar";
    public EXE = "exe";
    private types = {
        255216: this.JPG,
        13780: this.PNG,
        7173: this.GIF,
        6677: this.BMP,
        6787: this.SWF,
        7087: this.SWF,
        7368: this.MP3,
        255250: this.MP3,
        7076: this.FLV,
        8273: this.WAV,
        7784: this.MID,
        8297: this.RAR,
        7790: this.EXE
    }
    private contentTypes: { [key: string]: string } = {};
    public DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public constructor() {
        this.contentTypes[this.JPG] = "image/jpeg";
        this.contentTypes[this.PNG] = "image/png";
        this.contentTypes[this.GIF] = "image/gif";
        this.contentTypes[this.BMP] = "image/bmp";
        this.contentTypes[this.SWF] = "application/x-shockwave-flash";
        this.contentTypes[this.MP3] = "audio/mpeg";
        this.contentTypes[this.FLV] = "video/x-flv";
        this.contentTypes[this.WAV] = "audio/wav";
        this.contentTypes[this.MID] = "audio/mid";
        this.contentTypes[this.RAR] = "";//application/octet-stream
        this.contentTypes[this.EXE] = "";//application/octet-stream
    }
    public get(bytes: Uint8Array): string {
        return this.contentTypes[this.types[bytes[0] + "" + bytes[1]]] || this.DEFAULT_CONTENT_TYPE;
    }
})();