interface NativeTSArgs { op: string, Status: number, Desc: string, extra: string };
export const nativeTS = window["nativeTS"] = new (class {
    public onNative2TS: (args: NativeTSArgs) => void;
    public ts2native(op: string, args?: any): void {
        if (args) {
            args.op = op;
        } else {
            args = { op: op };
        }
        const jsonCode = JSON.stringify(args);
        console.log("ts2native 发送：" + jsonCode);
        if (cc.sys.os == cc.sys.OS_IOS) {
            jsb.reflection.callStaticMethod("NativeTS", "ts2native:", jsonCode);
        } else {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/NativeTS", "ts2native", "(Ljava/lang/String;)V", jsonCode);
        }
    }
    private native2ts(args: NativeTSArgs): void {//最好延迟一帧调用，否则可能会出一些奇怪的渲染问题
        if (args.extra?.replace) {
            args.extra = args.extra.replace(/^\s*|\s*$/g, "");
            if (args.extra.startsWith("{") && args.extra.endsWith("}")) {
                const extra = JSON.parse(args.extra);
                if (extra) {
                    delete args.extra;
                    for (const key in extra) {
                        args[key] = extra[key];
                    }
                }
            }
        }
        console.log("native2ts 接收：" + JSON.stringify(args));
        this.onNative2TS?.(args);
    }
})();