import { contentTypes } from "./ContentTypes";

export type KVs = Array<string | number>;
export const requests = (window as any).requests = new (class {
    private sb: Array<string> = [];
    public vars = (kvs: KVs) => {
        let i: number = kvs?.length;
        if (i) {
            this.sb.length = 0;
            let sbIndex: number = 0;
            while ((i -= 2) >= 0) {
                this.sb[sbIndex++] = "&";
                this.sb[sbIndex++] = kvs[i] as any;
                this.sb[sbIndex++] = "=";
                this.sb[sbIndex++] = encodeURIComponent(kvs[i + 1]);
            }
            this.sb.shift();
            return this.sb.join("");
        }
        return "";
    };
    public json = (kvs: KVs, json?: { [key: string]: string | number }) => {
        json || (json = {});
        let i: number = kvs?.length;
        if (i) {
            while ((i -= 2) >= 0) {
                const key = kvs[i] as string;
                const value = kvs[i + 1];
                if (value) {
                    switch (typeof (value)) {
                        case "string":
                        case "number":
                            json[key] = value;
                            break;
                        default:
                            json[key] = "[" + value + "]";
                            break;
                    }
                } else {
                    switch (value) {
                        case null:
                        case undefined:
                            break;
                        default:
                            json[key] = value as any;
                            break;
                    }
                }
            }
        }
        return json;

    };
    private err(evt: ProgressEvent | string | number, info: string): void {
        this.sb.length = 0;
        let sbIndex: number = 0;
        if (evt) {
            if (window.ProgressEvent && evt instanceof window.ProgressEvent) {
                this.sb[sbIndex++] = evt.type;
            } else if (typeof (evt) == "string" || typeof (evt) == "number") {
                this.sb[sbIndex++] = evt as string;
            } else {
                for (const key in evt) {
                    const value = evt[key];
                    switch (typeof (value)) {
                        case "number":
                        case "string":
                        case "boolean":
                            this.sb[sbIndex++] = key;
                            this.sb[sbIndex++] = " " + value;
                            this.sb[sbIndex++] = "\n";
                            break;
                    }
                }
            }
        }
        sbIndex || (this.sb[sbIndex++] = evt + "");
        this.sb[sbIndex++] = "\n";
        this.sb[sbIndex++] = info;
        console.error(this.sb.join(""));
    }
    private send(url: string, method: "GET" | "POST", headers: Array<string>, body: string | Form, finish: (rsp: string) => void): void {
        const xhr = new XMLHttpRequest();
        xhr.timeout = 60000;
        xhr.onload = () => {
            finish?.(xhr.response);
            finish = null;
        };
        xhr.onerror = evt => {
            this.err(evt, method + " " + url.match(/\/[^\/]+\/[^\/]+$/));
            finish?.(undefined);
            finish = null;
        };
        xhr.ontimeout = () => {
            this.err("timeout", method + " " + url.match(/\/[^\/]+\/[^\/]+$/));
            finish?.(undefined);
            finish = null;
        };
        xhr.onreadystatechange = () => {
            if (xhr.readyState > 399) {
                this.err(xhr.readyState, method + " " + url.match(/\/[^\/]+\/[^\/]+$/));
                finish?.(undefined);
                finish = null;
            } else if (xhr.readyState > 299) {
                this.err(xhr.readyState, method + " " + url.match(/\/[^\/]+\/[^\/]+$/));
            } else {
                switch (xhr.readyState) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 200:
                        break;
                    default:
                        console.log(xhr.readyState, method + " " + url.match(/\/[^\/]+\/[^\/]+$/));
                        break;
                }
            }
        }
        xhr.responseType = "text";
        xhr.open(method, url, true);
        if (headers) {
            let i: number = headers.length;
            while ((i -= 2) >= 0) {
                xhr.setRequestHeader(headers[i], headers[i + 1]);
            }
        }
        if (body instanceof Form) {
            body.contentType && xhr.setRequestHeader("Content-Type", body.contentType);
            xhr.send(body.getBody());
        } else {
            xhr.send(body);
        }
    }
    public get(url: string, finish?: (rsp: string) => void, kvs?: KVs, headers?: Array<string>): void {
        const vars = this.vars(kvs);
        if (vars) {
            url += (url.includes("?") ? "&" : "?") + vars;
        }
        //console.log("get " + url);
        this.send(url, "GET", headers, undefined, finish);
    }
    public post(url: string, finish?: (rsp: string) => void, body?: string | Form, headers?: Array<string>): void {
        //console.log("post " + url);
        this.send(url, "POST", headers, body, finish);
    }
})();

export class Form {
    //有 FormData
    private formData: FormData;

    //无 FormData
    private boundary: Uint8Array;
    public contentType: string;
    private data: Array<string | Uint8Array>;
    public constructor() {
        if (window.FormData) {
            this.formData = new FormData();
        } else {
            const boundary = "------------------------------7m" + (0x100000000000 + Math.floor(Math.random() * 0x100000000000)).toString(16).substr(1);
            this.contentType = "multipart/form-data; boundary=" + boundary;
            this.boundary = this.cs2u8s("--" + boundary);
            this.data = [];
        }
    }
    private cs2u8s(cs: string): Uint8Array {
        let i: number = cs.length;
        const u8s = new Uint8Array(i);
        while (i--) {
            u8s[i] = cs.charCodeAt(i);
        }
        return u8s;
    }
    private str2u8s(str: string): Uint8Array {
        return this.cs2u8s(unescape(encodeURIComponent(str)));
    }
    public append(key: string, value: Uint8Array | string | number, fileName?: string): void {
        if (this.formData) {
            if (fileName) {
                this.formData.append(key, new Blob([value as Uint8Array], { type: "application/octet-binary" }), fileName);
            } else {
                this.formData.append(key, value + "");
            }
        } else {
            this.data.push(this.boundary, '\r\nContent-Disposition: form-data; name="', this.str2u8s(key), '"');
            if (fileName) {
                this.data.push('; filename="', this.str2u8s(fileName), '"\r\nContent-Type: ', contentTypes.get(value as Uint8Array), "\r\n\r\n", value as Uint8Array, "\r\n");
            } else {
                this.data.push('\r\n\r\n', this.str2u8s(value + ""), "\r\n");
            }
        }
    }
    public getBody(): FormData | Uint8Array {
        if (this.formData) {
            return this.formData;
        } else {
            const u8ss: Array<Uint8Array> = [];
            for (const part of this.data) {
                u8ss.push(part instanceof Uint8Array ? part : this.cs2u8s(part));
            }
            u8ss.push(this.boundary, this.cs2u8s("--\r\n"));
            let L: number = 0;
            for (const u8s of u8ss) {
                L += u8s.length;
            }
            const bytes = new Uint8Array(L);
            let i: number = 0;
            for (const u8s of u8ss) {
                for (const byte of u8s as any) {
                    bytes[i++] = byte;
                }
            }
            u8ss.length = 0;
            return bytes;
        }
    }
}