export type Channel = "H5调试" | "传图H5" | "传图" | "传图App";
export type Platform = "web-mobile" | "android" | "wechatgame" | "dygame";
interface PlatformInfo {
    channel?: Channel,
    platform: Platform
}
export const utils = (window as any).utils = new (class {
    public platformInfos: { [key: string]: PlatformInfo } = {
        "H5调试": {
            "platform": "web-mobile"
        },
        "传图H5": {
            "platform": "web-mobile"
        },
        "传图": {
            "platform": "wechatgame"
        },
        "CT": {
            "platform": "android"
        }
    };
    public platformInfo: PlatformInfo;
    public init(): void {
        this.platformInfo = this.platformInfos[window["channel"] || (window["channel"] = "H5调试")];
        this.platformInfo.channel = window["channel"];
    }
})();