package org.cocos2dx.javascript;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSON {

    // private String data;//仅用于调试时查看

    public JSONObject jo;
    public JSONArray ja;

    public JSON() {
    }

    public boolean decode(String _data) {

        // data=_data;

        try {
            jo = new JSONObject(_data);
            return true;
        } catch (JSONException e) {
        }

        try {
            ja = new JSONArray(_data);
            return true;
        } catch (JSONException e) {
        }

        return false;

    }

    public String toString() {

        if (jo == null) {
        } else {
            return jo.toString();
        }

        if (ja == null) {
        } else {
            return ja.toString();
        }

        return null;

    }

    public JSON clone() {
        JSON jsonClone = new JSON();
        jsonClone.decode(this.toString());
        return jsonClone;
    }

    public boolean has(String name) {
        return jo.has(name);
    }

    public int length() {
        return ja.length();
    }

    public String getString(String name) {

        if (jo.isNull(name)) {
            return null;
        }

        try {
            return jo.getString(name);// 如果值为 null，会返回 "null" - -
        } catch (JSONException e) {
        }

        return null;

    }

    public void setString(String name, String value) {
        try {
            jo.put(name, value);
        } catch (JSONException e) {
        }
    }

    public String getString(int index) {

        if (ja.isNull(index)) {
            return null;
        }

        try {
            return ja.getString(index);// 如果值为 null，会返回 "null" - -
        } catch (JSONException e) {
        }

        return null;

    }

    public void setString(int index, String value) {
        try {
            ja.put(index, value);
        } catch (JSONException e) {
        }
    }

    public boolean getBoolean(String name) {

        try {
            return jo.getBoolean(name);
        } catch (JSONException e) {
        }

        return false;

    }

    public void setBoolean(String name, boolean value) {
        try {
            jo.put(name, value);
        } catch (JSONException e) {
        }
    }

    public boolean getBoolean(int index) {

        try {
            return ja.getBoolean(index);
        } catch (JSONException e) {
        }

        return false;

    }

    public void setBoolean(int index, boolean value) {
        try {
            ja.put(index, value);
        } catch (JSONException e) {
        }
    }

    public int getInt(String name) {

        try {
            return jo.getInt(name);
        } catch (JSONException e) {
        }

        return 0;

    }

    public void setInt(String name, int value) {
        try {
            jo.put(name, value);
        } catch (JSONException e) {
        }
    }

    public int getInt(int index) {

        try {
            return ja.getInt(index);
        } catch (JSONException e) {
        }

        return 0;

    }

    public void setInt(int index, int value) {
        try {
            ja.put(index, value);
        } catch (JSONException e) {
        }
    }

    public long getLong(String name) {

        try {
            return jo.getLong(name);
        } catch (JSONException e) {
        }

        return 0;

    }

    public void setLong(String name, long value) {
        try {
            jo.put(name, value);
        } catch (JSONException e) {
        }
    }

    public long getLong(int index) {

        try {
            return ja.getLong(index);
        } catch (JSONException e) {
        }

        return 0;

    }

    public void setLong(int index, long value) {
        try {
            ja.put(index, value);
        } catch (JSONException e) {
        }
    }

    public Iterator<String> getIterator() {
        return jo.keys();
    }

    public JSON getJSON(String name) {

        JSONObject subJO;
        try {
            subJO = jo.getJSONObject(name);
        } catch (JSONException e) {
            // e=org.json.JSONException: No value for
            // yesActionJSON，name=yesActionJSON
            // e=org.json.JSONException: Value null at yesActionJSON of type
            // org.json.JSONObject$1 cannot be converted to
            // JSONObject，name=yesActionJSON
            // Global.log("e="+e+"，name="+name);
            subJO = null;
        }

        if (subJO == null) {
        } else {
            JSON subJSON = new JSON();
            subJSON.jo = subJO;
            return subJSON;
        }

        JSONArray subJA;
        try {
            subJA = jo.getJSONArray(name);
        } catch (JSONException e) {
            subJA = null;
        }

        if (subJA == null) {
        } else {
            JSON subJSON = new JSON();
            subJSON.ja = subJA;
            return subJSON;
        }

        return null;

    }

    public JSON getJSON(int index) {

        JSONObject subJO;
        try {
            subJO = ja.getJSONObject(index);
        } catch (JSONException e) {
            subJO = null;
        }

        if (subJO == null) {
        } else {
            JSON subJSON = new JSON();
            subJSON.jo = subJO;
            return subJSON;
        }

        JSONArray subJA;
        try {
            subJA = ja.getJSONArray(index);
        } catch (JSONException e) {
            subJA = null;
        }

        if (subJA == null) {
        } else {
            JSON subJSON = new JSON();
            subJSON.ja = subJA;
            return subJSON;
        }

        return null;

    }

    public void setJSON(String name, JSON subJSON) {
        if (subJSON.jo == null) {
        } else {
            try {
                jo.put(name, subJSON.jo);
                return;
            } catch (JSONException e) {
            }
        }

        if (subJSON.ja == null) {
        } else {
            try {
                jo.put(name, subJSON.ja);
                return;
            } catch (JSONException e) {
            }
        }
    }
}
