package org.cocos2dx.javascript;

import android.util.Log;

import androidx.annotation.Nullable;

import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeTS {
    public static void ts2native(final String jsonCode) {
        AppActivity.appActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.i("xxx", "ts2native 接收：" + jsonCode);
                JSON json = new JSON();
                if (!json.decode(jsonCode)) {
                    Log.e("xxx", "解析 JSON 失败！");
                    return;
                }
                AppActivity.appActivity.ts2native(json);
            }
        });
    }

    public static void native2ts(String op, int Status, String Desc) {
        native2ts(op, Status, Desc, null);
    }

    public static void native2ts(String op, int Status, String Desc, String[] keyValueArr) {
        JSON json = new JSON();
        json.decode("{}");
        json.setString("op", op);
        json.setInt("Status", Status);
        json.setString("Desc", Desc);
        if (keyValueArr != null) {
            for (int i = 0; i < keyValueArr.length; i += 2) {
                json.setString(keyValueArr[i], keyValueArr[i + 1]);
            }
        }
        String jsCode = "nativeTS.native2ts(" + json + ")";
        AppActivity.appActivity.runOnGLThread((new Runnable() {
            @Override
            public void run() {
                Log.i("xxx", "native2ts 运行：" + jsCode);
                Cocos2dxJavascriptJavaBridge.evalString(jsCode);
            }
        }));
    }
}
