window.boot = function () {
var log = console.log;
var warn = console.warn;
var error = console.error;
var msgs = [];
window.hijackConsole = {
    log: log,
    warn: warn,
    error: error,
    msgs: msgs
};
console.log = function () {
    msgs.push.apply(msgs, arguments);
    log.apply(console, arguments);
};
console.warn = function () {
    msgs.push.apply(msgs, arguments);
    warn.apply(console, arguments);
};
console.error = function () {
    msgs.push.apply(msgs, arguments);
    error.apply(console, arguments);
};
window.onerror = function (message, source, lineno, colno, error) {
    var _ex = error.name + " " + message + " " + source + " " + lineno + "," + colno + "\n" + error.stack;
    msgs.push(_ex);
    var ex = window["hijackConsole"].ex;
    ex && ex.apply(window["hijackConsole"], [_ex]);
};

window.maxApplyMixingFromDepth = 1;

window.channel = "CT";
window.ress = {
    "version": 1000,
    "imports": "0039099279916D2D",
    "res": {}
};
for (var bundleName in window.ress.res) {
    var res = window.ress.res[bundleName];
    var i = res.length;
    while (i--) {
        var arr = res[i] = res[i].split(",");
        var path = arr[0];
        path && (res[path] = arr);
        res["_" + arr[1]] = arr;
    }
}
var resPath = jsb.fileUtils.getWritablePath() + "res/";
var cdnPath = resPath + "cdn/";
window.requireCDN = function (bundleName, jsPath) {
    var res = window.ress.res[bundleName];
    var arr = res[jsPath];
    return require(cdnPath + arr[2]);
};
window.solveURL = function (type, bundleNameOrItem, name) {
    var url;
    switch (type) {
        case "jsb-loader":
            switch (bundleNameOrItem) {
                case "main":
                case "internal":
                    url = "assets/" + bundleNameOrItem + "/" + name;
                    break;
                default:
                    url = cdnPath + window.ress.res[bundleNameOrItem][name][2];
                    break;
            }
            //console.log(type, bundleNameOrItem, name, "url=" + url);
            break;
        case "url-transformer":
            var bundleName = bundleNameOrItem.config.base.replace(/\/$/, "");
            switch (bundleName) {
                case "main":
                case "internal":
                    url = "assets/" + bundleName + "/" + (bundleNameOrItem.ext == ".json" ? "import/" : "native/") + bundleNameOrItem.uuid + bundleNameOrItem.ext;
                    break;
                default:
                    var arr;
                    switch (bundleNameOrItem.ext) {
                        case ".json":
                            var pack = bundleNameOrItem.info.packs[0];
                            arr = window.ress.res[bundleName]["_" + (pack && pack.uuid || bundleNameOrItem.uuid)];
                            break;
                        default:
                            arr = window.ress.res[bundleName]["_" + bundleNameOrItem.uuid];
                            break;
                    }
                    url = cdnPath + arr[2];
                    break;
            }
            //console.log(type, bundleNameOrItem.config.base, bundleNameOrItem.ext, "url=" + url);
            break;
        default:
            console.error("未处理的 url：", type, bundleNameOrItem, name);
            break;
    }
    return url;
};

    var settings = window._CCSettings;
    window._CCSettings = undefined;
    var onProgress = null;
    
    var RESOURCES = cc.AssetManager.BuiltinBundleName.RESOURCES;
    var INTERNAL = cc.AssetManager.BuiltinBundleName.INTERNAL;
    var MAIN = cc.AssetManager.BuiltinBundleName.MAIN;

    var onStart = function () {

        cc.view.enableRetina(true);
        cc.view.resizeWithBrowserSize(true);

        if (cc.sys.isMobile) {
            if (settings.orientation === 'landscape') {
                cc.view.setOrientation(cc.macro.ORIENTATION_LANDSCAPE);
            }
            else if (settings.orientation === 'portrait') {
                cc.view.setOrientation(cc.macro.ORIENTATION_PORTRAIT);
            }
            cc.view.enableAutoFullScreen([
                cc.sys.BROWSER_TYPE_BAIDU,
                cc.sys.BROWSER_TYPE_BAIDU_APP,
                cc.sys.BROWSER_TYPE_WECHAT,
                cc.sys.BROWSER_TYPE_MOBILE_QQ,
                cc.sys.BROWSER_TYPE_MIUI,
                cc.sys.BROWSER_TYPE_HUAWEI,
                cc.sys.BROWSER_TYPE_UC,
            ].indexOf(cc.sys.browserType) < 0);
        }

        var launchScene = settings.launchScene;
        var bundle = cc.assetManager.bundles.find(function (b) {
            return b.getSceneInfo(launchScene);
        });
        
        bundle.loadScene(launchScene, null, onProgress,
            function (err, scene) {
                if (!err) {
                    cc.director.runSceneImmediate(scene);
                }
            }
        );

    };

    var option = {
        id: 'GameCanvas',
        debugMode: settings.debug ? cc.debug.DebugMode.INFO : cc.debug.DebugMode.ERROR,
        showFPS: settings.debug,
        frameRate: 60,
        groupList: settings.groupList,
        collisionMatrix: settings.collisionMatrix,
    };

    cc.assetManager.init({ 
        bundleVers: settings.bundleVers,
        remoteBundles: settings.remoteBundles,
        server: settings.server
    });
    
    var bundleRoot = [INTERNAL];
    settings.hasResourcesBundle && bundleRoot.push(RESOURCES);

    var count = 0;
    function cb (err) {
        if (err) return console.error(err.message, err.stack);
        count++;
        if (count === bundleRoot.length + 1) {
            cc.assetManager.loadBundle(MAIN, function (err) {
                if (!err) cc.game.run(option, onStart);
            });
        }
    }

    cc.assetManager.loadScript(settings.jsList.map(function (x) { return 'src/' + x;}), cb);

    for (var i = 0; i < bundleRoot.length; i++) {
        cc.assetManager.loadBundle(bundleRoot[i], cb);
    }
};

require('src/settings.js');
require('src/cocos2d-jsb.js');
require('jsb-adapter/jsb-engine.js');

cc.macro.CLEANUP_IMAGE_CACHE = true;
window.boot();