"use strict";

require('adapter-min.js');
__globalAdapter.init();
require('cocos/cocos2d-js-min.js');
__globalAdapter.adaptEngine();
require('./ccRequire');
require('./src/settings');
// Introduce Cocos Service here
require('./main'); // TODO: move to common
var log = console.log;
var warn = console.warn;
var error = console.error;
var msgs = [];
window.hijackConsole = {
    log: log,
    warn: warn,
    error: error,
    msgs: msgs
};
console.log = function () {
    msgs.push.apply(msgs, arguments);
    log.apply(console, arguments);
};
console.warn = function () {
    msgs.push.apply(msgs, arguments);
    warn.apply(console, arguments);
};
console.error = function () {
    msgs.push.apply(msgs, arguments);
    error.apply(console, arguments);
};
wx.onError(function (args) {
    var _ex = args.message + "\n" + args.stack;
    msgs.push(_ex);
    var ex = window["hijackConsole"].ex;
    ex && ex.apply(window["hijackConsole"], [_ex]);
});

window.maxApplyMixingFromDepth = 1;

window.channel = "传图";
window.ress = {
    "version": 1000,
    "imports": "0039099279916D2D",
    "res": {}
};
for (var bundleName in window.ress.res) {
    var res = window.ress.res[bundleName];
    var i = res.length;
    while (i--) {
        var arr = res[i] = res[i].split(",");
        var path = arr[0];
        path && (res[path] = arr);
        res["_" + arr[1]] = arr;
    }
}
var resPath = wx.env.USER_DATA_PATH + "/res/";
var importsPath = resPath + "imports/";
var cdnPath = resPath + "cdn/";
window.solveURL = function (type, bundleNameOrItem, name) {
    var url;
    switch (type) {
        case "assetManager":
            switch (bundleNameOrItem) {
                case "main":
                case "internal":
                    url = "assets/" + bundleNameOrItem + "/" + name;
                    break;
                default:
                    switch (name) {
                        case "index.js":
                            url = "assets/" + bundleNameOrItem + "/" + name;
                            break;
                        case "config.json":
                            url = importsPath + "config." + bundleNameOrItem + ".json";
                            break;
                        default:
                            console.error("未处理的 assetManager：", type, bundleNameOrItem, name);
                            break;
                    }
                    break;
            }
            //console.log(type, bundleNameOrItem, name, "url=" + url);
            break;
        case "url-transformer":
            var bundleName = bundleNameOrItem.config.base.replace(/\/$/, "");
            switch (bundleName) {
                case "main":
                case "internal":
                    url = "assets/" + bundleName + "/" + (bundleNameOrItem.ext == ".json" ? "import/" : "native/") + bundleNameOrItem.uuid + bundleNameOrItem.ext;
                    break;
                default:
                    switch (bundleNameOrItem.ext) {
                        case ".json":
                            url = importsPath + bundleNameOrItem.uuid + bundleNameOrItem.ext;
                            break;
                        default:
                            var bundleName = bundleNameOrItem.config.base.replace(/\/$/, "");
                            var arr = window.ress.res[bundleName]["_" + bundleNameOrItem.uuid];
                            url = cdnPath + arr[2];
                            break;
                    }
                    break;
            }
            //console.log(type, bundleNameOrItem.config.base, bundleNameOrItem.ext, "url=" + url);
            break;
        default:
            console.error("未处理的 url：", type, bundleNameOrItem, name);
            break;
    }
    return url;
};

// Adjust devicePixelRatio
cc.view._maxPixelRatio = 4;
if (cc.sys.platform !== cc.sys.WECHAT_GAME_SUB) {
  // Release Image objects after uploaded gl texture
  cc.macro.CLEANUP_IMAGE_CACHE = true;
}
window.boot();