import { _decorator, Component, Node, Camera, RenderTexture, ImageAsset, view, Texture2D, SpriteFrame, Sprite, sys, Layers, UITransform, MeshRenderer } from 'cc';

const { ccclass, property } = _decorator;

/* the screen shot's sclae, the lower, the less memory and I/O costs */
const scale =1;


@ccclass('CamShot')
export class CamShot extends Component {

    @property(Camera)
    mainCam: Camera = null;

    rt: RenderTexture = null;

    private _canvas: HTMLCanvasElement = null!;

    private _buffer: ArrayBufferView = null!;

    private _size: number[] = new Array(2);

    private _cam: Camera = null!;

    public static ins: CamShot = null;

    private captureSize = [];


    start() {
        CamShot.ins = this;
        this.initCam();
    }

    initCam(){

        this._cam  =this.node.getComponent(Camera);

        this.rt = new RenderTexture();
        this._size = [Math.round(view.getVisibleSize().width), Math.round(view.getVisibleSize().height)]
        this.rt.reset({
            width: Math.round(this._size[0]),
            height: Math.round(this._size[1]),
        })
        this._cam.targetTexture = this.rt;
        this.setHeight();
        this._cam.visibility = Layers.Enum.NONE;
    }

    setHeight() {
        this._cam.orthoHeight = this.mainCam.orthoHeight;
        this._cam.node.worldPosition = this.mainCam.node.worldPosition;
        // this._cam.node.active = false;
    } 
    
    
    copyRTtoMesh(node:Node, mesh: MeshRenderer) {
        this._cam.visibility = Layers.Enum.UI_2D;
        this._buffer = null;
        const size = node.getComponent(UITransform);
        this.captureSize = [Math.round(size.width),Math.round(size.height)];
        this._size = [Math.round(node.worldPosition.x),Math.round(node.worldPosition.y)]
        this.scheduleOnce(() => {
            const width = this.captureSize[0];
            const height = this.captureSize[1];
            const x =this._size[0]-width*0.5;
            const y = this._size[1]-height*0.5;
            this._buffer = this.rt.readPixels(x, y, width, height);
            this._cam.visibility = Layers.Enum.NONE;
            this.showMesh(mesh);
        }) 
    }

    showMesh(mesh:MeshRenderer){

        mesh.material.setProperty("mainTexture",this.createTex());

    }


    copyRTtoSp(node:Node, sp: Sprite) {
        this._cam.visibility = Layers.Enum.UI_2D;
        this._buffer = null;
        const size = node.getComponent(UITransform);
        this.captureSize = [Math.round(size.width),Math.round(size.height)];
        this._size = [Math.round(node.worldPosition.x),Math.round(node.worldPosition.y)]
        this.scheduleOnce(() => {
            const width = this.captureSize[0];
            const height = this.captureSize[1];
            const x =this._size[0]-width*0.5;
            const y = this._size[1]-height*0.5;
            this._buffer = this.rt.readPixels(x, y, width, height);
            this._cam.visibility = Layers.Enum.NONE;
            this.showImage(sp);
        }) 
    }

    showImage(sp: Sprite) {
    
        let sf = new SpriteFrame();
        sf.texture = this.createTex();
        sf.packable = false;
        const transfrom = sp.node.getComponent(UITransform);
        sp.spriteFrame = sf;
        sp.spriteFrame.flipUVY = true;
        transfrom.setContentSize(transfrom.width,transfrom.width*this.captureSize[1]/this.captureSize[0]);
        if (sys.isNative && (sys.os === sys.OS.IOS || sys.os === sys.OS.OSX)) {
            sp.spriteFrame.flipUVY = false;
        }
    }

    createTex(){
        const img = new ImageAsset();
        img.reset({
            _data: this._buffer,
            width: this.captureSize[0],
            height: this.captureSize[1],
            format: Texture2D.PixelFormat.RGBA8888,
            _compressed: false
        });
        let texture = new Texture2D();
        texture.image = img;
        return texture;
    }


    clearCanvas() {
        let ctx = this._canvas.getContext('2d');
        ctx.clearRect(0, 0, this._canvas.width, this._canvas.height);
    }

  
}