import { _decorator, Component, Node, instantiate, v3, log, Camera, RenderTexture, SpriteFrame, Sprite, MeshRenderer } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('main')
export class main extends Component {
    @property(Node)
    obj:Node=null;


    @property(Camera)
    camera:Camera=null;

    @property(Sprite)
    sp:Sprite=null;

    @property(MeshRenderer)
    plane2:MeshRenderer=null;

    start() {
        let index=1;
        this.schedule(()=>{
            console.log(index);
            
            let node = instantiate(this.obj);
            node.parent=this.obj.parent;
            node.setPosition(v3(this.obj.position.x+index,this.obj.position.y,this.obj.position.z));
            index++;
            this.scheduleOnce(()=>{
                node.destroy();
            },1)
        },1)


        let renderTex = new RenderTexture();

        // 处理锯齿  方案：放大RT
        const rt_scale = 3;
        renderTex.initialize({
            width: 350 * rt_scale,
            height: 610 * rt_scale
        });

        let spriteframe: SpriteFrame = this.sp.spriteFrame!;
        let sp: SpriteFrame = new SpriteFrame();
        sp.reset({
            originalSize: spriteframe.originalSize,
            rect: spriteframe.rect,
            offset: spriteframe.offset,
            isRotate: spriteframe.rotated,
            borderTop: spriteframe.insetTop,
            borderLeft: spriteframe.insetLeft,
            borderBottom: spriteframe.insetBottom,
            borderRight: spriteframe.insetRight,
        });

        this.camera.targetTexture = renderTex;
        sp.texture = renderTex;
        this.sp.spriteFrame = sp;

        this.plane2.material.setProperty('mainTexture',renderTex);
    }

    update(deltaTime: number) {
        
    }
}

