
import { _decorator, Component, Node, AudioSource, AudioClip } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = AudioController
 * DateTime = Fri Jun 24 2022 16:24:47 GMT+0800 (中国标准时间)
 * Author = jasonmr.q
 * FileBasename = AudioController.ts
 * FileBasenameNoExtension = AudioController
 * URL = db://assets/scripts/AudioController.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('AudioController')
export class AudioController extends Component {
    @property([AudioClip])
    audioClip : AudioClip[] = [];

    @property(AudioSource)
    audioSource: NonNullable<AudioSource> = null;

    start () {
        
    }

    onOneTime(){
        this.audioSource.stop();
        this.audioSource.playOneShot(this.audioClip[0])
    }

    onLoop(){
        this.audioSource.clip = this.audioClip[1];
        this.audioSource.loop = true;
        this.audioSource.play()
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
