
import { _decorator, Component, Node, director, instantiate, Label } from 'cc';
const { ccclass, type } = _decorator;

@ccclass('UIMain')
export class UIMain extends Component {

    @type(Node)
    n: Node = null;

    @type(Label)
    label: Label = null;

    start() {

        this.label.string = 'box count:1';

    }

    reload() {

        director.loadScene('main');

    }

    add() {

        for (let i = 0; i < 10; i++) {

            let n = instantiate(this.n);

            this.n.parent.addChild(n);

            n.setPosition(this.randomInt(-25, 25), 0.5, this.randomInt(-25, 25));

        }

        this.label.string = `box count:${this.n.parent.children.length}`;

    }

    randomInt = (min: number, max: number) => min + Math.floor(Math.random() * (max - min + 1));

}
