import fs from "fs-extra";
import path from "path";

//symlink同步
export const symlinkCommon = async () => {
  const dst = path.resolve(__dirname, "../../../client/assets/Scripts/Common");
  const src = path.resolve(__dirname, "../Common");

  if (
    (await fs
      .lstat(dst)
      .then((v) => v.isSymbolicLink())
      .catch(() => false)) &&
    (await fs.readlink(dst)) === src
  ) {
    console.log("同步成功！");
  } else {
    fs.symlink(src, dst)
      .then(() => {
        console.log("同步成功！");
      })
      .catch((e) => {
        console.log("同步失败！", e);
      });
  }
};


export const buffer2ArrayBuffer = (buffer: Buffer) => {
  const ab = new ArrayBuffer(buffer.length);
  const dv = new DataView(ab);
  for (let index = 0; index < buffer.length; index++) {
    dv.setUint8(index, buffer[index])
  }
  return dv.buffer;
}
