/**
 * Promise 的公共基类，提供通用功能
 */
export abstract class PromiseBase {
    /**
     * 安全执行回调函数，捕获并处理异常
     * @param callback 要执行的回调函数
     * @param reason 传递给回调的参数
     */
    protected async safeExecuteCallback<T = any>(callback: ((reason?: any) => T | Promise<T>) | undefined, reason?: any): Promise<void> {
        if (!callback) {
            return;
        }

        try {
            const result = callback(reason);
            if (result instanceof Promise) {
                await result;
            }
        } catch (error) {
            // LogUtils.error(`回调执行失败: ${error}`);
            // 继续执行，不抛出异常，避免影响 Promise 的正常流程
        }
    }

    /**
     * 安全执行条件检查函数
     * @param checkFunction 检查函数
     * @param errorContext 错误上下文信息
     * @returns 检查结果，异常时返回 false
     */
    protected safeCheck(checkFunction: () => boolean, errorContext: string): boolean {
        try {
            return checkFunction();
        } catch (error) {
            // LogUtils.error(`${errorContext}: ${error}`);
            return false;
        }
    }
}
