import { _decorator, Component, Node, Sprite, SpriteFrame, ImageAsset, Texture2D, gfx, RenderTexture, director, instantiate, resources, Vec3, Material } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('StarScript')
export class starScript extends Component {
    @property(Node)
    public container: Node = null!;
    @property(Node)
    template: Node = null!;

    start() {
        let matPath = 'star_random'; // 你的材质资源路径
        resources.load(matPath, Material, (err, materialAsset) => {
            if (err) {
                console.error(err);
                return;
            }
            console.log(materialAsset)
            const clone = instantiate(this.template);
            const newWorldPos = new Vec3(200, 300, 0);
            
            // 创建新实例，避免共享
            let newMat = new Material();
            newMat.copy(materialAsset);
            clone.getComponent(Sprite).customMaterial = materialAsset;
            
            clone.setWorldPosition(newWorldPos);
            // 应用到克隆节点
            this.container.addChild(clone);
        });
        console.log(this.container.children)
    }
}


