// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    charTime: cc.Label = null;
    @property(cc.Label)
    btimapTime: cc.Label = null;
    @property(cc.Button)
    btnCreate: cc.Button = null;
    @property(cc.Node)
    charNode: cc.Node = null;
    @property(cc.Node)
    bitmapNode: cc.Node = null;
    @property(cc.Node)
    charLabel: cc.Node = null;
    @property(cc.Node)
    bitmapLabel: cc.Node = null;

    createLabel(){
        cc.Label._shareAtlas.reset()
        
        this.charNode.destroyAllChildren()
        this.bitmapNode.destroyAllChildren()

        this.createChar()
        this.createBitmap()
    }

    createChar(){
        let starttime = new Date().getTime()
        for (let i = 0; i < 20; i++) {
            let char = cc.instantiate(this.charLabel)
            char.x = 0
            char.y = i * 25
            this.charNode.addChild(char)
            char.getComponent(cc.Label).string = "Cocos Creator 是一款高效、轻量、免费。" + i * 10;
        }
        this.charTime.string = "CharTime:" + (new Date().getTime() - starttime)
    }


    createBitmap(){
        let starttime = new Date().getTime()
        for (let i = 0; i < 20; i++) {
            let bitmap = cc.instantiate(this.bitmapLabel)
            bitmap.x = 0
            bitmap.y = i * 25
            this.bitmapNode.addChild(bitmap)
            bitmap.getComponent(cc.Label).string = "Cocos Creator 是一款高效、轻量、免费。" + i * 10;
        }
        this.btimapTime.string = "BitmapTime:" + (new Date().getTime() - starttime)
    }
}
