const { ccclass, property, menu } = cc._decorator

/**
 * 地图移动，缩放功能
 */
@ccclass
@menu('map/MapScroll')
export default class MapScroll extends cc.Component {
    private mapOrigin: cc.Vec2 = cc.v2()
    private moveCallBack: Function = null
    private scaleCallBack: Function = null
    private scaleConetentMin: number = 0.2
    private scaleConetentMax: number = 1.5
    @property({ tooltip: "是否开启拖动" }) isCanDrag: boolean = true

    protected onLoad(): void {
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegin, this)
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMove, this)
        this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this)
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchEnd, this)

        this.updateMapOrgin()
        this.setSaclePostion()
        // this.node.on(cc.Node.EventType.MOUSE_WHEEL, function (event) {
        // })
    }

    protected start() {
    }



    private setSaclePostion() {
        // 修正锚点(按当前的位置计算新锚点后在缩放) 否则会按照0.5 0.5放大
        const touchPoint1 = cc.v2(0, 100)
        const touchPoint2 = cc.v2(0, -100)
        const pointVec1 = touchPoint1.sub(this.mapOrigin)
        const pointVec2 = touchPoint2.sub(this.mapOrigin)
        const relMidx = (pointVec1.x + pointVec2.x) / 2
        const relMidy = (pointVec1.y + pointVec2.y) / 2
        const anchorX = relMidx / (this.node.width * this.node.scale)
        const anchorY = relMidy / (this.node.height * this.node.scale)
        const absMidx = (touchPoint2.x + touchPoint1.x) / 2
        const absMidy = (touchPoint2.y + touchPoint1.y) / 2
        this.node.anchorX = anchorX
        this.node.anchorY = anchorY
        this.node.x = absMidx
        this.node.y = absMidy
        // console.log('setSaclePostion:', this.mapOrigin.x, this.mapOrigin.y, anchorX, anchorY, absMidx, absMidy)
    }

    // scorllView content touch
    private touchBegin(event: cc.Event.EventTouch) {
        // console.log("touchBegin:", event.getTouches().length, event.getID())
        if (event.getID() > 0) {
            return false
        }
    }

    private touchMove(event: cc.Event.EventTouch) {
        const touches = event.getTouches()
        if (touches.length >= 2) { // 缩放地图操作
            const touch1 = touches[0]
            const touch2 = touches[1]
            const delta1 = touch1.getDelta()
            const delta2 = touch2.getDelta()

            // 得到当前两触摸点 转到parent下坐标
            let touchPoint1 = this.node.parent.convertToNodeSpaceAR(touch1.getLocation()) as cc.Vec2
            let touchPoint2 = this.node.parent.convertToNodeSpaceAR(touch2.getLocation()) as cc.Vec2

            // 转换为坐标 进行向量计算
            touchPoint1 = cc.v2(touchPoint1.x, touchPoint1.y)
            touchPoint2 = cc.v2(touchPoint2.x, touchPoint2.y)

            // 两触摸点与原点的差向量，pointVec1和pointVec2是相对于bgSprite的位置
            const pointVec1 = touchPoint1.sub(this.mapOrigin)
            const pointVec2 = touchPoint2.sub(this.mapOrigin)

            // 两触摸点的相对中点
            const relMidx = (pointVec1.x + pointVec2.x) / 2
            const relMidy = (pointVec1.y + pointVec2.y) / 2

            // 计算bgSprite的锚点
            const anchorX = relMidx / (this.node.width * this.node.scale)
            const anchorY = relMidy / (this.node.height * this.node.scale)

            // 相对屏幕的中点
            const absMidx = (touchPoint2.x + touchPoint1.x) / 2
            const absMidy = (touchPoint2.y + touchPoint1.y) / 2

            // 重设bgSprite锚点和位置
            this.node.anchorX = anchorX
            this.node.anchorY = anchorY

            this.node.x = absMidx
            this.node.y = absMidy
            // console.log('anchorX anchorY absMidx absMidy', anchorX.toFixed(2), anchorY.toFixed(2), absMidx.toFixed(2), absMidy.toFixed(2),
            //     this.node.anchorX.toFixed(2), this.node.anchorY.toFixed(2), this.node.scaleX.toFixed(2),
            //     this.node.scaleY.toFixed(2))

            // 缩放
            const distance = touchPoint1.sub(touchPoint2)
            const delta = delta1.sub(delta2)
            let scale = 1
            if (Math.abs(distance.x) > Math.abs(distance.y)) {
                scale = (distance.x + delta.x * 0.5) / distance.x * this.node.scale
            } else {
                scale = (distance.y + delta.y * 0.5) / distance.y * this.node.scale
            }
            this.node.scale = scale < this.scaleConetentMin
                ? this.scaleConetentMin
                : scale > this.scaleConetentMax ? this.scaleConetentMax : scale

            if (this.scaleCallBack) {
                this.scaleCallBack(this.node.scale)
            }
            // 更新原点位置
            this.mapOrigin = cc.v2(this.node.x, this.node.y).sub(
                cc.v2(this.node.width * anchorX * this.node.scaleX,
                    this.node.height * anchorY * this.node.scaleY))
            // console.log("updateMapOrgin222:", this.mapOrigin.x.toFixed(), this.mapOrigin.y.toFixed())
        } else if (event.getTouches().length === 1) { // 拖动地图
            if (this.isCanDrag) {
                if (event.getID() > 0) {
                    return
                }
                const location = event.getLocation()
                const previousLocation: cc.Vec2 = event.getPreviousLocation()
                const distance = cc.Vec2.distance(previousLocation, location)
                // console.log("distance:", distance)

                if (distance > 2) {
                    const delta = event.getDelta()
                    this.node.x += delta.x
                    this.node.y += delta.y
                    // console.log("this.node.x :", this.node.x, this.node.y)
                    if (this.moveCallBack) {
                        this.moveCallBack(this.node.getPosition())
                    }
                }
            }

        }

        this.goboundary()
        this.updateMapOrgin()
    }

    private touchEnd(event: cc.Event.EventTouch) {

    }

    private updateMapOrgin() {
        this.mapOrigin = cc.v2(this.node.position).sub(cc.v2(
            this.node.width * this.node.anchorX * this.node.scaleX,
            this.node.height * this.node.anchorY * this.node.scaleY))
        // console.log("updateMapOrgin111:", this.mapOrigin.x.toFixed(), this.mapOrigin.y.toFixed(), this.node.x.toFixed(),
        // this.node.y.toFixed(), this.node.width.toFixed(), this.node.height.toFixed(), this.node.anchorX.toFixed(),
        // this.node.anchorY.toFixed())
    }

    private goboundary() {
        let windowSize = cc.view.getVisibleSize();
        let minScale = Math.ceil(windowSize.height / this.node.height);
        let _map_scale = this.node.scale;
        let anchorPoint_after = this.node.getAnchorPoint();
        const posX_left = windowSize.width / 2 - (this.node.width * anchorPoint_after.x * _map_scale - this.node.getPosition().x);
        if (posX_left > 0) {
            let posx = (this.node.width * anchorPoint_after.x * _map_scale) - windowSize.width / 2;
            this.node.setPosition(posx, this.node.y);
        }
        // 下侧空白距离
        const posX_bottom = windowSize.height / 2 - (this.node.height * anchorPoint_after.y * _map_scale - this.node.getPosition().y);
        if (posX_bottom > 0) {
            let posy = (this.node.height * anchorPoint_after.y * _map_scale) - windowSize.height / 2;
            this.node.setPosition(this.node.x, posy);
        }
        // 右侧空白距离
        const posX_right = windowSize.width / 2 - (this.node.width * (1 - anchorPoint_after.x) * _map_scale + this.node.getPosition().x);
        if (posX_right > 0) {
            let posx = windowSize.width / 2 - (this.node.width * (1 - anchorPoint_after.x) * _map_scale);
            this.node.setPosition(posx, this.node.y);
        }
        // 上侧空白距离
        const posX_top = windowSize.height / 2 - (this.node.height * (1 - anchorPoint_after.y) * _map_scale + this.node.getPosition().y);
        if (posX_top > 0) {
            let posy = windowSize.height / 2 - (this.node.height * (1 - anchorPoint_after.y) * _map_scale);
            this.node.setPosition(this.node.x, posy);
        }
    }

    setMoveCallBack(callBack: Function) {
        this.moveCallBack = callBack
    }

    setScaleCallBack(callBack: Function) {
        this.scaleCallBack = callBack
    }

    setScaleScope(minScale: number, maxScale: number) {
        this.scaleConetentMin = minScale
        this.scaleConetentMax = maxScale
    }
}
