
import MapScroll from "./MapScroll";

const { ccclass, property, menu } = cc._decorator;


const BlockSize = 180 //长宽相等
const AvatarSizeOther = 40
const AvatarSizeMine = 100

const BuildingZindex = 1
const AvatarZindex = 2
let ScreenRect = cc.rect()
const RequestDistance = 500


@ccclass
@menu('map/MapSub')
export default class MapSub extends cc.Component {
    private map_size: number = 50
    private fristPos = cc.v2()
    private indexPosMap: Array<cc.Vec2> = []
    private myNo: number = 0
    private data: any = null
    private subMapId: string = null
    private userBlocks: Array<cc.Node> = []
    private exsitPoses: Array<cc.Vec2> = []
    private lastRequestPos: cc.Vec2 = cc.v2()
    private resNo: number = 1
    private blockId: string = null
    private mapScroll: MapScroll = null
    private startPoint: cc.Vec2 = cc.v2()
    private subMapBlockId: string = ""

    protected onLoad(): void {

        const Origin = cc.view.getVisibleOrigin()
        const VisibleSize = cc.view.getVisibleSize()
        ScreenRect = cc.rect(Origin.x, Origin.y, VisibleSize.width, VisibleSize.height)
    }

    protected start() {
        // //test use
        this.setMapView("431735834161842745", "431839989634959963",
            {
                "server_ts": 1667182984, "castle": { "block_id": "431840300718096386", "no": 1, "position_x": 0, "position_y": 0 },
                "dispatch_count": 26, "map_size": 10
            }, 1)
    }

    protected onDestroy(): void {
    }


    setMapView(blockId: string, subMapId: string, data: any, no: number) {
        // console.log("setMapData:", blockId, subMapId, JSON.stringify(data))
        this.blockId = blockId
        this.subMapId = subMapId
        this.data = data
        this.resNo = no
        this.map_size = data?.map_size
        const castle = data?.castle
        this.myNo = castle?.no || 0
        const position_x = castle?.position_x || 0
        const position_y = castle?.position_y || 0
        this.subMapBlockId = castle?.block_id || ""

        this.setIndexPosMap()
        this.setMap()

        this.scheduleOnce(() => {
            this.toBlockView(position_x, position_y)
        })
    }

    private setIndexPosMap() {
        for (let index = 1; index <= this.map_size * this.map_size; index++) {
            const x = this.GetPositionXByIndex(index)
            const y = this.GetPositionYByIndex(index)
            // console.log("index:", index,x,y)
            this.indexPosMap.push(cc.v2(x, y))
        }
    }

    private setMap() {
        const size = BlockSize * this.map_size
        this.node.setContentSize(size + BlockSize * 2, size + BlockSize * 2)
        this.node.parent.setContentSize(this.node.getContentSize())
        const firstFactor = BlockSize / 2 * (this.map_size - 1)
        this.fristPos = cc.v2(-firstFactor, firstFactor)

        this.startPoint.x = size / 2 - BlockSize
        this.startPoint.y = -(this.startPoint.x - 420)

        //装饰用不参与实际格子坐标计算
        for (let y = -1; y < this.map_size + 1; y++) {
            for (let x = -1; x < this.map_size + 1; x++) {
                // console.log("setMap:", x, y)
                if (x === -1 || y === -1 || x === this.map_size || y === this.map_size) {
                    this.addBlock(x, y, -1)
                }
            }
        }

        for (let y = 0; y < this.map_size; y++) {
            for (let x = 0; x < this.map_size; x++) {
                // console.log("setMap:", x, y)
                const no = this.getNoForPos(x, y)
                this.addBlock(x, y, no)
            }
        }
    }

    private addBlock(x: number, y: number, no: number) {
        const posX = this.fristPos.x + x * BlockSize
        const posY = this.fristPos.y - y * BlockSize
        const node = new cc.Node()
        this.node.addChild(node)
        node.name = 'block' + x + '_' + y
        node.setPosition(posX, posY)
        if (no > 0 && no % 7 !== 0) {
            this.userBlocks.push(node)
        }
        //// console.log("addBlock:", x, y, sp.spriteFrame.name)
        /*--- test use ----*/
        const labNo = new cc.Node()
        labNo.zIndex = 100
        const lab = labNo.addComponent(cc.Label)
        lab.fontSize = 30
        lab.string = x + "," + y
        labNo.setPosition(posX, posY)
        this.node.addChild(labNo)
    }






    private GetPositionXByIndex(index: number): number {
        const n = Math.ceil(Math.sqrt(index))
        const layerOuterStartNo = Math.pow((n - 1), 2) + 1
        const layerOuterEndNo = Math.pow((n - 1), 2) + n
        if (layerOuterStartNo <= index && index <= layerOuterEndNo) {
            return n - 1
        }
        return n - (index - layerOuterEndNo) - 1

    }

    private GetPositionYByIndex(index: number): number {
        const n = Math.ceil(Math.sqrt(index))
        const layerOuterStartNo = Math.pow(n, 2) - (n - 1)
        const layerOuterEndNo = Math.pow(n, 2)
        if (layerOuterStartNo <= index && index <= layerOuterEndNo) {
            return n - 1
        }
        return n - (layerOuterStartNo - index) - 1
    }

    private getNoForPos(x: number, y: number): number {
        for (let index = 0; index < this.indexPosMap.length; index++) {
            const pos = this.indexPosMap[index];
            if (pos.x === x && pos.y === y) {
                return index + 1
            }
        }
        return 0
    }


    private toBlockView(x: number, y: number, duration: number = 0) {
        // console.log("toBlockView:", this.startPoint.x, this.startPoint.y, x, y)
        if (this.mapScroll) {
            this.mapScroll.node.setPosition(this.startPoint.x - 180 * x, this.startPoint.y + y * 180)
        }
    }



    private moveMap(pos: cc.Vec2) {
    }
}
